/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeFileSearch;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.project.NativeProjectChangeSupport;
import org.netbeans.modules.cnd.api.project.NativeProjectItemsListener;
import org.netbeans.modules.cnd.api.project.NativeProjectSupport;
import org.netbeans.modules.cnd.api.remote.RemoteProject;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.api.toolchain.AbstractCompiler;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.api.toolchain.ui.ToolsPanelSupport;
import org.netbeans.modules.cnd.makeproject.ConfigurationDescriptorProviderImpl;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.ItemConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.ui.MakeLogicalViewProvider;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.cnd.utils.NamedRunnable;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.Path;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.netbeans.spi.jumpto.file.FileProvider;
import org.netbeans.spi.jumpto.file.FileProviderFactory;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class NativeProjectProvider
implements NativeProject,
PropertyChangeListener,
ChangeListener,
NativeProjectChangeSupport {
    private static final boolean TRACE = false;
    private final Project project;
    private final String projectRoot;
    private final FileSystem fileSystem;
    private final ConfigurationDescriptorProviderImpl projectDescriptorProvider;
    private final Set<NativeProjectItemsListener> listeners = new HashSet<NativeProjectItemsListener>();
    private static final RequestProcessor RP = new RequestProcessor("ReadErrorStream", 2);
    private static final RequestProcessor RPCC = new RequestProcessor("NativeProjectProvider.CheckConfiguration", 1);
    private Reference<List<NativeProject>> cachedDependency = new SoftReference<Object>(null);
    private final AtomicBoolean fileOperationsProgress = new AtomicBoolean(false);

    public NativeProjectProvider(Project project, RemoteProject remoteProject, ConfigurationDescriptorProviderImpl projectDescriptorProvider) {
        assert (remoteProject != null);
        this.project = project;
        this.fileSystem = NativeProjectProvider.getFileSystem(remoteProject);
        this.projectRoot = NativeProjectProvider.getProjectRoot(remoteProject);
        this.projectDescriptorProvider = projectDescriptorProvider;
        ToolsPanelSupport.addCodeAssistanceChangeListener((ChangeListener)this);
    }

    public void runOnProjectReadiness(NamedRunnable task) {
        MakeConfigurationDescriptor descriptor = this.getMakeConfigurationDescriptor();
        if (descriptor != null) {
            descriptor.getConfs().runOnProjectReadiness(task);
        }
    }

    private void addMyListeners() {
        this.projectDescriptorProvider.getConfigurationDescriptorImpl().getConfs().addPropertyChangeListener(this);
    }

    private void removeMyListeners() {
        this.projectDescriptorProvider.getConfigurationDescriptorImpl().getConfs().removePropertyChangeListener(this);
    }

    private MakeConfigurationDescriptor getMakeConfigurationDescriptor() {
        return this.projectDescriptorProvider.getConfigurationDescriptor();
    }

    private MakeConfiguration getMakeConfiguration() {
        MakeConfigurationDescriptor descriptor = this.getMakeConfigurationDescriptor();
        if (descriptor != null) {
            return descriptor.getActiveConfiguration();
        }
        return null;
    }

    public Lookup.Provider getProject() {
        return this.project;
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    private static FileSystem getFileSystem(RemoteProject remoteProject) {
        ExecutionEnvironment env = remoteProject.getSourceFileSystemHost();
        FileSystem fileSystem = FileSystemProvider.getFileSystem((ExecutionEnvironment)env);
        CndUtils.assertNotNull((Object)fileSystem, (String)"null file system");
        return fileSystem;
    }

    public List<String> getSourceRoots() {
        MakeConfigurationDescriptor descriptor = this.getMakeConfigurationDescriptor();
        if (descriptor != null) {
            return descriptor.getAbsoluteSourceRoots();
        }
        return Collections.emptyList();
    }

    public String getProjectRoot() {
        return this.projectRoot;
    }

    private static String getProjectRoot(RemoteProject remoteProject) {
        String projectRoot = remoteProject.getSourceBaseDir();
        CndUtils.assertNotNull((Object)projectRoot, (String)"null projectRoot");
        return projectRoot;
    }

    public String getProjectDisplayName() {
        return ProjectUtils.getInformation((Project)this.project).getDisplayName();
    }

    public List<NativeFileItem> getAllFiles() {
        MakeConfiguration conf;
        MakeConfigurationDescriptor descriptor = this.getMakeConfigurationDescriptor();
        if (descriptor != null && (conf = descriptor.getActiveConfiguration()) != null) {
            Item[] items;
            ArrayList<NativeFileItem> list = new ArrayList<NativeFileItem>();
            for (Item item : items = descriptor.getProjectItems()) {
                ItemConfiguration itemConfiguration = item.getItemConfiguration(conf);
                if (itemConfiguration == null) continue;
                if (itemConfiguration.isCompilerToolConfiguration()) {
                    list.add(item);
                    continue;
                }
                if (!item.hasHeaderOrSourceExtension(true, true)) continue;
                list.add(item);
            }
            return list;
        }
        return Collections.emptyList();
    }

    public List<NativeProject> getDependences() {
        List<Object> cachedList = this.cachedDependency.get();
        if (cachedList == null) {
            cachedList = new ArrayList<NativeProject>(0);
            MakeConfiguration makeConfiguration = this.getMakeConfiguration();
            int size = 0;
            NativeProject oneOf = null;
            if (makeConfiguration != null) {
                for (Project lib : makeConfiguration.getSubProjects()) {
                    Project prj = lib;
                    NativeProject nativeProject = (NativeProject)prj.getLookup().lookup(NativeProject.class);
                    if (nativeProject == null) continue;
                    cachedList.add(nativeProject);
                    ++size;
                    oneOf = nativeProject;
                }
            }
            cachedList = size == 0 ? Collections.emptyList() : (size == 1 ? Collections.singletonList(oneOf) : Collections.unmodifiableList(cachedList));
            this.cachedDependency = new SoftReference<List<NativeProject>>(cachedList);
        }
        return cachedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProjectItemsListener(NativeProjectItemsListener listener) {
        Set<NativeProjectItemsListener> set = this.listeners;
        synchronized (set) {
            if (this.listeners.isEmpty()) {
                this.addMyListeners();
            }
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProjectItemsListener(NativeProjectItemsListener listener) {
        Set<NativeProjectItemsListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listener);
            if (this.listeners.isEmpty()) {
                this.removeMyListeners();
            }
        }
    }

    public void fireFilesAdded(List<NativeFileItem> nativeFileIetms) {
        ArrayList<NativeFileItem> actualList = new ArrayList<NativeFileItem>();
        for (NativeFileItem nativeFileIetm : nativeFileIetms) {
            PredefinedToolKind tool;
            if (nativeFileIetm == null || (tool = ((Item)nativeFileIetm).getDefaultTool()) == PredefinedToolKind.CustomTool && !"text/x-h".equals(((Item)nativeFileIetm).getMIMEType())) continue;
            actualList.add(nativeFileIetm);
        }
        if (!actualList.isEmpty()) {
            for (NativeProjectItemsListener listener : this.getListenersCopy()) {
                listener.filesAdded(actualList);
            }
        }
    }

    public void fireFilesRemoved(List<NativeFileItem> nativeFileItems) {
        if (!nativeFileItems.isEmpty()) {
            for (NativeProjectItemsListener listener : this.getListenersCopy()) {
                listener.filesRemoved(nativeFileItems);
            }
        }
    }

    public void fireFileRenamed(String oldPath, NativeFileItem newNativeFileIetm) {
        for (NativeProjectItemsListener listener : this.getListenersCopy()) {
            listener.fileRenamed(oldPath, newNativeFileIetm);
        }
    }

    public void fireFilesPropertiesChanged(List<NativeFileItem> fileItems) {
        for (NativeProjectItemsListener listener : this.getListenersCopy()) {
            listener.filesPropertiesChanged(fileItems);
        }
    }

    public void fireFilesPropertiesChanged() {
        for (NativeProjectItemsListener listener : this.getListenersCopy()) {
            listener.filesPropertiesChanged();
        }
    }

    public void fireFileOperationsStarted() {
        if (this.fileOperationsProgress.compareAndSet(false, true)) {
            for (NativeProjectItemsListener listener : this.getListenersCopy()) {
                listener.fileOperationsStarted((NativeProject)this);
            }
        }
    }

    public void fireFileOperationsFinished() {
        if (this.fileOperationsProgress.compareAndSet(true, false)) {
            for (NativeProjectItemsListener listener : this.getListenersCopy()) {
                listener.fileOperationsFinished((NativeProject)this);
            }
        }
    }

    public void fireProjectDeleted() {
        for (NativeProjectItemsListener listener : this.getListenersCopy()) {
            listener.projectDeleted((NativeProject)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<NativeProjectItemsListener> getListenersCopy() {
        Set<NativeProjectItemsListener> set = this.listeners;
        synchronized (set) {
            return this.listeners.isEmpty() ? Collections.EMPTY_LIST : new ArrayList<NativeProjectItemsListener>(this.listeners);
        }
    }

    public NativeFileItem findFileItem(FileObject fileObject) {
        MakeConfigurationDescriptor descr;
        if (this.projectDescriptorProvider.gotDescriptor() && (descr = this.getMakeConfigurationDescriptor()) != null) {
            return descr.findItemByFileObject(fileObject);
        }
        return null;
    }

    private void checkConfigurationChanged(final Configuration oldConf, final Configuration newConf) {
        if (SwingUtilities.isEventDispatchThread()) {
            RPCC.post(new Runnable(){

                @Override
                public void run() {
                    NativeProjectProvider.this.checkConfigurationChangedWorker(oldConf, newConf);
                }
            });
        } else {
            this.checkConfigurationChangedWorker(oldConf, newConf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkConfigurationChangedWorker(Configuration oldConf, Configuration newConf) {
        MakeConfiguration oldMConf = (MakeConfiguration)oldConf;
        MakeConfiguration newMConf = (MakeConfiguration)newConf;
        ArrayList<NativeFileItem> list = new ArrayList<NativeFileItem>();
        ArrayList<NativeFileItem> added = new ArrayList<NativeFileItem>();
        ArrayList<NativeFileItem> deleted = new ArrayList<NativeFileItem>();
        Set<NativeProjectItemsListener> set = this.listeners;
        synchronized (set) {
            if (this.listeners.isEmpty()) {
                return;
            }
        }
        if (newConf == null) {
            System.err.println("Nativeprojectprovider - checkConfigurationChanged - newConf is null!");
            return;
        }
        if (!newConf.isDefault()) {
            return;
        }
        MakeConfigurationDescriptor descriptor = this.getMakeConfigurationDescriptor();
        Item[] items = descriptor.getProjectItems();
        Project proj = descriptor.getProject();
        ConfigurationDescriptorProvider.recordMetrics("USG_PROJECT_CONFIG_CND", descriptor);
        if (oldConf == null) {
            this.firePropertiesChanged(items, true, true, true);
            MakeLogicalViewProvider.checkForChangedViewItemNodes(proj, null, null);
            MakeLogicalViewProvider.checkForChangedName(proj);
            return;
        }
        boolean toolColectionChanged = false;
        if (!oldMConf.getCompilerSet().getName().equals(newMConf.getCompilerSet().getName()) || !oldMConf.getDevelopmentHost().getExecutionEnvironment().equals((Object)newMConf.getDevelopmentHost().getExecutionEnvironment())) {
            MakeLogicalViewProvider.checkForChangedViewItemNodes(proj, null, null);
            if (!oldMConf.getDevelopmentHost().getExecutionEnvironment().equals((Object)newMConf.getDevelopmentHost().getExecutionEnvironment())) {
                MakeLogicalViewProvider.checkForChangedName(proj);
            }
            toolColectionChanged = true;
        }
        if (toolColectionChanged && newConf.getName().equals(oldConf.getName())) {
            this.fireFilesPropertiesChanged();
            return;
        }
        CompilerSet oldCompilerSet = oldMConf.getCompilerSet().getCompilerSet();
        CompilerSet newCompilerSet = newMConf.getCompilerSet().getCompilerSet();
        for (int i = 0; i < items.length; ++i) {
            ItemConfiguration oldItemConf = items[i].getItemConfiguration(oldMConf);
            ItemConfiguration newItemConf = items[i].getItemConfiguration(newMConf);
            if (oldItemConf == null || newItemConf == null) continue;
            if (newItemConf.getExcluded().getValue() ^ oldItemConf.getExcluded().getValue() && (newItemConf.getTool() == PredefinedToolKind.CCompiler || newItemConf.getTool() == PredefinedToolKind.CCCompiler || items[i].hasHeaderOrSourceExtension(true, true))) {
                if (newItemConf.getExcluded().getValue()) {
                    deleted.add(items[i]);
                } else {
                    added.add(items[i]);
                }
                MakeLogicalViewProvider.checkForChangedViewItemNodes(proj, null, items[i]);
                continue;
            }
            if (newItemConf.getTool() == PredefinedToolKind.CCompiler) {
                if (oldItemConf.getTool() != PredefinedToolKind.CCompiler) {
                    list.add(items[i]);
                    continue;
                }
                if (oldCompilerSet == null || newCompilerSet == null) {
                    if (oldCompilerSet == null && newCompilerSet == null) continue;
                    list.add(items[i]);
                    continue;
                }
                if (!oldItemConf.getCCompilerConfiguration().getPreprocessorOptions(oldCompilerSet).equals(newItemConf.getCCompilerConfiguration().getPreprocessorOptions(newCompilerSet))) {
                    list.add(items[i]);
                    continue;
                }
                if (oldItemConf.getCCompilerConfiguration().getIncludeDirectoriesOptions(oldCompilerSet).equals(newItemConf.getCCompilerConfiguration().getIncludeDirectoriesOptions(newCompilerSet))) continue;
                list.add(items[i]);
                continue;
            }
            if (newItemConf.getTool() != PredefinedToolKind.CCCompiler) continue;
            if (oldItemConf.getTool() != PredefinedToolKind.CCCompiler) {
                list.add(items[i]);
                continue;
            }
            if (oldCompilerSet == null || newCompilerSet == null) {
                if (oldCompilerSet == null && newCompilerSet == null) continue;
                list.add(items[i]);
                continue;
            }
            if (!oldItemConf.getCCCompilerConfiguration().getPreprocessorOptions(oldCompilerSet).equals(newItemConf.getCCCompilerConfiguration().getPreprocessorOptions(newCompilerSet))) {
                list.add(items[i]);
                continue;
            }
            if (oldItemConf.getCCCompilerConfiguration().getIncludeDirectoriesOptions(oldCompilerSet).equals(newItemConf.getCCCompilerConfiguration().getIncludeDirectoriesOptions(newCompilerSet))) continue;
            list.add(items[i]);
        }
        this.fireFilesRemoved(deleted);
        this.fireFilesAdded(added);
        if (!list.isEmpty()) {
            this.fireFilesPropertiesChanged(list);
        }
        if (toolColectionChanged) {
            this.fireFilesPropertiesChanged();
        }
    }

    private void firePropertiesChanged(Item[] items, boolean cFiles, boolean ccFiles, boolean projectChanged) {
        MakeConfiguration conf = this.getMakeConfiguration();
        NativeProjectProvider.firePropertiesChanged(items, cFiles, ccFiles, projectChanged, conf, this);
    }

    public static void firePropertiesChanged(Item[] items, boolean cFiles, boolean ccFiles, boolean projectChanged, MakeConfiguration conf, NativeProjectChangeSupport nativeProjectChangeSupport) {
        if (nativeProjectChangeSupport == null) {
            return;
        }
        ArrayList<Item> list = new ArrayList<Item>();
        ArrayList<Item> deleted = new ArrayList<Item>();
        for (int i = 0; i < items.length; ++i) {
            ItemConfiguration itemConfiguration = items[i].getItemConfiguration(conf);
            if (itemConfiguration == null) continue;
            if (items[i].isExcluded()) {
                deleted.add(items[i]);
                continue;
            }
            if (!(cFiles && itemConfiguration.getTool() == PredefinedToolKind.CCompiler || ccFiles && itemConfiguration.getTool() == PredefinedToolKind.CCCompiler) && !items[i].hasHeaderOrSourceExtension(cFiles, ccFiles)) continue;
            list.add(items[i]);
        }
        if (!deleted.isEmpty()) {
            nativeProjectChangeSupport.fireFilesRemoved(deleted);
        }
        if (projectChanged) {
            nativeProjectChangeSupport.fireFilesPropertiesChanged();
        } else if (!list.isEmpty()) {
            nativeProjectChangeSupport.fireFilesPropertiesChanged(list);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("activeConfiguration")) {
            this.checkConfigurationChanged((Configuration)evt.getOldValue(), (Configuration)evt.getNewValue());
        }
    }

    public List<FSPath> getSystemIncludePaths() {
        ArrayList<FSPath> vec = new ArrayList<FSPath>();
        MakeConfiguration makeConfiguration = this.getMakeConfiguration();
        if (makeConfiguration != null) {
            CompilerSet compilerSet = makeConfiguration.getCompilerSet().getCompilerSet();
            if (compilerSet == null) {
                return vec;
            }
            AbstractCompiler compiler = (AbstractCompiler)compilerSet.getTool((ToolKind)PredefinedToolKind.CCCompiler);
            if (compiler != null) {
                FileSystem compilerFS = FileSystemProvider.getFileSystem((ExecutionEnvironment)compiler.getExecutionEnvironment());
                vec.addAll(CndFileUtils.toFSPathList((FileSystem)compilerFS, (Collection)compiler.getSystemIncludeDirectories()));
            }
        }
        return vec;
    }

    public List<FSPath> getUserIncludePaths() {
        ArrayList<FSPath> vec = new ArrayList<FSPath>();
        MakeConfiguration makeConfiguration = this.getMakeConfiguration();
        if (makeConfiguration != null) {
            CCCompilerConfiguration cccCompilerConfiguration = makeConfiguration.getCCCompilerConfiguration();
            ArrayList<String> vec2 = new ArrayList<String>();
            vec2.addAll(cccCompilerConfiguration.getIncludeDirectories().getValue());
            Iterator iter = vec2.iterator();
            FileSystem fs = this.getFileSystem();
            while (iter.hasNext()) {
                String path = (String)iter.next();
                if (CndPathUtilities.isPathAbsolute((CharSequence)path)) {
                    vec.add(new FSPath(fs, path));
                    continue;
                }
                path = CndPathUtilities.toAbsolutePath((FileSystem)fs, (String)this.getProjectRoot(), (String)path);
                vec.add(new FSPath(fs, path));
            }
        }
        return vec;
    }

    public List<String> getIncludeFiles() {
        ArrayList<String> vec = new ArrayList<String>();
        MakeConfiguration makeConfiguration = this.getMakeConfiguration();
        if (makeConfiguration != null) {
            CCCompilerConfiguration cccCompilerConfiguration = makeConfiguration.getCCCompilerConfiguration();
            ArrayList<String> vec2 = new ArrayList<String>();
            vec2.addAll(cccCompilerConfiguration.getIncludeFiles().getValue());
            Iterator iter = vec2.iterator();
            FileSystem fs = this.getFileSystem();
            while (iter.hasNext()) {
                String path = (String)iter.next();
                if (CndPathUtilities.isPathAbsolute((CharSequence)path)) {
                    vec.add(path);
                    continue;
                }
                path = CndPathUtilities.toAbsolutePath((FileSystem)fs, (String)this.getProjectRoot(), (String)path);
                vec.add(path);
            }
        }
        return vec;
    }

    public List<String> getSystemMacroDefinitions() {
        List<String> undefinedMacros;
        ArrayList<String> vec = new ArrayList<String>();
        MakeConfiguration makeConfiguration = this.getMakeConfiguration();
        if (makeConfiguration != null) {
            CompilerSet compilerSet = makeConfiguration.getCompilerSet().getCompilerSet();
            if (compilerSet == null) {
                return vec;
            }
            AbstractCompiler compiler = (AbstractCompiler)compilerSet.getTool((ToolKind)PredefinedToolKind.CCCompiler);
            if (compiler != null) {
                vec.addAll(compiler.getSystemPreprocessorSymbols());
            }
        }
        if ((undefinedMacros = this.getUndefinedMacros()).size() > 0) {
            ArrayList<String> out = new ArrayList<String>();
            for (String macro : vec) {
                boolean remove = true;
                for (String undef : undefinedMacros) {
                    if (!macro.equals(undef) && !macro.startsWith(undef + "=")) continue;
                    remove = false;
                    break;
                }
                if (!remove) continue;
                out.add(macro);
            }
            vec = out;
        }
        return vec;
    }

    public List<String> getUserMacroDefinitions() {
        ArrayList<String> vec = new ArrayList<String>();
        MakeConfiguration makeConfiguration = this.getMakeConfiguration();
        if (makeConfiguration != null) {
            CCCompilerConfiguration cccCompilerConfiguration = makeConfiguration.getCCCompilerConfiguration();
            vec.addAll(cccCompilerConfiguration.getPreprocessorConfiguration().getValue());
        }
        return vec;
    }

    private List<String> getUndefinedMacros() {
        ArrayList<String> vec = new ArrayList<String>();
        MakeConfiguration makeConfiguration = this.getMakeConfiguration();
        if (makeConfiguration != null) {
            CCCompilerConfiguration cccCompilerConfiguration = makeConfiguration.getCCCompilerConfiguration();
            vec.addAll(cccCompilerConfiguration.getUndefinedPreprocessorConfiguration().getValue());
        }
        return vec;
    }

    public String toString() {
        return this.getProjectDisplayName() + " " + this.getProjectRoot();
    }

    private void clearCache() {
        this.cachedDependency.clear();
    }

    NativeProjectSupport.NativeExitStatus execute(String executable, String[] env, String ... args) throws IOException {
        MakeConfiguration makeConfiguration = this.getMakeConfiguration();
        ExecutionEnvironment ev = makeConfiguration.getDevelopmentHost().getExecutionEnvironment();
        return NativeProjectProvider.execute(ev, executable, env, args);
    }

    static NativeProjectSupport.NativeExitStatus execute(ExecutionEnvironment ee, String executable, String[] env, String ... args) throws IOException {
        ServerRecord record = ServerList.get((ExecutionEnvironment)ee);
        if (!record.isOnline()) {
            return new NativeProjectSupport.NativeExitStatus(-1, "", NativeProjectProvider.getString("HOST_OFFLINE", ee.getHost()));
        }
        try {
            if (ee.isLocal()) {
                String exePath = Path.findCommand((String)executable);
                if (exePath == null) {
                    throw new IOException(NativeProjectProvider.getString("NOT_FOUND", executable));
                }
                executable = exePath;
            }
            NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)ee);
            npb.setExecutable(executable);
            npb.setArguments(args);
            if (env != null) {
                for (String envEntry : env) {
                    String[] varValuePair = envEntry.split("=");
                    npb.getEnvironment().put(varValuePair[0], varValuePair[1]);
                }
            }
            ProcessUtils.ExitStatus exitStatus = ProcessUtils.execute((NativeProcessBuilder)npb);
            return new NativeProjectSupport.NativeExitStatus(exitStatus.exitCode, exitStatus.output, exitStatus.error);
        }
        catch (Exception e) {
            return new NativeProjectSupport.NativeExitStatus(-1, "", e.getMessage());
        }
    }

    String getPlatformName() {
        MakeConfiguration makeConfiguration = this.getMakeConfiguration();
        String platformName = makeConfiguration.getDevelopmentHost().getBuildPlatformName();
        return platformName;
    }

    private static String getString(String s, String s2) {
        return NbBundle.getMessage(NativeProjectProvider.class, (String)s, (Object)s2);
    }

    NativeFileSearch getNativeFileSearch() {
        NativeFileSearch search = null;
        for (FileProviderFactory fpf : Lookup.getDefault().lookupAll(FileProviderFactory.class)) {
            FileProvider provider = fpf.createFileProvider();
            if (!(provider instanceof NativeFileSearch)) continue;
            search = (NativeFileSearch)provider;
        }
        return search;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.fireFilesPropertiesChanged();
    }
}

