/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject;

import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.cnd.makeproject.MakeProject;
import org.netbeans.spi.queries.FileEncodingQueryImplementation;
import org.openide.loaders.CreateFromTemplateAttributesProvider;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;

public class TemplateAttributesProviderImpl
implements CreateFromTemplateAttributesProvider {
    private final MakeProject project;
    private final FileEncodingQueryImplementation encodingQuery;
    private static final Logger LOG = Logger.getLogger(TemplateAttributesProviderImpl.class.getName());

    public TemplateAttributesProviderImpl(MakeProject project, FileEncodingQueryImplementation encodingQuery) {
        this.project = project;
        this.encodingQuery = encodingQuery;
    }

    public Map<String, ?> attributesFor(DataObject template, DataFolder target, String name) {
        Charset charset;
        String encoding;
        String license;
        HashMap<String, String> values = new HashMap<String, String>();
        Properties priv = this.project.getProjectProperties(false);
        Properties props = this.project.getProjectProperties(true);
        String licensePath = priv.getProperty("project.licensePath");
        if (licensePath == null) {
            licensePath = props.getProperty("project.licensePath");
        }
        if (licensePath != null) {
            values.put("licensePath", licensePath);
        }
        if ((license = priv.getProperty("project.license")) == null) {
            license = props.getProperty("project.license");
        }
        if (license != null) {
            values.put("license", license);
        }
        String string = encoding = (charset = this.encodingQuery.getEncoding(target.getPrimaryFile())) != null ? charset.name() : null;
        if (encoding != null) {
            values.put("encoding", encoding);
        }
        try {
            ProjectInformation info = ProjectUtils.getInformation((Project)this.project);
            if (info != null) {
                String pdname;
                String pname = info.getName();
                if (pname != null) {
                    values.put("name", pname);
                }
                if ((pdname = info.getDisplayName()) != null) {
                    values.put("displayName", pdname);
                }
            }
        }
        catch (Exception ex) {
            Logger.getLogger(TemplateAttributesProviderImpl.class.getName()).log(Level.FINE, "", ex);
        }
        if (values.isEmpty()) {
            return null;
        }
        return Collections.singletonMap("project", values);
    }
}

