/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.actions;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.makeproject.actions.BatchBuildAction;
import org.netbeans.modules.cnd.makeproject.api.SourceFolderInfo;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.ui.wizards.SourceFilesPanel;
import org.netbeans.modules.cnd.utils.FileObjectFilter;
import org.netbeans.modules.cnd.utils.ui.ModalMessageDlg;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;
import org.openide.windows.WindowManager;

public final class AddExistingFolderItemsAction
extends NodeAction {
    private static ResourceBundle bundle;

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes.length != 1) {
            return false;
        }
        Object project = activatedNodes[0].getValue("Project");
        if (project == null || !(project instanceof Project)) {
            return false;
        }
        Folder folder = (Folder)activatedNodes[0].getValue("Folder");
        if (folder == null) {
            return false;
        }
        return folder.isProjectFiles();
    }

    public String getName() {
        return AddExistingFolderItemsAction.getString("CTL_AddExistingFolderItemsAction");
    }

    public void performAction(Node[] activatedNodes) {
        Node n = activatedNodes[0];
        Project project = (Project)n.getValue("Project");
        assert (project != null);
        Folder folder = (Folder)n.getValue("Folder");
        assert (folder != null);
        ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class);
        MakeConfigurationDescriptor makeConfigurationDescriptor = pdp.getConfigurationDescriptor();
        if (!makeConfigurationDescriptor.okToChange()) {
            return;
        }
        JButton addButton = new JButton(AddExistingFolderItemsAction.getString("AddButtonText"));
        addButton.getAccessibleContext().setAccessibleDescription(AddExistingFolderItemsAction.getString("AddButtonAD"));
        Object[] options = new Object[]{addButton, DialogDescriptor.CANCEL_OPTION};
        SourceFilesPanel sourceFilesPanel = new SourceFilesPanel(project);
        JPanel panel = new JPanel();
        panel.setPreferredSize(new Dimension(700, 380));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 12, 12);
        panel.add((Component)sourceFilesPanel, gridBagConstraints);
        JTextArea instructionsTextArea = new JTextArea();
        instructionsTextArea.setEditable(false);
        instructionsTextArea.setLineWrap(true);
        instructionsTextArea.setText(AddExistingFolderItemsAction.getString("AddExistingFolderItemsTxt"));
        instructionsTextArea.setWrapStyleWord(true);
        instructionsTextArea.setBackground(panel.getBackground());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 12, 0, 12);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        panel.add((Component)instructionsTextArea, gridBagConstraints);
        sourceFilesPanel.setSeed(makeConfigurationDescriptor.getBaseDir(), null);
        panel.getAccessibleContext().setAccessibleDescription(AddExistingFolderItemsAction.getString("AddFilesDialogAD"));
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)panel, AddExistingFolderItemsAction.getString("AddFilesDialogText"), true, options, (Object)addButton, 0, null, null);
        Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (ret == addButton && !sourceFilesPanel.getSourceListData().isEmpty()) {
            AddFilesRunnable task = new AddFilesRunnable(makeConfigurationDescriptor, folder, sourceFilesPanel.getSourceListData(), sourceFilesPanel.getFileFilter());
            ModalMessageDlg.runLongTask((Window)WindowManager.getDefault().getMainWindow(), (Runnable)task, null, null, (String)AddExistingFolderItemsAction.getString("AddingFilesDialogTitle"), (String)AddExistingFolderItemsAction.getString("AddingFilesDialogText"));
        }
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    protected boolean asynchronous() {
        return false;
    }

    private static String getString(String s) {
        if (bundle == null) {
            bundle = NbBundle.getBundle(BatchBuildAction.class);
        }
        return bundle.getString(s);
    }

    private static final class AddFilesRunnable
    implements Runnable {
        private final MakeConfigurationDescriptor confDescriptor;
        private final Folder targetFolder;
        private final List<? extends SourceFolderInfo> foldersToAdd;
        private final FileObjectFilter fileFilter;

        public AddFilesRunnable(MakeConfigurationDescriptor confDescriptor, Folder targetFolder, List<? extends SourceFolderInfo> foldersToAdd, FileObjectFilter fileFilter) {
            this.confDescriptor = confDescriptor;
            this.targetFolder = targetFolder;
            this.foldersToAdd = foldersToAdd;
            this.fileFilter = fileFilter;
        }

        @Override
        public void run() {
            for (SourceFolderInfo sourceFolderInfo : this.foldersToAdd) {
                this.confDescriptor.addFilesFromRoot(this.targetFolder, sourceFolderInfo.getFileObject(), null, null, false, Folder.Kind.SOURCE_LOGICAL_FOLDER, this.fileFilter);
            }
            this.confDescriptor.save();
        }
    }
}

