/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.actions;

import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.makeproject.actions.RunDialogAction;
import org.netbeans.modules.cnd.makeproject.api.RunDialogPanel;
import org.netbeans.modules.cnd.makeproject.launchers.Launcher;
import org.netbeans.modules.cnd.makeproject.launchers.LaunchersRegistry;
import org.netbeans.modules.cnd.makeproject.launchers.LaunchersRegistryFactory;
import org.netbeans.modules.cnd.makeproject.launchers.actions.LauncherAction;
import org.netbeans.modules.cnd.utils.MIMENames;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;
import org.openide.util.lookup.Lookups;

public class DebugDialogAction
extends NodeAction {
    protected JButton debugButton = null;
    private Object[] options;
    private ResourceBundle bundle;

    private void init() {
        if (this.debugButton == null) {
            this.debugButton = new JButton(this.getString("DebugButtonText"));
            this.debugButton.getAccessibleContext().setAccessibleDescription(this.getString("DebugButtonAD"));
            this.options = new Object[]{this.debugButton, DialogDescriptor.CANCEL_OPTION};
        }
    }

    public String getName() {
        return this.getString("DEBUG_COMMAND");
    }

    protected void performAction(Node[] activatedNodes) {
        FileObject executableFO = null;
        if (activatedNodes != null && activatedNodes.length == 1) {
            FileObject fo;
            DataObject dataObject = (DataObject)activatedNodes[0].getLookup().lookup(DataObject.class);
            String mime = this.getMime(dataObject);
            if (dataObject != null && dataObject.isValid() && MIMENames.isBinary((String)mime) && (fo = dataObject.getPrimaryFile()) != null) {
                executableFO = fo;
            }
        }
        if (executableFO != null) {
            this.perform(executableFO);
        }
    }

    private String getMime(DataObject dob) {
        FileObject primaryFile = dob == null ? null : dob.getPrimaryFile();
        String mime = primaryFile == null ? "" : primaryFile.getMIMEType();
        return mime;
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length != 1) {
            return false;
        }
        DataObject dataObject = (DataObject)activatedNodes[0].getLookup().lookup(DataObject.class);
        String mime = this.getMime(dataObject);
        return MIMENames.isBinary((String)mime) && !"application/x-core+elf".equals(mime);
    }

    private void perform(FileObject executableFO) {
        if (this.debugButton == null) {
            this.init();
        }
        try {
            this.perform(new RunDialogPanel(executableFO, this.debugButton, true));
        }
        catch (FileStateInvalidException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    protected void perform(final RunDialogPanel runDialogPanel) {
        if (this.debugButton == null) {
            this.init();
        }
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)runDialogPanel, this.getString("DebugDialogTitle"), true, this.options, (Object)this.debugButton, 0, null, null);
        Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (ret == this.debugButton) {
            runDialogPanel.getSelectedProject(new RunDialogPanel.RunProjectAction(){

                @Override
                public void run(Project project) {
                    DebugDialogAction.this.performDebug(project, runDialogPanel.getExecutablePath() + " " + runDialogPanel.getArguments());
                }
            });
        }
    }

    private void performDebug(Project project, String runCommand) {
        LaunchersRegistry registry = LaunchersRegistryFactory.getInstance(project.getProjectDirectory());
        Launcher launcher = null;
        if (registry.hasLaunchers()) {
            for (Launcher l : registry.getLaunchers()) {
                if (!runCommand.equals(l.getCommand())) continue;
                launcher = l;
                break;
            }
        }
        if (launcher == null) {
            launcher = new Launcher(runCommand, null);
            registry.add(launcher);
        }
        LauncherAction action = LauncherAction.debugAsAction();
        action.createContextAwareInstance(Lookups.fixed((Object[])new Object[]{project}));
        LauncherAction launcherAction = action;
        launcherAction.getClass();
        new LauncherAction.LauncherExecutableAction(launcherAction, launcher).actionPerformed(null);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(RunDialogAction.class);
    }

    private String getString(String s) {
        if (this.bundle == null) {
            this.bundle = NbBundle.getBundle(RunDialogAction.class);
        }
        return this.bundle.getString(s);
    }

    public final class SimpleDebugActionProxy
    extends AbstractAction {
        private final Project project;
        private final String executable;

        public SimpleDebugActionProxy(Project project, String executable) {
            this.project = project;
            this.executable = executable;
        }

        @Override
        public Object getValue(String key) {
            if ("Name".equals(key)) {
                return DebugDialogAction.this.getName();
            }
            return super.getValue(key);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DebugDialogAction.this.performDebug(this.project, this.executable);
        }
    }
}

