/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import java.util.List;
import java.util.regex.Pattern;
import org.netbeans.modules.cnd.makeproject.api.configurations.BooleanConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.StringConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.VectorConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ui.BooleanNodeProp;
import org.netbeans.modules.cnd.makeproject.configurations.ui.StringListNodeProp;
import org.netbeans.modules.cnd.makeproject.configurations.ui.StringNodeProp;
import org.netbeans.modules.cnd.makeproject.ui.utils.TokenizerFactory;
import org.netbeans.modules.cnd.utils.MIMENames;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CodeAssistanceConfiguration
implements Cloneable {
    private MakeConfiguration makeConfiguration;
    private BooleanConfiguration buildAnalyzer;
    private BooleanConfiguration resolveSymbolicLinks;
    private VectorConfiguration<String> transientMacros;
    private VectorConfiguration<String> environmentVariables;
    private StringConfiguration tools;
    private BooleanConfiguration includeInCA;
    private StringConfiguration excludeInCA;
    private static final String DEFAULT_TOOLS = "gcc:c++:g++:clang:clang++:icc:icpc:ifort:gfortran:g77:g90:g95:cc:CC:ffortran:f77:f90:f95:ar:ld";
    private Pattern lastIgnorePattern = null;

    public CodeAssistanceConfiguration(MakeConfiguration makeConfiguration) {
        this.makeConfiguration = makeConfiguration;
        this.buildAnalyzer = new BooleanConfiguration(true);
        this.resolveSymbolicLinks = new BooleanConfiguration(false);
        this.tools = new StringConfiguration(null, DEFAULT_TOOLS);
        this.transientMacros = new VectorConfiguration(null);
        this.environmentVariables = new VectorConfiguration(null);
        this.includeInCA = new BooleanConfiguration(false);
        this.excludeInCA = new StringConfiguration(null, "");
    }

    public boolean getModified() {
        return this.getBuildAnalyzer().getModified() || this.getResolveSymbolicLinks().getModified() || this.getTools().getModified() || this.getEnvironmentVariables().getModified() || this.getTransientMacros().getModified() || this.getIncludeInCA().getModified() || this.getExcludeInCA().getModified();
    }

    public void setMakeConfiguration(MakeConfiguration makeConfiguration) {
        this.makeConfiguration = makeConfiguration;
    }

    public MakeConfiguration getMakeConfiguration() {
        return this.makeConfiguration;
    }

    public void setBuildAnalyzer(BooleanConfiguration buildAnalyzer) {
        this.buildAnalyzer = buildAnalyzer;
    }

    public BooleanConfiguration getBuildAnalyzer() {
        return this.buildAnalyzer;
    }

    public void setResolveSymbolicLinks(BooleanConfiguration resolveSymbolicLinks) {
        this.resolveSymbolicLinks = resolveSymbolicLinks;
    }

    public BooleanConfiguration getResolveSymbolicLinks() {
        return this.resolveSymbolicLinks;
    }

    public void setTools(StringConfiguration tools) {
        this.tools = tools;
    }

    public StringConfiguration getTools() {
        return this.tools;
    }

    public VectorConfiguration<String> getTransientMacros() {
        return this.transientMacros;
    }

    public void setTransientMacros(VectorConfiguration<String> transientMacros) {
        this.transientMacros = transientMacros;
    }

    public VectorConfiguration<String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public void setEnvironmentVariables(VectorConfiguration<String> environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public BooleanConfiguration getIncludeInCA() {
        return this.includeInCA;
    }

    public void setIncludeInCA(BooleanConfiguration includeInCA) {
        this.includeInCA = includeInCA;
    }

    public StringConfiguration getExcludeInCA() {
        return this.excludeInCA;
    }

    public void setExcludeInCA(StringConfiguration excludeInCA) {
        this.excludeInCA = excludeInCA;
    }

    public void assign(CodeAssistanceConfiguration conf) {
        this.getBuildAnalyzer().assign(conf.getBuildAnalyzer());
        this.getResolveSymbolicLinks().assign(conf.getResolveSymbolicLinks());
        this.getTools().assign(conf.getTools());
        this.getTransientMacros().assign(conf.getTransientMacros());
        this.getEnvironmentVariables().assign(conf.getEnvironmentVariables());
        this.getIncludeInCA().assign(conf.getIncludeInCA());
        this.getExcludeInCA().assign(conf.getExcludeInCA());
    }

    public CodeAssistanceConfiguration clone() {
        CodeAssistanceConfiguration clone = new CodeAssistanceConfiguration(this.getMakeConfiguration());
        clone.setBuildAnalyzer(this.getBuildAnalyzer().clone());
        clone.setResolveSymbolicLinks(this.getResolveSymbolicLinks().clone());
        clone.setTools(this.getTools().clone());
        clone.setTransientMacros((VectorConfiguration<String>)this.getTransientMacros().clone());
        clone.setEnvironmentVariables((VectorConfiguration<String>)this.getEnvironmentVariables().clone());
        clone.setIncludeInCA(this.getIncludeInCA().clone());
        clone.setExcludeInCA(this.getExcludeInCA().clone());
        return clone;
    }

    public Sheet getGeneralSheet(MakeConfiguration conf) {
        Sheet sheet = new Sheet();
        Sheet.Set set = new Sheet.Set();
        set.setName("CodeAssistance");
        set.setDisplayName(CodeAssistanceConfiguration.getString("CodeAssistanceTxt"));
        set.setShortDescription(CodeAssistanceConfiguration.getString("CodeAssistanceHint"));
        set.put((Node.Property)new BooleanNodeProp(this.getBuildAnalyzer(), true, "BuildAnalyzer", CodeAssistanceConfiguration.getString("BuildAnalyzerTxt"), CodeAssistanceConfiguration.getString("BuildAnalyzerHint")));
        if (System.getProperty("cnd.buildtrace.tools") != null) {
            set.put((Node.Property)new StringNodeProp(this.getTools(), DEFAULT_TOOLS, "Tools", CodeAssistanceConfiguration.getString("ToolsTxt2"), CodeAssistanceConfiguration.getString("ToolsHint2")));
        }
        set.put((Node.Property)new StringListNodeProp(this.getTransientMacros(), null, new String[]{"transient-macros", CodeAssistanceConfiguration.getString("TransientMacrosTxt"), CodeAssistanceConfiguration.getString("TransientMacrosHint"), CodeAssistanceConfiguration.getString("TransientMacrosLbl"), null}, true, new HelpCtx("transient-macros")){

            @Override
            protected List<String> convertToList(String text) {
                return TokenizerFactory.DEFAULT_CONVERTER.convertToList(text);
            }

            @Override
            protected String convertToString(List<String> list) {
                return TokenizerFactory.DEFAULT_CONVERTER.convertToString(list);
            }
        });
        set.put((Node.Property)new StringListNodeProp(this.getEnvironmentVariables(), null, new String[]{"environment-variables", CodeAssistanceConfiguration.getString("EnvironmentVariablesTxt"), CodeAssistanceConfiguration.getString("EnvironmentVariablesHint"), CodeAssistanceConfiguration.getString("EnvironmentVariablesLbl"), null}, true, new HelpCtx("environment-variables")){

            @Override
            protected List<String> convertToList(String text) {
                return TokenizerFactory.DEFAULT_CONVERTER.convertToList(text);
            }

            @Override
            protected String convertToString(List<String> list) {
                return TokenizerFactory.DEFAULT_CONVERTER.convertToString(list);
            }
        });
        sheet.put(set);
        set = new Sheet.Set();
        set.setName("IncludeInCodeAssistance");
        set.setDisplayName(CodeAssistanceConfiguration.getString("IncludeInCodeAssistanceTxt"));
        set.setShortDescription(CodeAssistanceConfiguration.getString("IncludeInCodeAssistanceHint"));
        set.put((Node.Property)new BooleanNodeProp(this.getIncludeInCA(), true, "IncludeFlag", CodeAssistanceConfiguration.getString("IncludeFlagTxt"), CodeAssistanceConfiguration.getString("IncludeFlagHint")));
        set.put((Node.Property)new PatternNodeProp(this.getExcludeInCA(), "", "ExcludePattern", CodeAssistanceConfiguration.getString("ExcludePatternTxt"), CodeAssistanceConfiguration.getString("ExcludePatternHint")));
        set.put((Node.Property)new BooleanNodeProp(this.getResolveSymbolicLinks(), false, "ResolveSymbolicLinks", CodeAssistanceConfiguration.getString("ResolveSymbolicLinksTxt"), CodeAssistanceConfiguration.getString("ResolveSymbolicLinksHint")));
        sheet.put(set);
        return sheet;
    }

    private static String getString(String s) {
        return NbBundle.getMessage(CodeAssistanceConfiguration.class, (String)s);
    }

    public String toString() {
        return "{buildAnalyzer=" + this.buildAnalyzer + " tools=" + this.tools + '}';
    }

    boolean includeInCA(Item item) {
        boolean add = this.getIncludeInCA().getValue();
        if (add && MIMENames.isCppOrCOrFortran((String)item.getMIMEType())) {
            return !this.excludeInCA(item);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean excludeInCA(Item item) {
        Pattern ignorePattern;
        String ignore = this.getExcludeInCA().getValue();
        if (ignore.isEmpty()) {
            return false;
        }
        CodeAssistanceConfiguration codeAssistanceConfiguration = this;
        synchronized (codeAssistanceConfiguration) {
            if (this.lastIgnorePattern != null && !this.lastIgnorePattern.pattern().equals(ignore)) {
                this.lastIgnorePattern = null;
            }
            if (this.lastIgnorePattern == null) {
                try {
                    this.lastIgnorePattern = Pattern.compile(ignore);
                }
                catch (Throwable ex) {
                    // empty catch block
                }
            }
            ignorePattern = this.lastIgnorePattern;
        }
        if (ignorePattern != null) {
            return ignorePattern.matcher(item.getAbsolutePath()).find();
        }
        return false;
    }

    private static class PatternNodeProp
    extends StringNodeProp {
        public PatternNodeProp(StringConfiguration stringConfiguration, String def, String txt1, String txt2, String txt3) {
            super(stringConfiguration, def, txt1, txt2, txt3);
        }

        @Override
        public void setValue(String v) {
            try {
                Pattern.compile(v);
            }
            catch (Throwable ex) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)CodeAssistanceConfiguration.getString("InvalidPattern"), 0));
            }
            super.setValue(v);
        }
    }
}

