/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.cnd.api.remote.PathMap;
import org.netbeans.modules.cnd.api.remote.RemoteFileUtil;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.StringConfiguration;
import org.netbeans.modules.cnd.makeproject.configurations.ui.StringNodeProp;
import org.netbeans.modules.cnd.spi.remote.RemoteSyncFactory;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.FileFilterFactory;
import org.netbeans.modules.dlight.libs.common.PathUtilities;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class MakefileConfiguration
implements Cloneable {
    private MakeConfiguration makeConfiguration;
    private StringConfiguration buildCommandWorkingDir;
    private StringConfiguration buildCommand;
    private StringConfiguration cleanCommand;
    private StringConfiguration output;
    private static final RequestProcessor RP = new RequestProcessor("MakeConfiguration", 1);
    private static ResourceBundle bundle;

    public MakefileConfiguration(MakeConfiguration makeConfiguration) {
        this.makeConfiguration = makeConfiguration;
        this.buildCommandWorkingDir = new StringConfiguration(null, ".");
        this.buildCommand = new StringConfiguration(null, "${MAKE}");
        this.cleanCommand = new StringConfiguration(null, "${MAKE} clean");
        this.output = new StringConfiguration(null, "");
    }

    public void setMakeConfiguration(MakeConfiguration makeConfiguration) {
        this.makeConfiguration = makeConfiguration;
    }

    public MakeConfiguration getMakeConfiguration() {
        return this.makeConfiguration;
    }

    public StringConfiguration getBuildCommandWorkingDir() {
        return this.buildCommandWorkingDir;
    }

    public String getBuildCommandWorkingDirValue() {
        if (this.buildCommandWorkingDir.getValue().length() == 0) {
            return ".";
        }
        return this.buildCommandWorkingDir.getValue();
    }

    public void setBuildCommandWorkingDir(StringConfiguration buildCommandWorkingDir) {
        this.buildCommandWorkingDir = buildCommandWorkingDir;
    }

    public StringConfiguration getBuildCommand() {
        return this.buildCommand;
    }

    public void setBuildCommand(StringConfiguration buildCommand) {
        this.buildCommand = buildCommand;
    }

    public StringConfiguration getCleanCommand() {
        return this.cleanCommand;
    }

    public void setCleanCommand(StringConfiguration cleanCommand) {
        this.cleanCommand = cleanCommand;
    }

    public StringConfiguration getOutput() {
        return this.output;
    }

    public void setOutput(StringConfiguration output) {
        this.output = output;
    }

    public boolean canBuild() {
        return this.getBuildCommand().getValue().length() > 0;
    }

    public FileObject getAbsBuildCommandFileObject() {
        String path = this.getAbsBuildCommandWorkingDir();
        return FileSystemProvider.getFileObject((ExecutionEnvironment)this.getSourceExecutionEnvironment(), (String)path);
    }

    public String getAbsBuildCommandWorkingDir() {
        String wd = this.getBuildCommandWorkingDirValue().length() > 0 && CndPathUtilities.isPathAbsolute((CharSequence)this.getBuildCommandWorkingDirValue()) ? this.getBuildCommandWorkingDirValue() : this.getMakeConfiguration().getBaseDir() + "/" + this.getBuildCommandWorkingDirValue();
        wd = FileSystemProvider.normalizeAbsolutePath((String)wd, (ExecutionEnvironment)this.getSourceExecutionEnvironment());
        return wd;
    }

    public boolean canClean() {
        return this.getCleanCommand().getValue().length() > 0;
    }

    public String getAbsOutput() {
        if (this.getOutput().getValue().length() == 0) {
            return "";
        }
        if (CndPathUtilities.isPathAbsolute((CharSequence)this.getOutput().getValue())) {
            return this.getOutput().getValue();
        }
        return this.getMakeConfiguration().getBaseDir() + "/" + this.getOutput().getValue();
    }

    public void assign(MakefileConfiguration conf) {
        this.getBuildCommandWorkingDir().assign(conf.getBuildCommandWorkingDir());
        this.getBuildCommand().assign(conf.getBuildCommand());
        this.getCleanCommand().assign(conf.getCleanCommand());
        this.getOutput().assign(conf.getOutput());
    }

    public MakefileConfiguration clone() {
        MakefileConfiguration clone = new MakefileConfiguration(this.getMakeConfiguration());
        clone.setBuildCommandWorkingDir(this.getBuildCommandWorkingDir().clone());
        clone.setBuildCommand(this.getBuildCommand().clone());
        clone.setCleanCommand(this.getCleanCommand().clone());
        clone.setOutput(this.getOutput().clone());
        return clone;
    }

    public Sheet getSheet() {
        Sheet sheet = new Sheet();
        Sheet.Set set = new Sheet.Set();
        set.setName("Makefile");
        set.setDisplayName(MakefileConfiguration.getString("MakefileTxt"));
        set.setShortDescription(MakefileConfiguration.getString("MakefileHint"));
        set.put((Node.Property)new DirStringNodeProp(this.getBuildCommandWorkingDir(), "WorkingDirectory", MakefileConfiguration.getString("WorkingDirectory_LBL"), MakefileConfiguration.getString("WorkingDirectory_TT")));
        set.put((Node.Property)new StringNodeProp(this.getBuildCommand(), "BuildCommandLine", MakefileConfiguration.getString("BuildCommandLine_LBL"), MakefileConfiguration.getString("BuildCommandLine_TT")));
        set.put((Node.Property)new StringNodeProp(this.getCleanCommand(), "CleanCommandLine", MakefileConfiguration.getString("CleanCommandLine_LBL"), MakefileConfiguration.getString("CleanCommandLine_TT")));
        set.put((Node.Property)new OutputStringNodeProp(this.getOutput(), "BuildResult", MakefileConfiguration.getString("BuildResult_LBL"), MakefileConfiguration.getString("BuildResult_TT")));
        sheet.put(set);
        return sheet;
    }

    private ExecutionEnvironment getSourceExecutionEnvironment() {
        ExecutionEnvironment env = null;
        MakeConfiguration mc = this.getMakeConfiguration();
        if (mc != null) {
            return FileSystemProvider.getExecutionEnvironment((FileSystem)mc.getBaseFSPath().getFileSystem());
        }
        if (env == null) {
            env = ExecutionEnvironmentFactory.getLocal();
        }
        return env;
    }

    private JFileChooser createDirPanel(String seed, final PropertyEditorSupport editor, PropertyEnv propenv) {
        String titleText = ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/api/Bundle").getString("Run_Directory");
        String buttonText = ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/api/Bundle").getString("SelectLabel");
        final JFileChooser chooser = RemoteFileUtil.createFileChooser((ExecutionEnvironment)this.getSourceExecutionEnvironment(), (String)titleText, (String)buttonText, (int)1, null, (String)seed, (boolean)true);
        chooser.putClientProperty("title", chooser.getDialogTitle());
        chooser.setControlButtonsAreShown(false);
        propenv.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
        propenv.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("state".equals(evt.getPropertyName()) && evt.getNewValue() == PropertyEnv.STATE_VALID) {
                    File selectedFile = chooser.getSelectedFile();
                    String path = CndPathUtilities.toRelativePath((String)MakefileConfiguration.this.makeConfiguration.getBaseDir(), (String)selectedFile.getPath());
                    path = CndPathUtilities.normalizeSlashes((String)path);
                    editor.setValue(path);
                }
            }
        });
        return chooser;
    }

    private void setElfFilters(final JFileChooser chooser, final List<FileFilter> filters, final CountDownLatch latch) {
        final Runnable setFiltersRunner = new Runnable(){

            @Override
            public void run() {
                for (FileFilter f : filters) {
                    chooser.addChoosableFileFilter(f);
                }
                if (!filters.isEmpty()) {
                    chooser.setFileFilter((FileFilter)filters.get(0));
                }
            }
        };
        Runnable waiter = new Runnable(){

            @Override
            public void run() {
                try {
                    latch.await();
                    SwingUtilities.invokeLater(setFiltersRunner);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        RP.post(waiter);
    }

    private JFileChooser createElfPanel(String seed, final PropertyEditorSupport editor, PropertyEnv propenv) {
        MakeConfiguration mc = this.getMakeConfiguration();
        RemoteSyncFactory syncFactory = mc == null ? null : mc.getRemoteSyncFactory();
        ExecutionEnvironment execEnv = mc != null && syncFactory != null && syncFactory.isCopying() ? mc.getDevelopmentHost().getExecutionEnvironment() : this.getSourceExecutionEnvironment();
        final PathMap pathMap = syncFactory != null && syncFactory.isCopying() ? syncFactory.getPathMap(execEnv) : null;
        CountDownLatch latch = new CountDownLatch(1);
        List<FileFilter> filters = Collections.synchronizedList(new ArrayList());
        final JFileChooser chooser = RemoteFileUtil.createFileChooser((ExecutionEnvironment)execEnv, (String)"", (String)"", (int)0, null, (Callable)new ElfChooserInitializer(execEnv, pathMap, seed, filters, latch), (boolean)true);
        chooser.setControlButtonsAreShown(false);
        chooser.putClientProperty("title", chooser.getDialogTitle());
        this.setElfFilters(chooser, filters, latch);
        propenv.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
        propenv.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                File selectedFile = chooser.getSelectedFile();
                if ("state".equals(evt.getPropertyName()) && evt.getNewValue() == PropertyEnv.STATE_VALID && selectedFile != null) {
                    String path = selectedFile.getPath();
                    if (pathMap != null) {
                        String newPath = pathMap.getTrueLocalPath(path);
                        path = newPath == null ? "//" + path : newPath;
                    }
                    path = CndPathUtilities.toRelativePath((String)MakefileConfiguration.this.makeConfiguration.getBaseDir(), (String)path);
                    path = CndPathUtilities.normalizeSlashes((String)path);
                    editor.setValue(path);
                }
            }
        });
        return chooser;
    }

    private static String getString(String s) {
        if (bundle == null) {
            bundle = NbBundle.getBundle(MakefileConfiguration.class);
        }
        return bundle.getString(s);
    }

    private static class ElfChooserInitializer
    implements Callable<String> {
        private final ExecutionEnvironment execEnv;
        private final PathMap pathMap;
        private final String seed;
        private final List<FileFilter> filters;
        private final CountDownLatch latch;

        public ElfChooserInitializer(ExecutionEnvironment execEnv, PathMap pathMap, String seed, List<FileFilter> filters, CountDownLatch latch) {
            this.execEnv = execEnv;
            this.pathMap = pathMap;
            this.seed = seed;
            this.filters = filters;
            this.latch = latch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String call() throws Exception {
            String realSeed = this.seed;
            try {
                HostInfo hostInfo = null;
                try {
                    ConnectionManager.getInstance().connectTo(this.execEnv);
                }
                catch (IOException e) {
                    e.printStackTrace(System.err);
                }
                catch (ConnectionManager.CancellationException e) {
                    // empty catch block
                }
                if (HostInfoUtils.isHostInfoAvailable((ExecutionEnvironment)this.execEnv)) {
                    hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)this.execEnv);
                }
                if (this.pathMap != null && this.seed != null) {
                    realSeed = this.pathMap.getRemotePath(this.seed, true);
                }
                FileObject seedFo = FileSystemProvider.getFileObject((ExecutionEnvironment)this.execEnv, (String)realSeed);
                while (seedFo == null && realSeed.length() > 1) {
                    realSeed = PathUtilities.getDirName((String)realSeed);
                    seedFo = FileSystemProvider.getFileObject((ExecutionEnvironment)this.execEnv, (String)realSeed);
                }
                this.filters.add((FileFilter)FileFilterFactory.getAllBinaryFileFilter());
                if (hostInfo != null) {
                    if (hostInfo.getOSFamily() == HostInfo.OSFamily.WINDOWS) {
                        this.filters.add((FileFilter)FileFilterFactory.getPeExecutableFileFilter());
                        this.filters.add((FileFilter)FileFilterFactory.getPeStaticLibraryFileFilter());
                        this.filters.add((FileFilter)FileFilterFactory.getPeDynamicLibraryFileFilter());
                    } else if (hostInfo.getOSFamily() == HostInfo.OSFamily.MACOSX) {
                        this.filters.add((FileFilter)FileFilterFactory.getMacOSXExecutableFileFilter());
                        this.filters.add((FileFilter)FileFilterFactory.getElfStaticLibraryFileFilter());
                        this.filters.add((FileFilter)FileFilterFactory.getMacOSXDynamicLibraryFileFilter());
                    } else {
                        this.filters.add((FileFilter)FileFilterFactory.getElfExecutableFileFilter());
                        this.filters.add((FileFilter)FileFilterFactory.getElfStaticLibraryFileFilter());
                        this.filters.add((FileFilter)FileFilterFactory.getElfDynamicLibraryFileFilter());
                    }
                }
            }
            finally {
                this.latch.countDown();
            }
            return realSeed;
        }
    }

    private final class ElfEditor
    extends PropertyEditorSupport
    implements ExPropertyEditor {
        private PropertyEnv propenv;
        private final String seed;

        public ElfEditor(String seed) {
            this.seed = seed;
        }

        @Override
        public void setAsText(String text) {
            MakefileConfiguration.this.getOutput().setValue(text);
        }

        @Override
        public String getAsText() {
            return MakefileConfiguration.this.getOutput().getValue();
        }

        @Override
        public Object getValue() {
            return MakefileConfiguration.this.getOutput().getValue();
        }

        @Override
        public void setValue(Object v) {
            MakefileConfiguration.this.getOutput().setValue((String)v);
        }

        @Override
        public boolean supportsCustomEditor() {
            return true;
        }

        @Override
        public Component getCustomEditor() {
            return MakefileConfiguration.this.createElfPanel(this.seed, this, this.propenv);
        }

        public void attachEnv(PropertyEnv propenv) {
            this.propenv = propenv;
        }
    }

    private class DirEditor
    extends PropertyEditorSupport
    implements ExPropertyEditor {
        private PropertyEnv propenv;
        private final String seed;

        public DirEditor(String seed) {
            this.seed = seed;
        }

        @Override
        public void setAsText(String text) {
            MakefileConfiguration.this.getBuildCommandWorkingDir().setValue(text);
        }

        @Override
        public String getAsText() {
            return MakefileConfiguration.this.getBuildCommandWorkingDir().getValue();
        }

        @Override
        public Object getValue() {
            return MakefileConfiguration.this.getBuildCommandWorkingDir().getValue();
        }

        @Override
        public void setValue(Object v) {
            MakefileConfiguration.this.getBuildCommandWorkingDir().setValue((String)v);
        }

        @Override
        public boolean supportsCustomEditor() {
            return true;
        }

        @Override
        public Component getCustomEditor() {
            return MakefileConfiguration.this.createDirPanel(this.seed, this, this.propenv);
        }

        public void attachEnv(PropertyEnv propenv) {
            this.propenv = propenv;
        }
    }

    private class OutputStringNodeProp
    extends StringNodeProp {
        public OutputStringNodeProp(StringConfiguration stringConfiguration, String txt1, String txt2, String txt3) {
            super(stringConfiguration, txt1, txt2, txt3);
        }

        @Override
        public void setValue(String v) {
            String path = CndPathUtilities.toRelativePath((String)MakefileConfiguration.this.getMakeConfiguration().getBaseDir(), (String)v);
            path = CndPathUtilities.normalizeSlashes((String)path);
            super.setValue(path);
        }

        public PropertyEditor getPropertyEditor() {
            String seed = MakefileConfiguration.this.getAbsOutput();
            if (seed.length() == 0) {
                seed = MakefileConfiguration.this.getMakeConfiguration().getBaseDir();
            }
            return new ElfEditor(seed);
        }
    }

    private class DirStringNodeProp
    extends StringNodeProp {
        public DirStringNodeProp(StringConfiguration stringConfiguration, String txt1, String txt2, String txt3) {
            super(stringConfiguration, txt1, txt2, txt3);
        }

        @Override
        public void setValue(String v) {
            String path = CndPathUtilities.toRelativePath((String)MakefileConfiguration.this.getMakeConfiguration().getBaseDir(), (String)v);
            path = CndPathUtilities.normalizeSlashes((String)path);
            super.setValue(path);
        }

        public PropertyEditor getPropertyEditor() {
            return new DirEditor(MakefileConfiguration.this.getAbsBuildCommandWorkingDir());
        }
    }
}

