/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.configurations;

import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.cnd.api.toolchain.AbstractCompiler;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.makeproject.SmartOutputStream;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCCCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.ItemConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.LibraryItem;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.VectorConfiguration;
import org.netbeans.modules.cnd.makeproject.configurations.ConfigurationMakefileWriter;
import org.netbeans.modules.cnd.makeproject.configurations.CppUtils;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.FSPath;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class QmakeProjectWriter {
    private static final String PKGCONFIG_BINARY = "pkg-config";
    private static final String PROJECT_PREFIX = "nbproject/qt-";
    private static final String PROJECT_SUFFIX = ".pro";
    private final MakeConfigurationDescriptor projectDescriptor;
    private final MakeConfiguration configuration;

    public QmakeProjectWriter(MakeConfigurationDescriptor projectDescriptor, MakeConfiguration configuration) {
        this.projectDescriptor = projectDescriptor;
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write() throws IOException {
        if (this.configuration.isQmakeConfiguration()) {
            FSPath baseFSPath = this.configuration.getBaseFSPath();
            FileObject confBaseFO = baseFSPath.getFileObject();
            if (confBaseFO == null) {
                throw new FileNotFoundException("FileObject not found: " + baseFSPath);
            }
            FileObject qmakeProjectFO = FileUtil.createData((FileObject)confBaseFO, (String)(PROJECT_PREFIX + this.configuration.getName() + PROJECT_SUFFIX));
            try (BufferedWriter bw = null;){
                Charset encoding = FileEncodingQuery.getEncoding((FileObject)qmakeProjectFO);
                bw = new BufferedWriter(new OutputStreamWriter(SmartOutputStream.getSmartOutputStream(qmakeProjectFO), encoding));
                this.write(bw);
            }
        }
    }

    private void write(BufferedWriter bw) throws IOException {
        bw.write("# This file is generated automatically. Do not edit.\n");
        bw.write("# Use project properties -> Build -> Qt -> Expert -> Custom Definitions.\n");
        this.write(bw, Variable.TEMPLATE, Operation.SET, this.getTemplate());
        this.write(bw, Variable.DESTDIR, Operation.SET, this.expandAndQuote(this.configuration.getQmakeConfiguration().getDestdirValue()));
        this.write(bw, Variable.TARGET, Operation.SET, this.expandAndQuote(this.configuration.getQmakeConfiguration().getTargetValue()));
        this.write(bw, Variable.VERSION, Operation.SET, this.expandAndQuote(this.configuration.getQmakeConfiguration().getVersion().getValue()));
        this.write(bw, Variable.CONFIG, Operation.SUB, "debug_and_release app_bundle lib_bundle");
        this.write(bw, Variable.CONFIG, Operation.ADD, this.getConfig());
        this.write(bw, Variable.PKGCONFIG, Operation.ADD, this.getPkgConfig());
        this.write(bw, Variable.QT, Operation.SET, this.configuration.getQmakeConfiguration().getEnabledModules());
        Item[] items = ConfigurationMakefileWriter.getSortedProjectItems(this.projectDescriptor);
        this.write(bw, Variable.SOURCES, Operation.ADD, this.getItems(items, "text/x-c", "text/x-c++"));
        this.write(bw, Variable.HEADERS, Operation.ADD, this.getItems(items, "text/x-h"));
        this.write(bw, Variable.FORMS, Operation.ADD, this.getItems(items, "text/qtui+xml"));
        this.write(bw, Variable.RESOURCES, Operation.ADD, this.getItems(items, "text/qtresource+xml"));
        this.write(bw, Variable.TRANSLATIONS, Operation.ADD, this.getItems(items, "text/qttranslation+xml"));
        this.write(bw, Variable.OBJECTS_DIR, Operation.SET, this.expandAndQuote(ConfigurationMakefileWriter.getObjectDir(this.configuration)));
        this.write(bw, Variable.MOC_DIR, Operation.SET, this.expandAndQuote(this.configuration.getQmakeConfiguration().getMocDir().getValue()));
        this.write(bw, Variable.RCC_DIR, Operation.SET, this.expandAndQuote(this.configuration.getQmakeConfiguration().getRccDir().getValue()));
        this.write(bw, Variable.UI_DIR, Operation.SET, this.expandAndQuote(this.configuration.getQmakeConfiguration().getUiDir().getValue()));
        this.write(bw, Variable.QMAKE_CC, Operation.SET, ConfigurationMakefileWriter.getCompilerName(this.configuration, PredefinedToolKind.CCompiler));
        this.write(bw, Variable.QMAKE_CXX, Operation.SET, ConfigurationMakefileWriter.getCompilerName(this.configuration, PredefinedToolKind.CCCompiler));
        CompilerSet compilerSet = this.configuration.getCompilerSet().getCompilerSet();
        CCCCompilerConfiguration.OptionToString defineVisitor = new CCCCompilerConfiguration.OptionToString(compilerSet, null);
        this.write(bw, Variable.DEFINES, Operation.ADD, this.configuration.getCCCompilerConfiguration().getPreprocessorConfiguration().toString(defineVisitor));
        IncludeToString includeVisitor = new IncludeToString(compilerSet);
        this.write(bw, Variable.INCLUDEPATH, Operation.ADD, this.configuration.getCCCompilerConfiguration().getIncludeDirectories().toString(includeVisitor));
        this.write(bw, Variable.LIBS, Operation.ADD, this.getLibs());
        if (this.configuration.getCCCompilerConfiguration().getCppStandard().getValue() != 0) {
            AbstractCompiler ccCompiler;
            AbstractCompiler abstractCompiler = ccCompiler = compilerSet == null ? null : (AbstractCompiler)compilerSet.getTool((ToolKind)PredefinedToolKind.CCCompiler);
            if (ccCompiler != null) {
                bw.write("equals(QT_MAJOR_VERSION, 4) {\n");
                this.write(bw, Variable.QMAKE_CXXFLAGS, Operation.ADD, ccCompiler.getCppStandardOptions(this.configuration.getCCCompilerConfiguration().getCppStandard().getValue()));
                bw.write("}\n");
                if (this.configuration.getCCCompilerConfiguration().getCppStandard().getValue() == 2) {
                    bw.write("equals(QT_MAJOR_VERSION, 5) {\n");
                    this.write(bw, Variable.CONFIG, Operation.ADD, "c++11");
                    bw.write("}\n");
                }
            }
        }
        for (String line : this.configuration.getQmakeConfiguration().getCustomDefs().getValue()) {
            bw.write(line);
            bw.write(10);
        }
    }

    private void write(BufferedWriter bw, Variable var, Operation op, String value) throws IOException {
        bw.write(var.toString());
        bw.write(32);
        bw.write(op.getOp());
        bw.write(32);
        bw.write(value);
        bw.write(10);
    }

    private void write(BufferedWriter bw, Variable var, Operation op, List<String> values) throws IOException {
        bw.write(var.toString());
        bw.write(32);
        bw.write(op.getOp());
        for (String value : values) {
            bw.write(32);
            bw.write(value);
        }
        bw.write(10);
    }

    private List<String> getItems(Item[] items, String ... mimeTypes) {
        ArrayList<String> list = new ArrayList<String>();
        block0: for (Item item : items) {
            FileObject fo;
            ItemConfiguration itemConf = item.getItemConfiguration(this.configuration);
            if (itemConf == null || itemConf.getExcluded().getValue() || (fo = item.getFileObject()) == null) continue;
            String actualMimeType = fo.getMIMEType();
            for (String mimeType : mimeTypes) {
                if (!mimeType.equals(actualMimeType)) continue;
                list.add(CndPathUtilities.quoteIfNecessary((String)item.getPath()));
                continue block0;
            }
        }
        return list;
    }

    private String getTemplate() {
        switch (this.configuration.getConfigurationType().getValue()) {
            case 4: {
                return "app";
            }
            case 5: 
            case 6: {
                return "lib";
            }
        }
        return "";
    }

    private List<String> getConfig() {
        ArrayList<String> list = new ArrayList<String>();
        switch (this.configuration.getConfigurationType().getValue()) {
            case 5: {
                list.add("dll");
                break;
            }
            case 6: {
                list.add("staticlib");
            }
        }
        if (this.isPkgConfigUsed()) {
            list.add("link_pkgconfig");
        }
        list.add(this.configuration.getQmakeConfiguration().getBuildMode().getOption());
        return list;
    }

    private boolean isPkgConfigUsed() {
        for (LibraryItem lib : this.configuration.getLinkerConfiguration().getLibrariesConfiguration().getValue()) {
            LibraryItem.OptionItem option;
            if (lib.getType() != 4 || !(option = (LibraryItem.OptionItem)lib).getLibraryOption().contains(PKGCONFIG_BINARY)) continue;
            return true;
        }
        return false;
    }

    private List<String> getPkgConfig() {
        List libraries = this.configuration.getLinkerConfiguration().getLibrariesConfiguration().getValue();
        ArrayList<String> list = new ArrayList<String>(libraries.size());
        for (LibraryItem lib : libraries) {
            LibraryItem.OptionItem option;
            if (lib.getType() != 4 || !(option = (LibraryItem.OptionItem)lib).getLibraryOption().contains(PKGCONFIG_BINARY)) continue;
            list.add(option.getLibraryOption().replaceAll("`", "").replace(PKGCONFIG_BINARY, "").replace("--libs", "").trim());
        }
        return list;
    }

    private String getLibs() {
        StringBuilder buf = new StringBuilder();
        CompilerSet compilerSet = this.configuration.getCompilerSet().getCompilerSet();
        LibraryToString libVisitor = new LibraryToString(this.configuration);
        buf.append(this.configuration.getLinkerConfiguration().getLibrariesConfiguration().toString(libVisitor));
        if (compilerSet != null) {
            if (0 < buf.length()) {
                buf.append(' ');
            }
            CCCCompilerConfiguration.OptionToString dynamicSearchVisitor = new CCCCompilerConfiguration.OptionToString(compilerSet, compilerSet.getCompilerFlavor().getToolchainDescriptor().getLinker().getDynamicLibrarySearchFlag());
            buf.append(this.configuration.getLinkerConfiguration().getDynamicSearch().toString(dynamicSearchVisitor));
        }
        return buf.toString();
    }

    private String expandAndQuote(String s) {
        return CndPathUtilities.quoteIfNecessary((String)this.configuration.expandMacros(s));
    }

    private static class IncludeToString
    implements VectorConfiguration.ToString<String> {
        private final CompilerSet compilerSet;

        public IncludeToString(CompilerSet compilerSet) {
            this.compilerSet = compilerSet;
        }

        @Override
        public String toString(String item) {
            if (0 < item.length()) {
                if (this.compilerSet != null) {
                    item = CppUtils.normalizeDriveLetter(this.compilerSet, item);
                }
                return CndPathUtilities.quoteIfNecessary((String)item);
            }
            return "";
        }
    }

    private static class LibraryToString
    implements VectorConfiguration.ToString<LibraryItem> {
        private final MakeConfiguration configuration;

        public LibraryToString(MakeConfiguration configuration) {
            this.configuration = configuration;
        }

        @Override
        public String toString(LibraryItem item) {
            switch (item.getType()) {
                case 0: 
                case 3: {
                    return this.libFileToOptionsString(item.getPath());
                }
                case 1: 
                case 2: {
                    return item.getOption(this.configuration);
                }
                case 4: {
                    LibraryItem.OptionItem option = (LibraryItem.OptionItem)item;
                    if (!option.getLibraryOption().contains(QmakeProjectWriter.PKGCONFIG_BINARY)) {
                        return item.getOption(this.configuration);
                    }
                    return "";
                }
            }
            return "";
        }

        private String libFileToOptionsString(String path) {
            StringBuilder buf = new StringBuilder();
            CompilerSet compilerSet = this.configuration.getCompilerSet().getCompilerSet();
            if (compilerSet != null && this.isDynamicLib(path)) {
                String searchOption = compilerSet.getCompilerFlavor().getToolchainDescriptor().getLinker().getDynamicLibrarySearchFlag();
                if (searchOption.length() == 0) {
                    searchOption = compilerSet.getCompilerFlavor().getToolchainDescriptor().getLinker().getLibrarySearchFlag();
                }
                buf.append(searchOption);
                String dirName = CndPathUtilities.getDirName((String)path);
                if (dirName != null && dirName.length() > 0) {
                    buf.append(CndPathUtilities.quoteIfNecessary((String)dirName));
                    buf.append(' ');
                }
            }
            buf.append(CndPathUtilities.quoteIfNecessary((String)path));
            return buf.toString();
        }

        private boolean isDynamicLib(String path) {
            return path.endsWith(".dll") || path.endsWith(".dylib") || path.endsWith(".so") || 0 <= path.indexOf(".so.");
        }
    }

    private static enum Operation {
        SET("="),
        ADD("+="),
        SUB("-=");

        private final String op;

        private Operation(String op) {
            this.op = op;
        }

        public String getOp() {
            return this.op;
        }
    }

    private static enum Variable {
        TEMPLATE,
        DESTDIR,
        TARGET,
        VERSION,
        CONFIG,
        PKGCONFIG,
        QT,
        SOURCES,
        HEADERS,
        FORMS,
        RESOURCES,
        TRANSLATIONS,
        DEFINES,
        INCLUDEPATH,
        LIBS,
        QMAKE_CC,
        QMAKE_CXX,
        MOC_DIR,
        RCC_DIR,
        UI_DIR,
        OBJECTS_DIR,
        QMAKE_CXXFLAGS;

    }
}

