/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.configurations.ui;

import java.awt.Component;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.util.ArrayList;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.makeproject.api.configurations.DevelopmentHostConfiguration;
import org.netbeans.modules.cnd.makeproject.ui.customizer.DevelopmentHostCustomizer;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class DevelopmentHostNodeProp
extends Node.Property {
    private final DevelopmentHostConfiguration configuration;
    private final boolean canWrite;
    private final String name;
    private final String displayName;
    private final String description;

    public DevelopmentHostNodeProp(DevelopmentHostConfiguration configuration, boolean canWrite, String name, String displayName, String description) {
        super(Integer.class);
        this.configuration = configuration;
        this.canWrite = canWrite;
        this.name = name;
        this.displayName = displayName;
        this.description = description;
        this.setValue("title", NbBundle.getMessage(DevelopmentHostNodeProp.class, (String)"DLG_TITLE_Connect"));
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getShortDescription() {
        return this.description;
    }

    public String getHtmlDisplayName() {
        if (this.configuration.getModified()) {
            return "<b>" + this.getDisplayName() + "</b>";
        }
        return null;
    }

    public Object getValue() {
        return this.configuration.getValue();
    }

    public Object getValue(String attributeName) {
        if (attributeName.equals("canAutoComplete")) {
            return Boolean.FALSE;
        }
        return super.getValue(attributeName);
    }

    public void setValue(Object value) {
        this.configuration.setValue((String)value, true);
    }

    public void restoreDefaultValue() {
        this.configuration.reset();
    }

    public boolean supportsDefaultValue() {
        return true;
    }

    public boolean isDefaultValue() {
        return !this.configuration.getModified();
    }

    public boolean canWrite() {
        return this.canWrite;
    }

    public boolean canRead() {
        return true;
    }

    public PropertyEditor getPropertyEditor() {
        return new IntEditor();
    }

    private class IntEditor
    extends PropertyEditorSupport
    implements ExPropertyEditor {
        private PropertyEnv env;

        private IntEditor() {
        }

        @Override
        public String getJavaInitializationString() {
            return this.getAsText();
        }

        @Override
        public String getAsText() {
            return DevelopmentHostNodeProp.this.configuration.getDisplayName(true);
        }

        @Override
        public void setAsText(String text) throws IllegalArgumentException {
            super.setValue(text);
        }

        @Override
        public void setValue(Object value) {
            super.setValue(value);
        }

        @Override
        public String[] getTags() {
            ArrayList<String> l = new ArrayList<String>();
            for (ServerRecord record : ServerList.getRecords()) {
                l.add(record.getDisplayName());
            }
            return l.toArray(new String[l.size()]);
        }

        @Override
        public boolean supportsCustomEditor() {
            return DevelopmentHostNodeProp.this.canWrite;
        }

        @Override
        public Component getCustomEditor() {
            return new DevelopmentHostCustomizer(DevelopmentHostNodeProp.this.configuration, this, this.env);
        }

        public void attachEnv(PropertyEnv env) {
            this.env = env;
        }
    }
}

