/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.launchers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.cnd.makeproject.LaunchersRegistryAccessor;
import org.netbeans.modules.cnd.makeproject.launchers.Launcher;
import org.netbeans.modules.cnd.makeproject.launchers.LaunchersProjectMetadataFactory;
import org.netbeans.modules.cnd.makeproject.launchers.LaunchersRegistryFactory;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.lookup.Lookups;

public final class LaunchersRegistry {
    private final List<Launcher> launchers = new ArrayList<Launcher>();
    private static final Object lock = "LaunchersRegistryLock";
    private static final String LAUNCHER_TAG = "launcher";
    private static final String COMMON_TAG = "common";
    private static final String COMMAND_TAG = "runCommand";
    private static final String BUILD_COMMAND_TAG = "buildCommand";
    private static final String NAME_TAG = "displayName";
    private static final String DIRECTORY_TAG = "runDir";
    private static final String SYMFILES_TAG = "symbolFiles";
    private static final String ENV_TAG = "env";
    private static Pattern pattern;
    private Object privateLaucnhersListener = null;

    void setPrivateLaucnhersListener(Object privateLaucnhersListener) {
        this.privateLaucnhersListener = privateLaucnhersListener;
    }

    private Object getPrivateLaucnhersListener() {
        return this.privateLaucnhersListener;
    }

    LaunchersRegistry() {
        String regex = "launcher(\\d*)[.]runCommand";
        pattern = Pattern.compile(regex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Launcher launcher) {
        Object object = lock;
        synchronized (object) {
            if (this.launchers.contains(launcher)) {
                return;
            }
            this.launchers.add(launcher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Launcher launcher) {
        Object object = lock;
        synchronized (object) {
            this.launchers.remove(launcher);
        }
    }

    public boolean hasLaunchers() {
        return !this.launchers.isEmpty();
    }

    public Collection<Launcher> getLaunchers() {
        return Collections.unmodifiableCollection(this.launchers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean load(Properties properties) {
        ArrayList<Launcher> newLaunchers = new ArrayList<Launcher>();
        Launcher common = this.create(-1, COMMON_TAG, properties, null);
        for (String key : properties.stringPropertyNames()) {
            int index;
            Launcher l;
            Matcher matcher = pattern.matcher(key);
            if (!matcher.find() || (l = this.create(index = Integer.parseInt(matcher.group(1)), key.substring(0, key.indexOf(".runCommand")), properties, common)) == null) continue;
            newLaunchers.add(l);
        }
        Collections.sort(newLaunchers, new Comparator<Launcher>(){

            @Override
            public int compare(Launcher o1, Launcher o2) {
                return o1.getIndex() - o2.getIndex();
            }
        });
        boolean modified = false;
        Object object = lock;
        synchronized (object) {
            if (!this.isEqualsLauncers(newLaunchers)) {
                this.launchers.clear();
                this.launchers.addAll(newLaunchers);
                modified = true;
            }
        }
        return modified;
    }

    private boolean isEqualsLauncers(List<Launcher> newLaunchers) {
        if (this.launchers.size() != newLaunchers.size()) {
            return false;
        }
        for (int i = 0; i < this.launchers.size(); ++i) {
            Launcher l2;
            Launcher l1 = this.launchers.get(i);
            if (l1.isLauncherEquals(l2 = newLaunchers.get(i))) continue;
            return false;
        }
        return true;
    }

    private Launcher create(int index, String name, Properties properties, Launcher common) {
        boolean commonLauncher = name.equals(COMMON_TAG);
        assert (!commonLauncher || common == null) : "common launcher can not have other common";
        String command = properties.getProperty(name + "." + COMMAND_TAG);
        assert (commonLauncher || command != null) : "usual launcher without command " + name;
        Launcher launcher = new Launcher(index, command, common);
        String displayName = properties.getProperty(name + "." + NAME_TAG);
        if (displayName != null) {
            launcher.setName(displayName);
        } else {
            launcher.setName(command);
        }
        String buildCommand = properties.getProperty(name + "." + BUILD_COMMAND_TAG);
        launcher.setBuildCommand(buildCommand);
        String directory = properties.getProperty(name + "." + DIRECTORY_TAG);
        launcher.setRunDir(directory);
        String symFiles = properties.getProperty(name + "." + SYMFILES_TAG);
        launcher.setSymbolFiles(symFiles);
        for (String key : properties.stringPropertyNames()) {
            if (!key.matches(name + "[.]" + ENV_TAG + "[.]\\w+")) continue;
            launcher.putEnv(key.substring(key.lastIndexOf(".") + 1), properties.getProperty(key));
        }
        return launcher;
    }

    static {
        LaunchersRegistryAccessor.setDefault(new LaunchersRegistryAccessorImpl());
    }

    private static final class LaunchersRegistryAccessorImpl
    extends LaunchersRegistryAccessor {
        private LaunchersRegistryAccessorImpl() {
        }

        @Override
        public void assertPrivateListenerNotNull(FileObject dir) {
            if (LaunchersRegistryFactory.getInstance(dir).getPrivateLaucnhersListener() == null) {
                LaunchersProjectMetadataFactory factoryInstance = (LaunchersProjectMetadataFactory)Lookups.forPath((String)"Projects/org-netbeans-modules-cnd-makeproject/ProjectMetadataFactory").lookup(LaunchersProjectMetadataFactory.class);
                factoryInstance.read(dir);
                CndUtils.assertUnconditional((String)("Private launchers listener is null for " + dir));
            }
        }
    }
}

