/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui;

import java.awt.EventQueue;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.cnd.api.remote.RemoteFileUtil;
import org.netbeans.modules.cnd.makeproject.MakeProject;
import org.netbeans.modules.cnd.makeproject.MakeProjectTypeImpl;
import org.netbeans.modules.cnd.makeproject.actions.AddExistingFolderItemsAction;
import org.netbeans.modules.cnd.makeproject.actions.DebugTestAction;
import org.netbeans.modules.cnd.makeproject.actions.NewTestActionFactory;
import org.netbeans.modules.cnd.makeproject.actions.RunTestAction;
import org.netbeans.modules.cnd.makeproject.actions.StepIntoTestAction;
import org.netbeans.modules.cnd.makeproject.api.actions.AddExistingItemAction;
import org.netbeans.modules.cnd.makeproject.api.actions.NewFolderAction;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.ui.AnnotatedNode;
import org.netbeans.modules.cnd.makeproject.ui.FolderSearchInfo;
import org.netbeans.modules.cnd.makeproject.ui.LogicalViewChildren;
import org.netbeans.modules.cnd.makeproject.ui.MakeLogicalViewProvider;
import org.netbeans.modules.cnd.makeproject.ui.NodeActionFactory;
import org.netbeans.modules.cnd.makeproject.ui.PropertiesFolderAction;
import org.netbeans.modules.cnd.makeproject.ui.RemoveFolderAction;
import org.netbeans.modules.cnd.makeproject.ui.ViewFolderPasteType;
import org.netbeans.modules.cnd.makeproject.ui.ViewItemNode;
import org.netbeans.modules.cnd.makeproject.ui.ViewItemPasteType;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.ProjectSensitiveActions;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.DeleteAction;
import org.openide.actions.FileSystemAction;
import org.openide.actions.FindAction;
import org.openide.actions.PasteAction;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.Lookups;

final class LogicalFolderNode
extends AnnotatedNode
implements ChangeListener {
    private static final MessageFormat FOLDER_VIEW_FLAVOR = new MessageFormat("application/x-org-netbeans-modules-cnd-makeproject-uidnd-folder; class=org.netbeans.modules.cnd.makeproject.ui.LogicalFolderNode; mask={0}");
    private final Folder folder;
    private final MakeLogicalViewProvider provider;
    private final String pathPostfix;
    private RequestProcessor.Task updateTask;

    public LogicalFolderNode(Node folderNode, Folder folder, MakeLogicalViewProvider provider) {
        super((Children)new LogicalViewChildren(folder, provider), LogicalFolderNode.createLFNLookup(folderNode, folder, provider), provider.getAnnotationRP());
        String absPath;
        this.folder = folder;
        this.provider = provider;
        String postfix = "";
        if (folder != null && folder.getRoot() != null && (absPath = folder.getAbsolutePath()) != null) {
            postfix = " - " + absPath;
        }
        this.pathPostfix = postfix;
        this.setForceAnnotation(true);
        this.updateAnnotationFiles();
    }

    private static Lookup createLFNLookup(Node folderNode, Folder folder, MakeLogicalViewProvider provider) {
        ArrayList<Object> elems = new ArrayList<Object>(3);
        elems.add(folder);
        elems.add((Object)new FolderSearchInfo(folder));
        if (!folder.isDiskFolder()) {
            elems.add(provider.getProject());
        } else {
            MakeConfigurationDescriptor conf = folder.getConfigurationDescriptor();
            if (conf != null) {
                String rootPath = folder.getRootPath();
                FileObject fo = RemoteFileUtil.getFileObject((FileObject)conf.getBaseDirFileObject(), (String)rootPath);
                if (fo != null && fo.isValid() && fo.isFolder()) {
                    try {
                        DataFolder dataFolder = DataFolder.findFolder((FileObject)fo);
                        if (dataFolder != null) {
                            elems.add(dataFolder);
                        }
                    }
                    catch (IllegalArgumentException ex) {
                        // empty catch block
                    }
                    File file = FileUtil.toFile((FileObject)fo);
                    if (file != null) {
                        elems.add(file);
                    }
                }
            }
        }
        return Lookups.fixed((Object[])elems.toArray());
    }

    private void updateAnnotationFiles() {
        if (this.updateTask == null) {
            this.updateTask = this.provider.getAnnotationRP().create((Runnable)new FileAnnotationUpdater(this));
        }
        this.updateTask.schedule(50);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.updateAnnotationFiles();
    }

    public Folder getFolder() {
        return this.folder;
    }

    public Object getValue(String valstring) {
        if (valstring == null) {
            return super.getValue(null);
        }
        if (valstring.equals("Folder")) {
            return this.folder;
        }
        if (valstring.equals("Project")) {
            return this.provider.getProject();
        }
        if (valstring.equals("This")) {
            return this;
        }
        if (valstring.equals("slowRename")) {
            return null;
        }
        return super.getValue(valstring);
    }

    public Image getIcon(int type) {
        Image image = this.folder.isTest() ? ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/makeproject/ui/resources/testContainer.gif") : (this.folder.isTestRootFolder() ? ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/makeproject/ui/resources/testFolder.gif") : (this.folder.isDiskFolder() && this.folder.isTestLogicalFolder() ? ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/makeproject/ui/resources/testFolder.gif") : (this.folder.isDiskFolder() ? ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/makeproject/ui/resources/tree_folder.gif") : ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/makeproject/ui/resources/logicalFilesFolder.gif"))));
        if (this.folder.isProjectFiles() && this.folder.isRemoved()) {
            image = ImageUtilities.mergeImages((Image)image, (Image)MakeLogicalViewProvider.brokenFolderBadge, (int)11, (int)0);
        }
        image = this.annotateIcon(image, type);
        return image;
    }

    public Image getOpenedIcon(int type) {
        Image image = this.folder.isTest() ? ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/makeproject/ui/resources/testContainer.gif") : (this.folder.isTestRootFolder() ? ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/makeproject/ui/resources/testFolderOpened.gif") : (this.folder.isDiskFolder() && this.folder.isTestLogicalFolder() ? ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/makeproject/ui/resources/testFolder.gif") : (this.folder.isDiskFolder() ? ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/makeproject/ui/resources/tree_folder.gif") : ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/makeproject/ui/resources/logicalFilesFolderOpened.gif"))));
        if (this.folder.isProjectFiles() && this.folder.isRemoved()) {
            image = ImageUtilities.mergeImages((Image)image, (Image)MakeLogicalViewProvider.brokenFolderBadge, (int)11, (int)0);
        }
        image = this.annotateIcon(image, type);
        return image;
    }

    public String getName() {
        return this.folder.getDisplayName();
    }

    public String getDisplayName() {
        return this.annotateName(this.folder.getDisplayName() + this.pathPostfix);
    }

    public void setName(final String newName) {
        this.provider.getAnnotationRP().post(new Runnable(){

            @Override
            public void run() {
                LogicalFolderNode.this.setNameImpl(newName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNameImpl(String newName) {
        String oldName = this.folder.getDisplayName();
        if (this.folder.isDiskFolder()) {
            String rootPath = this.folder.getRootPath();
            FileObject fo = RemoteFileUtil.getFileObject((FileObject)this.folder.getConfigurationDescriptor().getBaseDirFileObject(), (String)rootPath);
            if (fo == null || !fo.isValid() || !fo.isFolder()) {
                return;
            }
            FileLock lock = null;
            try {
                lock = fo.lock();
                fo.rename(lock, newName, null);
            }
            catch (IOException ioe) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)ioe.getMessage()));
            }
            finally {
                if (lock != null) {
                    lock.releaseLock();
                }
            }
            return;
        }
        if (this.folder.getParent() != null && this.folder.getParent().findFolderByDisplayName(newName) != null) {
            String msg = NbBundle.getMessage(MakeLogicalViewProvider.class, (String)"CANNOT_RENAME", (Object)oldName, (Object)newName);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg));
            return;
        }
        this.folder.setDisplayName(newName);
        this.fireDisplayNameChange(oldName, newName);
    }

    public boolean canRename() {
        return true;
    }

    public boolean canDestroy() {
        return true;
    }

    public boolean canCut() {
        return true;
    }

    public boolean canCopy() {
        return true;
    }

    public Transferable clipboardCopy() throws IOException {
        return this.addViewFolderTransferable(super.clipboardCopy(), 1);
    }

    public Transferable clipboardCut() throws IOException {
        return this.addViewFolderTransferable(super.clipboardCut(), 2);
    }

    public Transferable drag() throws IOException {
        return this.addViewFolderTransferable(super.drag(), 0);
    }

    public void destroy() throws IOException {
        this.provider.getAnnotationRP().post(new Runnable(){

            @Override
            public void run() {
                try {
                    LogicalFolderNode.this.destroyImpl();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
    }

    public void destroyImpl() throws IOException {
        Folder aFolder = this.getFolder();
        if (!aFolder.isDiskFolder()) {
            MakeConfigurationDescriptor makeConfigurationDescriptor;
            ConfigurationDescriptorProvider pdp;
            MakeProject project;
            Folder parent = aFolder.getParent();
            if (parent != null && this.provider != null && (project = this.provider.getProject()) != null && (pdp = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class)) != null && (makeConfigurationDescriptor = pdp.getConfigurationDescriptor()).okToChange()) {
                parent.removeFolderAction(this.folder);
                makeConfigurationDescriptor.save();
            }
            return;
        }
        String absPath = CndPathUtilities.toAbsolutePath((FileObject)aFolder.getConfigurationDescriptor().getBaseDirFileObject(), (String)aFolder.getRootPath());
        FileObject folderFileObject = CndFileUtils.toFileObject((FileSystem)aFolder.getConfigurationDescriptor().getBaseDirFileSystem(), (CharSequence)absPath);
        if (folderFileObject == null || !folderFileObject.isValid() || !folderFileObject.isFolder()) {
            return;
        }
        folderFileObject.delete();
        Folder parent = aFolder.getParent();
        if (parent != null) {
            parent.removeFolderAction(aFolder);
        }
        super.destroy();
    }

    public PasteType getDropType(Transferable transferable, int action, int index) {
        DataFlavor[] flavors = transferable.getTransferDataFlavors();
        for (int i = 0; i < flavors.length; ++i) {
            if (flavors[i].getSubType().equals("x-org-netbeans-modules-cnd-makeproject-uidnd")) {
                return super.getDropType(transferable, action, index);
            }
            if (!flavors[i].getSubType().equals("x-org-netbeans-modules-cnd-makeproject-uidnd-folder")) continue;
            return super.getDropType(transferable, action, index);
        }
        return null;
    }

    protected void createPasteTypes(Transferable transferable, List<PasteType> list) {
        if (this.folder.isTestLogicalFolder()) {
            return;
        }
        DataFlavor[] flavors = transferable.getTransferDataFlavors();
        for (int i = 0; i < flavors.length; ++i) {
            int type;
            if (flavors[i].getSubType().equals("x-org-netbeans-modules-cnd-makeproject-uidnd")) {
                try {
                    ViewItemNode viewItemNode = (ViewItemNode)transferable.getTransferData(flavors[i]);
                    type = Integer.parseInt(flavors[i].getParameter("mask"));
                    list.add(new ViewItemPasteType(this.getFolder(), viewItemNode, type, this.provider));
                }
                catch (Exception e) {}
                continue;
            }
            if (!flavors[i].getSubType().equals("x-org-netbeans-modules-cnd-makeproject-uidnd-folder")) continue;
            try {
                LogicalFolderNode viewFolderNode = (LogicalFolderNode)transferable.getTransferData(flavors[i]);
                if (viewFolderNode == this) continue;
                type = Integer.parseInt(flavors[i].getParameter("mask"));
                list.add(new ViewFolderPasteType(this.folder, viewFolderNode, type, this.provider));
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        super.createPasteTypes(transferable, list);
    }

    private ExTransferable addViewFolderTransferable(Transferable t, int operation) {
        try {
            ExTransferable extT = ExTransferable.create((Transferable)t);
            ViewFolderTransferable viewItem = new ViewFolderTransferable(this, operation);
            extT.put((ExTransferable.Single)viewItem);
            return extT;
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void newLogicalFolder() {
    }

    public Action[] getActions(boolean context) {
        Action[] result;
        ResourceBundle bundle = NbBundle.getBundle(MakeLogicalViewProvider.class);
        if (this.folder.isTestRootFolder()) {
            result = new Action[]{null, ProjectSensitiveActions.projectCommandAction((String)"test", (String)bundle.getString("LBL_TestAction_Name"), null), null, NewTestActionFactory.emptyTestFolderAction(), SystemAction.get(NewFolderAction.class), SystemAction.get(FindAction.class), null, SystemAction.get(PropertiesFolderAction.class)};
            result = NodeActionFactory.insertAfter(NewTestActionFactory.getTestCreationActions(this.folder.getProject()), result);
        } else if (this.folder.isTestLogicalFolder() && !this.folder.isDiskFolder()) {
            result = new Action[]{null, NewTestActionFactory.emptyTestFolderAction(), SystemAction.get(NewFolderAction.class), SystemAction.get(FindAction.class), null, SystemAction.get(RemoveFolderAction.class), NodeActionFactory.createRenameAction(), null, SystemAction.get(PropertiesFolderAction.class)};
            result = NodeActionFactory.insertAfter(NewTestActionFactory.getTestCreationActions(this.folder.getProject()), result);
        } else {
            result = this.folder.isTest() ? new Action[]{CommonProjectActions.newFileAction(), SystemAction.get(AddExistingItemAction.class), SystemAction.get(FindAction.class), null, SystemAction.get(RunTestAction.class), SystemAction.get(DebugTestAction.class), SystemAction.get(StepIntoTestAction.class), null, SystemAction.get(RemoveFolderAction.class), NodeActionFactory.createRenameAction(), null, SystemAction.get(PropertiesFolderAction.class)} : (this.folder.isDiskFolder() ? (this.folder.isRemoved() ? new Action[]{CommonProjectActions.newFileAction(), null, SystemAction.get(RemoveFolderAction.class), null, SystemAction.get(FileSystemAction.class), null, SystemAction.get(PropertiesFolderAction.class)} : new Action[]{CommonProjectActions.newFileAction(), SystemAction.get(FindAction.class), null, SystemAction.get(CutAction.class), SystemAction.get(CopyAction.class), SystemAction.get(PasteAction.class), null, SystemAction.get(DeleteAction.class), NodeActionFactory.createRenameAction(), null, SystemAction.get(FileSystemAction.class), null, SystemAction.get(PropertiesFolderAction.class)}) : new Action[]{CommonProjectActions.newFileAction(), SystemAction.get(NewFolderAction.class), SystemAction.get(AddExistingItemAction.class), SystemAction.get(AddExistingFolderItemsAction.class), SystemAction.get(FindAction.class), null, SystemAction.get(CutAction.class), SystemAction.get(CopyAction.class), SystemAction.get(PasteAction.class), null, SystemAction.get(RemoveFolderAction.class), NodeActionFactory.createRenameAction(), null, SystemAction.get(PropertiesFolderAction.class)});
        }
        MakeProjectTypeImpl projectKind = (MakeProjectTypeImpl)this.provider.getProject().getLookup().lookup(MakeProjectTypeImpl.class);
        List actionsForMakeProject = Utilities.actionsForPath((String)projectKind.folderActionsPath());
        result = NodeActionFactory.insertAfter(result, actionsForMakeProject.toArray(new Action[actionsForMakeProject.size()]), NodeActionFactory.RenameNodeAction.class);
        result = NodeActionFactory.insertSyncActions(result, NodeActionFactory.RenameNodeAction.class);
        return result;
    }

    private static final class ViewFolderTransferable
    extends ExTransferable.Single {
        private final LogicalFolderNode node;

        public ViewFolderTransferable(LogicalFolderNode node, int operation) throws ClassNotFoundException {
            super(new DataFlavor(FOLDER_VIEW_FLAVOR.format(new Object[]{operation}), null, MakeLogicalViewProvider.class.getClassLoader()));
            this.node = node;
        }

        protected Object getData() throws IOException, UnsupportedFlavorException {
            return this.node;
        }
    }

    private final class VisualUpdater
    implements Runnable {
        private VisualUpdater() {
        }

        @Override
        public void run() {
            LogicalFolderNode.this.fireIconChange();
            LogicalFolderNode.this.fireOpenedIconChange();
        }
    }

    private final class FileAnnotationUpdater
    implements Runnable {
        private final LogicalFolderNode logicalFolderNode;

        FileAnnotationUpdater(LogicalFolderNode logicalFolderNode2) {
            this.logicalFolderNode = logicalFolderNode2;
        }

        @Override
        public void run() {
            MakeConfigurationDescriptor conf;
            Set<FileObject> newSet = Collections.emptySet();
            if (LogicalFolderNode.this.folder.isDiskFolder() && (conf = LogicalFolderNode.this.folder.getConfigurationDescriptor()) != null) {
                String rootPath = LogicalFolderNode.this.folder.getRootPath();
                FileObject fo = RemoteFileUtil.getFileObject((FileObject)conf.getBaseDirFileObject(), (String)rootPath);
                if (fo != null && fo.isValid() && fo.isFolder()) {
                    newSet = Collections.singleton(fo);
                }
            }
            LogicalFolderNode.this.setFiles(newSet);
            ArrayList<Folder> allFolders = new ArrayList<Folder>();
            allFolders.add(LogicalFolderNode.this.folder);
            allFolders.addAll(LogicalFolderNode.this.folder.getAllFolders(true));
            Iterator iter = allFolders.iterator();
            while (iter.hasNext()) {
                ((Folder)iter.next()).addChangeListener(this.logicalFolderNode);
            }
            EventQueue.invokeLater(new VisualUpdater());
        }
    }
}

