/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.wizards;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.cnd.api.remote.RemoteFileUtil;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.makeproject.api.wizards.BuildSupport;
import org.netbeans.modules.cnd.makeproject.api.wizards.PreBuildSupport;
import org.netbeans.modules.cnd.makeproject.api.wizards.ProjectWizardPanels;
import org.netbeans.modules.cnd.makeproject.api.wizards.WizardConstants;
import org.netbeans.modules.cnd.makeproject.ui.wizards.NewProjectWizardUtils;
import org.netbeans.modules.cnd.makeproject.ui.wizards.SelectModePanel;
import org.netbeans.modules.cnd.makeproject.ui.wizards.WizardStorage;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class SelectModeDescriptorPanel
implements ProjectWizardPanels.MakeModePanel<WizardDescriptor>,
ProjectWizardPanels.NamedPanel,
ChangeListener {
    private WizardDescriptor wizardDescriptor;
    private SelectModePanel component;
    private final String name;
    private final MyWizardStorage wizardStorage;
    private boolean isValid = false;
    private int generation = 0;
    private final Object lock = new Object();
    private final Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);

    public SelectModeDescriptorPanel() {
        this.name = NbBundle.getMessage(SelectModePanel.class, (String)"SelectModeName");
        this.wizardStorage = new MyWizardStorage();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public SelectModePanel getComponent() {
        if (this.component == null) {
            this.component = new SelectModePanel(this);
            this.component.setName(this.name);
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        return new HelpCtx("NewMakeWizardP0");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid() {
        Object object = this.lock;
        synchronized (object) {
            return this.isValid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validate() {
        int gen;
        Object object = this.lock;
        synchronized (object) {
            gen = this.generation;
        }
        boolean tmpValid = this.component.valid();
        boolean fire = false;
        Object object2 = this.lock;
        synchronized (object2) {
            if (this.generation == gen) {
                this.isValid = tmpValid;
                fire = true;
            }
        }
        if (fire) {
            this.fireChangeEvent();
        }
    }

    private void setMode(boolean isSimple) {
        WizardConstants.PROPERTY_SIMPLE_MODE.put(this.wizardDescriptor, isSimple);
        this.validate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void invalidate() {
        Object object = this.lock;
        synchronized (object) {
            this.isValid = false;
            ++this.generation;
        }
        this.fireChangeEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator<ChangeListener> it;
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            it = new HashSet<ChangeListener>(this.listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            it.next().stateChanged(ev);
        }
    }

    WizardDescriptor getWizardDescriptor() {
        return this.wizardDescriptor;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object o = this.component.getClientProperty("WizardPanel_contentData");
        String[] names = (String[])o;
        String[] res = Boolean.TRUE.equals(WizardConstants.PROPERTY_SIMPLE_MODE.get(this.wizardDescriptor)) ? new String[]{names[0]} : new String[]{names[0], "..."};
        this.component.putClientProperty("WizardPanel_contentData", res);
        this.fireChangeEvent();
    }

    public boolean isFinishPanel() {
        return Boolean.TRUE.equals(WizardConstants.PROPERTY_SIMPLE_MODE.get(this.wizardDescriptor));
    }

    public void readSettings(WizardDescriptor settings) {
        this.wizardDescriptor = settings;
        if (WizardConstants.PROPERTY_SIMPLE_MODE.get(this.wizardDescriptor) == null) {
            WizardConstants.PROPERTY_SIMPLE_MODE.put(this.wizardDescriptor, Boolean.TRUE);
        }
        this.getComponent().read(this.wizardDescriptor);
    }

    public void storeSettings(WizardDescriptor settings) {
        this.getComponent().store(settings);
        if (Boolean.TRUE.equals(WizardConstants.PROPERTY_SIMPLE_MODE.get(settings))) {
            this.wizardStorage.finishWizard(this.wizardDescriptor);
        }
    }

    public WizardStorage getWizardStorage() {
        return this.wizardStorage;
    }

    @Override
    public void setFinishPanel(boolean isFinishPanel) {
    }

    boolean isFullRemote() {
        return WizardConstants.PROPERTY_REMOTE_FILE_SYSTEM_ENV.get(this.wizardDescriptor) != null;
    }

    private class MyWizardStorage
    implements WizardStorage {
        volatile String projectPath = "";
        volatile FileObject sourceFileObject;
        volatile String flags = "";
        volatile boolean setMain = true;
        volatile boolean buildProject = true;
        volatile CompilerSet cs;
        volatile boolean defaultCompilerSet;
        volatile ExecutionEnvironment buildEnv = ServerList.getDefaultRecord().getExecutionEnvironment();
        volatile ExecutionEnvironment sourceEnv = NewProjectWizardUtils.getDefaultSourceEnvironment();
        volatile ExecutionEnvironment fullRemoteEnv;
        volatile FileObject makefileFO;

        void finishWizard(WizardDescriptor settings) {
            if (this.getSourcesFileObject() == null) {
                return;
            }
            WizardConstants.PROPERTY_HOST_UID.put(settings, ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)this.getExecutionEnvironment()));
            WizardConstants.PROPERTY_SOURCE_HOST_ENV.put(settings, this.getSourceExecutionEnvironment());
            WizardConstants.PROPERTY_TOOLCHAIN_DEFAULT.put(settings, this.isDefaultCompilerSet());
            WizardConstants.PROPERTY_TOOLCHAIN.put(settings, this.getCompilerSet());
            WizardConstants.PROPERTY_NATIVE_PROJ_DIR.put(settings, this.getSourcesFileObject().getPath());
            WizardConstants.PROPERTY_NATIVE_PROJ_FO.put(settings, this.getSourcesFileObject());
            WizardConstants.PROPERTY_SIMPLE_MODE.put(settings, Boolean.TRUE);
            try {
                WizardConstants.PROPERTY_PROJECT_FOLDER.put(settings, new FSPath(this.getSourcesFileObject().getFileSystem(), this.getSourcesFileObject().getPath()));
            }
            catch (FileStateInvalidException ex) {
                // empty catch block
            }
            PreBuildSupport.PreBuildArtifact scriptArtifact = this.getScriptArtifact();
            BuildSupport.BuildFile makeArtifact = null;
            if (scriptArtifact != null) {
                WizardConstants.PROPERTY_RUN_CONFIGURE.put(settings, Boolean.TRUE);
                FileObject script = scriptArtifact.getScript();
                WizardConstants.PROPERTY_CONFIGURE_RUN_FOLDER.put(settings, script.getParent().getPath());
                WizardConstants.PROPERTY_CONFIGURE_SCRIPT_PATH.put(settings, script.getPath());
                String args = scriptArtifact.getArguments(this.buildEnv, this.cs, this.flags);
                WizardConstants.PROPERTY_CONFIGURE_SCRIPT_ARGS.put(settings, args);
                String command = scriptArtifact.getCommandLine(args, script.getParent().getPath());
                WizardConstants.PROPERTY_CONFIGURE_COMMAND.put(settings, command);
                String makefile = script.getParent().getPath() + "/Makefile";
                ExecutionEnvironment env = WizardConstants.PROPERTY_REMOTE_FILE_SYSTEM_ENV.get(SelectModeDescriptorPanel.this.wizardDescriptor);
                if (env != null) {
                    makefile = RemoteFileUtil.normalizeAbsolutePath((String)makefile, (ExecutionEnvironment)env);
                }
                makeArtifact = BuildSupport.scriptToBuildFile(makefile);
            }
            if (makeArtifact == null) {
                makeArtifact = this.getMakeArtifact();
            }
            if (makeArtifact != null) {
                WizardConstants.PROPERTY_RUN_REBUILD.put(settings, Boolean.TRUE);
                WizardConstants.PROPERTY_USER_MAKEFILE_PATH.put(settings, makeArtifact.getFile());
                WizardConstants.PROPERTY_WORKING_DIR.put(settings, CndPathUtilities.getDirName((String)makeArtifact.getFile()));
                WizardConstants.PROPERTY_BUILD_COMMAND.put(settings, makeArtifact.getBuildCommandLine(null, CndPathUtilities.getDirName((String)makeArtifact.getFile())));
                WizardConstants.PROPERTY_CLEAN_COMMAND.put(settings, makeArtifact.getCleanCommandLine(null, CndPathUtilities.getDirName((String)makeArtifact.getFile())));
            }
        }

        @Override
        public void setMode(boolean isSimple) {
            SelectModeDescriptorPanel.this.setMode(isSimple);
        }

        @Override
        public String getProjectPath() {
            return this.projectPath;
        }

        @Override
        public FileObject getSourcesFileObject() {
            return this.sourceFileObject;
        }

        @Override
        public void setProjectPath(String path) {
            this.projectPath = path.trim();
            SelectModeDescriptorPanel.this.validate();
        }

        @Override
        public void setSourcesFileObject(FileObject fileObject) {
            this.sourceFileObject = fileObject;
            SelectModeDescriptorPanel.this.validate();
        }

        @Override
        public String getConfigure() {
            PreBuildSupport.PreBuildArtifact scriptArtifact = this.getScriptArtifact();
            if (scriptArtifact != null) {
                return scriptArtifact.getScript().getPath();
            }
            return null;
        }

        private PreBuildSupport.PreBuildArtifact getScriptArtifact() {
            if (this.sourceFileObject != null) {
                return PreBuildSupport.findArtifactInFolder(this.sourceFileObject, this.sourceEnv, this.cs);
            }
            if (SelectModeDescriptorPanel.this.wizardDescriptor != null) {
                ExecutionEnvironment env = WizardConstants.PROPERTY_REMOTE_FILE_SYSTEM_ENV.get(SelectModeDescriptorPanel.this.wizardDescriptor);
                if (env == null) {
                    env = ExecutionEnvironmentFactory.getLocal();
                }
                FileSystem fileSystem = FileSystemProvider.getFileSystem((ExecutionEnvironment)env);
                return PreBuildSupport.findArtifactInFolder(fileSystem.findResource(this.projectPath), this.sourceEnv, this.cs);
            }
            return null;
        }

        private BuildSupport.BuildFile getMakeArtifact() {
            if (this.makefileFO != null) {
                return BuildSupport.scriptToBuildFile(this.makefileFO.getPath());
            }
            return null;
        }

        @Override
        public String getMake() {
            return this.makefileFO == null ? null : this.makefileFO.getPath();
        }

        @Override
        public void setMake(FileObject makefileFO) {
            this.makefileFO = makefileFO;
        }

        @Override
        public String getFlags() {
            return this.flags;
        }

        @Override
        public void setFlags(String flags) {
            this.flags = flags;
            SelectModeDescriptorPanel.this.validate();
        }

        @Override
        public String getRealFlags() {
            PreBuildSupport.PreBuildArtifact scriptArtifact = this.getScriptArtifact();
            if (scriptArtifact != null) {
                return scriptArtifact.getArguments(this.buildEnv, this.cs, this.flags);
            }
            return null;
        }

        @Override
        public String getRealCommand() {
            PreBuildSupport.PreBuildArtifact scriptArtifact = this.getScriptArtifact();
            if (scriptArtifact != null) {
                String args = scriptArtifact.getArguments(this.buildEnv, this.cs, this.flags);
                return scriptArtifact.getCommandLine(args, scriptArtifact.getScript().getParent().getPath());
            }
            return null;
        }

        @Override
        public boolean isSetMain() {
            return this.setMain;
        }

        @Override
        public void setSetMain(boolean setMain) {
            this.setMain = setMain;
            SelectModeDescriptorPanel.this.validate();
        }

        @Override
        public boolean isBuildProject() {
            return this.buildProject;
        }

        @Override
        public void setBuildProject(boolean buildProject) {
            this.buildProject = buildProject;
            SelectModeDescriptorPanel.this.validate();
        }

        @Override
        public void setCompilerSet(CompilerSet cs) {
            this.cs = cs;
        }

        @Override
        public CompilerSet getCompilerSet() {
            return this.cs;
        }

        @Override
        public void setExecutionEnvironment(ExecutionEnvironment ee) {
            this.buildEnv = ee;
        }

        @Override
        public ExecutionEnvironment getExecutionEnvironment() {
            return this.buildEnv;
        }

        @Override
        public ExecutionEnvironment getSourceExecutionEnvironment() {
            return this.sourceEnv;
        }

        @Override
        public void setSourceExecutionEnvironment(ExecutionEnvironment sourceEnv) {
            this.sourceEnv = sourceEnv;
        }

        @Override
        public void setDefaultCompilerSet(boolean defaultCompilerSet) {
            this.defaultCompilerSet = defaultCompilerSet;
        }

        @Override
        public boolean isDefaultCompilerSet() {
            return this.defaultCompilerSet;
        }

        @Override
        public void setFullRemoteEnv(ExecutionEnvironment fullRemoteEnv) {
            this.fullRemoteEnv = fullRemoteEnv;
        }

        @Override
        public ExecutionEnvironment getFullRemoteEnv() {
            return this.fullRemoteEnv;
        }
    }
}

