/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makefile.wizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.cnd.makefile.wizard.MakefileWizard;
import org.netbeans.modules.cnd.makefile.wizard.MakefileWizardPanel;
import org.netbeans.modules.cnd.makefile.wizard.TargetData;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.ui.CndUIUtilities;

public class CreateTargetsPanel
extends MakefileWizardPanel
implements FocusListener {
    static final long serialVersionUID = -8649616207466524363L;
    private JLabel nameLabel;
    private JTextField nameText;
    private JButton nameChooser;
    private JRadioButton executable;
    private JRadioButton archive;
    private JRadioButton sharedLib;
    private JRadioButton recursiveMake;
    private JRadioButton customTarget;
    private ButtonGroup typeBG;
    private JButton addBtn;
    private JButton removeBtn;
    private JButton changeBtn;
    private JLabel listLabel;
    private JScrollPane listSP;
    private JList list;
    private boolean initialized;
    private JButton nextButton;
    private int newKey;
    private MakefileWizard wiz;
    protected JFileChooser fc;
    private Component inFocus = null;

    CreateTargetsPanel(MakefileWizard wiz) {
        super(wiz);
        this.wiz = wiz;
        String subtitle = this.getString("LBL_CreateTargetsPanel");
        this.setSubTitle(subtitle);
        this.getAccessibleContext().setAccessibleDescription(subtitle);
        this.nextButton = null;
        this.initialized = false;
    }

    private void create() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints grid = new GridBagConstraints();
        grid.anchor = 17;
        grid.gridx = 0;
        grid.gridy = 0;
        Insets defaultInsets = grid.insets;
        this.nextButton = MakefileWizard.getMakefileWizard().getNextButton();
        this.nameLabel = new JLabel(this.getString("LBL_TargetName"));
        this.nameLabel.setDisplayedMnemonic(this.getString("MNEM_TargetName").charAt(0));
        this.add((Component)this.nameLabel, grid);
        this.nameText = new JTextField();
        grid.anchor = 17;
        grid.gridx = 1;
        grid.gridy = -1;
        grid.weightx = 100.0;
        grid.fill = 2;
        grid.insets = new Insets(0, 11, 0, 5);
        this.add((Component)this.nameText, grid);
        this.nameLabel.setLabelFor(this.nameText);
        this.nameChooser = new JButton(this.getString("BTN_Chooser"));
        this.nameChooser.setMnemonic(this.getString("MNEM_Chooser").charAt(0));
        grid.gridx = 2;
        grid.weightx = 0.0;
        grid.fill = 0;
        grid.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.nameChooser, grid);
        this.createChooser(this.nameChooser);
        grid.gridx = 0;
        grid.gridwidth = 0;
        grid.insets = new Insets(12, 0, 0, 0);
        this.executable = new JRadioButton(this.getString("RB_Executable"));
        this.executable.setSelected(true);
        this.executable.setMnemonic(this.getString("MNEM_Executable").charAt(0));
        this.add((Component)this.executable, grid);
        grid.insets = defaultInsets;
        this.archive = new JRadioButton(this.getString("RB_StaticLibrary"));
        this.archive.setMnemonic(this.getString("MNEM_StaticLibrary").charAt(0));
        this.add((Component)this.archive, grid);
        this.sharedLib = new JRadioButton(this.getString("RB_SharedLibrary"));
        this.sharedLib.setMnemonic(this.getString("MNEM_SharedLibrary").charAt(0));
        this.add((Component)this.sharedLib, grid);
        this.recursiveMake = new JRadioButton(this.getString("RB_RecursiveMake"));
        this.recursiveMake.setMnemonic(this.getString("MNEM_RecursiveMake").charAt(0));
        this.add((Component)this.recursiveMake, grid);
        this.customTarget = new JRadioButton(this.getString("RB_CustomTarget"));
        this.customTarget.setMnemonic(this.getString("MNEM_CustomTarget").charAt(0));
        this.add((Component)this.customTarget, grid);
        this.typeBG = new ButtonGroup();
        this.typeBG.add(this.executable);
        this.typeBG.add(this.archive);
        this.typeBG.add(this.sharedLib);
        this.typeBG.add(this.recursiveMake);
        this.typeBG.add(this.customTarget);
        JPanel bpanel = this.createButtonPanel();
        grid.insets = new Insets(5, 0, 0, 0);
        this.add((Component)bpanel, grid);
        this.listLabel = new JLabel(this.getString("LBL_List"));
        this.listLabel.setDisplayedMnemonic(this.getString("MNEM_List").charAt(0));
        grid.insets = new Insets(11, 0, 0, 0);
        this.add((Component)this.listLabel, grid);
        this.list = new JList(new DefaultListModel());
        this.listSP = new JScrollPane(this.list);
        grid.weightx = 100.0;
        grid.weighty = 100.0;
        grid.fill = 1;
        grid.insets = defaultInsets;
        this.add((Component)this.listSP, grid);
        this.listLabel.setLabelFor(this.list);
        this.setupListeners();
        this.newKey = 0;
        this.list.getAccessibleContext().setAccessibleDescription(this.getString("ACSD_List"));
        this.nameText.getAccessibleContext().setAccessibleDescription(this.getString("ACSD_TargetNameTF"));
        this.addBtn.getAccessibleContext().setAccessibleDescription(this.getString("ACSD_CreateTargetsPanelAddBtn"));
        this.removeBtn.getAccessibleContext().setAccessibleDescription(this.getString("ACSD_CreateTargetsPanelRemoveBtn"));
        this.changeBtn.getAccessibleContext().setAccessibleDescription(this.getString("ACSD_CreateTargetsPanelChangeBtn"));
        this.nameChooser.getAccessibleContext().setAccessibleDescription(this.getString("ACSD_CreateTargetsPanelBrowseBtn"));
    }

    private JPanel createButtonPanel() {
        JPanel bpanel = new JPanel();
        bpanel.setLayout(new GridLayout(1, 3, 6, 0));
        this.addBtn = new JButton(this.getString("BTN_Add"));
        this.addBtn.setMnemonic(this.getString("MNEM_Add").charAt(0));
        this.addBtn.setEnabled(false);
        bpanel.add(this.addBtn);
        this.removeBtn = new JButton(this.getString("BTN_Remove"));
        this.removeBtn.setMnemonic(this.getString("MNEM_Remove").charAt(0));
        this.removeBtn.setEnabled(false);
        bpanel.add(this.removeBtn);
        this.changeBtn = new JButton(this.getString("BTN_Change"));
        this.changeBtn.setMnemonic(this.getString("MNEM_Change").charAt(0));
        this.changeBtn.setEnabled(false);
        bpanel.add(this.changeBtn);
        return bpanel;
    }

    protected void createChooser(JButton chooser) {
        chooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (CreateTargetsPanel.this.fc == null) {
                    CreateTargetsPanel.this.fc = new JFileChooser();
                    CreateTargetsPanel.this.fc.setApproveButtonText(CreateTargetsPanel.this.getString("BTN_Approve"));
                    CreateTargetsPanel.this.fc.setDialogTitle(CreateTargetsPanel.this.getString("DLG_FILE_CHOOSER_TITLE"));
                }
                File f = null;
                String cur = CreateTargetsPanel.this.nameText.getText();
                if (cur.length() > 0) {
                    f = new File(cur);
                }
                if (f != null && f.isDirectory()) {
                    CreateTargetsPanel.this.fc.setCurrentDirectory(f);
                } else {
                    CreateTargetsPanel.this.fc.setCurrentDirectory(new File(CreateTargetsPanel.this.getMakefileData().getBaseDirectory(true)));
                }
                int returnVal = CreateTargetsPanel.this.fc.showDialog(CreateTargetsPanel.this, null);
                if (returnVal == 0) {
                    File file = CreateTargetsPanel.this.fc.getSelectedFile();
                    CreateTargetsPanel.this.nameText.setText(file.getName());
                    CreateTargetsPanel.this.setupButtons();
                }
            }
        });
    }

    @Override
    public boolean isPanelValid() {
        return this.initialized && ((DefaultListModel)this.list.getModel()).size() != 0;
    }

    public void updatePanels() {
        this.wiz.updatePanels(4);
    }

    private int getCurrentType() {
        if (this.executable.isSelected()) {
            return 5;
        }
        if (this.archive.isSelected()) {
            return 6;
        }
        if (this.sharedLib.isSelected()) {
            return 7;
        }
        if (this.recursiveMake.isSelected()) {
            return 8;
        }
        if (this.customTarget.isSelected()) {
            return 9;
        }
        return 0;
    }

    private void addTarget(String name) {
        List<TargetData> tlist = this.getMakefileData().getTargetList();
        int type = this.getCurrentType();
        String dir = tlist.isEmpty() ? this.getMakefileData().defaultOutputDirectory() : tlist.get(tlist.size() - 1).getOutputDirectory();
        if (name == null) {
            name = this.nameText.getText().trim();
        }
        if (!((DefaultListModel)this.list.getModel()).contains(name)) {
            TargetData target = new TargetData(type, name, dir, this.newKey);
            tlist.add(target);
            ((DefaultListModel)this.list.getModel()).addElement(name);
            this.list.clearSelection();
            this.wiz.addTarget(type, name, this.newKey++);
        }
    }

    private void deleteTargets(int[] indices) {
        List<TargetData> tlist = this.getMakefileData().getTargetList();
        DefaultListModel model = (DefaultListModel)this.list.getModel();
        while (indices.length > 0) {
            int sel = indices[0];
            this.wiz.deleteTarget(tlist.get(sel).getKey());
            tlist.remove(sel);
            model.removeElementAt(sel);
            indices = this.list.getSelectedIndices();
        }
    }

    private void changeTarget(int idx, String name) {
        List<TargetData> tlist = this.getMakefileData().getTargetList();
        TargetData target = tlist.get(idx);
        if (name.charAt(name.length() - 1) == File.separatorChar) {
            name = CndPathUtilities.trimpath((String)name);
            this.nameText.setText(name);
            ((DefaultListModel)this.list.getModel()).set(idx, name);
        }
        this.wiz.changeTarget(tlist.get(idx).getKey(), name, this.getCurrentType());
        int ctype = this.getCurrentType();
        if (ctype != target.getTargetType()) {
            target = new TargetData(ctype, name, target.getOutputDirectory(), target.getKey());
            tlist.remove(idx);
            tlist.add(idx, target);
        } else {
            target.setName(name);
        }
    }

    private void setupListeners() {
        final DefaultListModel model = (DefaultListModel)this.list.getModel();
        this.nameText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                CreateTargetsPanel.this.setupButtons();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                CreateTargetsPanel.this.setupButtons();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                CreateTargetsPanel.this.setupButtons();
            }
        });
        this.addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String name = CreateTargetsPanel.this.nameText.getText().trim();
                if (CreateTargetsPanel.this.getMakefileData().validateTargetName(name, CreateTargetsPanel.this.getCurrentType())) {
                    CreateTargetsPanel.this.addTarget(name);
                    CreateTargetsPanel.this.nameText.setText(null);
                    CreateTargetsPanel.this.setupButtons();
                }
            }
        });
        this.changeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String name = CreateTargetsPanel.this.nameText.getText().trim();
                if (CreateTargetsPanel.this.getMakefileData().validateTargetName(name, CreateTargetsPanel.this.getCurrentType())) {
                    model.set(CreateTargetsPanel.this.list.getMinSelectionIndex(), name);
                    CreateTargetsPanel.this.changeTarget(CreateTargetsPanel.this.list.getMinSelectionIndex(), name);
                }
            }
        });
        this.removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int min = CreateTargetsPanel.this.list.getMinSelectionIndex();
                int max = CreateTargetsPanel.this.list.getMaxSelectionIndex();
                int[] indices = CreateTargetsPanel.this.list.getSelectedIndices();
                CreateTargetsPanel.this.deleteTargets(indices);
                if (model.isEmpty()) {
                    CreateTargetsPanel.this.nextButton.setEnabled(false);
                } else if (min >= 0 && min < model.getSize()) {
                    CreateTargetsPanel.this.list.setSelectedIndex(min);
                } else {
                    int newSel = min;
                    if (min >= model.getSize()) {
                        newSel = model.getSize() - 1;
                    }
                    CreateTargetsPanel.this.list.setSelectedIndex(newSel);
                }
                CreateTargetsPanel.this.setupButtons();
            }
        });
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    int min = CreateTargetsPanel.this.list.getMinSelectionIndex();
                    int max = CreateTargetsPanel.this.list.getMaxSelectionIndex();
                    if (min >= 0 && max >= 0 && CreateTargetsPanel.this.list.getModel().getSize() > 0 && min == max) {
                        CreateTargetsPanel.this.nameText.setText(model.get(min).toString());
                        CreateTargetsPanel.this.setTargetType(model.get(min).toString());
                    }
                    CreateTargetsPanel.this.setupButtons();
                }
            }
        });
        this.list.addFocusListener(this);
    }

    private void setupButtons() {
        int min = this.list.getMinSelectionIndex();
        int max = this.list.getMaxSelectionIndex();
        String name = this.nameText.getText().trim();
        this.addBtn.setEnabled(name.length() > 0);
        if (min < 0) {
            this.changeBtn.setEnabled(false);
            this.removeBtn.setEnabled(false);
        } else if (min == max) {
            this.changeBtn.setEnabled(name.length() > 0);
            this.removeBtn.setEnabled(true);
        } else {
            this.changeBtn.setEnabled(false);
            this.removeBtn.setEnabled(true);
        }
        if (this.inFocus == this.list || name.length() == 0) {
            this.getRootPane().setDefaultButton(this.nextButton);
        } else {
            this.getRootPane().setDefaultButton(this.addBtn);
        }
    }

    @Override
    public void focusGained(FocusEvent evt) {
        DefaultListModel model;
        Component comp;
        this.inFocus = comp = evt.getComponent();
        if (this.inFocus == this.list && !(model = (DefaultListModel)this.list.getModel()).isEmpty() && this.list.getLeadSelectionIndex() < 0) {
            this.list.setSelectedIndex(0);
        }
    }

    @Override
    public void focusLost(FocusEvent evt) {
        this.inFocus = null;
    }

    private void setTargetType(String tname) {
        List<TargetData> tlist = this.getMakefileData().getTargetList();
        for (int i = 0; i < tlist.size(); ++i) {
            TargetData target = tlist.get(i);
            if (!tname.equals(target.getName())) continue;
            this.setTargetType(target.getTargetType());
            return;
        }
    }

    private void setTargetType(int type) {
        switch (type) {
            case 5: {
                this.typeBG.setSelected(this.executable.getModel(), true);
                break;
            }
            case 6: {
                this.typeBG.setSelected(this.archive.getModel(), true);
                break;
            }
            case 7: {
                this.typeBG.setSelected(this.sharedLib.getModel(), true);
                break;
            }
            case 8: {
                this.typeBG.setSelected(this.recursiveMake.getModel(), true);
                break;
            }
            case 9: {
                this.typeBG.setSelected(this.customTarget.getModel(), true);
            }
        }
        this.repaint();
    }

    @Override
    public void addNotify() {
        TargetData target;
        List<TargetData> tlist = this.getMakefileData().getTargetList();
        if (!this.initialized) {
            this.create();
            if (tlist.size() > 0) {
                target = tlist.get(tlist.size() - 1);
                this.setTargetType(target.getTargetType());
                DefaultListModel model = (DefaultListModel)this.list.getModel();
                for (int i = 0; i < tlist.size(); ++i) {
                    model.addElement(tlist.get(i).getName());
                }
            } else {
                this.executable.setEnabled(true);
            }
            this.initialized = true;
        }
        if (tlist.size() > 0 && (target = tlist.get(0)).getTargetType() < 4) {
            target.convert();
            if (this.newKey == 0) {
                ++this.newKey;
            }
            if (!this.wiz.targetExists(target.getKey())) {
                this.wiz.addTarget(target.getTargetType(), target.getName(), target.getKey());
            }
        }
        super.addNotify();
        this.nameText.selectAll();
        CndUIUtilities.requestFocus((Component)this.nameText);
    }

    @Override
    public void removeNotify() {
        Container o;
        super.removeNotify();
        if (this.fc != null && this.fc.isShowing() && (o = this.fc.getTopLevelAncestor()) != null && o instanceof JDialog) {
            ((JDialog)o).dispose();
        }
    }
}

