/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.introduce;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.deep.CsmCompoundStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmDeclarationStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmExceptionHandler;
import org.netbeans.modules.cnd.api.model.deep.CsmIfStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmLoopStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmSwitchStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmTryCatchStatement;
import org.netbeans.modules.cnd.api.model.services.CsmFileReferences;
import org.netbeans.modules.cnd.api.model.services.CsmReferenceContext;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.refactoring.api.IntroduceMethodRefactoring;
import org.openide.filesystems.FileObject;
import org.openide.util.Pair;

public class BodyFinder {
    private final Document doc;
    private final FileObject fileObject;
    private final CsmFile file;
    private final int caretOffset;
    private final int selectionStart;
    private final int selectionEnd;
    private final AtomicBoolean canceled;
    private BodyResult result;

    public BodyFinder(Document doc, FileObject fileObject, CsmFile file, int caretOffset, int selectionStart, int selectionEnd, AtomicBoolean canceled) {
        this.doc = doc;
        this.fileObject = fileObject;
        this.file = file;
        this.caretOffset = caretOffset;
        this.selectionStart = selectionStart;
        this.selectionEnd = selectionEnd;
        this.canceled = canceled;
    }

    public BodyResult findBody() {
        this.result = this.findBody(this.file.getDeclarations());
        return this.result;
    }

    private BodyResult findBody(Collection<? extends CsmOffsetableDeclaration> decls) {
        for (CsmOffsetableDeclaration csmOffsetableDeclaration : decls) {
            if (this.canceled.get()) {
                return null;
            }
            if (csmOffsetableDeclaration.getStartOffset() >= this.selectionStart || this.selectionEnd >= csmOffsetableDeclaration.getEndOffset()) continue;
            if (CsmKindUtilities.isFunctionDefinition((CsmObject)csmOffsetableDeclaration)) {
                CsmFunctionDefinition def = (CsmFunctionDefinition)csmOffsetableDeclaration;
                BodyResult res = this.findBody(def.getBody());
                if (res != null) {
                    res.setFunction(def);
                }
                return res;
            }
            if (CsmKindUtilities.isNamespaceDefinition((CsmObject)csmOffsetableDeclaration)) {
                CsmNamespaceDefinition def = (CsmNamespaceDefinition)csmOffsetableDeclaration;
                return this.findBody(def.getDeclarations());
            }
            if (!CsmKindUtilities.isClass((CsmObject)csmOffsetableDeclaration)) continue;
            CsmClass cls = (CsmClass)csmOffsetableDeclaration;
            return this.findBody(cls.getMembers());
        }
        return null;
    }

    private BodyResult findBody(CsmCompoundStatement body) {
        if (body != null && body.getStartOffset() <= this.selectionStart && this.selectionEnd <= body.getEndOffset()) {
            List statements = body.getStatements();
            int begStatement = -1;
            int endStatement = -1;
            for (int i = 0; i < statements.size() && !this.canceled.get(); ++i) {
                CsmStatement st = (CsmStatement)statements.get(i);
                if (st.getStartOffset() < this.selectionStart && this.selectionEnd < st.getEndOffset()) {
                    return this.findBodyInStatement(st);
                }
                if (st.getStartOffset() < this.selectionStart && this.selectionStart < st.getEndOffset()) {
                    return null;
                }
                if (st.getStartOffset() < this.selectionEnd && this.selectionEnd < st.getEndOffset()) {
                    return null;
                }
                if (begStatement == -1 && this.selectionStart <= st.getStartOffset()) {
                    begStatement = i;
                }
                if (endStatement != -1 || this.selectionEnd >= st.getStartOffset()) continue;
                endStatement = i;
                break;
            }
            if (endStatement == -1) {
                endStatement = statements.size();
            }
            if (begStatement >= 0 && endStatement > begStatement) {
                return new BodyResult(this.doc, this.fileObject, body, begStatement, endStatement);
            }
        }
        return null;
    }

    private BodyResult findBodyInStatement(CsmStatement st) {
        switch (st.getKind()) {
            case CATCH: 
            case COMPOUND: {
                return this.findBody((CsmCompoundStatement)st);
            }
            case SWITCH: {
                CsmSwitchStatement switchStmt = (CsmSwitchStatement)st;
                CsmStatement body = switchStmt.getBody();
                if (body != null) {
                    return this.findBodyInStatement(body);
                }
                return null;
            }
            case FOR: 
            case RANGE_FOR: 
            case WHILE: 
            case DO_WHILE: {
                CsmLoopStatement loopStmt = (CsmLoopStatement)st;
                CsmStatement body = loopStmt.getBody();
                if (body != null) {
                    return this.findBodyInStatement(body);
                }
                return null;
            }
            case TRY_CATCH: {
                BodyResult res;
                CsmTryCatchStatement tryStmt = (CsmTryCatchStatement)st;
                CsmStatement body = tryStmt.getTryStatement();
                if (body != null && (res = this.findBodyInStatement(body)) != null) {
                    return res;
                }
                List handlers = tryStmt.getHandlers();
                if (handlers != null) {
                    for (int i = 0; i < handlers.size(); ++i) {
                        CsmExceptionHandler handler = (CsmExceptionHandler)handlers.get(i);
                        res = this.findBody((CsmCompoundStatement)handler);
                        if (res == null) continue;
                        return res;
                    }
                }
                return null;
            }
            case IF: {
                BodyResult res;
                CsmIfStatement ifStmt = (CsmIfStatement)st;
                CsmStatement thenStmt = ifStmt.getThen();
                CsmStatement elseStmt = ifStmt.getElse();
                if (thenStmt != null && (res = this.findBodyInStatement(thenStmt)) != null) {
                    return res;
                }
                if (elseStmt != null && (res = this.findBodyInStatement(elseStmt)) != null) {
                    return res;
                }
                return null;
            }
        }
        return null;
    }

    public static final class BodyResult
    implements IntroduceMethodRefactoring.IntroduceMethodContext {
        private final Document doc;
        private final FileObject fileObject;
        private final CsmCompoundStatement body;
        private final int startStatment;
        private final int endStatement;
        private int startSelection = -1;
        private int endSelection = -1;
        private int insertionPoint = -1;
        private CsmFunctionDefinition function;
        private CsmFunction functionDeclaration;
        private CsmClass enclosingClass;
        private IntroduceMethodRefactoring.IntroduceMethodContext.FunctionKind functionKind;
        private CsmScope insertScope;
        private AtomicBoolean canceled;
        private LinkedList<CsmStatement.Kind> stack;
        private ArrayList<Pair<Integer, Integer>> innerBlocks;
        private VariablesInfo vars;

        private BodyResult(Document doc, FileObject fileObject, CsmCompoundStatement body, int startStatment, int endStatement) {
            this.doc = doc;
            this.fileObject = fileObject;
            this.body = body;
            this.startStatment = startStatment;
            this.endStatement = endStatement;
        }

        @Override
        public Document getDocument() {
            return this.doc;
        }

        @Override
        public boolean isC() {
            return "text/x-c".equals(this.fileObject.getMIMEType());
        }

        @Override
        public boolean isApplicable(AtomicBoolean canceled) {
            this.canceled = canceled;
            this.stack = new LinkedList();
            this.innerBlocks = new ArrayList();
            this.vars = new VariablesInfo();
            List statements = this.body.getStatements();
            for (int i = this.startStatment; i < this.endStatement; ++i) {
                if (canceled.get()) {
                    return false;
                }
                CsmStatement st = (CsmStatement)statements.get(i);
                if (this.startSelection == -1) {
                    this.startSelection = st.getStartOffset();
                }
                this.endSelection = st.getEndOffset();
                if (this.isApplicableStatement(st)) continue;
                return false;
            }
            this.extendEndSelection();
            if (canceled.get()) {
                return false;
            }
            this.visit();
            if (!this.vars.topLevelVariablesUsedOutside().isEmpty()) {
                return false;
            }
            if (canceled.get()) {
                return false;
            }
            this.vars.calculateReferencedVariables(this.doc, this.startSelection, this.endSelection);
            return !canceled.get();
        }

        @Override
        public List<IntroduceMethodRefactoring.VariableContext> getImportantVariables() {
            return this.vars.getImportantVariables();
        }

        @Override
        public int getSelectionFrom() {
            return this.startSelection;
        }

        @Override
        public int getSelectionTo() {
            return this.endSelection;
        }

        @Override
        public CsmFunctionDefinition getFunction() {
            return this.function;
        }

        @Override
        public CsmFunction getFunctionDeclaration() {
            return this.functionDeclaration;
        }

        @Override
        public CsmClass getEnclosingClass() {
            return this.enclosingClass;
        }

        @Override
        public CsmScope getInsertScope() {
            return this.insertScope;
        }

        @Override
        public IntroduceMethodRefactoring.IntroduceMethodContext.FunctionKind getFunctionKind() {
            return this.functionKind;
        }

        private void extendEndSelection() {
            this.doc.render(new Runnable(){

                @Override
                public void run() {
                    TokenHierarchy hi = TokenHierarchy.get((Document)BodyResult.this.doc);
                    TokenSequence ts = hi.tokenSequence();
                    ts.move(BodyResult.this.endSelection);
                    boolean newLineFound = false;
                    while (ts.moveNext()) {
                        Token token = ts.token();
                        if (token.id() == CppTokenId.WHITESPACE) {
                            BodyResult.this.endSelection = ts.offset() + token.length();
                            continue;
                        }
                        if (token.id() == CppTokenId.SEMICOLON) {
                            BodyResult.this.endSelection = ts.offset() + token.length();
                            continue;
                        }
                        if ("comment".equals(token.id().primaryCategory())) {
                            BodyResult.this.endSelection = ts.offset() + token.length();
                            continue;
                        }
                        return;
                    }
                }
            });
        }

        @Override
        public int getInsetionOffset() {
            if (this.insertionPoint == -1) {
                final AtomicInteger point = new AtomicInteger(this.function.getStartOffset());
                this.doc.render(new Runnable(){

                    @Override
                    public void run() {
                        TokenHierarchy hi = TokenHierarchy.get((Document)BodyResult.this.doc);
                        TokenSequence ts = hi.tokenSequence();
                        ts.move(BodyResult.this.function.getStartOffset());
                        boolean newLineFound = false;
                        while (ts.movePrevious()) {
                            Token token = ts.token();
                            if (token.id() == CppTokenId.WHITESPACE) {
                                point.set(ts.offset());
                                continue;
                            }
                            if (token.id() == CppTokenId.NEW_LINE) {
                                if (!newLineFound) {
                                    point.set(ts.offset());
                                    newLineFound = true;
                                    continue;
                                }
                                return;
                            }
                            if ("comment".equals(token.id().primaryCategory())) {
                                point.set(ts.offset());
                                newLineFound = false;
                                continue;
                            }
                            return;
                        }
                        point.set(0);
                    }
                });
                this.insertionPoint = point.get();
            }
            return this.insertionPoint;
        }

        private void setFunction(CsmFunctionDefinition function) {
            this.function = function;
            this.insertScope = function.getScope();
            this.functionDeclaration = function.getDeclaration();
            if (CsmKindUtilities.isClassMember((CsmObject)this.functionDeclaration)) {
                this.enclosingClass = ((CsmMember)this.functionDeclaration).getContainingClass();
            }
            this.functionKind = this.enclosingClass != null ? (function.equals(this.functionDeclaration) ? IntroduceMethodRefactoring.IntroduceMethodContext.FunctionKind.MethodDeclarationDefinition : IntroduceMethodRefactoring.IntroduceMethodContext.FunctionKind.MethodDefinition) : IntroduceMethodRefactoring.IntroduceMethodContext.FunctionKind.Function;
        }

        private void visit() {
            CsmFileReferences.Visitor visitor = new CsmFileReferences.Visitor(){

                public boolean cancelled() {
                    return BodyResult.this.canceled.get();
                }

                public void visit(CsmReferenceContext context) {
                    CsmReference reference = context.getReference();
                    CsmObject referencedObject = reference.getReferencedObject();
                    if (!CsmKindUtilities.isVariable((CsmObject)referencedObject)) {
                        return;
                    }
                    CsmVariable var = (CsmVariable)referencedObject;
                    if (!BodyResult.this.function.getContainingFile().equals(var.getContainingFile())) {
                        return;
                    }
                    if (BodyResult.this.function.getStartOffset() >= var.getStartOffset() || var.getEndOffset() >= BodyResult.this.function.getEndOffset()) {
                        return;
                    }
                    if (this.isBlockLocalVariable(var)) {
                        return;
                    }
                    VariableInfo info = BodyResult.this.vars.add(var, false);
                    info.addReference(reference);
                    if (reference.getEndOffset() < BodyResult.this.startSelection) {
                        info.setAccessBefore();
                    } else if (BodyResult.this.endSelection < reference.getStartOffset()) {
                        info.setAccessAfter();
                    } else {
                        info.setAccessInside();
                    }
                }

                private boolean isBlockLocalVariable(CsmVariable var) {
                    for (Pair pair : BodyResult.this.innerBlocks) {
                        if ((Integer)pair.first() >= var.getStartOffset() || var.getEndOffset() >= (Integer)pair.second()) continue;
                        return true;
                    }
                    return false;
                }
            };
            CsmFileReferences.getDefault().accept((CsmScope)this.function, this.doc, visitor);
        }

        private boolean isApplicableStatement(CsmStatement st) {
            switch (st.getKind()) {
                case LABEL: 
                case GOTO: {
                    return false;
                }
                case DECLARATION: {
                    if (this.hasKind(CsmStatement.Kind.COMPOUND)) {
                        return true;
                    }
                    CsmDeclarationStatement decl = (CsmDeclarationStatement)st;
                    for (CsmDeclaration var : decl.getDeclarators()) {
                        if (!CsmKindUtilities.isVariable((CsmObject)var)) continue;
                        this.vars.add((CsmVariable)var, true);
                    }
                    return true;
                }
                case EXPRESSION: {
                    return true;
                }
                case CATCH: 
                case COMPOUND: {
                    return this.isApplicableBlock((CsmCompoundStatement)st);
                }
                case IF: {
                    return this.isApplicableIf((CsmIfStatement)st);
                }
                case SWITCH: {
                    return this.isApplicableSwitch((CsmSwitchStatement)st);
                }
                case FOR: 
                case RANGE_FOR: 
                case WHILE: 
                case DO_WHILE: {
                    return this.isApplicableLoop((CsmLoopStatement)st);
                }
                case CASE: 
                case DEFAULT: {
                    return this.hasKind(CsmStatement.Kind.SWITCH);
                }
                case BREAK: {
                    return this.hasKind(CsmStatement.Kind.SWITCH, CsmStatement.Kind.WHILE, CsmStatement.Kind.DO_WHILE, CsmStatement.Kind.FOR, CsmStatement.Kind.RANGE_FOR);
                }
                case CONTINUE: {
                    return this.hasKind(CsmStatement.Kind.WHILE, CsmStatement.Kind.DO_WHILE, CsmStatement.Kind.FOR, CsmStatement.Kind.RANGE_FOR);
                }
                case RETURN: {
                    return false;
                }
                case TRY_CATCH: {
                    return this.isApplicableTry((CsmTryCatchStatement)st);
                }
                case THROW: {
                    return false;
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isApplicableBlock(CsmCompoundStatement statement) {
            this.stack.addLast(CsmStatement.Kind.COMPOUND);
            try {
                this.innerBlocks.add((Pair<Integer, Integer>)Pair.of((Object)statement.getStartOffset(), (Object)statement.getEndOffset()));
                for (CsmStatement st : statement.getStatements()) {
                    if (this.canceled.get()) {
                        boolean bl = false;
                        return bl;
                    }
                    if (this.isApplicableStatement(st)) continue;
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.stack.removeLast();
            }
            return true;
        }

        private boolean isApplicableTry(CsmTryCatchStatement tryStmt) {
            CsmStatement aBody = tryStmt.getTryStatement();
            if (aBody != null && !this.isApplicableStatement(aBody)) {
                return false;
            }
            List handlers = tryStmt.getHandlers();
            if (handlers != null) {
                for (int i = 0; i < handlers.size(); ++i) {
                    CsmExceptionHandler handler = (CsmExceptionHandler)handlers.get(i);
                    if (this.isApplicableStatement((CsmStatement)handler)) continue;
                    return false;
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isApplicableSwitch(CsmSwitchStatement statement) {
            this.stack.addLast(CsmStatement.Kind.SWITCH);
            try {
                CsmStatement st = statement.getBody();
                if (st != null) {
                    boolean bl = this.isApplicableStatement(st);
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.stack.removeLast();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isApplicableLoop(CsmLoopStatement statement) {
            this.stack.addLast(statement.getKind());
            try {
                this.innerBlocks.add((Pair<Integer, Integer>)Pair.of((Object)statement.getStartOffset(), (Object)statement.getEndOffset()));
                CsmStatement st = statement.getBody();
                if (st != null) {
                    boolean bl = this.isApplicableStatement(st);
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.stack.removeLast();
            }
        }

        private boolean isApplicableIf(CsmIfStatement statement) {
            CsmStatement aElse = statement.getElse();
            if (aElse != null && !this.isApplicableStatement(aElse)) {
                return false;
            }
            CsmStatement then = statement.getThen();
            return then == null || this.isApplicableStatement(then);
        }

        private boolean hasKind(CsmStatement.Kind ... kinds) {
            for (CsmStatement.Kind kind : kinds) {
                if (!this.stack.contains(kind)) continue;
                return true;
            }
            return false;
        }
    }

    public static final class VariablesInfo {
        private final List<VariableInfo> variables = new ArrayList<VariableInfo>();

        private VariablesInfo() {
        }

        private VariableInfo add(CsmVariable variable, boolean topLevelDeclaration) {
            for (VariableInfo info : this.variables) {
                if (!info.variable.equals(variable)) continue;
                return info;
            }
            VariableInfo res = new VariableInfo(variable, topLevelDeclaration);
            this.variables.add(res);
            return res;
        }

        private List<IntroduceMethodRefactoring.VariableContext> getImportantVariables() {
            ArrayList<IntroduceMethodRefactoring.VariableContext> res = new ArrayList<IntroduceMethodRefactoring.VariableContext>();
            for (VariableInfo info : this.variables) {
                if (info.isTopLevelDeclaration() || !info.isAccessInside()) continue;
                res.add(info);
            }
            return res;
        }

        private List<VariableInfo> topLevelVariablesUsedOutside() {
            ArrayList<VariableInfo> res = new ArrayList<VariableInfo>();
            for (VariableInfo info : this.variables) {
                if (!info.isTopLevelDeclaration() || !info.isAccessAfter() && !info.accessBefore) continue;
                res.add(info);
            }
            return res;
        }

        private void calculateReferencedVariables(final Document doc, final int startSelection, final int endSelection) {
            doc.render(new Runnable(){

                @Override
                public void run() {
                    TokenHierarchy hi = TokenHierarchy.get((Document)doc);
                    TokenSequence ts = hi.tokenSequence();
                    VariablesInfo.this.calculateReferencedVariables(ts, startSelection, endSelection);
                }
            });
        }

        private void calculateReferencedVariables(TokenSequence<?> ts, int startSelection, int endSelection) {
            for (VariableInfo info : this.variables) {
                if (info.isTopLevelDeclaration() || !info.isAccessInside()) continue;
                boolean writeAccess = false;
                for (CsmReference references : info.getReferences()) {
                    if (startSelection > references.getStartOffset() || references.getEndOffset() > endSelection || !this.isWriteAccess(ts, references.getStartOffset())) continue;
                    writeAccess = true;
                    break;
                }
                if (!writeAccess) continue;
                info.setWriteAccessInside();
            }
        }

        private boolean isWriteAccess(TokenSequence<?> ts, int offset) {
            ts.move(offset);
            if (ts.moveNext()) {
                Token<?> token = this.lookNextImportant(ts);
                if (token != null && (token.id() == CppTokenId.PLUSPLUS || token.id() == CppTokenId.MINUSMINUS || token.id() == CppTokenId.EQ || token.id() == CppTokenId.PLUSEQ || token.id() == CppTokenId.MINUSEQ || token.id() == CppTokenId.STAREQ || token.id() == CppTokenId.SLASHEQ || token.id() == CppTokenId.AMPEQ || token.id() == CppTokenId.BAREQ || token.id() == CppTokenId.CARETEQ || token.id() == CppTokenId.PERCENTEQ || token.id() == CppTokenId.LTLTEQ || token.id() == CppTokenId.GTGTEQ)) {
                    return true;
                }
                token = this.lookPrevImportant(ts, 1);
                if (token != null && (token.id() == CppTokenId.PLUSPLUS || token.id() == CppTokenId.MINUSMINUS)) {
                    return true;
                }
                if (token != null && token.id() == CppTokenId.AMP) {
                    token = this.lookPrevImportant(ts, 2);
                    if (token != null && (token.id() == CppTokenId.LPAREN || token.id() == CppTokenId.EQ || token.id() == CppTokenId.COMMA)) {
                        return true;
                    }
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Token<?> lookNextImportant(TokenSequence<?> ts) {
            int index = ts.index();
            try {
                while (ts.moveNext()) {
                    if (ts.token().id() == CppTokenId.WHITESPACE || ts.token().id() == CppTokenId.ESCAPED_WHITESPACE || ts.token().id() == CppTokenId.NEW_LINE || ts.token().id() == CppTokenId.LINE_COMMENT || ts.token().id() == CppTokenId.BLOCK_COMMENT || ts.token().id() == CppTokenId.DOXYGEN_COMMENT || ts.token().id() == CppTokenId.DOXYGEN_LINE_COMMENT || ts.token().id() == CppTokenId.PREPROCESSOR_DIRECTIVE) continue;
                    Token token = ts.token();
                    return token;
                }
                Token<?> token = null;
                return token;
            }
            finally {
                ts.moveIndex(index);
                ts.moveNext();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Token<?> lookPrevImportant(TokenSequence<?> ts, int which) {
            int index = ts.index();
            try {
                while (ts.movePrevious()) {
                    if (ts.token().id() == CppTokenId.WHITESPACE || ts.token().id() == CppTokenId.ESCAPED_WHITESPACE || ts.token().id() == CppTokenId.NEW_LINE || ts.token().id() == CppTokenId.LINE_COMMENT || ts.token().id() == CppTokenId.BLOCK_COMMENT || ts.token().id() == CppTokenId.DOXYGEN_COMMENT || ts.token().id() == CppTokenId.DOXYGEN_LINE_COMMENT || ts.token().id() == CppTokenId.PREPROCESSOR_DIRECTIVE || --which != 0) continue;
                    Token token = ts.token();
                    return token;
                }
                Token<?> token = null;
                return token;
            }
            finally {
                ts.moveIndex(index);
                ts.moveNext();
            }
        }
    }

    public static final class VariableInfo
    implements IntroduceMethodRefactoring.VariableContext {
        private final CsmVariable variable;
        private final List<CsmReference> refs = new ArrayList<CsmReference>();
        private boolean accessBefore;
        private boolean accessAfter;
        private boolean accessInside;
        private boolean topLevelDeclaration;
        private boolean writeAccessInside;

        private VariableInfo(CsmVariable variable, boolean topLevelDeclaration) {
            this.variable = variable;
            this.topLevelDeclaration = topLevelDeclaration;
        }

        @Override
        public CsmVariable getVariable() {
            return this.variable;
        }

        @Override
        public boolean isAccessBefore() {
            return this.accessBefore;
        }

        @Override
        public boolean isAccessAfter() {
            return this.accessAfter;
        }

        @Override
        public boolean isAccessInside() {
            return this.accessInside;
        }

        @Override
        public boolean isTopLevelDeclaration() {
            return this.topLevelDeclaration;
        }

        @Override
        public List<CsmReference> getReferences() {
            return this.refs;
        }

        @Override
        public boolean isWriteAccessInside() {
            return this.writeAccessInside;
        }

        private void setAccessBefore() {
            this.accessBefore = true;
        }

        private void setAccessAfter() {
            this.accessAfter = true;
        }

        private void setAccessInside() {
            this.accessInside = true;
        }

        private void addReference(CsmReference reference) {
            this.refs.add(reference);
        }

        private void setWriteAccessInside() {
            this.writeAccessInside = true;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(this.variable.getName());
            buf.append(" Access ");
            if (this.accessBefore) {
                buf.append('*');
            } else {
                buf.append('-');
            }
            buf.append('[');
            if (this.accessInside) {
                buf.append('*');
            } else {
                buf.append('-');
            }
            buf.append(']');
            if (this.accessAfter) {
                buf.append('*');
            } else {
                buf.append('-');
            }
            buf.append(" Refs " + this.refs.size());
            return buf.toString();
        }
    }
}

