/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.plugins;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.services.CsmCacheManager;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.services.CsmMacroExpansion;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceRepository;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceResolver;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.refactoring.api.InlineRefactoring;
import org.netbeans.modules.cnd.refactoring.plugins.CsmModificationRefactoringPlugin;
import org.netbeans.modules.cnd.refactoring.spi.CsmInlineExtraObjectProvider;
import org.netbeans.modules.cnd.refactoring.support.CsmRefactoringUtils;
import org.netbeans.modules.cnd.refactoring.support.ModificationResult;
import org.netbeans.modules.cnd.support.Interrupter;
import org.netbeans.modules.refactoring.api.Problem;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class InlinePlugin
extends CsmModificationRefactoringPlugin {
    private final InlineRefactoring refactoring;
    private Collection<CsmObject> referencedObjects;

    public InlinePlugin(InlineRefactoring refactoring) {
        super(refactoring);
        this.refactoring = refactoring;
    }

    @Override
    protected final void processFile(CsmFile file, ModificationResult mr, AtomicReference<Problem> outProblem) {
        ArrayList<CsmReference> sortedRefs = new ArrayList<CsmReference>();
        if (file == null) {
            return;
        }
        if (this.refactoring.getApplyPlace().equals((Object)InlineRefactoring.Apply.IN_PLACE)) {
            JTextComponent component = EditorRegistry.lastFocusedComponent();
            int caret = component.getCaretPosition();
            Document originalDoc = component.getDocument();
            CsmReference ref = CsmReferenceResolver.getDefault().findReference(originalDoc, caret);
            if (ref == null) {
                return;
            }
            sortedRefs.add(ref);
        } else {
            ArrayList refs = new ArrayList();
            for (CsmObject o : this.referencedObjects) {
                refs.addAll(CsmReferenceRepository.getDefault().getReferences(o, file, EnumSet.of(CsmReferenceKind.DIRECT_USAGE), Interrupter.DUMMY));
            }
            if (!refs.isEmpty()) {
                sortedRefs = new ArrayList(refs);
                Collections.sort(sortedRefs, new Comparator<CsmReference>(){

                    @Override
                    public int compare(CsmReference o1, CsmReference o2) {
                        return o1.getStartOffset() - o2.getStartOffset();
                    }
                });
            }
        }
        this.processRefactoredReferences(sortedRefs, file, mr);
    }

    private void processRefactoredReferences(List<CsmReference> sortedRefs, CsmFile file, ModificationResult mr) {
        for (CsmReference ref : sortedRefs) {
            int objLine;
            CsmObject obj = ref.getReferencedObject();
            if (!CsmKindUtilities.isMacro((CsmObject)obj) || this.isInMacro(file, ref)) continue;
            CsmMacro macro = (CsmMacro)obj;
            int refLine = CsmFileInfoQuery.getDefault().getLineColumnByOffset(file, ref.getStartOffset())[0];
            if (refLine == (objLine = CsmFileInfoQuery.getDefault().getLineColumnByOffset(file, macro.getStartOffset())[0]) && ref.getContainingFile().equals(macro.getContainingFile())) continue;
            String oldText = macro.getName().toString();
            CloneableEditorSupport ces = CsmUtilities.findCloneableEditorSupport((CsmFile)file);
            StyledDocument doc = CsmUtilities.openDocument((CloneableEditorSupport)ces);
            String newText = CsmMacroExpansion.expand((Document)doc, (CsmFile)file, (int)ref.getStartOffset(), (int)ref.getEndOffset(), (boolean)true);
            if (newText == null || newText.isEmpty()) continue;
            String descr = NbBundle.getMessage(InlinePlugin.class, (String)"TXT_Preview_Entity_escription") + " " + oldText;
            ModificationResult.Difference diff = CsmRefactoringUtils.rename(ref.getStartOffset(), ref.getEndOffset() + InlinePlugin.getMacroParametersEndOffset(file, macro, ref.getEndOffset()), ces, oldText, newText, descr);
            assert (diff != null);
            mr.addDifference(file.getFileObject(), diff);
        }
    }

    private boolean isInMacro(CsmFile file, CsmReference reference) {
        CsmFileInfoQuery fiq = CsmFileInfoQuery.getDefault();
        int stopOffset = reference.getStartOffset();
        int line = fiq.getLineColumnByOffset(file, stopOffset)[0];
        int offset = (int)fiq.getOffset(file, line, 1);
        CharSequence codeLine = file.getText(offset, stopOffset);
        int fin = codeLine.length();
        for (int i = 0; i < fin; ++i) {
            char character = codeLine.charAt(i);
            if (character == '#') {
                return true;
            }
            if (!Character.isWhitespace(character)) break;
        }
        return false;
    }

    public static int getMacroParametersEndOffset(CsmFile file, CsmMacro macro, int pos) {
        if (macro.getParameters() != null && !macro.getParameters().isEmpty()) {
            int offset = 0;
            int bracketCount = 0;
            boolean isWhitespace = false;
            do {
                char ch;
                if (Character.isWhitespace(ch = file.getText(pos++, pos).charAt(0))) {
                    ++offset;
                    isWhitespace = true;
                    continue;
                }
                isWhitespace = false;
                switch (ch) {
                    case '(': {
                        ++bracketCount;
                        break;
                    }
                    case ')': {
                        --bracketCount;
                        break;
                    }
                }
                ++offset;
            } while (bracketCount > 0 || isWhitespace);
            return offset;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Problem preCheck() {
        Problem preCheckProblem = null;
        this.fireProgressListenerStart(1, 6);
        CsmRefactoringUtils.waitParsedAllProjects();
        this.fireProgressListenerStep();
        CsmCacheManager.enter();
        try {
            if (this.referencedObjects == null) {
                this.initReferencedObjects();
                this.fireProgressListenerStep();
            }
            if ((preCheckProblem = this.isResovledElement(this.getStartReferenceObject())) != null) {
                Problem problem = preCheckProblem;
                return problem;
            }
            Problem problem = preCheckProblem;
            return problem;
        }
        finally {
            CsmCacheManager.leave();
        }
    }

    @Override
    protected Collection<CsmFile> getRefactoredFiles() {
        if (this.refactoring.getApplyPlace().equals((Object)InlineRefactoring.Apply.IN_PROJECT)) {
            Collection<CsmObject> objs = this.getRefactoredObjects();
            if (objs == null || objs.isEmpty()) {
                return Collections.emptySet();
            }
            HashSet<CsmFile> files = new HashSet<CsmFile>();
            CsmFile startFile = this.getStartCsmFile();
            for (CsmObject obj : objs) {
                Collection<CsmProject> prjs = CsmRefactoringUtils.getRelatedCsmProjects(obj, null);
                CsmProject[] ar = prjs.toArray(new CsmProject[prjs.size()]);
                this.refactoring.getContext().add((Object)ar);
                files.addAll(this.getRelevantFiles(startFile, obj, this.refactoring));
            }
            return files;
        }
        HashSet<CsmFile> res = new HashSet<CsmFile>(1);
        res.add(this.getStartCsmFile());
        return res;
    }

    private Collection<CsmObject> getRefactoredObjects() {
        return this.referencedObjects == null ? Collections.emptyList() : Collections.unmodifiableCollection(this.referencedObjects);
    }

    private CsmFile getStartCsmFile() {
        CsmFile startFile = CsmRefactoringUtils.getCsmFile(this.getStartReferenceObject());
        if (startFile == null && this.getEditorContext() != null) {
            startFile = this.getEditorContext().getFile();
        }
        return startFile;
    }

    private void initReferencedObjects() {
        CsmObject primaryObject = CsmRefactoringUtils.getReferencedElement(this.getStartReferenceObject());
        if (primaryObject != null) {
            HashSet<CsmObject> objects = new HashSet<CsmObject>();
            objects.add(primaryObject);
            for (CsmInlineExtraObjectProvider provider : Lookup.getDefault().lookupAll(CsmInlineExtraObjectProvider.class)) {
                objects.addAll(provider.getExtraObjects(primaryObject));
            }
            this.referencedObjects = new LinkedHashSet<CsmObject>();
            for (CsmObject csmObject : objects) {
                this.referencedObjects.addAll(this.getEqualObjects(csmObject));
            }
        }
    }
}

