/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.classfile;

import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.lib.profiler.classfile.BaseClassInfo;
import org.netbeans.lib.profiler.classfile.ClassFileParser;
import org.netbeans.lib.profiler.global.CommonConstants;
import org.netbeans.lib.profiler.instrumentation.JavaClassConstants;

public abstract class ClassInfo
extends BaseClassInfo
implements JavaClassConstants,
CommonConstants {
    String packageName;
    String superName;
    char[] cpoolRefsToClassIdx;
    String[] cpoolRefsToClassName;
    String[][] cpoolRefsToMethodClassNameAndSig;
    char[] cpoolRefsToMethodIdx;
    int[] exceptionTableStartOffsets;
    String[] interfaces;
    char[] lineNumberTablesLengths;
    int[] lineNumberTablesOffsets;
    int localVaribaleTableCPindex;
    char[] localVariableTablesLengths;
    int[] localVariableTablesOffsets;
    int localVaribaleTypeTableCPindex;
    char[] localVariableTypeTablesLengths;
    int[] localVariableTypeTablesOffsets;
    int stackMapTableCPindex;
    char[] stackMapTablesLengths;
    int[] stackMapTablesOffsets;
    char[] methodAccessFlags;
    char[] methodBytecodesLengths;
    int[] methodBytecodesOffsets;
    int[] methodInfoLengths;
    int[] methodInfoOffsets;
    String[] methodNames;
    String[] methodSignatures;
    String[] nestedClassNames;
    int majorVersion;
    int classIndex;
    char accessFlags;
    int attrsStartOfs;
    int cpoolStartOfs;
    int fieldsStartOfs;
    int intermediateDataStartOfs;
    int methodsStartOfs;
    int origCPoolCount;
    private LineNumberTables lineNumberTables;
    private LocalVariableTables localVariableTables;
    private LocalVariableTypeTables localVariableTypeTables;
    private StackMapTables stackMapTables;

    protected ClassInfo(String className, int loaderId) {
        super(className, loaderId);
        this.packageName = ClassInfo.getPackageName(this.name);
    }

    ClassInfo(byte[] buf) throws ClassFormatError {
        super("", 0);
        try {
            new ClassFileParser().parseClassFile(buf, this);
        }
        catch (ClassFileParser.ClassFileReadException ex) {
            throw new ClassFormatError(ex.getMessage());
        }
        this.packageName = ClassInfo.getPackageName(this.name);
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.accessFlags);
    }

    public int getExceptionTableStartOffsetInMethodInfo(int i) {
        return this.exceptionTableStartOffsets[i];
    }

    public int getExceptionTableCount(int i) {
        int startOfs = this.getExceptionTableStartOffsetInMethodInfo(i);
        byte[] methodInfo = this.getMethodInfo(i);
        return ((methodInfo[startOfs] & 0xFF) << 8) + (methodInfo[startOfs + 1] & 0xFF);
    }

    public int getLocalVariableTableStartOffsetInMethodInfo(int i) {
        return this.localVariableTablesOffsets[i];
    }

    public int getLocalVariableTypeTableStartOffsetInMethodInfo(int i) {
        return this.localVariableTypeTablesOffsets[i];
    }

    public int getStackMapTableStartOffsetInMethodInfo(int i) {
        return this.stackMapTablesOffsets[i];
    }

    public boolean isInterface() {
        return Modifier.isInterface(this.accessFlags);
    }

    public String[] getInterfaceNames() {
        return this.interfaces;
    }

    public LineNumberTables getLineNumberTables() {
        this.initLineNumberTables();
        return this.lineNumberTables;
    }

    public LocalVariableTables getLocalVariableTables() {
        this.initLocalVariableTables();
        return this.localVariableTables;
    }

    public LocalVariableTypeTables getLocalVariableTypeTables() {
        this.initLocalVariableTypeTables();
        return this.localVariableTypeTables;
    }

    public StackMapTables getStackMapTables() {
        this.initStackMapTables();
        return this.stackMapTables;
    }

    public void resetTables() {
        this.lineNumberTables = null;
        this.localVariableTables = null;
        this.localVariableTypeTables = null;
        this.stackMapTables = null;
    }

    public boolean isMethodAbstract(int i) {
        return Modifier.isAbstract(this.methodAccessFlags[i]);
    }

    public byte[] getMethodBytecode(int i) {
        try {
            byte[] classFile = this.getClassFileBytes();
            byte[] res = new byte[this.methodBytecodesLengths[i]];
            System.arraycopy(classFile, this.methodInfoOffsets[i] + this.methodBytecodesOffsets[i], res, 0, this.methodBytecodesLengths[i]);
            return res;
        }
        catch (IOException ex1) {
            return null;
        }
        catch (ClassNotFoundException ex2) {
            return null;
        }
    }

    public int getMethodBytecodeOffsetInMethodInfo(int i) {
        return this.methodBytecodesOffsets[i];
    }

    public int getMethodBytecodesLength(int i) {
        return this.methodBytecodesLengths[i];
    }

    public boolean isMethodFinal(int i) {
        return Modifier.isFinal(this.methodAccessFlags[i]);
    }

    public int getMethodIndex(String name, String sig) {
        if (this.methodNames == null) {
            return -1;
        }
        for (int i = 0; i < this.methodNames.length; ++i) {
            if (this.methodNames[i] != name || this.methodSignatures[i] != sig) continue;
            return i;
        }
        return -1;
    }

    public byte[] getMethodInfo(int i) {
        try {
            byte[] classFile = this.getClassFileBytes();
            byte[] res = new byte[this.methodInfoLengths[i]];
            System.arraycopy(classFile, this.methodInfoOffsets[i], res, 0, this.methodInfoLengths[i]);
            return res;
        }
        catch (IOException ex1) {
            return null;
        }
        catch (ClassNotFoundException ex2) {
            return null;
        }
    }

    public int getMethodInfoLength(int i) {
        return this.methodInfoLengths[i];
    }

    public String getMethodName(int i) {
        return this.methodNames[i];
    }

    public String[] getMethodNames() {
        if (this.methodNames == null) {
            return new String[0];
        }
        return this.methodNames;
    }

    public boolean isMethodNative(int i) {
        return Modifier.isNative(this.methodAccessFlags[i]);
    }

    public boolean isMethodPrivate(int i) {
        return Modifier.isPrivate(this.methodAccessFlags[i]);
    }

    public boolean isMethodProtected(int i) {
        return Modifier.isProtected(this.methodAccessFlags[i]);
    }

    public boolean isMethodPublic(int i) {
        return Modifier.isPublic(this.methodAccessFlags[i]);
    }

    public String getMethodSignature(int i) {
        return this.methodSignatures[i];
    }

    public String[] getMethodSignatures() {
        return this.methodSignatures;
    }

    public boolean isMethodStatic(int i) {
        return Modifier.isStatic(this.methodAccessFlags[i]);
    }

    public int[] getMinAndMaxLinesForMethod(int methodIdx) {
        this.initLineNumberTables();
        return this.lineNumberTables.getMinAndMaxLinesForMethod(methodIdx);
    }

    public String[] getNestedClassNames() {
        return this.nestedClassNames;
    }

    public int getOrigAttrsStartOfs() {
        return this.attrsStartOfs;
    }

    public int getOrigCPoolCount() {
        return this.origCPoolCount;
    }

    public int getOrigCPoolStartOfs() {
        return this.cpoolStartOfs;
    }

    public int getOrigFieldsStartOfs() {
        return this.fieldsStartOfs;
    }

    public int getOrigIntermediateDataStartOfs() {
        return this.intermediateDataStartOfs;
    }

    public int getOrigMethodsStartOfs() {
        return this.methodsStartOfs;
    }

    public String getRefClassName(int refClassIdx) {
        for (int i = 0; i < this.cpoolRefsToClassIdx.length; ++i) {
            if (this.cpoolRefsToClassIdx[i] != refClassIdx) continue;
            return this.cpoolRefsToClassName[i];
        }
        return null;
    }

    public int getCPIndexOfClass(String className) {
        int cpIndex = -1;
        for (int i = 0; i < this.cpoolRefsToClassName.length; ++i) {
            if (!this.cpoolRefsToClassName[i].equals(className)) continue;
            cpIndex = this.cpoolRefsToClassIdx[i];
        }
        return cpIndex;
    }

    public String[] getRefMethodsClassNameAndSig(int refMethodIdx) {
        for (int i = 0; i < this.cpoolRefsToMethodIdx.length; ++i) {
            if (this.cpoolRefsToMethodIdx[i] != refMethodIdx) continue;
            return this.cpoolRefsToMethodClassNameAndSig[i];
        }
        return null;
    }

    public String getSuperclassName() {
        return this.superName;
    }

    public int bciForMethodAndLineNo(int methodIdx, int lineNo) {
        this.initLineNumberTables();
        return this.lineNumberTables.bciForLineNo(methodIdx, lineNo);
    }

    public int checkIfAtGoTo(int methodIdx, int bci) {
        byte[] codeBytes = this.getMethodBytecode(methodIdx);
        int codeAtBCI = codeBytes[bci] & 0xFF;
        if (codeAtBCI != 167 && codeAtBCI != 200) {
            return bci;
        }
        return ClassInfo.findPreviousBCI(codeBytes, bci);
    }

    public boolean containsMethod(String name, String sig) {
        return this.getMethodIndex(name, sig) != -1;
    }

    public static int findPreviousBCI(byte[] codeBytes, int bci) {
        int prev_offset = 0;
        int offset = 0;
        block4: while (offset < bci) {
            prev_offset = offset;
            int opcode = codeBytes[offset] & 0xFF;
            if (opcode == 196) {
                opcode = codeBytes[offset + 1] & 0xFF;
                if (opcode >= 21 && opcode <= 25 || opcode >= 54 && opcode <= 58 || opcode == 169) {
                    offset += 4;
                    continue;
                }
                if (opcode == 132) {
                    offset += 6;
                    continue;
                }
                ++offset;
                continue;
            }
            switch (opcode) {
                case 170: {
                    int tbl = offset + 1 + 3 & 0xFFFFFFFC;
                    long default_skip = ClassInfo.intAt(codeBytes, tbl, 0);
                    long low = ClassInfo.intAt(codeBytes, tbl, 1);
                    long high = ClassInfo.intAt(codeBytes, tbl, 2);
                    offset = (tbl += 12) + (int)(high - low + 1L << 2);
                    continue block4;
                }
                case 171: {
                    int tbl = offset + 1 + 3 & 0xFFFFFFFC;
                    long default_skip = ClassInfo.intAt(codeBytes, tbl, 0);
                    int npairs = (int)ClassInfo.intAt(codeBytes, tbl, 1);
                    int nints = npairs * 2;
                    offset = (tbl += 8) + (nints << 2);
                    continue block4;
                }
            }
            offset += opc_length[opcode];
        }
        return prev_offset;
    }

    public int lineNoForMethodAndBci(int methodIdx, int bci) {
        this.initLineNumberTables();
        return this.lineNumberTables.lineNoForBci(methodIdx, bci);
    }

    public int[] methodIdxAndBestBCIForLineNo(int lineNo) {
        int bestBCI;
        int i;
        this.initLineNumberTables();
        if (!this.lineNumberTables.hasTable()) {
            return new int[]{-2, -2};
        }
        int nMethods = this.methodNames.length;
        for (i = 0; i < nMethods; ++i) {
            if (this.methodNames[i] == "<init>" || this.methodNames[i] == "<clinit>" || (bestBCI = this.lineNumberTables.bciForLineNo(i, lineNo)) == -1) continue;
            return new int[]{i, bestBCI};
        }
        for (i = 0; i < nMethods; ++i) {
            if (this.methodNames[i] != "<init>" && this.methodNames[i] != "<clinit>" || (bestBCI = this.lineNumberTables.bciForLineNo(i, lineNo)) == -1) continue;
            return new int[]{i, bestBCI};
        }
        return new int[]{-1, -1};
    }

    public int overridesVirtualMethod(ClassInfo superClass, int superMethodIdx) {
        int idx = this.getMethodIndex(superClass.methodNames[superMethodIdx], superClass.methodSignatures[superMethodIdx]);
        if (idx == -1) {
            return -1;
        }
        if (superClass.isMethodPublic(superMethodIdx) || superClass.isMethodProtected(superMethodIdx)) {
            return idx;
        }
        if (superClass.packageName == this.packageName) {
            return idx;
        }
        return -1;
    }

    protected abstract byte[] getClassFileBytes() throws IOException, ClassNotFoundException;

    protected static String getPackageName(String clazzName) {
        int ldi = clazzName.lastIndexOf(47);
        if (ldi == -1) {
            return "";
        }
        return clazzName.substring(0, ldi).intern();
    }

    static long intAt(byte[] codeBytes, int tbl, int entry) {
        int base = tbl + (entry << 2);
        return codeBytes[base] << 24 | (codeBytes[base + 1] & 0xFF) << 16 | (codeBytes[base + 2] & 0xFF) << 8 | codeBytes[base + 3] & 0xFF;
    }

    static void putU2(byte[] buf, int pos, int value) {
        buf[pos] = (byte)(value >> 8 & 0xFF);
        buf[pos + 1] = (byte)(value & 0xFF);
    }

    static int getU2(byte[] buf, int pos) {
        return ((buf[pos] & 0xFF) << 8) + (buf[pos + 1] & 0xFF);
    }

    private static boolean adjustOffset(int bciIter, int injectionPos, boolean changeTypeIsInjectNewInstr, boolean injectionBindsToFollowingInstruction) {
        boolean adjustOffset = false;
        if (bciIter > injectionPos) {
            adjustOffset = true;
        } else if (changeTypeIsInjectNewInstr) {
            if (injectionPos == 0 && bciIter == 0) {
                adjustOffset = true;
            } else if (!injectionBindsToFollowingInstruction && bciIter >= injectionPos) {
                adjustOffset = true;
            }
        }
        return adjustOffset;
    }

    private synchronized void initLineNumberTables() {
        if (this.lineNumberTables == null) {
            this.lineNumberTables = new LineNumberTables(this);
        }
    }

    private synchronized void initLocalVariableTables() {
        if (this.localVariableTables == null) {
            this.localVariableTables = new LocalVariableTables(this);
        }
    }

    private synchronized void initLocalVariableTypeTables() {
        if (this.localVariableTypeTables == null) {
            this.localVariableTypeTables = new LocalVariableTypeTables(this);
        }
    }

    private synchronized void initStackMapTables() {
        if (this.stackMapTables == null) {
            this.stackMapTables = new StackMapTables();
        }
    }

    static class FullStackMapFrame
    extends StackMapFrame {
        int[] localsCPIdx;
        int[] stacksCPIdx;

        FullStackMapFrame(int delta, int[] locals, int[] stacks) {
            super(StackMapFrame.FrameType.FULL_FRAME, delta, stacks.length * 3 + (locals.length > 0 && locals[0] == 0 ? locals.length : 3 * locals.length));
            this.localsCPIdx = locals;
            this.stacksCPIdx = stacks;
        }

        @Override
        void writeFrame(byte[] ret, int offset) {
            int i;
            ret[offset++] = -1;
            ClassInfo.putU2(ret, offset, this.storedOffsetDelta);
            ClassInfo.putU2(ret, offset += 2, this.localsCPIdx.length);
            offset += 2;
            for (i = 0; i < this.localsCPIdx.length; ++i) {
                int cpIndex = this.localsCPIdx[i];
                if (cpIndex == 0) {
                    ret[offset++] = 0;
                    continue;
                }
                ret[offset++] = 7;
                ClassInfo.putU2(ret, offset, cpIndex);
                offset += 2;
            }
            ClassInfo.putU2(ret, offset, this.stacksCPIdx.length);
            offset += 2;
            for (i = 0; i < this.stacksCPIdx.length; ++i) {
                ret[offset++] = 7;
                ClassInfo.putU2(ret, offset, this.stacksCPIdx[i]);
                offset += 2;
            }
        }
    }

    static class StackMapFrame {
        FrameType frameType;
        int storedOffsetDelta;
        int size;
        boolean modified;
        boolean frameModified;
        boolean uninitializedListModified;
        List<Integer> uninitializedList;

        StackMapFrame(FrameType type, int offset, int s) {
            this.frameType = type;
            this.storedOffsetDelta = offset - 1;
            this.size = type.size() + s;
        }

        StackMapFrame(byte[] buffer, int offset) {
            int type = buffer[offset++] & 0xFF;
            if (type <= 63) {
                this.frameType = FrameType.SAME;
                this.storedOffsetDelta = type;
            } else if (type <= 127) {
                this.frameType = FrameType.SAME_LOCALS_1_STACK_ITEM;
                this.storedOffsetDelta = type - 64;
                this.size = this.getVerificationTypeInfoSize(buffer[offset]);
                this.storeUninitializedVariableInfo(buffer, offset, 0);
            } else {
                if (type <= 246) {
                    throw new IllegalArgumentException("Type: " + type);
                }
                if (type == 247) {
                    this.frameType = FrameType.SAME_LOCALS_1_STACK_ITEM_EXTENDED;
                    this.storedOffsetDelta = ClassInfo.getU2(buffer, offset);
                    this.size = this.getVerificationTypeInfoSize(buffer[offset += 2]);
                    this.storeUninitializedVariableInfo(buffer, offset, 0);
                } else if (type <= 250) {
                    this.frameType = FrameType.CHOP;
                    this.storedOffsetDelta = ClassInfo.getU2(buffer, offset);
                } else if (type == 251) {
                    this.frameType = FrameType.SAME_FRAME_EXTENDED;
                    this.storedOffsetDelta = ClassInfo.getU2(buffer, offset);
                } else if (type <= 254) {
                    this.frameType = FrameType.APPEND;
                    this.storedOffsetDelta = ClassInfo.getU2(buffer, offset);
                    offset += 2;
                    int locals = type - 251;
                    for (int i = 0; i < locals; ++i) {
                        int typeInfoSize = this.getVerificationTypeInfoSize(buffer[offset]);
                        this.size += typeInfoSize;
                        this.storeUninitializedVariableInfo(buffer, offset, i);
                        offset += typeInfoSize;
                    }
                } else if (type == 255) {
                    this.frameType = FrameType.FULL_FRAME;
                    this.storedOffsetDelta = ClassInfo.getU2(buffer, offset);
                    int locals = ClassInfo.getU2(buffer, offset += 2);
                    offset += 2;
                    for (int i = 0; i < locals; ++i) {
                        int typeInfoSize = this.getVerificationTypeInfoSize(buffer[offset]);
                        this.size += typeInfoSize;
                        this.storeUninitializedVariableInfo(buffer, offset, i);
                        offset += typeInfoSize;
                    }
                    int stacks = ClassInfo.getU2(buffer, offset);
                    offset += 2;
                    for (int i = 0; i < stacks; ++i) {
                        int typeInfoSize = this.getVerificationTypeInfoSize(buffer[offset]);
                        this.size += typeInfoSize;
                        this.storeUninitializedVariableInfo(buffer, offset, locals + i);
                        offset += typeInfoSize;
                    }
                } else {
                    throw new IllegalArgumentException("Type: " + type);
                }
            }
            this.size += this.frameType.size();
        }

        int getSize() {
            return this.size;
        }

        void setFrameType(FrameType newFrameType) {
            int frameSizeDiff = newFrameType.size() - this.frameType.size();
            this.frameType = newFrameType;
            this.size += frameSizeDiff;
            this.frameModified = true;
        }

        private int getVerificationTypeInfoSize(byte type) {
            switch (type) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    return 1;
                }
                case 7: 
                case 8: {
                    return 3;
                }
            }
            throw new IllegalArgumentException("Type " + type);
        }

        public String toString() {
            return "StackMapFrame " + (Object)((Object)this.frameType) + " offsetDelta " + this.getOffsetDelta() + " size " + this.getSize();
        }

        private int getOffsetDelta() {
            return this.storedOffsetDelta + 1;
        }

        private void setOffsetDelta(int newOffsetDelta) {
            this.storedOffsetDelta = newOffsetDelta - 1;
            this.modified = true;
        }

        private void updateUnitilializedList(int injectionPos, int injectedBytesCount, boolean changeTypeIsInjectNewInstr, boolean injectionBindsToFollowingInstruction) {
            if (this.uninitializedList != null) {
                for (int i = 0; i < this.uninitializedList.size(); ++i) {
                    int uninitializedOffset;
                    Integer off = this.uninitializedList.get(i);
                    if (off == null || !ClassInfo.adjustOffset(uninitializedOffset = off.intValue(), injectionPos, changeTypeIsInjectNewInstr, injectionBindsToFollowingInstruction)) continue;
                    this.uninitializedList.set(i, uninitializedOffset + injectedBytesCount);
                    this.uninitializedListModified = true;
                }
            }
        }

        private void storeUninitializedVariableInfo(byte[] buffer, int offset, int listIndex) {
            byte type;
            if ((type = buffer[offset++]) == 8) {
                if (this.uninitializedList == null) {
                    this.uninitializedList = new ArrayList<Integer>();
                }
                while (this.uninitializedList.size() < listIndex + 1) {
                    this.uninitializedList.add(null);
                }
                this.uninitializedList.set(listIndex, ClassInfo.getU2(buffer, offset));
            }
        }

        void writeFrame(byte[] ret, int newFrameOffset) {
            if (this.modified) {
                if (this.frameModified) {
                    switch (this.frameType) {
                        case SAME_LOCALS_1_STACK_ITEM_EXTENDED: {
                            ret[newFrameOffset] = -9;
                            break;
                        }
                        case SAME_FRAME_EXTENDED: {
                            ret[newFrameOffset] = -5;
                        }
                    }
                }
                switch (this.frameType) {
                    case SAME: {
                        ret[newFrameOffset] = (byte)(this.storedOffsetDelta & 0x3F);
                        break;
                    }
                    case SAME_LOCALS_1_STACK_ITEM: {
                        ret[newFrameOffset] = (byte)(64 + (this.storedOffsetDelta & 0x3F));
                        break;
                    }
                    case SAME_LOCALS_1_STACK_ITEM_EXTENDED: 
                    case SAME_FRAME_EXTENDED: 
                    case CHOP: 
                    case APPEND: 
                    case FULL_FRAME: {
                        ClassInfo.putU2(ret, newFrameOffset + 1, this.storedOffsetDelta);
                    }
                }
            }
            if (this.uninitializedListModified) {
                switch (this.frameType) {
                    case SAME_LOCALS_1_STACK_ITEM: {
                        ClassInfo.putU2(ret, newFrameOffset + 2, this.uninitializedList.get(0));
                        break;
                    }
                    case SAME_LOCALS_1_STACK_ITEM_EXTENDED: {
                        ClassInfo.putU2(ret, newFrameOffset + 3, this.uninitializedList.get(0));
                        break;
                    }
                    case APPEND: {
                        int offset = newFrameOffset + 3;
                        for (Integer off : this.uninitializedList) {
                            byte type = ret[offset];
                            int typeInfoSize = this.getVerificationTypeInfoSize(type);
                            if (type == 8) {
                                ClassInfo.putU2(ret, offset + 1, off);
                            }
                            offset += typeInfoSize;
                        }
                        break;
                    }
                    case FULL_FRAME: {
                        int offset = newFrameOffset + 3;
                        int locals = ClassInfo.getU2(ret, offset);
                        offset += 2;
                        for (int i = 0; i < locals; ++i) {
                            byte type = ret[offset];
                            int typeInfoSize = this.getVerificationTypeInfoSize(type);
                            if (type == 8) {
                                ClassInfo.putU2(ret, offset + 1, this.uninitializedList.get(i));
                            }
                            offset += typeInfoSize;
                        }
                        int stacks = ClassInfo.getU2(ret, offset);
                        offset += 2;
                        for (int i = 0; i < stacks; ++i) {
                            byte type = ret[offset];
                            int typeInfoSize = this.getVerificationTypeInfoSize(type);
                            if (type == 8) {
                                ClassInfo.putU2(ret, offset + 1, this.uninitializedList.get(locals + i));
                            }
                            offset += typeInfoSize;
                        }
                        break;
                    }
                }
            }
        }

        static enum FrameType {
            SAME(1),
            SAME_LOCALS_1_STACK_ITEM(1),
            SAME_LOCALS_1_STACK_ITEM_EXTENDED(3),
            CHOP(3),
            SAME_FRAME_EXTENDED(3),
            APPEND(3),
            FULL_FRAME(7);

            private int frameSize;

            int size() {
                return this.frameSize;
            }

            private FrameType(int size) {
                this.frameSize = size;
            }
        }
    }

    public class StackMapTables {
        private StackMapFrame[][] frames;
        private byte[][] framesBytes;
        private boolean hasTable;

        StackMapTables() {
            byte[] classBuf = null;
            try {
                classBuf = ClassInfo.this.getClassFileBytes();
            }
            catch (IOException ex1) {
            }
            catch (ClassNotFoundException ex2) {
                // empty catch block
            }
            int nMethods = ClassInfo.this.getMethodNames().length;
            this.frames = new StackMapFrame[nMethods][];
            this.framesBytes = new byte[nMethods][];
            for (int i = 0; i < nMethods; ++i) {
                int startOfs;
                int tableLen = ClassInfo.this.stackMapTablesLengths[i];
                if (tableLen == 0) continue;
                int ofs = startOfs = ClassInfo.this.methodInfoOffsets[i] + ClassInfo.this.stackMapTablesOffsets[i];
                this.frames[i] = new StackMapFrame[tableLen];
                StackMapFrame[] frms = this.frames[i];
                for (int j = 0; j < tableLen; ++j) {
                    frms[j] = new StackMapFrame(classBuf, ofs);
                    ofs += frms[j].getSize();
                }
                int len = ofs - startOfs;
                this.framesBytes[i] = new byte[len + tableLen + 2 * (StackMapFrame.FrameType.FULL_FRAME.size() + 6)];
                System.arraycopy(classBuf, startOfs, this.framesBytes[i], 0, len);
                this.hasTable = true;
            }
        }

        public boolean hasTable() {
            return this.hasTable;
        }

        public void updateTable(int injectionPos, int injectedBytesCount, int methodIdx, boolean changeTypeIsInjectNewInstr, boolean injectionBindsToFollowingInstruction) {
            StackMapFrame[] frms;
            String method = ClassInfo.this.getMethodName(methodIdx);
            if (this.hasTable() && (frms = this.frames[methodIdx]) != null) {
                int bciIter = -1;
                boolean offsetAdjusted = false;
                for (StackMapFrame frame : frms) {
                    int offsetDelta = frame.getOffsetDelta();
                    if (!offsetAdjusted && ClassInfo.adjustOffset(bciIter += offsetDelta, injectionPos, changeTypeIsInjectNewInstr, injectionBindsToFollowingInstruction)) {
                        this.setOffsetDelta(methodIdx, frame, offsetDelta + injectedBytesCount);
                        offsetAdjusted = true;
                    }
                    frame.updateUnitilializedList(injectionPos, injectedBytesCount, changeTypeIsInjectNewInstr, injectionBindsToFollowingInstruction);
                }
            }
        }

        public int getNumberOfFrames(int methodIdx) {
            StackMapFrame[] frms = this.frames[methodIdx];
            if (frms != null) {
                return frms.length;
            }
            return 0;
        }

        public byte[] getAttributeHeader(int methodIdx) {
            byte[] header = new byte[8];
            ClassInfo.putU2(header, 0, ClassInfo.this.stackMapTableCPindex);
            return header;
        }

        public byte[] writeTable(int methodIdx) {
            StackMapFrame[] frms = this.frames[methodIdx];
            byte[] frameBytes = this.framesBytes[methodIdx];
            if (frms != null) {
                int offset = 0;
                for (StackMapFrame frame : frms) {
                    frame.writeFrame(frameBytes, offset);
                    offset += frame.getSize();
                }
                byte[] ret = new byte[offset];
                System.arraycopy(frameBytes, 0, ret, 0, offset);
                return ret;
            }
            return null;
        }

        void addFullStackMapFrameEntry(int methodIdx, int endPC, int[] locals, int[] stacks) {
            StackMapFrame[] frms = this.frames[methodIdx];
            if (frms != null) {
                int bciIter = -1;
                for (StackMapFrame frame : frms) {
                    bciIter += frame.getOffsetDelta();
                }
                this.frames[methodIdx] = new StackMapFrame[frms.length + 1];
                StackMapFrame[] newFrms = this.frames[methodIdx];
                System.arraycopy(frms, 0, newFrms, 0, frms.length);
                newFrms[frms.length] = new FullStackMapFrame(endPC - bciIter, locals, stacks);
            } else {
                this.frames[methodIdx] = new StackMapFrame[1];
                StackMapFrame[] newFrms = this.frames[methodIdx];
                newFrms[0] = new FullStackMapFrame(endPC + 1, locals, stacks);
                this.framesBytes[methodIdx] = new byte[newFrms[0].getSize()];
                this.hasTable = true;
            }
        }

        private void setOffsetDelta(int methodIdx, StackMapFrame frame, int newOffsetDelta) {
            StackMapFrame.FrameType frameType = frame.frameType;
            if (frameType.equals((Object)StackMapFrame.FrameType.SAME) && newOffsetDelta > 63) {
                this.extendFrame(methodIdx, frame, 2);
                frame.setFrameType(StackMapFrame.FrameType.SAME_FRAME_EXTENDED);
            }
            if (frameType.equals((Object)StackMapFrame.FrameType.SAME_LOCALS_1_STACK_ITEM) && newOffsetDelta > 63) {
                this.extendFrame(methodIdx, frame, 2);
                frame.setFrameType(StackMapFrame.FrameType.SAME_LOCALS_1_STACK_ITEM_EXTENDED);
            }
            frame.setOffsetDelta(newOffsetDelta);
        }

        private void extendFrame(int methodIdx, StackMapFrame frame, int addBytes) {
            StackMapFrame[] frms = this.frames[methodIdx];
            byte[] data = this.framesBytes[methodIdx];
            int offset = 0;
            for (StackMapFrame f : frms) {
                if (f == frame) break;
                offset += f.getSize();
            }
            System.arraycopy(data, offset, data, offset + addBytes, data.length - offset - addBytes);
        }
    }

    public static class LocalVariableTypeTables
    extends LocalVariableTables {
        LocalVariableTypeTables(ClassInfo ci) {
            super(ci, ci.localVariableTypeTablesOffsets, ci.localVariableTypeTablesLengths);
        }
    }

    public static class LocalVariableTables {
        public static final int ATTR_SIZE = 10;
        private char[][] lengths;
        private char[][] startPCs;
        private boolean hasTable;

        LocalVariableTables(ClassInfo ci) {
            this(ci, ci.localVariableTablesOffsets, ci.localVariableTablesLengths);
        }

        private LocalVariableTables(ClassInfo ci, int[] tablesOffsets, char[] tablesLengths) {
            byte[] classBuf = null;
            try {
                classBuf = ci.getClassFileBytes();
            }
            catch (IOException ex1) {
            }
            catch (ClassNotFoundException ex2) {
                // empty catch block
            }
            int nMethods = ci.getMethodNames().length;
            this.startPCs = new char[nMethods][];
            this.lengths = new char[nMethods][];
            for (int i = 0; i < nMethods; ++i) {
                int tableLen = tablesLengths[i];
                if (tableLen == 0) continue;
                int ofs = ci.methodInfoOffsets[i] + tablesOffsets[i];
                this.startPCs[i] = new char[tableLen];
                char[] startPC = this.startPCs[i];
                this.lengths[i] = new char[tableLen];
                char[] length = this.lengths[i];
                int j = 0;
                while (j < tableLen) {
                    int offset = ofs;
                    startPC[j] = (char)(((classBuf[offset++] & 0xFF) << 8) + (classBuf[offset++] & 0xFF));
                    length[j] = (char)(((classBuf[offset++] & 0xFF) << 8) + (classBuf[offset++] & 0xFF));
                    ++j;
                    ofs += 10;
                }
                this.hasTable = true;
            }
        }

        char[][] getStartPCs() {
            return this.startPCs;
        }

        char[][] getLengts() {
            return this.lengths;
        }

        public boolean hasTable() {
            return this.hasTable;
        }

        public void updateTable(int injectionPos, int injectedBytesCount, int methodIdx) {
            if (this.hasTable()) {
                char[] startPC = this.getStartPCs()[methodIdx];
                char[] lengths = this.getLengts()[methodIdx];
                if (startPC != null) {
                    for (int i = 0; i < startPC.length; ++i) {
                        char currentBCI = startPC[i];
                        if (currentBCI >= injectionPos) {
                            startPC[i] = (char)(currentBCI + injectedBytesCount);
                            continue;
                        }
                        char currentLength = lengths[i];
                        if (currentBCI + currentLength <= injectionPos) continue;
                        lengths[i] = (char)(currentLength + injectedBytesCount);
                    }
                }
            }
        }

        public void writeTable(byte[] buffer, int locVarTablePtr, int methodIdx) {
            char[] startPC = this.getStartPCs()[methodIdx];
            char[] lengths = this.getLengts()[methodIdx];
            if (startPC != null) {
                int i = 0;
                while (i < startPC.length) {
                    ClassInfo.putU2(buffer, locVarTablePtr, startPC[i]);
                    ClassInfo.putU2(buffer, locVarTablePtr + 2, lengths[i]);
                    ++i;
                    locVarTablePtr += 10;
                }
            }
        }
    }

    public static class LineNumberTables {
        private char[][] lineNumbers;
        private char[][] startPCs;
        private boolean hasTable;

        LineNumberTables(ClassInfo ci) {
            byte[] classBuf = null;
            try {
                classBuf = ci.getClassFileBytes();
            }
            catch (IOException ex1) {
            }
            catch (ClassNotFoundException ex2) {
                // empty catch block
            }
            int nMethods = ci.getMethodNames().length;
            this.startPCs = new char[nMethods][];
            this.lineNumbers = new char[nMethods][];
            for (int i = 0; i < nMethods; ++i) {
                int ofs = ci.methodInfoOffsets[i] + ci.lineNumberTablesOffsets[i];
                if (ofs == -1) continue;
                this.hasTable = true;
                int tableLen = ci.lineNumberTablesLengths[i];
                this.startPCs[i] = new char[tableLen];
                char[] startPC = this.startPCs[i];
                this.lineNumbers[i] = new char[tableLen];
                char[] lineNumber = this.lineNumbers[i];
                for (int j = 0; j < tableLen; ++j) {
                    startPC[j] = (char)(((classBuf[ofs++] & 0xFF) << 8) + (classBuf[ofs++] & 0xFF));
                    lineNumber[j] = (char)(((classBuf[ofs++] & 0xFF) << 8) + (classBuf[ofs++] & 0xFF));
                }
            }
        }

        public char[][] getStartPCs() {
            return this.startPCs;
        }

        int[] getMinAndMaxLinesForMethod(int methodIdx) {
            int[] lines = new int[2];
            if (this.startPCs[methodIdx] == null) {
                lines[1] = -1;
                lines[0] = -1;
                return lines;
            }
            lines[0] = 10000000;
            lines[1] = -10000000;
            char[] lns = this.lineNumbers[methodIdx];
            for (int i = 0; i < lns.length; ++i) {
                if (lns[i] < lines[0]) {
                    lines[0] = lns[i];
                }
                if (lns[i] <= lines[1]) continue;
                lines[1] = lns[i];
            }
            return lines;
        }

        int bciForLineNo(int methodIdx, int lineNo) {
            char c;
            char[] spcs = this.startPCs[methodIdx];
            if (spcs == null) {
                return -1;
            }
            int tableLen = spcs.length;
            char[] lns = this.lineNumbers[methodIdx];
            int minLine = 100000000;
            int bestLine = 100000000;
            int maxLine = 0;
            int curLine = -1;
            int n = 100000000;
            for (int i = 0; i < tableLen; ++i) {
                char c2;
                curLine = lns[i];
                if (curLine > maxLine) {
                    maxLine = curLine;
                }
                if (curLine < minLine) {
                    minLine = curLine;
                }
                if (curLine == lineNo) {
                    c = spcs[i];
                    break;
                }
                if (curLine <= lineNo || curLine > bestLine || spcs[i] >= c2) continue;
                c2 = spcs[i];
                bestLine = curLine;
            }
            if (curLine == lineNo || lineNo >= minLine && lineNo <= maxLine) {
                return c;
            }
            return -1;
        }

        int lineNoForBci(int methodIdx, int bci) {
            char[] spcs = this.startPCs[methodIdx];
            if (spcs == null) {
                return -1;
            }
            int tableLen = spcs.length;
            char[] lns = this.lineNumbers[methodIdx];
            int bestLine = -1;
            for (int i = 0; i < tableLen && spcs[i] <= bci; ++i) {
                bestLine = lns[i];
            }
            return bestLine;
        }

        private boolean hasTable() {
            return this.hasTable;
        }
    }
}

