/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.memory;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.results.memory.HeapHistogram;
import org.netbeans.lib.profiler.results.memory.MemoryCCTProvider;
import org.netbeans.lib.profiler.results.memory.MemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.PresoObjAllocCCTNode;
import org.netbeans.lib.profiler.results.memory.RuntimeMemoryCCTNode;
import org.netbeans.lib.profiler.results.memory.SampledMemoryResultsDiff;

public class SampledMemoryResultsSnapshot
extends MemoryResultsSnapshot {
    private static final String MEMORY_SAMPLED_MSG = ResourceBundle.getBundle("org.netbeans.lib.profiler.results.memory.Bundle").getString("SampledMemoryResultsSnapshot_MemorySamledMsg");
    private int[] liveObjectsCounts;

    public SampledMemoryResultsSnapshot() {
    }

    public SampledMemoryResultsSnapshot(long beginTime, long timeTaken, ProfilerClient client) throws ClientUtils.TargetAppOrVMTerminated {
        super(beginTime, timeTaken, null, client);
    }

    public int[] getObjectsCounts() {
        return this.liveObjectsCounts;
    }

    @Override
    public void performInit(ProfilerClient client, MemoryCCTProvider provider) throws ClientUtils.TargetAppOrVMTerminated {
        HeapHistogram histo = client.getHeapHistogram();
        Set<HeapHistogram.ClassInfo> info = histo.getHeapHistogram();
        this.nProfiledClasses = info.size();
        this.classNames = new String[this.nProfiledClasses];
        this.objectsSizePerClass = new long[this.nProfiledClasses];
        this.liveObjectsCounts = new int[this.nProfiledClasses];
        int i = 0;
        for (HeapHistogram.ClassInfo ci : info) {
            this.classNames[i] = ci.getName();
            this.objectsSizePerClass[i] = ci.getBytes();
            this.liveObjectsCounts[i] = (int)ci.getInstancesCount();
            ++i;
        }
    }

    @Override
    public SampledMemoryResultsSnapshot createDiff(MemoryResultsSnapshot snapshot) {
        if (!(snapshot instanceof SampledMemoryResultsSnapshot)) {
            return null;
        }
        return new SampledMemoryResultsDiff(this, (SampledMemoryResultsSnapshot)snapshot);
    }

    @Override
    public void readFromStream(DataInputStream in) throws IOException {
        super.readFromStream(in);
        int len = in.readInt();
        this.liveObjectsCounts = new int[len];
        for (int i = 0; i < len; ++i) {
            this.liveObjectsCounts[i] = in.readInt();
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            this.debugValues();
        }
    }

    @Override
    public String toString() {
        return MessageFormat.format(MEMORY_SAMPLED_MSG, super.toString());
    }

    @Override
    public void writeToStream(DataOutputStream out) throws IOException {
        super.writeToStream(out);
        out.writeInt(this.liveObjectsCounts.length);
        for (int i = 0; i < this.liveObjectsCounts.length; ++i) {
            out.writeInt(this.liveObjectsCounts[i]);
        }
    }

    @Override
    protected PresoObjAllocCCTNode createPresentationCCT(RuntimeMemoryCCTNode rootNode, int classId, boolean dontShowZeroLiveObjAllocPaths) {
        return PresoObjAllocCCTNode.createPresentationCCTFromSnapshot(this, rootNode, this.getClassName(classId));
    }

    @Override
    void debugValues() {
        super.debugValues();
        LOGGER.finest("objectsCounts.length: " + this.debugLength(this.liveObjectsCounts));
    }
}

