/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.optional;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.extexecution.print.ConvertedLine;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

public class ErrorLineConvertor
implements LineConvertor {
    private String previousMessage;

    public List<ConvertedLine> convert(String line) {
        String path = null;
        int lineNo = -1;
        String message = null;
        boolean accessible = false;
        String logLine = line.trim();
        int lineLenght = logLine.length();
        if (logLine.startsWith("/")) {
            int colonIdx = logLine.indexOf(58);
            if (colonIdx > -1) {
                int nextColonIdx;
                path = logLine.substring(0, colonIdx);
                if (lineLenght > colonIdx && (nextColonIdx = logLine.indexOf(58, colonIdx + 1)) > -1) {
                    String lineNum = logLine.substring(colonIdx + 1, nextColonIdx);
                    try {
                        lineNo = Integer.valueOf(lineNum);
                        accessible = true;
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                    if (lineLenght > nextColonIdx) {
                        message = logLine.substring(nextColonIdx + 1, lineLenght);
                    }
                }
            }
        } else if (lineLenght > 3 && Character.isLetter(logLine.charAt(0)) && logLine.charAt(1) == ':' && logLine.charAt(2) == '\\') {
            int secondColonIdx = logLine.indexOf(58, 2);
            if (secondColonIdx > -1) {
                int thirdColonIdx;
                path = logLine.substring(0, secondColonIdx);
                if (lineLenght > secondColonIdx && (thirdColonIdx = logLine.indexOf(58, secondColonIdx + 1)) > -1) {
                    String lineNum = logLine.substring(secondColonIdx + 1, thirdColonIdx);
                    try {
                        lineNo = Integer.valueOf(lineNum);
                        accessible = true;
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                    if (lineLenght > thirdColonIdx) {
                        message = logLine.substring(thirdColonIdx + 1, lineLenght);
                    }
                }
            }
        } else if (logLine.startsWith("at ") && lineLenght > 3) {
            String classWithMethod;
            int lastDotIdx;
            int parenthIdx = logLine.indexOf(40);
            if (parenthIdx > -1 && (lastDotIdx = (classWithMethod = logLine.substring(3, parenthIdx)).lastIndexOf(46)) > -1) {
                int firstDolarIdx;
                int lastColonIdx;
                int lastParenthIdx = logLine.lastIndexOf(41);
                String content = null;
                if (lastParenthIdx > -1) {
                    content = logLine.substring(parenthIdx + 1, lastParenthIdx);
                }
                if (content != null && (lastColonIdx = content.lastIndexOf(58)) > -1) {
                    String lineNum = content.substring(lastColonIdx + 1);
                    try {
                        lineNo = Integer.valueOf(lineNum);
                    }
                    catch (NumberFormatException nfe) {
                        Logger.getLogger(ErrorLineConvertor.class.getName()).log(Level.INFO, null, nfe);
                    }
                    message = this.previousMessage;
                }
                String className = classWithMethod.substring(0, (firstDolarIdx = classWithMethod.indexOf(36)) > -1 ? firstDolarIdx : lastDotIdx);
                path = className.replace('.', '/') + ".java";
                accessible = GlobalPathRegistry.getDefault().findResource(path) != null;
            }
        } else {
            this.previousMessage = logLine;
        }
        if (accessible) {
            return Collections.singletonList(ConvertedLine.forText((String)line, (OutputListener)new LinkOutputListener(message, lineNo, path)));
        }
        return null;
    }

    private static class LinkOutputListener
    implements OutputListener {
        private final String message;
        private final int line;
        private final String path;

        LinkOutputListener(String msg, int lineNo, String filePath) {
            this.message = msg;
            this.line = lineNo;
            this.path = filePath;
        }

        public void outputLineAction(OutputEvent ev) {
            FileObject sourceFile = GlobalPathRegistry.getDefault().findResource(this.path);
            if (sourceFile == null) {
                sourceFile = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(this.path)));
            }
            DataObject dataObject = null;
            if (sourceFile != null) {
                try {
                    dataObject = DataObject.find((FileObject)sourceFile);
                }
                catch (DataObjectNotFoundException ex) {
                    Logger.getLogger(ErrorLineConvertor.class.getName()).log(Level.INFO, null, ex);
                }
            }
            if (dataObject != null) {
                EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
                if (editorCookie == null) {
                    return;
                }
                editorCookie.open();
                Line errorLine = null;
                try {
                    errorLine = editorCookie.getLineSet().getCurrent(this.line - 1);
                }
                catch (IndexOutOfBoundsException iobe) {
                    return;
                }
                errorLine.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.NONE);
            }
        }

        public void outputLineCleared(OutputEvent ev) {
        }

        public void outputLineSelected(OutputEvent ev) {
        }
    }
}

