/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.cplusplus;

import java.util.EnumSet;
import java.util.Set;
import java.util.Stack;
import java.util.prefs.Preferences;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CndAbstractTokenProcessor;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CndTokenProcessor;
import org.netbeans.cnd.api.lexer.CndTokenUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.cnd.api.lexer.TokenItem;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenProcessor;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.spi.editor.typinghooks.TypedTextInterceptor;

public class BracketCompletion {
    private static final Set<? extends TokenId> STOP_TOKENS_FOR_SKIP_CLOSING_BRACKET = EnumSet.of(CppTokenId.LBRACE, CppTokenId.RBRACE, CppTokenId.SEMICOLON);
    private static final Set<? extends TokenId> STRING_AND_COMMENT_TOKENS = EnumSet.of(CppTokenId.STRING_LITERAL, CppTokenId.LINE_COMMENT, CppTokenId.DOXYGEN_COMMENT, CppTokenId.DOXYGEN_LINE_COMMENT, CppTokenId.BLOCK_COMMENT);

    static void charInserted(BaseDocument doc, int dotPos, Caret caret, char ch, boolean blockCommentStart) throws BadLocationException {
        if (!BracketCompletion.completionSettingEnabled((Document)doc)) {
            return;
        }
        TokenItem tokenAtDot = CndTokenUtilities.getToken((Document)doc, (int)dotPos, (boolean)true);
        if (tokenAtDot == null) {
            return;
        }
        if (ch == '\"' || ch == '\'') {
            BracketCompletion.completeQuote(doc, dotPos, caret, ch);
        } else if (ch == ';') {
            BracketCompletion.moveSemicolon(doc, dotPos, caret);
        } else if (ch == '.') {
            if (dotPos > 0 && (tokenAtDot = CndTokenUtilities.getToken((Document)doc, (int)(dotPos - 1), (boolean)true)).id() == CppTokenId.THIS) {
                doc.remove(dotPos, 1);
                doc.insertString(dotPos, "->", null);
                caret.setDot(dotPos + 2);
            }
        } else if (ch == '*' && blockCommentStart && tokenAtDot.id() == CppTokenId.BLOCK_COMMENT) {
            doc.insertString(dotPos + 1, "*/", null);
            caret.setDot(dotPos + 1);
        }
    }

    private static void moveSemicolon(BaseDocument doc, int dotPos, Caret caret) throws BadLocationException {
        int eolPos = Utilities.getRowEnd((BaseDocument)doc, (int)dotPos);
        TokenSequence cppTokenSequence = CndLexerUtilities.getCppTokenSequence((Document)doc, (int)dotPos, (boolean)true, (boolean)false);
        if (cppTokenSequence == null) {
            return;
        }
        int lastParenPos = dotPos;
        while (cppTokenSequence.moveNext() && cppTokenSequence.offset() < eolPos) {
            Token token = cppTokenSequence.token();
            if (token.id() == CppTokenId.RPAREN || token.id() == CppTokenId.RBRACKET) {
                lastParenPos = cppTokenSequence.offset();
                continue;
            }
            if ("whitespace".equals(token.id().primaryCategory())) continue;
            return;
        }
        if (BracketCompletion.posWithinAnyQuote(doc, dotPos) || BracketCompletion.isForLoopSemicolon(doc, dotPos)) {
            return;
        }
        doc.remove(dotPos, 1);
        doc.insertString(lastParenPos, ";", null);
        caret.setDot(lastParenPos + 1);
    }

    private static boolean isForLoopSemicolon(BaseDocument doc, int dotPos) {
        TokenSequence ts = CndLexerUtilities.getCppTokenSequence((Document)doc, (int)dotPos, (boolean)true, (boolean)false);
        if (ts == null || ts.token().id() != CppTokenId.SEMICOLON) {
            return false;
        }
        int parDepth = 0;
        int braceDepth = 0;
        boolean semicolonFound = false;
        while (ts.movePrevious()) {
            Token token = ts.token();
            if (token.id() == CppTokenId.LPAREN) {
                if (parDepth == 0) {
                    String category;
                    while (ts.movePrevious() && ("whitespace".equals(category = (token = ts.token()).id().primaryCategory()) || "comment".equals(category))) {
                    }
                    return token.id() == CppTokenId.FOR;
                }
                --parDepth;
                continue;
            }
            if (token.id() == CppTokenId.RPAREN) {
                ++parDepth;
                continue;
            }
            if (token.id() == CppTokenId.LBRACE) {
                if (braceDepth == 0) {
                    return false;
                }
                --braceDepth;
                continue;
            }
            if (token.id() == CppTokenId.RBRACE) {
                ++braceDepth;
                continue;
            }
            if (token.id() != CppTokenId.SEMICOLON) continue;
            if (semicolonFound) {
                return false;
            }
            semicolonFound = true;
        }
        return false;
    }

    static void charBackspaced(BaseDocument doc, int dotPos, char ch) throws BadLocationException {
        if (BracketCompletion.completionSettingEnabled((Document)doc)) {
            TokenItem token;
            TokenId id;
            char[] match;
            if (doc.getLength() == 0) {
                return;
            }
            if (ch == '(' || ch == '[') {
                TokenItem token2 = CndTokenUtilities.getToken((Document)doc, (int)dotPos, (boolean)true);
                if (token2 == null) {
                    return;
                }
                if (token2.id() == CppTokenId.RBRACKET && BracketCompletion.tokenBalance(doc, CppTokenId.LBRACKET, CppTokenId.RBRACKET, dotPos) != 0 || token2.id() == CppTokenId.RPAREN && BracketCompletion.tokenBalance(doc, CppTokenId.LPAREN, CppTokenId.RPAREN, dotPos) != 0) {
                    doc.remove(dotPos, 1);
                }
            } else if (ch == '\"') {
                char[] match2 = doc.getChars(dotPos, 1);
                if (match2 != null && match2[0] == '\"') {
                    doc.remove(dotPos, 1);
                }
            } else if (ch == '\'') {
                char[] match3 = doc.getChars(dotPos, 1);
                if (match3 != null && match3[0] == '\'') {
                    doc.remove(dotPos, 1);
                }
            } else if (ch == '<' && (match = doc.getChars(dotPos, 1)) != null && match[0] == '>' && dotPos > 0 && (id = (token = CndTokenUtilities.getFirstNonWhiteBwd((Document)doc, (int)(dotPos - 1))).id()) instanceof CppTokenId) {
                switch ((CppTokenId)id) {
                    case PREPROCESSOR_INCLUDE: 
                    case PREPROCESSOR_INCLUDE_NEXT: {
                        doc.remove(dotPos, 1);
                    }
                }
            }
        }
    }

    private static TokenSequence<TokenId> cppTokenSequence(Document doc, int offset, boolean backwardBias) {
        return CndLexerUtilities.getCppTokenSequence((Document)doc, (int)offset, (boolean)true, (boolean)backwardBias);
    }

    static boolean isAddRightBrace(BaseDocument doc, int caretOffset) throws BadLocationException {
        if (!BracketCompletion.completionSettingEnabled((Document)doc)) {
            return false;
        }
        if (BracketCompletion.tokenBalance(doc, CppTokenId.LBRACE, CppTokenId.RBRACE, caretOffset) <= 0) {
            return false;
        }
        int caretRowStartOffset = Utilities.getRowStart((BaseDocument)doc, (int)caretOffset);
        TokenSequence<TokenId> ts = BracketCompletion.cppTokenSequence((Document)doc, caretOffset, true);
        if (ts == null) {
            return false;
        }
        boolean first = true;
        do {
            if (ts.offset() < caretRowStartOffset) {
                return false;
            }
            TokenId id = ts.token().id();
            if (id instanceof CppTokenId) {
                switch ((CppTokenId)id) {
                    case WHITESPACE: 
                    case LINE_COMMENT: 
                    case DOXYGEN_LINE_COMMENT: {
                        break;
                    }
                    case BLOCK_COMMENT: 
                    case DOXYGEN_COMMENT: {
                        if (!first || caretOffset <= ts.offset() || caretOffset >= ts.offset() + ts.token().length()) break;
                        return false;
                    }
                    case LBRACE: {
                        return true;
                    }
                }
            }
            first = false;
        } while (ts.movePrevious());
        return false;
    }

    static int getRowOrBlockEnd(BaseDocument doc, int caretOffset) throws BadLocationException {
        int rowEnd = Utilities.getRowLastNonWhite((BaseDocument)doc, (int)caretOffset);
        if (rowEnd == -1 || caretOffset >= rowEnd) {
            return caretOffset;
        }
        ++rowEnd;
        int parenBalance = 0;
        int braceBalance = 0;
        int bracketBalance = 0;
        TokenSequence<TokenId> cppTokenSequence = BracketCompletion.cppTokenSequence((Document)doc, caretOffset, false);
        if (cppTokenSequence == null) {
            return caretOffset;
        }
        while (cppTokenSequence.moveNext() && cppTokenSequence.offset() < rowEnd) {
            TokenId id = cppTokenSequence.token().id();
            if (!(id instanceof CppTokenId)) continue;
            switch ((CppTokenId)id) {
                case LPAREN: {
                    ++parenBalance;
                    break;
                }
                case RPAREN: {
                    if (parenBalance-- != 0) break;
                    return cppTokenSequence.offset();
                }
                case LBRACE: {
                    ++braceBalance;
                    break;
                }
                case RBRACE: {
                    if (braceBalance-- != 0) break;
                    return cppTokenSequence.offset();
                }
                case LBRACKET: {
                    ++bracketBalance;
                    break;
                }
                case RBRACKET: {
                    if (bracketBalance-- != 0) break;
                    return cppTokenSequence.offset();
                }
            }
        }
        return rowEnd;
    }

    private static int tokenBalance(BaseDocument doc, CppTokenId open, CppTokenId close, int caretOffset) throws BadLocationException {
        BalanceTokenProcessor tp = new BalanceTokenProcessor(open, close);
        CndTokenUtilities.processTokens((CndTokenProcessor)tp, (Document)doc, (int)0, (int)doc.getLength());
        return tp.getBalance();
    }

    private static boolean isSkipClosingBracket(TypedTextInterceptor.MutableContext context, TokenSequence<TokenId> cppTS, CppTokenId bracketId) throws BadLocationException {
        if (context.getOffset() == context.getDocument().getLength()) {
            return false;
        }
        boolean skipClosingBracket = false;
        TokenId id = cppTS.token().id();
        if (id == CppTokenId.PREPROCESSOR_SYS_INCLUDE && bracketId == CppTokenId.GT) {
            char chr = context.getDocument().getText(context.getOffset(), 1).charAt(0);
            return chr == '>';
        }
        if (id == bracketId) {
            CppTokenId leftBracketId = BracketCompletion.matching(bracketId);
            do {
                boolean isPrevious;
                if (!STOP_TOKENS_FOR_SKIP_CLOSING_BRACKET.contains(cppTS.token().id()) && (cppTS.token().id() != CppTokenId.WHITESPACE || !cppTS.token().text().toString().contains("\n"))) continue;
                while (cppTS.token().id() != bracketId && (isPrevious = cppTS.movePrevious())) {
                }
                break;
            } while (cppTS.moveNext());
            int braceBalance = 0;
            int bracketBalance = -1;
            int numOfSemi = 0;
            boolean finished = false;
            while (!finished && cppTS.movePrevious()) {
                id = cppTS.token().id();
                switch ((CppTokenId)id) {
                    case LPAREN: 
                    case LBRACKET: {
                        if (id != leftBracketId || ++bracketBalance != 1) break;
                        if (braceBalance != 0) {
                            bracketBalance = 2;
                        }
                        finished = cppTS.offset() < context.getOffset();
                        break;
                    }
                    case RPAREN: 
                    case RBRACKET: {
                        if (id != bracketId) break;
                        --bracketBalance;
                        break;
                    }
                    case LBRACE: {
                        if (++braceBalance <= 0) break;
                        finished = true;
                        break;
                    }
                    case RBRACE: {
                        --braceBalance;
                        break;
                    }
                    case SEMICOLON: {
                        ++numOfSemi;
                    }
                }
            }
            if (bracketBalance == 1 && numOfSemi < 2) {
                finished = false;
                block14: while (!finished && cppTS.movePrevious()) {
                    switch ((CppTokenId)cppTS.token().id()) {
                        case WHITESPACE: 
                        case LINE_COMMENT: 
                        case DOXYGEN_LINE_COMMENT: 
                        case BLOCK_COMMENT: 
                        case DOXYGEN_COMMENT: {
                            continue block14;
                        }
                        case FOR: {
                            --bracketBalance;
                        }
                    }
                    finished = true;
                }
            }
            skipClosingBracket = bracketBalance != 1;
        }
        return skipClosingBracket;
    }

    private static boolean isStringOrComment(TokenId tokenId) {
        return STRING_AND_COMMENT_TOKENS.contains(tokenId);
    }

    private static boolean isEscapeSequence(BaseDocument doc, int dotPos) throws BadLocationException {
        if (dotPos <= 0) {
            return false;
        }
        char previousChar = doc.getChars(dotPos - 1, 1)[0];
        return previousChar == '\\';
    }

    private static void completeQuote(BaseDocument doc, int dotPos, Caret caret, char theBracket) throws BadLocationException {
        CppTokenId[] cppTokenIdArray;
        if (BracketCompletion.isEscapeSequence(doc, dotPos)) {
            return;
        }
        if (theBracket == '\"') {
            CppTokenId[] cppTokenIdArray2 = new CppTokenId[3];
            cppTokenIdArray2[0] = CppTokenId.STRING_LITERAL;
            cppTokenIdArray2[1] = CppTokenId.RAW_STRING_LITERAL;
            cppTokenIdArray = cppTokenIdArray2;
            cppTokenIdArray2[2] = CppTokenId.PREPROCESSOR_USER_INCLUDE;
        } else {
            CppTokenId[] cppTokenIdArray3 = new CppTokenId[1];
            cppTokenIdArray = cppTokenIdArray3;
            cppTokenIdArray3[0] = CppTokenId.CHAR_LITERAL;
        }
        CppTokenId[] tokenIds = cppTokenIdArray;
        if (BracketCompletion.posWithinQuotes(doc, dotPos + 1, theBracket, tokenIds) && BracketCompletion.isCompletablePosition((Document)doc, dotPos + 1) && BracketCompletion.isUnclosedStringAtLineEnd(doc, dotPos + 1, tokenIds) && (doc.getLength() == dotPos + 1 || doc.getLength() != dotPos + 1 && doc.getChars(dotPos + 1, 1)[0] != theBracket)) {
            doc.insertString(dotPos + 1, "" + theBracket, null);
            caret.setDot(dotPos + 1);
        } else {
            char[] charss = doc.getChars(dotPos + 1, 1);
            if (charss != null && charss[0] == theBracket) {
                doc.remove(dotPos + 1, 1);
            }
        }
    }

    private static boolean isCompletablePosition(Document doc, int dotPos) throws BadLocationException {
        if (dotPos == doc.getLength()) {
            return true;
        }
        char chr = doc.getText(dotPos, 1).charAt(0);
        return chr == ')' || chr == ',' || chr == '\"' || chr == '\'' || chr == ' ' || chr == '-' || chr == '+' || chr == '|' || chr == '&' || chr == ']' || chr == '}' || chr == '\n' || chr == '\t' || chr == ';';
    }

    static boolean completionSettingEnabled(Document doc) {
        Preferences prefs = (Preferences)MimeLookup.getLookup((String)DocumentUtilities.getMimeType((Document)doc)).lookup(Preferences.class);
        return prefs.getBoolean("pair-characters-completion", true);
    }

    private static char matching(char theBracket) {
        switch (theBracket) {
            case '(': {
                return ')';
            }
            case '[': {
                return ']';
            }
            case '\"': {
                return '\"';
            }
            case '\'': {
                return '\'';
            }
            case '<': {
                return '>';
            }
        }
        return ' ';
    }

    static boolean posWithinNonRawString(BaseDocument doc, int dotPos) {
        return BracketCompletion.posWithinQuotes(doc, dotPos, '\"', new CppTokenId[]{CppTokenId.STRING_LITERAL});
    }

    static boolean posWithinQuotes(BaseDocument doc, int dotPos, char quote, CppTokenId[] tokenIDs) {
        TokenSequence<TokenId> cppTS = BracketCompletion.cppTokenSequence((Document)doc, dotPos, true);
        if (cppTS != null && BracketCompletion.matchIDs(cppTS.token().id(), tokenIDs)) {
            return dotPos - cppTS.offset() == 1 || DocumentUtilities.getText((Document)doc).charAt(dotPos - 1) != quote;
        }
        return false;
    }

    static boolean posWithinAnyQuote(BaseDocument doc, int dotPos) {
        TokenId id;
        TokenSequence<TokenId> cppTS = BracketCompletion.cppTokenSequence((Document)doc, dotPos - 1, false);
        if (cppTS != null && (id = cppTS.token().id()) instanceof CppTokenId) {
            switch ((CppTokenId)id) {
                case RAW_STRING_LITERAL: 
                case STRING_LITERAL: 
                case CHAR_LITERAL: 
                case PREPROCESSOR_USER_INCLUDE: 
                case PREPROCESSOR_SYS_INCLUDE: {
                    char ch = DocumentUtilities.getText((Document)doc).charAt(dotPos - 1);
                    return dotPos - cppTS.offset() == 1 || ch != '\"' && ch != '\'';
                }
            }
        }
        return false;
    }

    static boolean isUnclosedStringAtLineEnd(BaseDocument doc, int dotPos, CppTokenId[] tokenIDs) {
        int lastNonWhiteOffset;
        try {
            lastNonWhiteOffset = Utilities.getRowLastNonWhite((BaseDocument)doc, (int)dotPos);
        }
        catch (BadLocationException e) {
            return false;
        }
        TokenSequence<TokenId> cppTS = BracketCompletion.cppTokenSequence((Document)doc, lastNonWhiteOffset, false);
        if (cppTS != null) {
            return BracketCompletion.matchIDs(cppTS.token().id(), tokenIDs);
        }
        return false;
    }

    static boolean matchIDs(TokenID toCheck, TokenID[] checkWith) {
        for (int i = checkWith.length - 1; i >= 0; --i) {
            if (toCheck != checkWith[i]) continue;
            return true;
        }
        return false;
    }

    static boolean matchIDs(TokenId toCheck, CppTokenId[] checkWith) {
        for (int i = checkWith.length - 1; i >= 0; --i) {
            if (toCheck != checkWith[i]) continue;
            return true;
        }
        return false;
    }

    static boolean matchIDs(Token<CppTokenId> toCheck, Token<CppTokenId>[] checkWith) {
        for (int i = checkWith.length - 1; i >= 0; --i) {
            if (toCheck != checkWith[i]) continue;
            return true;
        }
        return false;
    }

    static void completeOpeningBracket(TypedTextInterceptor.MutableContext context) throws BadLocationException {
        TokenSequence<TokenId> cppTS = BracketCompletion.cppTokenSequence(context.getDocument(), context.getOffset(), false);
        if (BracketCompletion.isStringOrComment(cppTS.token().id())) {
            return;
        }
        char insChr = context.getText().charAt(0);
        char chr = context.getDocument().getText(context.getOffset(), 1).charAt(0);
        if (insChr == '<') {
            if (chr == '\n' && cppTS.language() == CppTokenId.languagePreproc()) {
                TokenId id;
                cppTS.moveStart();
                if (cppTS.moveNext() && cppTS.moveNext() && ((id = cppTS.token().id()) == CppTokenId.PREPROCESSOR_INCLUDE || id == CppTokenId.PREPROCESSOR_INCLUDE_NEXT)) {
                    context.setText("" + insChr + BracketCompletion.matching(insChr), 1);
                }
            }
            return;
        }
        if (BracketCompletion.isCompletablePosition(context.getDocument(), context.getOffset())) {
            context.setText("" + insChr + BracketCompletion.matching(insChr), 1);
        }
    }

    static int skipClosingBracket(TypedTextInterceptor.MutableContext context) throws BadLocationException {
        TokenSequence<TokenId> cppTS = BracketCompletion.cppTokenSequence(context.getDocument(), context.getOffset(), false);
        if (cppTS == null || BracketCompletion.isStringOrComment(cppTS.token().id())) {
            return -1;
        }
        CppTokenId rightBracketId = BracketCompletion.bracketCharToId(context.getText().charAt(0));
        if (BracketCompletion.isSkipClosingBracket(context, cppTS, rightBracketId)) {
            context.setText("", 0);
            return context.getOffset() + 1;
        }
        return -1;
    }

    private static CppTokenId bracketCharToId(char bracket) {
        switch (bracket) {
            case '(': {
                return CppTokenId.LPAREN;
            }
            case ')': {
                return CppTokenId.RPAREN;
            }
            case '[': {
                return CppTokenId.LBRACKET;
            }
            case ']': {
                return CppTokenId.RBRACKET;
            }
            case '{': {
                return CppTokenId.LBRACE;
            }
            case '}': {
                return CppTokenId.RBRACE;
            }
            case '<': {
                return CppTokenId.LT;
            }
            case '>': {
                return CppTokenId.GT;
            }
        }
        throw new IllegalArgumentException("Not a bracket char '" + bracket + '\'');
    }

    private static CppTokenId matching(CppTokenId id) {
        switch (id) {
            case LPAREN: {
                return CppTokenId.RPAREN;
            }
            case LBRACKET: {
                return CppTokenId.RBRACKET;
            }
            case RPAREN: {
                return CppTokenId.LPAREN;
            }
            case RBRACKET: {
                return CppTokenId.LBRACKET;
            }
            case LT: {
                return CppTokenId.GT;
            }
            case GT: {
                return CppTokenId.LT;
            }
        }
        return null;
    }

    private static class BalanceTokenProcessor
    extends CndAbstractTokenProcessor<Token<TokenId>> {
        private final CppTokenId leftTokenID;
        private final CppTokenId rightTokenID;
        private final Stack<Integer> stack = new Stack();
        private int balance;
        private boolean isDefine;

        BalanceTokenProcessor(CppTokenId leftTokenID, CppTokenId rightTokenID) {
            this.leftTokenID = leftTokenID;
            this.rightTokenID = rightTokenID;
        }

        public boolean token(Token<TokenId> token, int tokenOffset) {
            if (token.id() == CppTokenId.PREPROCESSOR_DIRECTIVE) {
                return true;
            }
            TokenId id = token.id();
            if (id instanceof CppTokenId) {
                switch ((CppTokenId)id) {
                    case NEW_LINE: {
                        this.isDefine = false;
                        break;
                    }
                    case PREPROCESSOR_DEFINE: {
                        this.isDefine = true;
                        break;
                    }
                    case PREPROCESSOR_IF: 
                    case PREPROCESSOR_IFDEF: 
                    case PREPROCESSOR_IFNDEF: {
                        this.stack.push(this.balance);
                        break;
                    }
                    case PREPROCESSOR_ELSE: 
                    case PREPROCESSOR_ELIF: {
                        if (this.stack.empty()) break;
                        this.balance = this.stack.peek();
                        break;
                    }
                    case PREPROCESSOR_ENDIF: {
                        if (this.stack.empty()) break;
                        this.stack.pop();
                        break;
                    }
                    default: {
                        if (this.isDefine) break;
                        if (token.id() == this.leftTokenID) {
                            ++this.balance;
                            break;
                        }
                        if (token.id() != this.rightTokenID) break;
                        --this.balance;
                    }
                }
            }
            return false;
        }

        private int getBalance() {
            return this.balance;
        }
    }

    static class MyTokenProcessor
    implements TokenProcessor {
        private TokenID tokenID;
        private int tokenStart = -1;
        private int bufferStartPos = 0;

        MyTokenProcessor() {
        }

        public boolean token(TokenID tokenID, TokenContextPath tcp, int tokBuffOffset, int tokLength) {
            this.tokenStart = this.tokenBuffer2DocumentOffset(tokBuffOffset);
            this.tokenID = tokenID;
            return false;
        }

        public int eot(int offset) {
            return 0;
        }

        public void nextBuffer(char[] buffer, int offset, int len, int startPos, int preScan, boolean lastBuffer) {
            this.bufferStartPos = startPos - offset;
        }

        private int tokenBuffer2DocumentOffset(int offs) {
            return offs + this.bufferStartPos;
        }
    }
}

