/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.wildfly.config;

import java.sql.SQLException;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

public final class WildflyDatasource
implements Datasource {
    public static final String PREFIX = "java:/";
    public static final String SHORT_PREFIX = "java:";
    private String rawName;
    private String url;
    private String username;
    private String password;
    private String driverClassName;
    private String minPoolSize = "5";
    private String maxPoolSize = "20";
    private String idleTimeoutMinutes = "5";
    private String description;
    private String name;
    private volatile int hash = -1;

    public WildflyDatasource(String name, String jndiName, String url, String username, String password, String driverClassName) {
        this.name = name;
        this.rawName = jndiName;
        this.url = url;
        this.username = username;
        this.password = password;
        this.driverClassName = driverClassName == null || driverClassName.isEmpty() ? this.guessDriverClassname() : driverClassName;
    }

    private final String guessDriverClassname() {
        JDBCDriver[] drivers;
        for (JDBCDriver jdbcDriver : drivers = JDBCDriverManager.getDefault().getDrivers()) {
            try {
                if (!jdbcDriver.getDriver().acceptsURL(this.url)) continue;
                return jdbcDriver.getClassName();
            }
            catch (DatabaseException ex) {
            }
            catch (SQLException ex) {
                // empty catch block
            }
        }
        return "";
    }

    public WildflyDatasource(String jndiName, String url, String username, String password, String driverClassName) {
        this.name = jndiName;
        this.rawName = jndiName;
        this.url = url;
        this.username = username;
        this.password = password;
        this.driverClassName = driverClassName;
    }

    public String getName() {
        return this.name;
    }

    public String getJndiName() {
        return WildflyDatasource.getJndiName(this.rawName);
    }

    public static String getJndiName(String rawName) {
        Parameters.notNull((CharSequence)"rawName", (Object)rawName);
        if (rawName.startsWith(PREFIX)) {
            return rawName;
        }
        if (rawName.startsWith(SHORT_PREFIX)) {
            return PREFIX + rawName.substring(5);
        }
        if (rawName.startsWith("/")) {
            return SHORT_PREFIX + rawName;
        }
        return PREFIX + rawName;
    }

    public static String getRawName(String jndiName) {
        Parameters.notNull((CharSequence)"jndiName", (Object)jndiName);
        if (jndiName.startsWith(PREFIX)) {
            return jndiName.substring(PREFIX.length());
        }
        if (jndiName.startsWith(SHORT_PREFIX)) {
            return jndiName.substring(SHORT_PREFIX.length());
        }
        if (jndiName.startsWith("/")) {
            return jndiName.substring(1);
        }
        return jndiName;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public String getMinPoolSize() {
        return this.minPoolSize;
    }

    public String getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public String getIdleTimeoutMinutes() {
        return this.idleTimeoutMinutes;
    }

    public String getDisplayName() {
        if (this.description == null) {
            this.description = this.getJndiName() + " [" + this.getUrl() + "]";
        }
        return this.description;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof WildflyDatasource)) {
            return false;
        }
        WildflyDatasource ds = (WildflyDatasource)obj;
        if (this.getJndiName() == null && ds.getJndiName() != null || this.getJndiName() != null && !this.getJndiName().equals(ds.getJndiName())) {
            return false;
        }
        if (this.url == null && ds.getUrl() != null || this.url != null && !this.url.equals(ds.getUrl())) {
            return false;
        }
        if (this.username == null && ds.getUsername() != null || this.username != null && !this.username.equals(ds.getUsername())) {
            return false;
        }
        if (this.password == null && ds.getPassword() != null || this.password != null && !this.password.equals(ds.getPassword())) {
            return false;
        }
        if (this.driverClassName == null && ds.getDriverClassName() != null || this.driverClassName != null && !this.driverClassName.equals(ds.getDriverClassName())) {
            return false;
        }
        if (this.minPoolSize == null && ds.getMinPoolSize() != null || this.minPoolSize != null && !this.minPoolSize.equals(ds.getMinPoolSize())) {
            return false;
        }
        if (this.maxPoolSize == null && ds.getMaxPoolSize() != null || this.maxPoolSize != null && !this.maxPoolSize.equals(ds.getMaxPoolSize())) {
            return false;
        }
        return (this.idleTimeoutMinutes != null || ds.getIdleTimeoutMinutes() == null) && (this.idleTimeoutMinutes == null || this.idleTimeoutMinutes.equals(ds.getIdleTimeoutMinutes()));
    }

    public int hashCode() {
        if (this.hash == -1) {
            int result = 17;
            result += 37 * result + (this.getJndiName() == null ? 0 : this.getJndiName().hashCode());
            result += 37 * result + (this.url == null ? 0 : this.url.hashCode());
            result += 37 * result + (this.username == null ? 0 : this.username.hashCode());
            result += 37 * result + (this.password == null ? 0 : this.password.hashCode());
            result += 37 * result + (this.driverClassName == null ? 0 : this.driverClassName.hashCode());
            result += 37 * result + (this.minPoolSize == null ? 0 : this.minPoolSize.hashCode());
            result += 37 * result + (this.maxPoolSize == null ? 0 : this.maxPoolSize.hashCode());
            result += 37 * result + (this.idleTimeoutMinutes == null ? 0 : this.idleTimeoutMinutes.hashCode());
            this.hash = result;
        }
        return this.hash;
    }

    public String toString() {
        return "[ " + NbBundle.getMessage(WildflyDatasource.class, (String)"LBL_DS_JNDI") + ": '" + this.getJndiName() + "', " + NbBundle.getMessage(WildflyDatasource.class, (String)"LBL_DS_URL") + ": '" + this.url + "', " + NbBundle.getMessage(WildflyDatasource.class, (String)"LBL_DS_USER") + ": '" + this.username + "', " + NbBundle.getMessage(WildflyDatasource.class, (String)"LBL_DS_PASS") + ": '" + this.password + "', " + NbBundle.getMessage(WildflyDatasource.class, (String)"LBL_DS_DRV") + ": '" + this.driverClassName + "', " + NbBundle.getMessage(WildflyDatasource.class, (String)"LBL_DS_MINPS") + ": '" + this.minPoolSize + "', " + NbBundle.getMessage(WildflyDatasource.class, (String)"LBL_DS_MAXPS") + ": '" + this.maxPoolSize + "', " + NbBundle.getMessage(WildflyDatasource.class, (String)"LBL_DS_IDLE") + ": '" + this.idleTimeoutMinutes + "' ]";
    }
}

