/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.wildfly.ide;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.javaee.wildfly.WildflyDeploymentManager;
import org.netbeans.modules.javaee.wildfly.ide.WildflyDeploymentStatus;
import org.netbeans.modules.javaee.wildfly.ide.WildflyKiller;
import org.netbeans.modules.javaee.wildfly.ide.WildflyOutputSupport;
import org.netbeans.modules.javaee.wildfly.ide.WildflyStartServer;
import org.openide.util.NbBundle;

class WildflyStopRunnable
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(WildflyStopRunnable.class.getName());
    private static final String JBOSS_CLI_SH = "/bin/jboss-cli.sh";
    private static final String JBOSS_CLI_BAT = "/bin/jboss-cli.bat";
    private static final int TIMEOUT = 300000;
    private final WildflyDeploymentManager dm;
    private final WildflyStartServer startServer;
    private final WildflyKiller killer;

    WildflyStopRunnable(WildflyDeploymentManager dm, WildflyStartServer startServer) {
        this.dm = dm;
        this.startServer = startServer;
        this.killer = new WildflyKiller();
    }

    @Override
    public void run() {
        InstanceProperties ip = this.dm.getInstanceProperties();
        String configName = ip.getProperty("server");
        if ("minimal".equals(configName)) {
            this.startServer.fireHandleProgressEvent(null, new WildflyDeploymentStatus(ActionType.EXECUTE, CommandType.STOP, StateType.FAILED, NbBundle.getMessage(WildflyStopRunnable.class, (String)"MSG_STOP_SERVER_FAILED_MINIMAL")));
            return;
        }
        String serverName = ip.getProperty("displayName");
        try {
            this.dm.getClient().shutdownServer();
        }
        catch (IOException ioe) {
            LOGGER.log(Level.INFO, null, ioe);
            this.startServer.fireHandleProgressEvent(null, new WildflyDeploymentStatus(ActionType.EXECUTE, CommandType.STOP, StateType.FAILED, NbBundle.getMessage(WildflyStopRunnable.class, (String)"MSG_STOP_SERVER_FAILED_PD", (Object)serverName)));
            return;
        }
        this.startServer.fireHandleProgressEvent(null, new WildflyDeploymentStatus(ActionType.EXECUTE, CommandType.STOP, StateType.RUNNING, NbBundle.getMessage(WildflyStopRunnable.class, (String)"MSG_STOP_SERVER_IN_PROGRESS", (Object)serverName)));
        LOGGER.log(Level.FINER, "Entering the loop");
        int elapsed = 0;
        while (elapsed < 300000) {
            block13: {
                if (this.startServer.isRunning()) {
                    this.startServer.fireHandleProgressEvent(null, new WildflyDeploymentStatus(ActionType.EXECUTE, CommandType.STOP, StateType.RUNNING, NbBundle.getMessage(WildflyStopRunnable.class, (String)"MSG_STOP_SERVER_IN_PROGRESS", (Object)serverName)));
                    LOGGER.log(Level.FINER, "STOPPING message fired");
                    try {
                        elapsed += 500;
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {}
                    continue;
                }
                LOGGER.log(Level.FINER, "JBoss has been stopped, going to stop the Log Writer thread");
                WildflyOutputSupport outputSupport = WildflyOutputSupport.getInstance(ip, false);
                try {
                    if (outputSupport == null) break block13;
                    try {
                        outputSupport.waitForStop(10000L);
                    }
                    catch (TimeoutException ex) {
                        LOGGER.log(Level.FINE, null, ex);
                    }
                    outputSupport.stop();
                }
                catch (InterruptedException ex) {
                    this.startServer.fireHandleProgressEvent(null, new WildflyDeploymentStatus(ActionType.EXECUTE, CommandType.STOP, StateType.FAILED, NbBundle.getMessage(WildflyStopRunnable.class, (String)"MSG_StopServerInterrupted", (Object)serverName)));
                    LOGGER.log(Level.INFO, null, ex);
                    Thread.currentThread().interrupt();
                    return;
                }
                catch (ExecutionException ex) {
                    this.startServer.fireHandleProgressEvent(null, new WildflyDeploymentStatus(ActionType.EXECUTE, CommandType.STOP, StateType.FAILED, NbBundle.getMessage(WildflyStopRunnable.class, (String)"MSG_STOP_SERVER_FAILED", (Object)serverName)));
                    LOGGER.log(Level.INFO, null, ex);
                    return;
                }
            }
            this.startServer.fireHandleProgressEvent(null, new WildflyDeploymentStatus(ActionType.EXECUTE, CommandType.STOP, StateType.COMPLETED, NbBundle.getMessage(WildflyStopRunnable.class, (String)"MSG_SERVER_STOPPED", (Object)serverName)));
            LOGGER.log(Level.FINER, "STOPPED message fired");
            this.startServer.setConsoleConfigured(false);
            return;
        }
        if (!this.killer.killServers()) {
            this.startServer.fireHandleProgressEvent(null, new WildflyDeploymentStatus(ActionType.EXECUTE, CommandType.STOP, StateType.FAILED, NbBundle.getMessage(WildflyStopRunnable.class, (String)"MSG_StopServerTimeout")));
            LOGGER.log(Level.FINER, "TIMEOUT expired");
        }
    }
}

