/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.cpu;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.tree.TreeNode;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.results.cpu.CPUResultsDiff;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.FlatProfileContainer;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.JExtendedSplitPane;
import org.netbeans.lib.profiler.ui.components.ProfilerToolbar;
import org.netbeans.lib.profiler.ui.cpu.CPUTableView;
import org.netbeans.lib.profiler.ui.cpu.CPUTreeTableView;
import org.netbeans.lib.profiler.ui.cpu.CPUView;
import org.netbeans.lib.profiler.ui.cpu.ThreadsSelector;
import org.netbeans.lib.profiler.ui.results.DataView;
import org.netbeans.lib.profiler.ui.swing.ActionPopupButton;
import org.netbeans.lib.profiler.ui.swing.ExportUtils;
import org.netbeans.lib.profiler.ui.swing.FilterUtils;
import org.netbeans.lib.profiler.ui.swing.GrayLabel;
import org.netbeans.lib.profiler.ui.swing.MultiButtonGroup;
import org.netbeans.lib.profiler.ui.swing.ProfilerTable;
import org.netbeans.lib.profiler.ui.swing.ProfilerTreeTable;
import org.netbeans.lib.profiler.ui.swing.SearchUtils;
import org.netbeans.modules.profiler.api.icons.Icons;

public abstract class SnapshotCPUView
extends JPanel {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.cpu.Bundle");
    private static final String TOOLBAR_VIEW = messages.getString("SnapshotCPUView_ToolbarView");
    private static final String VIEW_FORWARD = messages.getString("SnapshotCPUView_ViewForward");
    private static final String VIEW_HOTSPOTS = messages.getString("SnapshotCPUView_ViewHotSpots");
    private static final String VIEW_REVERSE = messages.getString("SnapshotCPUView_ViewReverse");
    private static final String TOOLBAR_AGGREGATION = messages.getString("SnapshotCPUView_ToolbarAggregation");
    private static final String AGGREGATION_METHODS = messages.getString("SnapshotCPUView_AggregationMethods");
    private static final String AGGREGATION_CLASSES = messages.getString("SnapshotCPUView_AggregationClasses");
    private static final String AGGREGATION_PACKAGES = messages.getString("SnapshotCPUView_AggregationPackages");
    private static final String COMPARE_SNAPSHOTS = messages.getString("SnapshotCPUView_CompareSnapshots");
    private static final String RESET_COMPARE_SNAPSHOTS = messages.getString("SnapshotCPUView_ResetCompareSnapshots");
    private boolean sampled;
    private CPUResultsSnapshot snapshot;
    private CPUResultsSnapshot refSnapshot;
    private int aggregation;
    private boolean mergedThreads;
    private Collection<Integer> selectedThreads;
    private DataView lastFocused;
    private CPUTableView hotSpotsView;
    private CPUTreeTableView forwardCallsView;
    private CPUTreeTableView reverseCallsView;
    private JToggleButton[] toggles;
    private JToggleButton compareButton;

    public SnapshotCPUView(CPUResultsSnapshot snapshot, boolean sampled, Action saveAction, Action compareAction, Action infoAction, ExportUtils.Exportable exportProvider) {
        this.initUI(saveAction, compareAction, infoAction, exportProvider);
        this.registerActions();
        this.aggregation = 0;
        this.setSnapshot(snapshot, sampled);
    }

    public void setRefSnapshot(CPUResultsSnapshot snapshot) {
        this.refSnapshot = snapshot;
        if (this.compareButton != null && snapshot != null) {
            this.compareButton.setSelected(true);
            this.compareButton.setToolTipText(RESET_COMPARE_SNAPSHOTS);
        }
        this.setAggregation(this.aggregation);
    }

    protected boolean profileMethodSupported() {
        return true;
    }

    protected abstract boolean showSourceSupported();

    protected abstract void showSource(ClientUtils.SourceCodeSelection var1);

    protected abstract void selectForProfiling(ClientUtils.SourceCodeSelection var1);

    protected void foundInForwardCalls() {
        this.toggles[0].setSelected(true);
    }

    protected void foundInHotSpots() {
        this.toggles[1].setSelected(true);
    }

    protected void foundInReverseCalls() {
        this.toggles[2].setSelected(true);
    }

    private void profileMethod(ClientUtils.SourceCodeSelection value) {
        this.selectForProfiling(value);
    }

    private void profileClass(ClientUtils.SourceCodeSelection value) {
        this.selectForProfiling(new ClientUtils.SourceCodeSelection(value.getClassName(), "*", null));
    }

    private void initUI(Action saveAction, final Action compareAction, Action infoAction, ExportUtils.Exportable exportProvider) {
        this.setLayout(new BorderLayout(0, 0));
        this.forwardCallsView = new CPUTreeTableView(null, false){

            @Override
            protected void performDefaultAction(ClientUtils.SourceCodeSelection value) {
                if (SnapshotCPUView.this.showSourceSupported()) {
                    SnapshotCPUView.this.showSource(value);
                }
            }

            @Override
            protected void populatePopup(JPopupMenu popup, Object value, ClientUtils.SourceCodeSelection userValue) {
                SnapshotCPUView.this.populatePopup(SnapshotCPUView.this.forwardCallsView, popup, value, userValue);
            }
        };
        this.forwardCallsView.notifyOnFocus(new Runnable(){

            @Override
            public void run() {
                SnapshotCPUView.this.lastFocused = SnapshotCPUView.this.forwardCallsView;
            }
        });
        this.hotSpotsView = new CPUTableView(null){

            @Override
            protected void performDefaultAction(ClientUtils.SourceCodeSelection userValue) {
                if (SnapshotCPUView.this.showSourceSupported()) {
                    SnapshotCPUView.this.showSource(userValue);
                }
            }

            @Override
            protected void populatePopup(JPopupMenu popup, Object value, ClientUtils.SourceCodeSelection userValue) {
                SnapshotCPUView.this.populatePopup(SnapshotCPUView.this.hotSpotsView, popup, value, userValue);
            }
        };
        this.hotSpotsView.notifyOnFocus(new Runnable(){

            @Override
            public void run() {
                SnapshotCPUView.this.lastFocused = SnapshotCPUView.this.hotSpotsView;
            }
        });
        this.reverseCallsView = new CPUTreeTableView(null, true){

            @Override
            protected void performDefaultAction(ClientUtils.SourceCodeSelection value) {
                if (SnapshotCPUView.this.showSourceSupported()) {
                    SnapshotCPUView.this.showSource(value);
                }
            }

            @Override
            protected void populatePopup(JPopupMenu popup, Object value, ClientUtils.SourceCodeSelection userValue) {
                SnapshotCPUView.this.populatePopup(SnapshotCPUView.this.reverseCallsView, popup, value, userValue);
            }
        };
        this.reverseCallsView.notifyOnFocus(new Runnable(){

            @Override
            public void run() {
                SnapshotCPUView.this.lastFocused = SnapshotCPUView.this.reverseCallsView;
            }
        });
        JExtendedSplitPane upperSplit = new JExtendedSplitPane(0){
            {
                BasicSplitPaneDivider divider;
                super(x0);
                this.setBorder(null);
                this.setDividerSize(5);
                if (this.getUI() instanceof BasicSplitPaneUI && (divider = ((BasicSplitPaneUI)this.getUI()).getDivider()) != null) {
                    Color c = UIUtils.isNimbus() || UIUtils.isAquaLookAndFeel() ? UIUtils.getDisabledLineColor() : new JSeparator().getForeground();
                    divider.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 0, c));
                }
            }
        };
        upperSplit.setBorder(BorderFactory.createEmptyBorder());
        ((JSplitPane)upperSplit).setTopComponent(this.forwardCallsView);
        ((JSplitPane)upperSplit).setBottomComponent(this.hotSpotsView);
        upperSplit.setDividerLocation(0.5);
        upperSplit.setResizeWeight(0.5);
        JExtendedSplitPane lowerSplit = new JExtendedSplitPane(0){
            {
                BasicSplitPaneDivider divider;
                super(x0);
                this.setBorder(null);
                this.setDividerSize(5);
                if (this.getUI() instanceof BasicSplitPaneUI && (divider = ((BasicSplitPaneUI)this.getUI()).getDivider()) != null) {
                    Color c = UIUtils.isNimbus() || UIUtils.isAquaLookAndFeel() ? UIUtils.getDisabledLineColor() : new JSeparator().getForeground();
                    divider.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 0, c));
                }
            }
        };
        lowerSplit.setBorder(BorderFactory.createEmptyBorder());
        ((JSplitPane)lowerSplit).setTopComponent(upperSplit);
        ((JSplitPane)lowerSplit).setBottomComponent(this.reverseCallsView);
        lowerSplit.setDividerLocation(0.66);
        lowerSplit.setResizeWeight(0.66);
        this.add((Component)lowerSplit, "Center");
        ProfilerToolbar toolbar = ProfilerToolbar.create(true);
        if (saveAction != null) {
            toolbar.add(saveAction);
        }
        toolbar.add(ExportUtils.exportButton(this, CPUView.EXPORT_TOOLTIP, this.getExportables(exportProvider)));
        if (compareAction != null) {
            toolbar.addSpace(2);
            toolbar.addSeparator();
            toolbar.addSpace(2);
            Icon icon = (Icon)compareAction.getValue("SmallIcon");
            this.compareButton = new JToggleButton(icon){

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    boolean sel = this.isSelected();
                    if (sel) {
                        compareAction.actionPerformed(e);
                        if (SnapshotCPUView.this.refSnapshot == null) {
                            this.setSelected(false);
                        }
                    } else {
                        SnapshotCPUView.this.setRefSnapshot(null);
                    }
                    this.setToolTipText(this.isSelected() ? RESET_COMPARE_SNAPSHOTS : COMPARE_SNAPSHOTS);
                }
            };
            this.compareButton.setToolTipText(COMPARE_SNAPSHOTS);
            toolbar.add(this.compareButton);
        }
        toolbar.addSpace(2);
        toolbar.addSeparator();
        toolbar.addSpace(5);
        GrayLabel viewL = new GrayLabel(TOOLBAR_VIEW);
        toolbar.add(viewL);
        toolbar.addSpace(5);
        MultiButtonGroup group = new MultiButtonGroup();
        this.toggles = new JToggleButton[3];
        this.toggles[0] = new JToggleButton(Icons.getIcon((String)"ProfilerIcons.NodeForward")){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                super.fireActionPerformed(e);
                SnapshotCPUView.this.setView(this.isSelected(), SnapshotCPUView.this.hotSpotsView.isVisible(), SnapshotCPUView.this.reverseCallsView.isVisible());
            }
        };
        this.toggles[0].setToolTipText(VIEW_FORWARD);
        group.add(this.toggles[0]);
        toolbar.add(this.toggles[0]);
        this.forwardCallsView.setVisible(true);
        this.toggles[0].setSelected(true);
        this.toggles[1] = new JToggleButton(Icons.getIcon((String)"ProfilerIcons.TabHotSpots")){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                super.fireActionPerformed(e);
                SnapshotCPUView.this.setView(SnapshotCPUView.this.forwardCallsView.isVisible(), this.isSelected(), SnapshotCPUView.this.reverseCallsView.isVisible());
            }
        };
        this.toggles[1].setToolTipText(VIEW_HOTSPOTS);
        group.add(this.toggles[1]);
        toolbar.add(this.toggles[1]);
        this.hotSpotsView.setVisible(false);
        this.toggles[1].setSelected(false);
        this.toggles[2] = new JToggleButton(Icons.getIcon((String)"ProfilerIcons.NodeReverse")){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                super.fireActionPerformed(e);
                SnapshotCPUView.this.setView(SnapshotCPUView.this.forwardCallsView.isVisible(), SnapshotCPUView.this.hotSpotsView.isVisible(), this.isSelected());
            }
        };
        this.toggles[2].setToolTipText(VIEW_REVERSE);
        group.add(this.toggles[2]);
        toolbar.add(this.toggles[2]);
        this.reverseCallsView.setVisible(false);
        this.toggles[2].setSelected(false);
        toolbar.addSpace(5);
        ThreadsSelector threadsPopup = new ThreadsSelector(){

            @Override
            protected CPUResultsSnapshot getSnapshot() {
                return SnapshotCPUView.this.snapshot;
            }

            @Override
            protected void selectionChanged(Collection<Integer> selected, boolean mergeThreads) {
                SnapshotCPUView.this.mergedThreads = mergeThreads;
                SnapshotCPUView.this.selectedThreads = selected;
                SnapshotCPUView.this.setAggregation(SnapshotCPUView.this.aggregation);
            }
        };
        toolbar.add(threadsPopup);
        toolbar.addSpace(2);
        toolbar.addSeparator();
        toolbar.addSpace(5);
        GrayLabel aggregationL = new GrayLabel(TOOLBAR_AGGREGATION);
        toolbar.add(aggregationL);
        toolbar.addSpace(2);
        AbstractAction aMethods = new AbstractAction(){
            {
                this.putValue("Name", AGGREGATION_METHODS);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                SnapshotCPUView.this.setAggregation(0);
            }
        };
        AbstractAction aClasses = new AbstractAction(){
            {
                this.putValue("Name", AGGREGATION_CLASSES);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                SnapshotCPUView.this.setAggregation(1);
            }
        };
        AbstractAction aPackages = new AbstractAction(){
            {
                this.putValue("Name", AGGREGATION_PACKAGES);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                SnapshotCPUView.this.setAggregation(2);
            }
        };
        ActionPopupButton aggregation = new ActionPopupButton(aMethods, aClasses, aPackages);
        toolbar.add(aggregation);
        if (infoAction != null) {
            toolbar.addFiller();
            toolbar.add(infoAction);
        }
        this.add((Component)toolbar.getComponent(), "North");
    }

    private void registerActions() {
        ActionMap map = this.getActionMap();
        map.put("filter-action-key", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataView active = SnapshotCPUView.this.getLastFocused();
                if (active != null) {
                    active.activateFilter();
                }
            }
        });
        map.put("find-action-key", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataView active = SnapshotCPUView.this.getLastFocused();
                if (active != null) {
                    active.activateSearch();
                }
            }
        });
    }

    private DataView getLastFocused() {
        if (this.lastFocused != null && !this.lastFocused.isShowing()) {
            this.lastFocused = null;
        }
        if (this.lastFocused == null) {
            if (this.forwardCallsView.isShowing()) {
                this.lastFocused = this.forwardCallsView;
            } else if (this.hotSpotsView.isShowing()) {
                this.lastFocused = this.hotSpotsView;
            } else if (this.reverseCallsView.isShowing()) {
                this.lastFocused = this.reverseCallsView;
            }
        }
        return this.lastFocused;
    }

    private void populatePopup(final DataView invoker, JPopupMenu popup, Object value, final ClientUtils.SourceCodeSelection userValue) {
        if (this.showSourceSupported()) {
            popup.add(new JMenuItem(CPUView.ACTION_GOTOSOURCE){
                {
                    super(x0);
                    this.setEnabled(userValue != null && SnapshotCPUView.this.aggregation != 2);
                    this.setFont(this.getFont().deriveFont(1));
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    SnapshotCPUView.this.showSource(userValue);
                }
            });
            popup.addSeparator();
        }
        popup.add(new JMenuItem(CPUView.ACTION_PROFILE_METHOD){
            {
                super(x0);
                this.setEnabled(SnapshotCPUView.this.profileMethodSupported() && userValue != null && SnapshotCPUView.this.aggregation == 0 && CPUTableView.isSelectable(userValue));
            }

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                SnapshotCPUView.this.profileMethod(userValue);
            }
        });
        popup.add(new JMenuItem(CPUView.ACTION_PROFILE_CLASS){
            {
                super(x0);
                this.setEnabled(userValue != null && SnapshotCPUView.this.aggregation != 2);
            }

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                SnapshotCPUView.this.profileClass(userValue);
            }
        });
        this.customizeNodePopup(invoker, popup, value, userValue);
        popup.addSeparator();
        if (invoker == this.forwardCallsView) {
            ProfilerTreeTable ttable = (ProfilerTreeTable)this.forwardCallsView.getResultsComponent();
            int column = ttable.convertColumnIndexToView(ttable.getMainColumn());
            final String searchString = ttable.getStringValue((TreeNode)value, column);
            popup.add(new JMenuItem(CPUView.FIND_IN_HOTSPOTS){
                {
                    super(x0);
                    this.setEnabled(userValue != null);
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    ProfilerTable table = SnapshotCPUView.this.hotSpotsView.getResultsComponent();
                    if (SearchUtils.findString(table, searchString)) {
                        SnapshotCPUView.this.toggles[1].setSelected(true);
                        SnapshotCPUView.this.hotSpotsView.setVisible(true);
                        table.requestFocusInWindow();
                    }
                }
            });
            popup.add(new JMenuItem(CPUView.FIND_IN_REVERSECALLS){
                {
                    super(x0);
                    this.setEnabled(userValue != null);
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    ProfilerTable table = SnapshotCPUView.this.reverseCallsView.getResultsComponent();
                    if (SearchUtils.findString(table, searchString)) {
                        SnapshotCPUView.this.toggles[2].setSelected(true);
                        SnapshotCPUView.this.reverseCallsView.setVisible(true);
                        table.requestFocusInWindow();
                    }
                }
            });
        } else if (invoker == this.hotSpotsView) {
            final String searchString = value.toString().replace("(", " (");
            popup.add(new JMenuItem(CPUView.FIND_IN_FORWARDCALLS){
                {
                    super(x0);
                    this.setEnabled(userValue != null);
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    ProfilerTable table = SnapshotCPUView.this.forwardCallsView.getResultsComponent();
                    if (SearchUtils.findString(table, searchString)) {
                        SnapshotCPUView.this.toggles[0].setSelected(true);
                        SnapshotCPUView.this.forwardCallsView.setVisible(true);
                        table.requestFocusInWindow();
                    }
                }
            });
            popup.add(new JMenuItem(CPUView.FIND_IN_REVERSECALLS){
                {
                    super(x0);
                    this.setEnabled(userValue != null);
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    ProfilerTable table = SnapshotCPUView.this.reverseCallsView.getResultsComponent();
                    if (SearchUtils.findString(table, searchString)) {
                        SnapshotCPUView.this.toggles[2].setSelected(true);
                        SnapshotCPUView.this.reverseCallsView.setVisible(true);
                        table.requestFocusInWindow();
                    }
                }
            });
        } else if (invoker == this.reverseCallsView) {
            ProfilerTreeTable ttable = (ProfilerTreeTable)this.reverseCallsView.getResultsComponent();
            int column = ttable.convertColumnIndexToView(ttable.getMainColumn());
            final String searchString = ttable.getStringValue((TreeNode)value, column);
            popup.add(new JMenuItem(CPUView.FIND_IN_FORWARDCALLS){
                {
                    super(x0);
                    this.setEnabled(userValue != null);
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    ProfilerTable table = SnapshotCPUView.this.forwardCallsView.getResultsComponent();
                    if (SearchUtils.findString(table, searchString)) {
                        SnapshotCPUView.this.toggles[0].setSelected(true);
                        SnapshotCPUView.this.forwardCallsView.setVisible(true);
                        table.requestFocusInWindow();
                    }
                }
            });
            popup.add(new JMenuItem(CPUView.FIND_IN_HOTSPOTS){
                {
                    super(x0);
                    this.setEnabled(userValue != null);
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    ProfilerTable table = SnapshotCPUView.this.hotSpotsView.getResultsComponent();
                    if (SearchUtils.findString(table, searchString)) {
                        SnapshotCPUView.this.toggles[1].setSelected(true);
                        SnapshotCPUView.this.hotSpotsView.setVisible(true);
                        table.requestFocusInWindow();
                    }
                }
            });
        }
        popup.addSeparator();
        popup.add(invoker.createCopyMenuItem());
        popup.addSeparator();
        popup.add(new JMenuItem(FilterUtils.ACTION_FILTER){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                invoker.activateFilter();
            }
        });
        popup.add(new JMenuItem(SearchUtils.ACTION_FIND){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                invoker.activateSearch();
            }
        });
    }

    protected void customizeNodePopup(DataView invoker, JPopupMenu popup, Object value, ClientUtils.SourceCodeSelection userValue) {
    }

    private void setView(boolean forwardCalls, boolean hotSpots, boolean reverseCalls) {
        this.forwardCallsView.setVisible(forwardCalls);
        this.hotSpotsView.setVisible(hotSpots);
        this.reverseCallsView.setVisible(reverseCalls);
    }

    private void setAggregation(int _aggregation) {
        this.aggregation = _aggregation;
        CPUResultsSnapshot _snapshot = this.refSnapshot == null ? this.snapshot : this.snapshot.createDiff(this.refSnapshot);
        FlatProfileContainer flatData = _snapshot.getFlatProfile(this.selectedThreads, this.aggregation);
        Map idMap = _snapshot.getMethodIDMap(this.aggregation);
        boolean diff = _snapshot instanceof CPUResultsDiff;
        this.forwardCallsView.setData(_snapshot, idMap, this.aggregation, this.selectedThreads, this.mergedThreads, this.sampled, diff);
        this.hotSpotsView.setData(flatData, idMap, this.sampled, diff);
        this.reverseCallsView.setData(_snapshot, idMap, this.aggregation, this.selectedThreads, this.mergedThreads, this.sampled, diff);
    }

    protected final void setSnapshot(CPUResultsSnapshot snapshot, boolean sampled) {
        this.snapshot = snapshot;
        this.sampled = sampled;
        this.setAggregation(this.aggregation);
    }

    private ExportUtils.Exportable[] getExportables(final ExportUtils.Exportable snapshotExporter) {
        return new ExportUtils.Exportable[]{new ExportUtils.Exportable(){

            @Override
            public boolean isEnabled() {
                return SnapshotCPUView.this.refSnapshot == null && snapshotExporter.isEnabled();
            }

            @Override
            public String getName() {
                return snapshotExporter.getName();
            }

            @Override
            public ExportUtils.ExportProvider[] getProviders() {
                return snapshotExporter.getProviders();
            }
        }, new ExportUtils.Exportable(){

            @Override
            public boolean isEnabled() {
                return SnapshotCPUView.this.forwardCallsView.isVisible();
            }

            @Override
            public String getName() {
                return MessageFormat.format(CPUView.EXPORT_METHODS, CPUView.EXPORT_FORWARD_CALLS);
            }

            @Override
            public ExportUtils.ExportProvider[] getProviders() {
                return SnapshotCPUView.this.forwardCallsView.getExportProviders();
            }
        }, new ExportUtils.Exportable(){

            @Override
            public boolean isEnabled() {
                return SnapshotCPUView.this.hotSpotsView.isVisible();
            }

            @Override
            public String getName() {
                return MessageFormat.format(CPUView.EXPORT_METHODS, CPUView.EXPORT_HOTSPOTS);
            }

            @Override
            public ExportUtils.ExportProvider[] getProviders() {
                return SnapshotCPUView.this.hotSpotsView.getExportProviders();
            }
        }, new ExportUtils.Exportable(){

            @Override
            public boolean isEnabled() {
                return SnapshotCPUView.this.reverseCallsView.isVisible();
            }

            @Override
            public String getName() {
                return MessageFormat.format(CPUView.EXPORT_METHODS, CPUView.EXPORT_REVERSE_CALLS);
            }

            @Override
            public ExportUtils.ExportProvider[] getProviders() {
                return SnapshotCPUView.this.reverseCallsView.getExportProviders();
            }
        }};
    }
}

