/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.queries;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.suite.SuiteProject;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteUtils;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.CreateFromTemplateAttributesProvider;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;

public class TemplateAttributesProvider
implements CreateFromTemplateAttributesProvider {
    private final NbModuleProject project;
    private final AntProjectHelper helper;
    private final boolean netbeansOrg;
    private static final Logger LOG = Logger.getLogger(TemplateAttributesProvider.class.getName());

    public TemplateAttributesProvider(NbModuleProject p, AntProjectHelper helper, boolean netbeansOrg) {
        this.project = p;
        this.helper = helper;
        this.netbeansOrg = netbeansOrg;
    }

    public Map<String, ?> attributesFor(DataObject template, DataFolder target, String name) {
        EditableProperties props = this.helper.getProperties("nbproject/project.properties");
        String license = props.getProperty("project.license");
        String licensePath = props.getProperty("project.licensePath");
        if (license == null && this.netbeansOrg) {
            license = "cddl-netbeans-sun";
        }
        if (license == null && licensePath == null && this.project != null) {
            try {
                SuiteProject sp = SuiteUtils.findSuite(this.project);
                if (sp != null) {
                    TemplateAttributesProvider tap = (TemplateAttributesProvider)sp.getLookup().lookup(TemplateAttributesProvider.class);
                    return tap.attributesFor(template, target, name);
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        HashMap<String, String> values = new HashMap<String, String>();
        if (license != null) {
            values.put("license", license);
        }
        if (licensePath != null) {
            File path = FileUtil.normalizeFile((File)this.helper.resolveFile(licensePath));
            if (path.exists() && path.isAbsolute()) {
                values.put("licensePath", path.getAbsolutePath());
            } else {
                LOG.log(Level.INFO, "project.licensePath value not accepted - " + license);
            }
        }
        values.put("encoding", "UTF-8");
        try {
            Project prj = ProjectManager.getDefault().findProject(this.helper.getProjectDirectory());
            ProjectInformation info = ProjectUtils.getInformation((Project)prj);
            if (info != null) {
                String pdname;
                String pname = info.getName();
                if (pname != null) {
                    values.put("name", pname);
                }
                if ((pdname = info.getDisplayName()) != null) {
                    values.put("displayName", pdname);
                }
            }
        }
        catch (Exception ex) {
            LOG.log(Level.FINE, "", ex);
        }
        return Collections.singletonMap("project", values);
    }
}

