/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.jdi;

import com.sun.jdi.InternalException;
import com.sun.jdi.Locatable;
import com.sun.jdi.Location;
import com.sun.jdi.Mirror;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import org.netbeans.modules.debugger.jpda.JDIExceptionReporter;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;

public final class LocatableWrapper {
    private LocatableWrapper() {
    }

    public static Location location(Locatable a) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.Locatable", "location", "JDI CALL: com.sun.jdi.Locatable({0}).location()", new Object[]{a});
        }
        Object retValue = null;
        try {
            Location ret = a.location();
            retValue = ret;
            Location location = ret;
            return location;
        }
        catch (InternalException ex) {
            retValue = ex;
            JDIExceptionReporter.report(ex);
            throw new InternalExceptionWrapper(ex);
        }
        catch (VMDisconnectedException ex) {
            retValue = ex;
            if (a instanceof Mirror) {
                VirtualMachine vm = ((Mirror)((Object)a)).virtualMachine();
                try {
                    vm.dispose();
                }
                catch (VMDisconnectedException vmdex) {
                    // empty catch block
                }
            }
            throw new VMDisconnectedExceptionWrapper(ex);
        }
        catch (Error err) {
            retValue = err;
            throw err;
        }
        catch (RuntimeException rex) {
            retValue = rex;
            throw rex;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.Locatable", "location", retValue);
            }
        }
    }
}

