/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.analysis.parsers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.php.analysis.results.Result;
import org.netbeans.modules.php.api.util.FileUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class MessDetectorReportParser
extends DefaultHandler {
    private static final Logger LOGGER = Logger.getLogger(MessDetectorReportParser.class.getName());
    private final List<Result> results = new ArrayList<Result>();
    private final XMLReader xmlReader = FileUtils.createXmlReader();
    private Result currentResult = null;
    private String currentFile = null;
    private StringBuilder description = null;

    private MessDetectorReportParser() throws SAXException {
    }

    private static MessDetectorReportParser create(Reader reader) throws SAXException, IOException {
        MessDetectorReportParser parser = new MessDetectorReportParser();
        parser.xmlReader.setContentHandler(parser);
        parser.xmlReader.parse(new InputSource(reader));
        return parser;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CheckForNull
    public static List<Result> parse(File file) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));){
            List<Result> list = MessDetectorReportParser.create(reader).getResults();
            return list;
        }
        catch (IOException | SAXException ex) {
            LOGGER.log(Level.INFO, null, ex);
            return null;
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("file".equals(qName)) {
            this.processFileStart(attributes);
        } else if ("violation".equals(qName)) {
            this.processResultStart(attributes);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("file".equals(qName)) {
            this.processFileEnd();
        } else if ("violation".equals(qName)) {
            this.processResultEnd();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.description != null) {
            this.description.append(new String(ch, start, length));
        }
    }

    private void processFileStart(Attributes attributes) {
        assert (this.currentResult == null) : this.currentResult.getFilePath();
        assert (this.currentFile == null) : this.currentFile;
        this.currentFile = attributes.getValue("name");
    }

    private void processFileEnd() {
        assert (this.currentFile != null);
        this.currentFile = null;
    }

    private void processResultStart(Attributes attributes) {
        assert (this.currentFile != null);
        assert (this.currentResult == null) : this.currentResult.getFilePath();
        assert (this.description == null) : this.description.toString();
        this.currentResult = new Result(this.currentFile);
        this.currentResult.setLine(this.getInt(attributes, "beginline"));
        this.currentResult.setCategory(this.formatCategory(attributes.getValue("ruleset"), attributes.getValue("rule")));
        this.description = new StringBuilder(200);
    }

    private void processResultEnd() {
        assert (this.currentResult != null);
        assert (this.description != null);
        this.currentResult.setDescription(this.description.toString().trim());
        this.results.add(this.currentResult);
        this.currentResult = null;
        this.description = null;
    }

    private String formatCategory(String category, String subCategory) {
        return category + ": " + subCategory;
    }

    private int getInt(Attributes attributes, String name) {
        int i = -1;
        try {
            i = Integer.parseInt(attributes.getValue(name));
        }
        catch (NumberFormatException exc) {
            // empty catch block
        }
        return i;
    }

    public List<Result> getResults() {
        return this.results;
    }
}

