/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.examples;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.web.examples.PanelConfigureProject;
import org.netbeans.modules.web.examples.WebSampleProjectGenerator;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

public class WebSampleProjectIterator
implements TemplateWizard.Iterator {
    private static final long serialVersionUID = 4L;
    int currentIndex;
    PanelConfigureProject basicPanel;
    private transient WizardDescriptor wiz;

    static Object create() {
        return new WebSampleProjectIterator();
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    public WizardDescriptor.Panel current() {
        return this.basicPanel;
    }

    public boolean hasNext() {
        return false;
    }

    public boolean hasPrevious() {
        return false;
    }

    public void initialize(TemplateWizard templateWizard) {
        int par;
        this.wiz = templateWizard;
        String name = templateWizard.getTemplate().getNodeDelegate().getDisplayName();
        if (name != null && (par = (name = name.replaceAll(" ", "")).indexOf("(")) != -1) {
            name = name.substring(0, par);
        }
        templateWizard.putProperty("name", (Object)name);
        this.basicPanel = new PanelConfigureProject();
        this.currentIndex = 0;
        this.updateStepsList();
    }

    public void uninitialize(TemplateWizard templateWizard) {
        this.basicPanel = null;
        this.wiz.putProperty("projdir", null);
        this.wiz.putProperty("name", null);
        this.currentIndex = -1;
    }

    public Set instantiate(TemplateWizard templateWizard) throws IOException {
        File projectLocation = (File)this.wiz.getProperty("projdir");
        String name = (String)this.wiz.getProperty("name");
        FileObject prjLoc = null;
        prjLoc = WebSampleProjectGenerator.createProjectFromTemplate(templateWizard.getTemplate().getPrimaryFile(), projectLocation, name);
        FileObject webRoot = prjLoc.getFileObject("web");
        FileObject index = this.getIndexFile(webRoot);
        HashSet<DataObject> hset = new HashSet<DataObject>();
        hset.add(DataObject.find((FileObject)prjLoc));
        hset.add(DataObject.find((FileObject)index));
        return hset;
    }

    public String name() {
        return this.current().getComponent().getName();
    }

    public void nextPanel() {
        throw new NoSuchElementException();
    }

    public void previousPanel() {
        throw new NoSuchElementException();
    }

    void updateStepsList() {
        JComponent component = (JComponent)this.current().getComponent();
        if (component == null) {
            return;
        }
        String[] list = new String[]{NbBundle.getMessage(PanelConfigureProject.class, (String)"LBL_NWP1_ProjectTitleName")};
        component.putClientProperty("WizardPanel_contentData", list);
        component.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(this.currentIndex));
    }

    private FileObject getIndexFile(FileObject webRoot) {
        FileObject file = null;
        file = webRoot.getFileObject("index", "jsp");
        if (file == null) {
            file = webRoot.getFileObject("index", "html");
        }
        return file;
    }
}

