/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote.ui.branch;

import java.awt.EventQueue;
import org.netbeans.modules.mercurial.remote.HgException;
import org.netbeans.modules.mercurial.remote.HgProgressSupport;
import org.netbeans.modules.mercurial.remote.Mercurial;
import org.netbeans.modules.mercurial.remote.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.remote.ui.branch.Bundle;
import org.netbeans.modules.mercurial.remote.ui.commit.CommitAction;
import org.netbeans.modules.mercurial.remote.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.remote.util.HgCommand;
import org.netbeans.modules.mercurial.remote.util.HgUtils;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

public class CloseBranchAction
extends ContextAction {
    @Override
    protected boolean enable(Node[] nodes) {
        return HgUtils.isFromHgRepository(HgUtils.getCurrentContext(nodes));
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_CloseBranch";
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        VCSContext ctx = HgUtils.getCurrentContext(nodes);
        final VCSFileProxy[] roots = HgUtils.getActionRoots(ctx);
        if (roots == null || roots.length == 0) {
            return;
        }
        final VCSFileProxy root = Mercurial.getInstance().getRepositoryRoot(roots[0]);
        RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(root);
        HgProgressSupport support = new HgProgressSupport(){

            @Override
            public void perform() {
                this.setDisplayName(NbBundle.getMessage(CloseBranchAction.class, (String)"MSG_CloseBranch.Progress.preparing"));
                try {
                    final String branchName = HgCommand.getBranch(root);
                    if (branchName.equals("default")) {
                        NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(CloseBranchAction.class, (String)"MSG_CloseBranch.error.defaultBranch"), 0);
                        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)nd);
                        return;
                    }
                    int numberOfHeads = this.getBranchHeadCount(branchName);
                    if (numberOfHeads == 0) {
                        NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(CloseBranchAction.class, (String)"MSG_CloseBranch.error.branchClosed", (Object[])new Object[]{branchName}), 0);
                        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)nd);
                    } else if (numberOfHeads > 1) {
                        NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(CloseBranchAction.class, (String)"MSG_CloseBranch.error.moreHeads", (Object[])new Object[]{branchName, numberOfHeads}), 0);
                        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)nd);
                    } else if (HgUtils.isRebasing(root)) {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.MSG_CloseBranchAction_interruptedRebase_error(root.getName()), 0));
                    } else if (!this.isCanceled()) {
                        final VCSContext ctx = VCSContext.forNodes((Node[])new Node[]{new AbstractNode(Children.LEAF, Lookups.fixed((Object[])roots)){

                            public String getDisplayName() {
                                return root.getName();
                            }
                        }});
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ((CommitAction)SystemAction.get(CommitAction.class)).closeBranch(branchName, ctx, NbBundle.getMessage(CloseBranchAction.class, (String)"MSG_CloseBranch.commit.title", (Object[])new Object[]{branchName, VCSFileProxySupport.getContextDisplayName((VCSContext)ctx)}));
                            }
                        });
                    }
                }
                catch (HgException.HgCommandCanceledException ex) {
                }
                catch (HgException ex) {
                    HgUtils.notifyException(ex);
                }
            }

            private int getBranchHeadCount(String branchName) throws HgException {
                HgLogMessage[] messages = HgCommand.getHeadRevisionsInfo(root, false, this.getLogger());
                int headsInBranch = 0;
                for (HgLogMessage message : messages) {
                    if (message.getBranches().length == 0 && branchName.equals("default")) {
                        ++headsInBranch;
                    }
                    for (String b : message.getBranches()) {
                        if (!b.equals(branchName)) continue;
                        ++headsInBranch;
                    }
                }
                return headsInBranch;
            }
        };
        support.start(rp, root, NbBundle.getMessage(CloseBranchAction.class, (String)"MSG_CloseBranch.Progress"));
    }
}

