/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote.ui.diff;

import java.awt.EventQueue;
import org.netbeans.modules.mercurial.remote.HgException;
import org.netbeans.modules.mercurial.remote.Mercurial;
import org.netbeans.modules.mercurial.remote.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.remote.ui.diff.DiffAction;
import org.netbeans.modules.mercurial.remote.ui.diff.DiffToRevision;
import org.netbeans.modules.mercurial.remote.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.remote.util.HgCommand;
import org.netbeans.modules.mercurial.remote.util.HgUtils;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.nodes.Node;
import org.openide.util.actions.SystemAction;

public class DiffToRevisionAction
extends ContextAction {
    @Override
    protected boolean enable(Node[] nodes) {
        VCSContext context = HgUtils.getCurrentContext(nodes);
        return HgUtils.isFromHgRepository(context);
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_DiffToRevision";
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        final VCSContext context = HgUtils.getCurrentContext(nodes);
        final VCSFileProxy[] actionRoots = HgUtils.getActionRoots(context);
        if (actionRoots == null || actionRoots.length == 0) {
            return;
        }
        Utils.post((Runnable)new Runnable(){

            @Override
            public void run() {
                final VCSFileProxy repository = Mercurial.getInstance().getRepositoryRoot(actionRoots[0]);
                try {
                    final HgLogMessage.HgRevision parent = HgCommand.getParent(repository, null, null);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            String contextName = VCSFileProxySupport.getContextDisplayName((VCSContext)context);
                            DiffToRevisionAction.this.diff(repository, actionRoots, parent, contextName);
                        }
                    });
                }
                catch (HgException.HgCommandCanceledException ex) {
                }
                catch (HgException ex) {
                    HgUtils.notifyException(ex);
                }
            }
        });
    }

    private void diff(VCSFileProxy repository, VCSFileProxy[] roots, HgLogMessage.HgRevision wcParent, String contextDisplayName) {
        DiffToRevision diffPanel = new DiffToRevision(repository, wcParent);
        if (diffPanel.showDialog()) {
            ((DiffAction)SystemAction.get(DiffAction.class)).diff(roots, diffPanel.getSelectedTreeFirst(), diffPanel.getSelectedTreeSecond(), contextDisplayName, false, true);
        }
    }
}

