/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote.ui.rollback;

import java.awt.event.ActionEvent;
import java.util.List;
import org.netbeans.modules.mercurial.remote.HgException;
import org.netbeans.modules.mercurial.remote.HgProgressSupport;
import org.netbeans.modules.mercurial.remote.Mercurial;
import org.netbeans.modules.mercurial.remote.OutputLogger;
import org.netbeans.modules.mercurial.remote.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.remote.util.HgCommand;
import org.netbeans.modules.mercurial.remote.util.HgUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class VerifyAction
extends ContextAction {
    @Override
    protected boolean enable(Node[] nodes) {
        return HgUtils.isFromHgRepository(HgUtils.getCurrentContext(nodes));
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_Verify";
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        VCSContext context = HgUtils.getCurrentContext(nodes);
        VerifyAction.verify(context);
    }

    public static void verify(VCSContext ctx) {
        VCSFileProxy[] roots = HgUtils.getActionRoots(ctx);
        if (roots == null || roots.length == 0) {
            return;
        }
        final VCSFileProxy root = Mercurial.getInstance().getRepositoryRoot(roots[0]);
        RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(root);
        HgProgressSupport support = new HgProgressSupport(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void perform() {
                OutputLogger logger = this.getLogger();
                try {
                    logger.outputInRed(NbBundle.getMessage(VerifyAction.class, (String)"MSG_VERIFY_TITLE"));
                    logger.outputInRed(NbBundle.getMessage(VerifyAction.class, (String)"MSG_VERIFY_TITLE_SEP"));
                    logger.output(NbBundle.getMessage(VerifyAction.class, (String)"MSG_VERIFY_INFO", (Object)root.getPath()));
                    List<String> list = HgCommand.doVerify(root, logger);
                    if (list != null && !list.isEmpty()) {
                        logger.output(list);
                    }
                }
                catch (HgException.HgCommandCanceledException ex) {
                }
                catch (HgException ex) {
                    HgUtils.notifyException(ex);
                }
                finally {
                    logger.outputInRed(NbBundle.getMessage(VerifyAction.class, (String)"MSG_VERIFY_DONE"));
                    logger.output("");
                    logger.getOpenOutputAction().actionPerformed(new ActionEvent(this, 1001, ""));
                }
            }
        };
        support.start(rp, root, NbBundle.getMessage(VerifyAction.class, (String)"MSG_VERIFY_PROGRESS"));
    }
}

