/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote.ui.status;

import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import org.netbeans.modules.mercurial.remote.Mercurial;
import org.netbeans.modules.mercurial.remote.WorkingCopyInfo;
import org.netbeans.modules.mercurial.remote.ui.status.VersioningPanel;
import org.netbeans.modules.mercurial.remote.util.HgUtils;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

@TopComponent.Description(persistenceType=0, preferredID="hgremoteversioningTC")
public class HgVersioningTopComponent
extends TopComponent
implements Externalizable,
PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private final VersioningPanel syncPanel;
    private VCSContext context;
    private String contentTitle;
    private String branchTitle;
    public static final String PREFERRED_ID = "hgremoteversioningTC";
    private static HgVersioningTopComponent instance;
    private WorkingCopyInfo info;

    public HgVersioningTopComponent() {
        this.putClientProperty("SlidingName", NbBundle.getMessage(HgVersioningTopComponent.class, (String)"CTL_Versioning_TopComponent_Title"));
        this.putClientProperty("KeepNonPersistentTCInModelWhenClosed", Boolean.TRUE);
        this.setName(NbBundle.getMessage(HgVersioningTopComponent.class, (String)"CTL_Versioning_TopComponent_Title"));
        this.setIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/mercurial/remote/resources/icons/versioning-view.png"));
        this.setLayout(new BorderLayout());
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HgVersioningTopComponent.class, (String)"CTL_Versioning_TopComponent_Title"));
        this.syncPanel = new VersioningPanel(this);
        this.add(this.syncPanel);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(this.getClass());
    }

    protected void componentActivated() {
        this.updateTitle();
        this.syncPanel.focus(true);
    }

    protected void componentDeactivated() {
        this.syncPanel.focus(false);
    }

    protected void componentOpened() {
        super.componentOpened();
        this.refreshContent();
    }

    protected void componentClosed() {
        super.componentClosed();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.contentTitle);
        if (this.context == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.context.getRootFiles().size());
            for (VCSFileProxy root : this.context.getRootFiles()) {
                URI uri = VCSFileProxySupport.toURI((VCSFileProxy)root);
                out.writeObject(uri);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.setContentTitle((String)in.readObject());
        int size = in.readInt();
        ArrayList<VCSFileProxy> rootFiles = new ArrayList<VCSFileProxy>(size);
        for (int i = 0; i < size; ++i) {
            URI uri = (URI)in.readObject();
            VCSFileProxy root = VCSFileProxySupport.fromURI((URI)uri);
            rootFiles.add(root);
        }
        VCSFileProxy[] files = rootFiles.toArray(new VCSFileProxy[size]);
        LinkedList<1> nodes = new LinkedList<1>();
        for (VCSFileProxy file : files) {
            nodes.add(new AbstractNode(Children.LEAF, Lookups.singleton((Object)file)){

                public String getDisplayName() {
                    return ((VCSFileProxy)this.getLookup().lookup(VCSFileProxy.class)).getName();
                }
            });
        }
        VCSContext ctx = VCSContext.forNodes((Node[])nodes.toArray(new Node[nodes.size()]));
        this.setContext(ctx);
    }

    private void refreshContent() {
        if (this.syncPanel == null) {
            return;
        }
        this.updateTitle();
        this.syncPanel.setContext(this.context);
    }

    public void setContentTitle(String contentTitle) {
        this.contentTitle = contentTitle;
        this.updateTitle();
    }

    void setBranchTitle(String branchTitle) {
        if (branchTitle == null) {
            branchTitle = NbBundle.getMessage(HgVersioningTopComponent.class, (String)"CTL_VersioningView_UnnamedBranchTitle");
        }
        this.branchTitle = branchTitle;
        this.updateTitle();
    }

    public void contentRefreshed() {
        this.updateTitle();
    }

    private void updateTitle() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (HgVersioningTopComponent.this.contentTitle == null) {
                    HgVersioningTopComponent.this.setName(NbBundle.getMessage(HgVersioningTopComponent.class, (String)"CTL_Versioning_TopComponent_Title"));
                } else {
                    VCSFileProxy baseFile = HgUtils.getRootFile(HgVersioningTopComponent.this.context);
                    String name = "";
                    if (baseFile != null) {
                        name = baseFile.getName();
                    }
                    if (HgVersioningTopComponent.this.branchTitle == null) {
                        HgVersioningTopComponent.this.setName(NbBundle.getMessage(HgVersioningTopComponent.class, (String)"CTL_Versioning_TopComponent_MultiTitle", (Object)HgVersioningTopComponent.this.contentTitle, (Object)(name.equals(HgVersioningTopComponent.this.contentTitle) ? "" : "[" + name + "]")));
                    } else {
                        HgVersioningTopComponent.this.setName(NbBundle.getMessage(HgVersioningTopComponent.class, (String)"CTL_Versioning_TopComponent_Title_ContentBranch", (Object)HgVersioningTopComponent.this.contentTitle, (Object)(name.equals(HgVersioningTopComponent.this.contentTitle) ? "" : "[" + name + "] "), (Object)HgVersioningTopComponent.this.branchTitle));
                    }
                }
                HgVersioningTopComponent.this.setToolTipText(HgVersioningTopComponent.this.getName());
            }
        });
    }

    String getContentTitle() {
        return this.contentTitle;
    }

    public static synchronized HgVersioningTopComponent getDefault() {
        if (instance == null) {
            instance = new HgVersioningTopComponent();
        }
        return instance;
    }

    public static synchronized HgVersioningTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            Mercurial.LOG.log(Level.FINE, "Cannot find hgremoteversioningTC component. It will not be located properly in the window system.");
            return HgVersioningTopComponent.getDefault();
        }
        if (win instanceof HgVersioningTopComponent) {
            return (HgVersioningTopComponent)win;
        }
        Mercurial.LOG.log(Level.FINE, "There seem to be multiple components with the 'hgremoteversioningTC' ID. That is a potential source of errors and unexpected behavior.");
        return HgVersioningTopComponent.getDefault();
    }

    public void performRefreshAction() {
        this.syncPanel.performRefreshAction();
    }

    public void setContext(VCSContext ctx) {
        this.syncPanel.cancelRefresh();
        if (ctx == null) {
            this.setName(NbBundle.getMessage(HgVersioningTopComponent.class, (String)"MSG_Preparing"));
            this.setEnabled(false);
            this.setCursor(Cursor.getPredefinedCursor(3));
        } else {
            this.setEnabled(true);
            this.setCursor(Cursor.getDefaultCursor());
            this.context = ctx;
            this.syncPanel.setContext(ctx);
            this.refreshBranchName();
            this.refreshContent();
        }
        this.setToolTipText(this.getName());
    }

    public boolean hasContext() {
        return this.context != null && this.context.getRootFiles().size() > 0;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (WorkingCopyInfo.PROPERTY_CURRENT_BRANCH.equals(evt.getPropertyName())) {
            this.setBranchTitle((String)evt.getNewValue());
            this.updateTitle();
        }
    }

    void refreshBranchName() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (HgVersioningTopComponent.this.info != null) {
                    HgVersioningTopComponent.this.info.removePropertyChangeListener(HgVersioningTopComponent.this);
                    HgVersioningTopComponent.this.info = null;
                }
                Set<VCSFileProxy> repositoryRoots = HgUtils.getRepositoryRoots(HgVersioningTopComponent.this.context);
                String label = null;
                if (repositoryRoots.size() == 1) {
                    HgVersioningTopComponent.this.info = WorkingCopyInfo.getInstance(repositoryRoots.iterator().next());
                    HgVersioningTopComponent.this.info.addPropertyChangeListener(HgVersioningTopComponent.this);
                    label = HgVersioningTopComponent.this.info.getCurrentBranch();
                }
                HgVersioningTopComponent.this.setBranchTitle(label);
            }
        };
        if (EventQueue.isDispatchThread()) {
            Utils.post((Runnable)runnable);
        } else {
            runnable.run();
        }
    }
}

