/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.ui.diff;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import org.netbeans.api.diff.Difference;
import org.netbeans.modules.versioning.ui.diff.DiffSidebar;
import org.netbeans.modules.versioning.ui.diff.DiffTooltipActionsPanel;
import org.netbeans.modules.versioning.ui.diff.DiffTooltipContentPanel;

class DiffActionTooltipWindow
implements AWTEventListener,
WindowFocusListener {
    private static final int SCREEN_BORDER = 20;
    private JWindow actionsWindow;
    private JWindow contentWindow;
    private final DiffSidebar master;
    private final Difference diff;

    public DiffActionTooltipWindow(DiffSidebar master, Difference diff) {
        this.master = master;
        this.diff = diff;
        Window w = SwingUtilities.windowForComponent(master.getTextComponent());
        this.actionsWindow = new JWindow(w);
        if (diff.getType() != 1) {
            this.contentWindow = new JWindow(w);
        }
    }

    DiffSidebar getMaster() {
        return this.master;
    }

    public void show(Point location) {
        final DiffTooltipActionsPanel tp = new DiffTooltipActionsPanel(this, this.diff);
        this.actionsWindow.add(tp);
        this.actionsWindow.pack();
        this.actionsWindow.setLocation(location);
        if (this.contentWindow != null) {
            GraphicsDevice device;
            GraphicsConfiguration gc;
            GraphicsDevice[] gds;
            DiffTooltipContentPanel cp = new DiffTooltipContentPanel(this.master.getTextComponent(), this.master.getMimeType(), this.diff);
            this.contentWindow.add(cp);
            this.contentWindow.pack();
            cp.resize();
            Dimension dim = this.contentWindow.getSize();
            Rectangle screenBounds = null;
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice[] arr$ = gds = ge.getScreenDevices();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && !(screenBounds = (gc = (device = arr$[i$]).getDefaultConfiguration()).getBounds()).contains(location); ++i$) {
            }
            if (location.y + dim.height + 20 > screenBounds.y + screenBounds.height) {
                dim.height = screenBounds.y + screenBounds.height - (location.y + 20);
            }
            if (location.x + dim.width + 20 > screenBounds.x + screenBounds.width) {
                dim.width = screenBounds.x + screenBounds.width - (location.x + 20);
            }
            if (dim.width < this.actionsWindow.getWidth()) {
                dim.width = this.actionsWindow.getWidth();
            }
            this.contentWindow.setSize(dim);
            this.contentWindow.setLocation(location.x, location.y + this.actionsWindow.getHeight() - 1);
            this.contentWindow.setVisible(true);
        }
        this.actionsWindow.setVisible(true);
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 16L);
        this.actionsWindow.addWindowFocusListener(this);
        this.actionsWindow.getOwner().addWindowFocusListener(this);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                tp.focusButton();
            }
        });
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        if (event.getID() == 501) {
            this.onClick(event);
        }
    }

    private void onClick(AWTEvent event) {
        Component component = (Component)event.getSource();
        Window w = SwingUtilities.windowForComponent(component);
        if (w != this.actionsWindow && (this.contentWindow == null || w != this.contentWindow)) {
            this.shutdown();
        }
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
        if (this.actionsWindow != null && e.getOppositeWindow() == null) {
            this.shutdown();
        }
    }

    void shutdown() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        this.actionsWindow.getOwner().removeWindowFocusListener(this);
        this.actionsWindow.removeWindowFocusListener(this);
        this.actionsWindow.dispose();
        if (this.contentWindow != null) {
            this.contentWindow.dispose();
        }
    }
}

