/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.tasks.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.IssueImpl;
import org.netbeans.modules.bugtracking.QueryImpl;
import org.netbeans.modules.bugtracking.RepositoryImpl;
import org.netbeans.modules.bugtracking.spi.IssueScheduleInfo;
import org.netbeans.modules.bugtracking.spi.IssueStatusProvider;
import org.netbeans.modules.bugtracking.spi.QueryController;
import org.netbeans.modules.bugtracking.tasks.DashboardTopComponent;
import org.netbeans.modules.bugtracking.tasks.DashboardUtils;
import org.netbeans.modules.bugtracking.tasks.SortPanel;
import org.netbeans.modules.bugtracking.tasks.actions.CategoryAction;
import org.netbeans.modules.bugtracking.tasks.actions.DummyAction;
import org.netbeans.modules.bugtracking.tasks.actions.QueryAction;
import org.netbeans.modules.bugtracking.tasks.actions.RepositoryAction;
import org.netbeans.modules.bugtracking.tasks.actions.TaskAction;
import org.netbeans.modules.bugtracking.tasks.dashboard.CategoryNode;
import org.netbeans.modules.bugtracking.tasks.dashboard.ClosedCategoryNode;
import org.netbeans.modules.bugtracking.tasks.dashboard.ClosedRepositoryNode;
import org.netbeans.modules.bugtracking.tasks.dashboard.DashboardViewer;
import org.netbeans.modules.bugtracking.tasks.dashboard.QueryNode;
import org.netbeans.modules.bugtracking.tasks.dashboard.Refreshable;
import org.netbeans.modules.bugtracking.tasks.dashboard.RepositoryNode;
import org.netbeans.modules.bugtracking.tasks.dashboard.Submitable;
import org.netbeans.modules.bugtracking.tasks.dashboard.TaskContainerNode;
import org.netbeans.modules.bugtracking.tasks.dashboard.TaskNode;
import org.netbeans.modules.bugtracking.ui.issue.IssueAction;
import org.netbeans.modules.bugtracking.ui.issue.IssueTopComponent;
import org.netbeans.modules.bugtracking.ui.query.QueryTopComponent;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.netbeans.modules.team.commons.treelist.TreeListNode;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakSet;
import org.openide.util.actions.Presenter;

public class Actions {
    public static final KeyStroke REFRESH_KEY = KeyStroke.getKeyStroke("F5");
    public static final KeyStroke DELETE_KEY = KeyStroke.getKeyStroke("DELETE");
    private static final RequestProcessor RP = new RequestProcessor(Actions.class.getName(), 10);

    public static List<Action> getDefaultActions(TreeListNode ... nodes) {
        RefreshAction refresh;
        ArrayList<Action> actions = new ArrayList<Action>();
        MarkSeenAction markSeen = MarkSeenAction.createAction(nodes);
        if (markSeen != null) {
            actions.add(markSeen);
        }
        if ((refresh = RefreshAction.createAction(nodes)) != null) {
            actions.add(refresh);
        }
        return actions;
    }

    public static List<Action> getSubmitablePopupActions(TreeListNode ... nodes) {
        CancelAction cancelAction;
        ArrayList<Action> actions = new ArrayList<Action>();
        SubmitAction submitAction = SubmitAction.createAction(nodes);
        if (submitAction != null) {
            actions.add(submitAction);
        }
        if ((cancelAction = CancelAction.createAction(nodes)) != null) {
            actions.add(cancelAction);
        }
        return actions;
    }

    public static List<Action> getTaskPopupActions(TaskNode ... taskNodes) {
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add(new OpenTaskAction(taskNodes));
        boolean enableSetCategory = true;
        boolean showRemoveTask = true;
        boolean showDeleteLocal = true;
        for (TaskNode taskNode : taskNodes) {
            if (!taskNode.isCategorized()) {
                showRemoveTask = false;
            }
            if (taskNode.getTask().isNew()) {
                enableSetCategory = false;
            }
            if (taskNode.isLocal()) continue;
            showDeleteLocal = false;
        }
        if (showRemoveTask) {
            actions.add(new RemoveTaskAction(taskNodes));
        }
        if (showDeleteLocal) {
            actions.add(new DeleteLocalTaskAction(taskNodes));
        }
        SetCategoryAction setCategoryAction = new SetCategoryAction(taskNodes);
        actions.add(setCategoryAction);
        if (!enableSetCategory) {
            setCategoryAction.setEnabled(false);
        }
        actions.add(Actions.getScheduleAction(taskNodes));
        return actions;
    }

    private static Action getScheduleAction(final TaskNode ... taskNodes) {
        boolean hasSchedule = true;
        for (TaskNode tn : taskNodes) {
            if (tn.getTask().hasSchedule()) continue;
            hasSchedule = false;
            break;
        }
        IssueScheduleInfo schedule = null;
        if (taskNodes.length == 1) {
            schedule = taskNodes[0].getTask().getSchedule();
        }
        final DashboardUtils.SchedulingMenu scheduleMenu = DashboardUtils.createScheduleMenu(schedule);
        ChangeListener listener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                for (TaskNode taskNode : taskNodes) {
                    if (!taskNode.getTask().hasSchedule()) continue;
                    taskNode.getTask().setSchedule(scheduleMenu.getScheduleInfo());
                }
                scheduleMenu.removeChangeListener(this);
            }
        };
        scheduleMenu.addChangeListener(listener);
        Action menuAction = scheduleMenu.getMenuAction();
        menuAction.setEnabled(hasSchedule);
        return menuAction;
    }

    public static List<Action> getCategoryPopupActions(CategoryNode ... categoryNodes) {
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add(new RenameCategoryAction(categoryNodes));
        actions.add(new DeleteCategoryAction(categoryNodes));
        return actions;
    }

    public static List<Action> getRepositoryPopupActions(RepositoryNode ... repositoryNodes) {
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add(new CreateTaskAction(repositoryNodes));
        actions.add(new CreateQueryAction(repositoryNodes));
        actions.add(new QuickSearchAction(repositoryNodes));
        actions.add(null);
        actions.add(new RemoveRepositoryAction(repositoryNodes));
        actions.add(new PropertiesRepositoryAction(repositoryNodes));
        return actions;
    }

    public static List<Action> getQueryPopupActions(QueryNode ... queryNodes) {
        boolean editPossible = true;
        boolean openPossible = true;
        boolean deletePossible = true;
        for (QueryNode queryNode : queryNodes) {
            QueryImpl q = queryNode.getQuery();
            if (!q.providesMode(QueryController.QueryMode.EDIT)) {
                editPossible = false;
            }
            if (!q.providesMode(QueryController.QueryMode.VIEW)) {
                openPossible = false;
            }
            if (!q.canRemove()) {
                deletePossible = false;
            }
            if (!editPossible && !openPossible && !deletePossible) break;
        }
        ArrayList<Action> actions = new ArrayList<Action>();
        EditQueryAction editQueryAction = new EditQueryAction(queryNodes);
        editQueryAction.setEnabled(editPossible);
        actions.add(editQueryAction);
        OpenQueryAction openQueryAction = new OpenQueryAction(queryNodes);
        openQueryAction.setEnabled(openPossible);
        actions.add(openQueryAction);
        DeleteQueryAction deleteQueryAction = new DeleteQueryAction(queryNodes);
        deleteQueryAction.setEnabled(deletePossible);
        actions.add(deleteQueryAction);
        actions.add(null);
        actions.add(new AutoRefreshAction(queryNodes));
        return actions;
    }

    private static boolean containsLocalRepository(RepositoryNode[] nodes) {
        boolean isLocal = false;
        for (RepositoryNode n : nodes) {
            if (!BugtrackingManager.isLocalConnectorID(n.getRepository().getConnectorId())) continue;
            isLocal = true;
            break;
        }
        return isLocal;
    }

    private static boolean containsQueryFromLocalRepository(QueryNode[] nodes) {
        boolean isLocal = false;
        for (QueryNode n : nodes) {
            if (!BugtrackingManager.isLocalConnectorID(n.getQuery().getRepositoryImpl().getConnectorId())) continue;
            isLocal = true;
            break;
        }
        return isLocal;
    }

    public static class AutoRefreshAction
    extends QueryAction
    implements Presenter.Popup {
        private JCheckBoxMenuItem item;

        public AutoRefreshAction(QueryNode ... queryNodes) {
            super(NbBundle.getMessage(OpenQueryAction.class, (String)"CTL_AutoRefresh"), queryNodes);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Boolean autoRefreshOn = this.getAutoRefresh();
            if (autoRefreshOn == null) {
                return;
            }
            for (QueryNode qn : this.getQueryNodes()) {
                this.item.setState(autoRefreshOn == false);
                DashboardUtils.setQueryAutoRefresh(qn.getQuery(), autoRefreshOn == false);
                qn.setStalled(autoRefreshOn);
            }
        }

        @Override
        public boolean isEnabled() {
            return this.getAutoRefresh() != null;
        }

        public Boolean getAutoRefresh() {
            Boolean b = null;
            for (QueryNode qn : this.getQueryNodes()) {
                QueryImpl q = qn.getQuery();
                boolean state = DashboardUtils.isQueryAutoRefresh(q);
                if (b == null) {
                    b = state;
                    continue;
                }
                if (b == state) continue;
                return null;
            }
            return b;
        }

        public JMenuItem getPopupPresenter() {
            if (this.item == null) {
                this.item = new JCheckBoxMenuItem(this);
                Boolean b = this.getAutoRefresh();
                if (b != null) {
                    this.item.setState(b);
                }
            }
            return this.item;
        }
    }

    public static class SortDialogAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            SortPanel panel = new SortPanel();
            NotifyDescriptor categoryNameDialog = new NotifyDescriptor((Object)panel, NbBundle.getMessage(Actions.class, (String)"MSG_SortDialog"), 2, -1, null, NotifyDescriptor.OK_OPTION);
            if (DialogDisplayer.getDefault().notify(categoryNameDialog) == NotifyDescriptor.OK_OPTION) {
                panel.saveAttributes();
            }
        }
    }

    public static class UniversalRefreshAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            List<TreeListNode> selectedNodes = DashboardViewer.getInstance().getSelectedNodes();
            RefreshAction refresh = RefreshAction.createAction(selectedNodes.toArray(new TreeListNode[selectedNodes.size()]));
            if (refresh != null) {
                refresh.actionPerformed(e);
            }
        }
    }

    public static class UniversalDeleteAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            List<TreeListNode> selectedNodes = DashboardViewer.getInstance().getSelectedNodes();
            HashMap<String, ArrayList<TreeListNode>> map = new HashMap<String, ArrayList<TreeListNode>>();
            for (TreeListNode treeListNode : selectedNodes) {
                ArrayList<TreeListNode> list = (ArrayList<TreeListNode>)map.get(treeListNode.getClass().getName());
                if (list == null) {
                    list = new ArrayList<TreeListNode>();
                }
                list.add(treeListNode);
                map.put(treeListNode.getClass().getName(), list);
            }
            for (String key : map.keySet()) {
                List value = (List)map.get(key);
                AbstractAction action = null;
                if (key.equals(RepositoryNode.class.getName()) || key.equals(ClosedRepositoryNode.class.getName())) {
                    action = new RemoveRepositoryAction(value.toArray(new RepositoryNode[value.size()]));
                } else if (key.equals(CategoryNode.class.getName()) || key.equals(ClosedCategoryNode.class.getName())) {
                    action = new DeleteCategoryAction(value.toArray(new CategoryNode[value.size()]));
                } else if (key.equals(QueryNode.class.getName())) {
                    action = new DeleteQueryAction(value.toArray(new QueryNode[value.size()]));
                } else if (key.equals(TaskNode.class.getName())) {
                    action = new DeleteLocalTaskAction(value.toArray(new TaskNode[value.size()]));
                }
                if (action == null || !action.isEnabled()) continue;
                action.actionPerformed(e);
            }
        }

        @Override
        public boolean isEnabled() {
            List<TreeListNode> selectedNodes = DashboardViewer.getInstance().getSelectedNodes();
            for (TreeListNode treeListNodes : selectedNodes) {
                if (treeListNodes instanceof RepositoryNode || treeListNodes instanceof CategoryNode || treeListNodes instanceof QueryNode || treeListNodes instanceof TaskNode) continue;
                return false;
            }
            return true;
        }
    }

    public static class EditQueryAction
    extends QueryAction {
        public EditQueryAction(QueryNode ... queryNodes) {
            super(NbBundle.getMessage(OpenQueryAction.class, (String)"CTL_Edit"), queryNodes);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (QueryNode queryNode : this.getQueryNodes()) {
                queryNode.getQuery().open(QueryController.QueryMode.EDIT);
            }
        }
    }

    public static class OpenQueryAction
    extends QueryAction {
        public OpenQueryAction(QueryNode ... queryNodes) {
            super(NbBundle.getMessage(OpenQueryAction.class, (String)"CTL_OpenNode"), queryNodes);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (QueryNode queryNode : this.getQueryNodes()) {
                queryNode.getQuery().open(QueryController.QueryMode.VIEW);
            }
        }
    }

    private static class NotificationQueryAction
    extends QueryAction {
        public NotificationQueryAction(QueryNode ... queryNodes) {
            super(NbBundle.getMessage(Actions.class, (String)"CTL_Notification"), queryNodes);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new DummyAction().actionPerformed(e);
        }

        @Override
        public boolean isEnabled() {
            return false;
        }
    }

    public static class DeleteQueryAction
    extends QueryAction {
        public DeleteQueryAction(QueryNode ... queryNodes) {
            super(NbBundle.getMessage(Actions.class, (String)"CTL_Delete"), queryNodes);
            this.putValue("AcceleratorKey", DELETE_KEY);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    DashboardViewer.getInstance().deleteQuery(DeleteQueryAction.this.getQueryNodes());
                }
            });
        }

        @Override
        public boolean isEnabled() {
            return !Actions.containsQueryFromLocalRepository(this.getQueryNodes());
        }
    }

    public static class QuickSearchAction
    extends RepositoryAction {
        public QuickSearchAction(RepositoryNode ... repositoryNodes) {
            super(NbBundle.getMessage(Actions.class, (String)"CTL_Search"), repositoryNodes);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RepositoryNode repositoryNode = this.getRepositoryNodes()[0];
            DashboardUtils.quickSearchTask(repositoryNode.getRepository());
        }

        @Override
        public boolean isEnabled() {
            boolean parentEnabled = super.isEnabled();
            return parentEnabled && this.getRepositoryNodes().length == 1;
        }
    }

    public static class CreateQueryAction
    extends RepositoryAction {
        public CreateQueryAction(RepositoryNode ... repositoryNodes) {
            super(NbBundle.getMessage(Actions.class, (String)"CTL_CreateQuery"), repositoryNodes);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (RepositoryNode repositoryNode : this.getRepositoryNodes()) {
                org.netbeans.modules.bugtracking.ui.query.QueryAction.createNewQuery(repositoryNode.getRepository());
            }
        }

        @Override
        public boolean isEnabled() {
            return super.isEnabled() && !Actions.containsLocalRepository(this.getRepositoryNodes());
        }
    }

    public static class OpenRepositoryNodeAction
    extends RepositoryAction {
        public OpenRepositoryNodeAction(RepositoryNode ... repositoryNodes) {
            super(NbBundle.getMessage(OpenCategoryNodeAction.class, (String)"CTL_OpenNode"), repositoryNodes);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (RepositoryNode repositoryNode : this.getRepositoryNodes()) {
                DashboardViewer.getInstance().setRepositoryOpened(repositoryNode, true);
            }
        }

        @Override
        public boolean isEnabled() {
            for (RepositoryNode repositoryNode : this.getRepositoryNodes()) {
                if (!repositoryNode.isOpened()) continue;
                return false;
            }
            return true;
        }
    }

    public static class CreateRepositoryAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            BugtrackingUtil.createRepository(false);
        }
    }

    public static class CloseRepositoryNodeAction
    extends RepositoryAction {
        public CloseRepositoryNodeAction(RepositoryNode ... repositoryNodes) {
            super(NbBundle.getMessage(CloseRepositoryNodeAction.class, (String)"CTL_CloseNode"), repositoryNodes);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (RepositoryNode repositoryNode : this.getRepositoryNodes()) {
                DashboardViewer.getInstance().setRepositoryOpened(repositoryNode, false);
                RepositoryImpl repo = repositoryNode.getRepository();
                IssueTopComponent.closeFor(repo);
                QueryTopComponent.closeFor(repo);
            }
        }
    }

    private static class PropertiesRepositoryAction
    extends RepositoryAction {
        public PropertiesRepositoryAction(RepositoryNode ... repositoryNodes) {
            super(NbBundle.getMessage(Actions.class, (String)"CTL_Properties"), repositoryNodes);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BugtrackingUtil.editRepository(this.getRepositoryNodes()[0].getRepository(), null);
        }

        @Override
        public boolean isEnabled() {
            RepositoryNode n;
            boolean singleNode = this.getRepositoryNodes().length == 1;
            boolean allMutable = true;
            RepositoryNode[] arr$ = this.getRepositoryNodes();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (allMutable = (n = arr$[i$]).getRepository().isMutable()); ++i$) {
            }
            return singleNode && allMutable;
        }
    }

    public static class RemoveRepositoryAction
    extends RepositoryAction {
        public RemoveRepositoryAction(RepositoryNode ... repositoryNodes) {
            super(NbBundle.getMessage(Actions.class, (String)"CTL_Remove"), repositoryNodes);
            this.putValue("AcceleratorKey", DELETE_KEY);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DashboardViewer.getInstance().removeRepository(this.getRepositoryNodes());
        }

        @Override
        public boolean isEnabled() {
            return !Actions.containsLocalRepository(this.getRepositoryNodes());
        }
    }

    public static class ClearCategoriesAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            DashboardViewer.getInstance().clearCategories();
        }
    }

    public static class OpenCategoryNodeAction
    extends CategoryAction {
        public OpenCategoryNodeAction(CategoryNode ... categoryNodes) {
            super(NbBundle.getMessage(OpenCategoryNodeAction.class, (String)"CTL_OpenNode"), categoryNodes);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (CategoryNode categoryNode : this.getCategoryNodes()) {
                DashboardViewer.getInstance().setCategoryOpened(categoryNode, true);
            }
        }

        @Override
        public boolean isEnabled() {
            return true;
        }
    }

    public static class CreateCategoryAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            DashboardTopComponent.findInstance().createCategory();
        }
    }

    public static class CloseCategoryNodeAction
    extends CategoryAction {
        public CloseCategoryNodeAction(CategoryNode ... categoryNodes) {
            super(NbBundle.getMessage(CloseCategoryNodeAction.class, (String)"CTL_CloseNode"), categoryNodes);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (CategoryNode categoryNode : this.getCategoryNodes()) {
                DashboardViewer.getInstance().setCategoryOpened(categoryNode, false);
            }
        }
    }

    private static class RenameCategoryAction
    extends CategoryAction {
        public RenameCategoryAction(CategoryNode ... categoryNodes) {
            super(NbBundle.getMessage(Actions.class, (String)"CTL_Rename"), categoryNodes);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DashboardTopComponent.findInstance().renameCategory(this.getCategoryNodes()[0].getCategory());
        }

        @Override
        public boolean isEnabled() {
            boolean parent = super.isEnabled();
            boolean singleNode = this.getCategoryNodes().length == 1;
            return parent && singleNode;
        }
    }

    private static class NotificationCategoryAction
    extends CategoryAction {
        public NotificationCategoryAction(CategoryNode ... categoryNodes) {
            super(NbBundle.getMessage(Actions.class, (String)"CTL_Notification"), categoryNodes);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new DummyAction().actionPerformed(e);
        }

        @Override
        public boolean isEnabled() {
            return false;
        }
    }

    public static class DeleteCategoryAction
    extends CategoryAction {
        public DeleteCategoryAction(CategoryNode ... categoryNodes) {
            super(NbBundle.getMessage(Actions.class, (String)"CTL_Delete"), categoryNodes);
            this.putValue("AcceleratorKey", DELETE_KEY);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DashboardViewer.getInstance().deleteCategory(this.getCategoryNodes());
        }

        @Override
        public boolean isEnabled() {
            return true;
        }
    }

    public static class OpenTaskAction
    extends TaskAction {
        public OpenTaskAction(TaskNode ... taskNodes) {
            super(NbBundle.getMessage(OpenTaskAction.class, (String)"CTL_OpenNode"), taskNodes);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (TaskNode taskNode : this.getTaskNodes()) {
                taskNode.getTask().open();
            }
        }
    }

    public static class DeactivateTaskAction
    extends AbstractAction {
        public DeactivateTaskAction() {
            super(NbBundle.getMessage(DeactivateTaskAction.class, (String)"CTL_DeactivateTask"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DashboardTopComponent.findInstance().deactivateTask();
        }
    }

    public static class CreateTaskAction
    extends RepositoryAction {
        public CreateTaskAction(RepositoryNode ... repositoryNodes) {
            super(NbBundle.getMessage(Actions.class, (String)"CTL_CreateTask"), repositoryNodes);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (RepositoryNode repositoryNode : this.getRepositoryNodes()) {
                IssueAction.createIssue(repositoryNode.getRepository());
            }
        }
    }

    public static class ActivateTaskAction
    extends TaskAction {
        public ActivateTaskAction(TaskNode taskNode) {
            super(NbBundle.getMessage(ActivateTaskAction.class, (String)"CTL_ActivateTask"), taskNode);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DashboardTopComponent.findInstance().activateTask(this.getTaskNodes()[0]);
        }
    }

    private static class NotificationTaskAction
    extends TaskAction {
        public NotificationTaskAction(TaskNode ... taskNode) {
            super(NbBundle.getMessage(Actions.class, (String)"CTL_Notification"), taskNode);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new DummyAction().actionPerformed(e);
        }

        @Override
        public boolean isEnabled() {
            return false;
        }
    }

    private static class SetCategoryAction
    extends TaskAction {
        public SetCategoryAction(TaskNode ... taskNode) {
            super(NbBundle.getMessage(Actions.class, (String)"CTL_SetCat"), taskNode);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DashboardTopComponent.findInstance().addTask(this.getTaskNodes());
        }
    }

    public static class DeleteLocalTaskAction
    extends TaskAction {
        public DeleteLocalTaskAction(TaskNode ... taskNodes) {
            super(NbBundle.getMessage(Actions.class, (String)"CTL_Delete"), taskNodes);
            this.putValue("AcceleratorKey", DELETE_KEY);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean confirmDelete = DashboardUtils.confirmDelete(NbBundle.getMessage(Actions.class, (String)"LBL_DeleteDialogTitle"), NbBundle.getMessage(Actions.class, (String)"LBL_DeleteDialogQuestion", (Object)this.getTaskNodes().length));
            if (confirmDelete) {
                RP.post(new Runnable(){

                    @Override
                    public void run() {
                        for (TaskNode taskNode : DeleteLocalTaskAction.this.getTaskNodes()) {
                            taskNode.getTask().discardChanges();
                        }
                    }
                });
            }
        }

        @Override
        public boolean isEnabled() {
            for (TaskNode taskNode : this.getTaskNodes()) {
                if (taskNode.isLocal()) continue;
                return false;
            }
            return true;
        }
    }

    public static class RemoveTaskAction
    extends TaskAction {
        public RemoveTaskAction(TaskNode ... taskNodes) {
            super(NbBundle.getMessage(Actions.class, (String)"CTL_RemoveFromCat"), taskNodes);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DashboardViewer.getInstance().removeTask(this.getTaskNodes());
        }

        @Override
        public boolean isEnabled() {
            for (TaskNode taskNode : this.getTaskNodes()) {
                if (taskNode.isCategorized()) continue;
                return false;
            }
            return true;
        }
    }

    public static class CancelAction
    extends AbstractAction {
        private final List<Submitable> nodes;
        private boolean canceled = false;

        private CancelAction(List<Submitable> nodes, String name) {
            super(name);
            this.nodes = nodes;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean confirmCancel = DashboardUtils.confirmDelete(NbBundle.getMessage(Actions.class, (String)"LBL_CancelDialogTitle"), NbBundle.getMessage(Actions.class, (String)"LBL_CancelDialogQuestion"));
            if (confirmCancel) {
                RP.post(new Runnable(){

                    @Override
                    public void run() {
                        HashMap<String, IssueImpl> tasksMap = new HashMap<String, IssueImpl>();
                        for (Submitable submitable : CancelAction.this.nodes) {
                            for (IssueImpl issueImpl : submitable.getTasksToSubmit()) {
                                if (tasksMap.containsKey(CancelAction.this.getTaskKey(issueImpl))) continue;
                                tasksMap.put(CancelAction.this.getTaskKey(issueImpl), issueImpl);
                            }
                        }
                        ProgressHandle cancelProgress = CancelAction.this.getProgress();
                        cancelProgress.start(tasksMap.values().size());
                        int workunits = 0;
                        for (IssueImpl issueImpl : tasksMap.values()) {
                            if (CancelAction.this.canceled) break;
                            cancelProgress.progress(NbBundle.getMessage(Actions.class, (String)"LBL_CancelTaskProgress", (Object)issueImpl.getDisplayName()));
                            issueImpl.discardChanges();
                            cancelProgress.progress(++workunits);
                        }
                        cancelProgress.finish();
                    }
                });
            }
        }

        private ProgressHandle getProgress() {
            return ProgressHandleFactory.createHandle((String)NbBundle.getMessage(Actions.class, (String)"LBL_CancelAllProgress"), (Cancellable)new Cancellable(){

                public boolean cancel() {
                    CancelAction.this.canceled = true;
                    return CancelAction.this.canceled;
                }
            });
        }

        private String getTaskKey(IssueImpl task) {
            return task.getRepositoryImpl().getId() + ";;" + task.getID();
        }

        public static CancelAction createAction(TreeListNode ... nodes) {
            TaskContainerNode n;
            ArrayList<Submitable> submitables = new ArrayList<Submitable>();
            for (TreeListNode n2 : nodes) {
                if (!(n2 instanceof Submitable) || !((Submitable)n2).isUnsubmitted()) {
                    return null;
                }
                submitables.add((Submitable)n2);
            }
            String name = NbBundle.getMessage(Actions.class, (String)"CTL_CancelAll");
            if (nodes.length == 1 && nodes[0] instanceof TaskContainerNode && (n = (TaskContainerNode)nodes[0]).getTasks(true).size() == 1 && n instanceof TaskNode) {
                name = NbBundle.getMessage(Actions.class, (String)"CTL_Cancel");
            }
            return new CancelAction(submitables, name);
        }
    }

    public static class SubmitAction
    extends AbstractAction {
        private final List<Submitable> nodes;
        private boolean canceled = false;

        private SubmitAction(List<Submitable> nodes, String name) {
            super(name);
            this.nodes = nodes;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    HashMap<String, IssueImpl> tasksMap = new HashMap<String, IssueImpl>();
                    for (Submitable submitable : SubmitAction.this.nodes) {
                        for (IssueImpl issueImpl : submitable.getTasksToSubmit()) {
                            if (tasksMap.containsKey(SubmitAction.this.getTaskKey(issueImpl))) continue;
                            tasksMap.put(SubmitAction.this.getTaskKey(issueImpl), issueImpl);
                        }
                    }
                    ProgressHandle submitProgress = SubmitAction.this.getProgress();
                    submitProgress.start(tasksMap.values().size());
                    int workunits = 0;
                    for (IssueImpl issueImpl : tasksMap.values()) {
                        if (SubmitAction.this.canceled) break;
                        submitProgress.progress(NbBundle.getMessage(Actions.class, (String)"LBL_SubmitTaskProgress", (Object)issueImpl.getDisplayName()));
                        issueImpl.submit();
                        submitProgress.progress(++workunits);
                    }
                    submitProgress.finish();
                }
            });
        }

        private ProgressHandle getProgress() {
            return ProgressHandleFactory.createHandle((String)NbBundle.getMessage(Actions.class, (String)"LBL_SubmitAllProgress"), (Cancellable)new Cancellable(){

                public boolean cancel() {
                    SubmitAction.this.canceled = true;
                    return SubmitAction.this.canceled;
                }
            });
        }

        private String getTaskKey(IssueImpl task) {
            return task.getRepositoryImpl().getId() + ";;" + task.getID();
        }

        public static SubmitAction createAction(TreeListNode ... nodes) {
            TaskContainerNode n;
            ArrayList<Submitable> submitables = new ArrayList<Submitable>();
            for (TreeListNode n2 : nodes) {
                if (!(n2 instanceof Submitable) || !((Submitable)n2).isUnsubmitted()) {
                    return null;
                }
                submitables.add((Submitable)n2);
            }
            String name = NbBundle.getMessage(Actions.class, (String)"CTL_SubmitAll");
            if (nodes.length == 1 && nodes[0] instanceof TaskContainerNode && (n = (TaskContainerNode)nodes[0]).getTasks(true).size() == 1 && n instanceof TaskNode) {
                name = NbBundle.getMessage(Actions.class, (String)"CTL_Submit");
            }
            return new SubmitAction(submitables, name);
        }
    }

    public static class MarkSeenAction
    extends AbstractAction {
        private final boolean setAsSeen;
        private final List<IssueImpl> tasks;
        private boolean canceled = false;

        private MarkSeenAction(boolean setAsSeen, List<IssueImpl> tasks) {
            super(setAsSeen ? NbBundle.getMessage(Actions.class, (String)"CTL_MarkSeen") : NbBundle.getMessage(Actions.class, (String)"CTL_MarkUnseen"));
            this.setAsSeen = setAsSeen;
            this.tasks = tasks;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    ProgressHandle markProgress = MarkSeenAction.this.getProgress();
                    markProgress.start(MarkSeenAction.this.tasks.size());
                    int workunits = 0;
                    for (IssueImpl task : MarkSeenAction.this.tasks) {
                        if (MarkSeenAction.this.canceled) break;
                        markProgress.progress(NbBundle.getMessage(Actions.class, (String)"LBL_MarkTaskProgress", (Object)task.getDisplayName()));
                        task.setSeen(MarkSeenAction.this.setAsSeen);
                        markProgress.progress(++workunits);
                    }
                    markProgress.finish();
                }
            });
        }

        static MarkSeenAction createAction(TreeListNode ... nodes) {
            ArrayList<IssueImpl> tasks = new ArrayList<IssueImpl>();
            for (TreeListNode n : nodes) {
                if (!(n instanceof TaskContainerNode)) {
                    return null;
                }
                tasks.addAll(((TaskContainerNode)n).getTasks(true));
            }
            boolean statusSupported = true;
            boolean setAsSeen = false;
            for (IssueImpl issue : tasks) {
                if (!issue.hasStatus()) {
                    statusSupported = false;
                }
                if (issue.getStatus().equals((Object)IssueStatusProvider.Status.SEEN)) continue;
                setAsSeen = true;
            }
            MarkSeenAction markSeenAction = new MarkSeenAction(setAsSeen, tasks);
            markSeenAction.setEnabled(statusSupported);
            return markSeenAction;
        }

        private ProgressHandle getProgress() {
            return ProgressHandleFactory.createHandle((String)NbBundle.getMessage(Actions.class, (String)(this.setAsSeen ? "LBL_MarkSeenAllProgress" : "LBL_MarkUnseenAllProgress")), (Cancellable)new Cancellable(){

                public boolean cancel() {
                    MarkSeenAction.this.canceled = true;
                    return MarkSeenAction.this.canceled;
                }
            });
        }
    }

    public static class RefreshAction
    extends AbstractAction {
        private final WeakSet<Refreshable> nodes;

        private RefreshAction(List<Refreshable> nodes) {
            super(NbBundle.getMessage(Actions.class, (String)"CTL_Refresh"));
            this.putValue("AcceleratorKey", REFRESH_KEY);
            this.nodes = new WeakSet(nodes);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (Refreshable refreshableNode : this.nodes) {
                refreshableNode.refreshContent();
            }
        }

        public static RefreshAction createAction(TreeListNode ... nodes) {
            ArrayList<Refreshable> refreshables = new ArrayList<Refreshable>();
            for (TreeListNode n : nodes) {
                if (!(n instanceof Refreshable)) {
                    return null;
                }
                refreshables.add((Refreshable)n);
            }
            return new RefreshAction(refreshables);
        }
    }
}

