/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.ui.query;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.QueryImpl;
import org.netbeans.modules.bugtracking.RepositoryImpl;
import org.netbeans.modules.bugtracking.commons.UIUtils;
import org.netbeans.modules.bugtracking.spi.QueryController;
import org.netbeans.modules.bugtracking.ui.query.QueryTopComponent;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class QueryAction
extends SystemAction {
    public QueryAction() {
        this.setIcon(null);
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public String getName() {
        return NbBundle.getMessage(QueryAction.class, (String)"CTL_QueryAction");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(QueryAction.class);
    }

    public void actionPerformed(ActionEvent ev) {
        QueryAction.createNewQuery(null);
    }

    public static void createNewQuery(RepositoryImpl repositoryToSelect) {
        QueryAction.openQuery(null, repositoryToSelect, repositoryToSelect != null, QueryController.QueryMode.EDIT, true);
    }

    public static void createNewQuery(RepositoryImpl repositoryToSelect, boolean suggestedSelectionOnly) {
        QueryAction.openQuery(null, repositoryToSelect, suggestedSelectionOnly, QueryController.QueryMode.EDIT, true);
    }

    public static void openQuery(QueryImpl query, RepositoryImpl repository, QueryController.QueryMode mode) {
        QueryAction.openQuery(query, repository, false, mode, false);
    }

    private static void openQuery(final QueryImpl query, final RepositoryImpl repository, final boolean suggestedSelectionOnly, final QueryController.QueryMode mode, final boolean isNew) {
        BugtrackingManager.getInstance().getRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                final File file = BugtrackingUtil.getLargerSelection();
                SwingUtilities.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        BugtrackingManager.LOG.log(Level.FINE, "QueryAction.openQuery start. query [{0}]", new Object[]{query != null ? query.getDisplayName() : null});
                        UIUtils.setWaitCursor((boolean)true);
                        try {
                            QueryTopComponent tc = null;
                            if (query != null) {
                                tc = QueryTopComponent.find(query);
                            }
                            if (tc == null) {
                                tc = new QueryTopComponent();
                                tc.init(query, repository, file, suggestedSelectionOnly, mode, isNew);
                            } else {
                                tc.setMode(mode);
                            }
                            if (!tc.isOpened()) {
                                tc.open();
                            }
                            tc.requestActive();
                            BugtrackingManager.LOG.log(Level.FINE, "QueryAction.openQuery finnish. query [{0}]", new Object[]{query != null ? query.getDisplayName() : null});
                        }
                        finally {
                            UIUtils.setWaitCursor((boolean)false);
                        }
                    }
                });
            }
        });
    }

    public static void closeQuery(final QueryImpl query) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TopComponent tc = null;
                if (query != null) {
                    tc = WindowManager.getDefault().findTopComponent(query.getDisplayName());
                }
                if (tc != null) {
                    tc.close();
                }
            }
        });
    }
}

