/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Rectangle;

class Area {
    public int x0;
    public int y0;
    public int x1;
    public int y1;

    public Area() {
        this.clear();
    }

    public Area(int width, int height) {
        this(0, 0, width - 1, height - 1);
    }

    public Area(int x0, int y0, int x1, int y1) {
        this.x0 = x0;
        this.y0 = y0;
        this.x1 = x1;
        this.y1 = y1;
    }

    public void clear() {
        this.x0 = Integer.MAX_VALUE;
        this.y0 = Integer.MAX_VALUE;
        this.x1 = -1;
        this.y1 = -1;
    }

    public void add(int newx, int newy) {
        this.x0 = Math.min(this.x0, newx);
        this.x1 = Math.max(this.x1, newx);
        this.y0 = Math.min(this.y0, newy);
        this.y1 = Math.max(this.y1, newy);
    }

    public void add(Rectangle r) {
        if ((r.x | r.width | r.y | r.height) >= 0) {
            this.x0 = Math.min(this.x0, r.x);
            this.x1 = Math.max(this.x1, r.x + r.width - 1);
            this.y0 = Math.min(this.y0, r.y);
            this.y1 = Math.max(this.y1, r.y + r.height - 1);
        }
    }

    public boolean isEmpty() {
        return this.x1 < this.x0 || this.y1 < this.y0;
    }

    public Area getBounds() {
        return new Area(this.x0, this.y0, this.x1, this.y1);
    }
}

