/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.node;

import com.carrotsearch.hppc.ObjectHashSet;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import com.google.common.collect.UnmodifiableIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.AbstractDiffable;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.transport.TransportAddress;

public class DiscoveryNodes
extends AbstractDiffable<DiscoveryNodes>
implements Iterable<DiscoveryNode> {
    public static final DiscoveryNodes EMPTY_NODES;
    public static final DiscoveryNodes PROTO;
    private final ImmutableOpenMap<String, DiscoveryNode> nodes;
    private final ImmutableOpenMap<String, DiscoveryNode> dataNodes;
    private final ImmutableOpenMap<String, DiscoveryNode> masterNodes;
    private final String masterNodeId;
    private final String localNodeId;
    private final Version minNodeVersion;
    private final Version minNonClientNodeVersion;

    private DiscoveryNodes(ImmutableOpenMap<String, DiscoveryNode> nodes, ImmutableOpenMap<String, DiscoveryNode> dataNodes, ImmutableOpenMap<String, DiscoveryNode> masterNodes, String masterNodeId, String localNodeId, Version minNodeVersion, Version minNonClientNodeVersion) {
        this.nodes = nodes;
        this.dataNodes = dataNodes;
        this.masterNodes = masterNodes;
        this.masterNodeId = masterNodeId;
        this.localNodeId = localNodeId;
        this.minNodeVersion = minNodeVersion;
        this.minNonClientNodeVersion = minNonClientNodeVersion;
    }

    @Override
    public UnmodifiableIterator<DiscoveryNode> iterator() {
        return this.nodes.valuesIt();
    }

    public boolean valid() {
        return this.localNodeId != null;
    }

    public boolean localNodeMaster() {
        if (this.localNodeId == null) {
            return false;
        }
        return this.localNodeId.equals(this.masterNodeId);
    }

    public int size() {
        return this.nodes.size();
    }

    public int getSize() {
        return this.size();
    }

    public ImmutableOpenMap<String, DiscoveryNode> nodes() {
        return this.nodes;
    }

    public ImmutableOpenMap<String, DiscoveryNode> getNodes() {
        return this.nodes();
    }

    public ImmutableOpenMap<String, DiscoveryNode> dataNodes() {
        return this.dataNodes;
    }

    public ImmutableOpenMap<String, DiscoveryNode> getDataNodes() {
        return this.dataNodes();
    }

    public ImmutableOpenMap<String, DiscoveryNode> masterNodes() {
        return this.masterNodes;
    }

    public ImmutableOpenMap<String, DiscoveryNode> getMasterNodes() {
        return this.masterNodes();
    }

    public ImmutableOpenMap<String, DiscoveryNode> masterAndDataNodes() {
        ImmutableOpenMap.Builder<String, DiscoveryNode> nodes = ImmutableOpenMap.builder(this.dataNodes);
        nodes.putAll(this.masterNodes);
        return nodes.build();
    }

    public DiscoveryNode get(String nodeId) {
        return this.nodes.get(nodeId);
    }

    public boolean nodeExists(String nodeId) {
        return this.nodes.containsKey(nodeId);
    }

    public String masterNodeId() {
        return this.masterNodeId;
    }

    public String getMasterNodeId() {
        return this.masterNodeId();
    }

    public String localNodeId() {
        return this.localNodeId;
    }

    public String getLocalNodeId() {
        return this.localNodeId();
    }

    public DiscoveryNode localNode() {
        return this.nodes.get(this.localNodeId);
    }

    public DiscoveryNode getLocalNode() {
        return this.localNode();
    }

    public DiscoveryNode masterNode() {
        return this.nodes.get(this.masterNodeId);
    }

    public DiscoveryNode getMasterNode() {
        return this.masterNode();
    }

    public DiscoveryNode findByAddress(TransportAddress address) {
        for (ObjectCursor cursor : this.nodes.values()) {
            DiscoveryNode node = (DiscoveryNode)cursor.value;
            if (!node.address().equals(address)) continue;
            return node;
        }
        return null;
    }

    public boolean isAllNodes(String ... nodesIds) {
        return nodesIds == null || nodesIds.length == 0 || nodesIds.length == 1 && nodesIds[0].equals("_all");
    }

    public Version smallestVersion() {
        return this.minNodeVersion;
    }

    public Version smallestNonClientNodeVersion() {
        return this.minNonClientNodeVersion;
    }

    public DiscoveryNode resolveNode(String node) {
        String[] resolvedNodeIds = this.resolveNodesIds(node);
        if (resolvedNodeIds.length > 1) {
            throw new IllegalArgumentException("resolved [" + node + "] into [" + resolvedNodeIds.length + "] nodes, where expected to be resolved to a single node");
        }
        if (resolvedNodeIds.length == 0) {
            throw new IllegalArgumentException("failed to resolve [" + node + " ], no matching nodes");
        }
        return this.nodes.get(resolvedNodeIds[0]);
    }

    public String[] resolveNodesIds(String ... nodesIds) {
        if (this.isAllNodes(nodesIds)) {
            int index = 0;
            nodesIds = new String[this.nodes.size()];
            for (DiscoveryNode node : this) {
                nodesIds[index++] = node.id();
            }
            return nodesIds;
        }
        ObjectHashSet resolvedNodesIds = new ObjectHashSet(nodesIds.length);
        for (String nodeId : nodesIds) {
            if (nodeId.equals("_local")) {
                String localNodeId = this.localNodeId();
                if (localNodeId == null) continue;
                resolvedNodesIds.add((Object)localNodeId);
                continue;
            }
            if (nodeId.equals("_master")) {
                String masterNodeId = this.masterNodeId();
                if (masterNodeId == null) continue;
                resolvedNodesIds.add((Object)masterNodeId);
                continue;
            }
            if (this.nodeExists(nodeId)) {
                resolvedNodesIds.add((Object)nodeId);
                continue;
            }
            for (DiscoveryNode node : this) {
                if (!Regex.simpleMatch(nodeId, node.name())) continue;
                resolvedNodesIds.add((Object)node.id());
            }
            for (DiscoveryNode node : this) {
                if (Regex.simpleMatch(nodeId, node.getHostAddress())) {
                    resolvedNodesIds.add((Object)node.id());
                    continue;
                }
                if (!Regex.simpleMatch(nodeId, node.getHostName())) continue;
                resolvedNodesIds.add((Object)node.id());
            }
            int index = nodeId.indexOf(58);
            if (index == -1) continue;
            String matchAttrName = nodeId.substring(0, index);
            String matchAttrValue = nodeId.substring(index + 1);
            if ("data".equals(matchAttrName)) {
                if (Booleans.parseBoolean(matchAttrValue, true)) {
                    resolvedNodesIds.addAll(this.dataNodes.keys());
                    continue;
                }
                resolvedNodesIds.removeAll(this.dataNodes.keys());
                continue;
            }
            if ("master".equals(matchAttrName)) {
                if (Booleans.parseBoolean(matchAttrValue, true)) {
                    resolvedNodesIds.addAll(this.masterNodes.keys());
                    continue;
                }
                resolvedNodesIds.removeAll(this.masterNodes.keys());
                continue;
            }
            for (DiscoveryNode node : this) {
                for (Map.Entry entry : node.attributes().entrySet()) {
                    String attrName = (String)entry.getKey();
                    String attrValue = (String)entry.getValue();
                    if (!Regex.simpleMatch(matchAttrName, attrName) || !Regex.simpleMatch(matchAttrValue, attrValue)) continue;
                    resolvedNodesIds.add((Object)node.id());
                }
            }
        }
        return (String[])resolvedNodesIds.toArray(String.class);
    }

    public DiscoveryNodes removeDeadMembers(Set<String> newNodes, String masterNodeId) {
        Builder builder = new Builder().masterNodeId(masterNodeId).localNodeId(this.localNodeId);
        for (DiscoveryNode node : this) {
            if (!newNodes.contains(node.id())) continue;
            builder.put(node);
        }
        return builder.build();
    }

    public DiscoveryNodes newNode(DiscoveryNode node) {
        return new Builder(this).put(node).build();
    }

    public Delta delta(DiscoveryNodes other) {
        ArrayList<DiscoveryNode> removed = new ArrayList<DiscoveryNode>();
        ArrayList<DiscoveryNode> added = new ArrayList<DiscoveryNode>();
        for (DiscoveryNode node : other) {
            if (this.nodeExists(node.id())) continue;
            removed.add(node);
        }
        for (DiscoveryNode node : this) {
            if (other.nodeExists(node.id())) continue;
            added.add(node);
        }
        DiscoveryNode previousMasterNode = null;
        DiscoveryNode newMasterNode = null;
        if (!(this.masterNodeId == null || other.masterNodeId != null && other.masterNodeId.equals(this.masterNodeId))) {
            previousMasterNode = other.masterNode();
            newMasterNode = this.masterNode();
        }
        return new Delta(previousMasterNode, newMasterNode, this.localNodeId, Collections.unmodifiableList(removed), Collections.unmodifiableList(added));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (DiscoveryNode node : this) {
            sb.append(node).append(',');
        }
        sb.append("}");
        return sb.toString();
    }

    public String prettyPrint() {
        StringBuilder sb = new StringBuilder();
        sb.append("nodes: \n");
        for (DiscoveryNode node : this) {
            sb.append("   ").append(node);
            if (node == this.localNode()) {
                sb.append(", local");
            }
            if (node == this.masterNode()) {
                sb.append(", master");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public Delta emptyDelta() {
        return new Delta(null, null, this.localNodeId, DiscoveryNode.EMPTY_LIST, DiscoveryNode.EMPTY_LIST);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (this.masterNodeId == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeString(this.masterNodeId);
        }
        out.writeVInt(this.nodes.size());
        for (DiscoveryNode node : this) {
            node.writeTo(out);
        }
    }

    public DiscoveryNodes readFrom(StreamInput in, DiscoveryNode localNode) throws IOException {
        Builder builder = new Builder();
        if (in.readBoolean()) {
            builder.masterNodeId(in.readString());
        }
        if (localNode != null) {
            builder.localNodeId(localNode.id());
        }
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            DiscoveryNode node = DiscoveryNode.readNode(in);
            if (localNode != null && node.id().equals(localNode.id())) {
                node = localNode;
            }
            builder.put(node);
        }
        return builder.build();
    }

    @Override
    public DiscoveryNodes readFrom(StreamInput in) throws IOException {
        return this.readFrom(in, this.localNode());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DiscoveryNodes nodes) {
        return new Builder(nodes);
    }

    static {
        PROTO = EMPTY_NODES = DiscoveryNodes.builder().build();
    }

    public static class Builder {
        private final ImmutableOpenMap.Builder<String, DiscoveryNode> nodes;
        private String masterNodeId;
        private String localNodeId;

        public Builder() {
            this.nodes = ImmutableOpenMap.builder();
        }

        public Builder(DiscoveryNodes nodes) {
            this.masterNodeId = nodes.masterNodeId();
            this.localNodeId = nodes.localNodeId();
            this.nodes = ImmutableOpenMap.builder(nodes.nodes());
        }

        public Builder put(DiscoveryNode node) {
            this.nodes.put(node.id(), node);
            return this;
        }

        public Builder remove(String nodeId) {
            this.nodes.remove(nodeId);
            return this;
        }

        public Builder masterNodeId(String masterNodeId) {
            this.masterNodeId = masterNodeId;
            return this;
        }

        public Builder localNodeId(String localNodeId) {
            this.localNodeId = localNodeId;
            return this;
        }

        public DiscoveryNodes build() {
            ImmutableOpenMap.Builder<Object, Object> dataNodesBuilder = ImmutableOpenMap.builder();
            ImmutableOpenMap.Builder<Object, Object> masterNodesBuilder = ImmutableOpenMap.builder();
            Version minNodeVersion = Version.CURRENT;
            Version minNonClientNodeVersion = Version.CURRENT;
            Iterator<ObjectObjectCursor<String, DiscoveryNode>> i$ = this.nodes.iterator();
            while (i$.hasNext()) {
                ObjectObjectCursor<String, DiscoveryNode> nodeEntry = i$.next();
                if (((DiscoveryNode)nodeEntry.value).dataNode()) {
                    dataNodesBuilder.put(nodeEntry.key, nodeEntry.value);
                    minNonClientNodeVersion = Version.smallest(minNonClientNodeVersion, ((DiscoveryNode)nodeEntry.value).version());
                }
                if (((DiscoveryNode)nodeEntry.value).masterNode()) {
                    masterNodesBuilder.put(nodeEntry.key, nodeEntry.value);
                    minNonClientNodeVersion = Version.smallest(minNonClientNodeVersion, ((DiscoveryNode)nodeEntry.value).version());
                }
                minNodeVersion = Version.smallest(minNodeVersion, ((DiscoveryNode)nodeEntry.value).version());
            }
            return new DiscoveryNodes(this.nodes.build(), dataNodesBuilder.build(), masterNodesBuilder.build(), this.masterNodeId, this.localNodeId, minNodeVersion, minNonClientNodeVersion);
        }

        public static DiscoveryNodes readFrom(StreamInput in, @Nullable DiscoveryNode localNode) throws IOException {
            return PROTO.readFrom(in, localNode);
        }
    }

    public static class Delta {
        private final String localNodeId;
        private final DiscoveryNode previousMasterNode;
        private final DiscoveryNode newMasterNode;
        private final List<DiscoveryNode> removed;
        private final List<DiscoveryNode> added;

        public Delta(String localNodeId, List<DiscoveryNode> removed, List<DiscoveryNode> added) {
            this(null, null, localNodeId, removed, added);
        }

        public Delta(@Nullable DiscoveryNode previousMasterNode, @Nullable DiscoveryNode newMasterNode, String localNodeId, List<DiscoveryNode> removed, List<DiscoveryNode> added) {
            this.previousMasterNode = previousMasterNode;
            this.newMasterNode = newMasterNode;
            this.localNodeId = localNodeId;
            this.removed = removed;
            this.added = added;
        }

        public boolean hasChanges() {
            return this.masterNodeChanged() || !this.removed.isEmpty() || !this.added.isEmpty();
        }

        public boolean masterNodeChanged() {
            return this.newMasterNode != null;
        }

        public DiscoveryNode previousMasterNode() {
            return this.previousMasterNode;
        }

        public DiscoveryNode newMasterNode() {
            return this.newMasterNode;
        }

        public boolean removed() {
            return !this.removed.isEmpty();
        }

        public List<DiscoveryNode> removedNodes() {
            return this.removed;
        }

        public boolean added() {
            return !this.added.isEmpty();
        }

        public List<DiscoveryNode> addedNodes() {
            return this.added;
        }

        public String shortSummary() {
            StringBuilder sb = new StringBuilder();
            if (!this.removed() && this.masterNodeChanged()) {
                if (this.newMasterNode.id().equals(this.localNodeId)) {
                    sb.append("new_master ").append(this.newMasterNode());
                } else {
                    sb.append("detected_master ").append(this.newMasterNode());
                }
            } else {
                if (this.masterNodeChanged()) {
                    sb.append("master {new ").append(this.newMasterNode());
                    if (this.previousMasterNode() != null) {
                        sb.append(", previous ").append(this.previousMasterNode());
                    }
                    sb.append("}");
                }
                if (this.removed()) {
                    if (this.masterNodeChanged()) {
                        sb.append(", ");
                    }
                    sb.append("removed {");
                    for (DiscoveryNode node : this.removedNodes()) {
                        sb.append(node).append(',');
                    }
                    sb.append("}");
                }
            }
            if (this.added() && (this.addedNodes().size() != 1 || !this.addedNodes().get(0).id().equals(this.localNodeId))) {
                if (this.removed() || this.masterNodeChanged()) {
                    sb.append(", ");
                }
                sb.append("added {");
                for (DiscoveryNode node : this.addedNodes()) {
                    if (node.id().equals(this.localNodeId)) continue;
                    sb.append(node).append(',');
                }
                sb.append("}");
            }
            return sb.toString();
        }
    }
}

