/**
 * WinPR: Windows Portable Runtime
 * Localization Functions
 *
 * Copyright 2014 Marc-Andre Moreau <marcandre.moreau@gmail.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef WINPR_LOCALE_H
#define WINPR_LOCALE_H

#include <winpr/winpr.h>
#include <winpr/wtypes.h>

#ifndef _WIN32

#include <stdio.h>
#include <stdarg.h>

#define LANG_NEUTRAL					0x00
#define LANG_INVARIANT					0x7f

#define LANG_AFRIKAANS					0x36
#define LANG_ALBANIAN					0x1c
#define LANG_ALSATIAN					0x84
#define LANG_AMHARIC					0x5e
#define LANG_ARABIC					0x01
#define LANG_ARMENIAN					0x2b
#define LANG_ASSAMESE					0x4d
#define LANG_AZERI					0x2c
#define LANG_AZERBAIJANI				0x2c
#define LANG_BANGLA					0x45
#define LANG_BASHKIR					0x6d
#define LANG_BASQUE					0x2d
#define LANG_BELARUSIAN					0x23
#define LANG_BENGALI					0x45
#define LANG_BRETON					0x7e
#define LANG_BOSNIAN					0x1a
#define LANG_BOSNIAN_NEUTRAL				0x781a
#define LANG_BULGARIAN					0x02
#define LANG_CATALAN					0x03
#define LANG_CENTRAL_KURDISH				0x92
#define LANG_CHEROKEE					0x5c
#define LANG_CHINESE					0x04
#define LANG_CHINESE_SIMPLIFIED				0x04
#define LANG_CHINESE_TRADITIONAL			0x7c04
#define LANG_CORSICAN					0x83
#define LANG_CROATIAN					0x1a
#define LANG_CZECH					0x05
#define LANG_DANISH					0x06
#define LANG_DARI					0x8c
#define LANG_DIVEHI					0x65
#define LANG_DUTCH					0x13
#define LANG_ENGLISH					0x09
#define LANG_ESTONIAN					0x25
#define LANG_FAEROESE					0x38
#define LANG_FARSI					0x29
#define LANG_FILIPINO					0x64
#define LANG_FINNISH					0x0b
#define LANG_FRENCH					0x0c
#define LANG_FRISIAN					0x62
#define LANG_FULAH					0x67
#define LANG_GALICIAN					0x56
#define LANG_GEORGIAN					0x37
#define LANG_GERMAN					0x07
#define LANG_GREEK					0x08
#define LANG_GREENLANDIC				0x6f
#define LANG_GUJARATI					0x47
#define LANG_HAUSA					0x68
#define LANG_HAWAIIAN					0x75
#define LANG_HEBREW					0x0d
#define LANG_HINDI					0x39
#define LANG_HUNGARIAN					0x0e
#define LANG_ICELANDIC					0x0f
#define LANG_IGBO					0x70
#define LANG_INDONESIAN					0x21
#define LANG_INUKTITUT					0x5d
#define LANG_IRISH					0x3c
#define LANG_ITALIAN					0x10
#define LANG_JAPANESE					0x11
#define LANG_KANNADA					0x4b
#define LANG_KASHMIRI					0x60
#define LANG_KAZAK					0x3f
#define LANG_KHMER					0x53
#define LANG_KICHE					0x86
#define LANG_KINYARWANDA				0x87
#define LANG_KONKANI					0x57
#define LANG_KOREAN					0x12
#define LANG_KYRGYZ					0x40
#define LANG_LAO					0x54
#define LANG_LATVIAN					0x26
#define LANG_LITHUANIAN					0x27
#define LANG_LOWER_SORBIAN				0x2e
#define LANG_LUXEMBOURGISH				0x6e
#define LANG_MACEDONIAN					0x2f
#define LANG_MALAY					0x3e
#define LANG_MALAYALAM					0x4c
#define LANG_MALTESE					0x3a
#define LANG_MANIPURI					0x58
#define LANG_MAORI					0x81
#define LANG_MAPUDUNGUN					0x7a
#define LANG_MARATHI					0x4e
#define LANG_MOHAWK					0x7c
#define LANG_MONGOLIAN					0x50
#define LANG_NEPALI					0x61
#define LANG_NORWEGIAN					0x14
#define LANG_OCCITAN					0x82
#define LANG_ODIA					0x48
#define LANG_ORIYA					0x48
#define LANG_PASHTO					0x63
#define LANG_PERSIAN					0x29
#define LANG_POLISH					0x15
#define LANG_PORTUGUESE					0x16
#define LANG_PULAR					0x67
#define LANG_PUNJABI					0x46
#define LANG_QUECHUA					0x6b
#define LANG_ROMANIAN					0x18
#define LANG_ROMANSH					0x17
#define LANG_RUSSIAN					0x19
#define LANG_SAKHA					0x85
#define LANG_SAMI					0x3b
#define LANG_SANSKRIT					0x4f
#define LANG_SCOTTISH_GAELIC				0x91
#define LANG_SERBIAN					0x1a
#define LANG_SERBIAN_NEUTRAL				0x7c1a
#define LANG_SINDHI					0x59
#define LANG_SINHALESE					0x5b
#define LANG_SLOVAK					0x1b
#define LANG_SLOVENIAN					0x24
#define LANG_SOTHO					0x6c
#define LANG_SPANISH					0x0a
#define LANG_SWAHILI					0x41
#define LANG_SWEDISH					0x1d
#define LANG_SYRIAC					0x5a
#define LANG_TAJIK					0x28
#define LANG_TAMAZIGHT					0x5f
#define LANG_TAMIL					0x49
#define LANG_TATAR					0x44
#define LANG_TELUGU					0x4a
#define LANG_THAI					0x1e
#define LANG_TIBETAN					0x51
#define LANG_TIGRIGNA					0x73
#define LANG_TIGRINYA					0x73
#define LANG_TSWANA					0x32
#define LANG_TURKISH					0x1f
#define LANG_TURKMEN					0x42
#define LANG_UIGHUR					0x80
#define LANG_UKRAINIAN					0x22
#define LANG_UPPER_SORBIAN				0x2e
#define LANG_URDU					0x20
#define LANG_UZBEK					0x43
#define LANG_VALENCIAN					0x03
#define LANG_VIETNAMESE					0x2a
#define LANG_WELSH					0x52
#define LANG_WOLOF					0x88
#define LANG_XHOSA					0x34
#define LANG_YAKUT					0x85
#define LANG_YI						0x78
#define LANG_YORUBA					0x6a
#define LANG_ZULU					0x35

#define SUBLANG_NEUTRAL						0x00
#define SUBLANG_DEFAULT						0x01
#define SUBLANG_SYS_DEFAULT					0x02
#define SUBLANG_CUSTOM_DEFAULT					0x03
#define SUBLANG_CUSTOM_UNSPECIFIED				0x04
#define SUBLANG_UI_CUSTOM_DEFAULT				0x05

#define SUBLANG_AFRIKAANS_SOUTH_AFRICA				0x01
#define SUBLANG_ALBANIAN_ALBANIA				0x01
#define SUBLANG_ALSATIAN_FRANCE					0x01
#define SUBLANG_AMHARIC_ETHIOPIA				0x01
#define SUBLANG_ARABIC_SAUDI_ARABIA				0x01
#define SUBLANG_ARABIC_IRAQ					0x02
#define SUBLANG_ARABIC_EGYPT					0x03
#define SUBLANG_ARABIC_LIBYA					0x04
#define SUBLANG_ARABIC_ALGERIA					0x05
#define SUBLANG_ARABIC_MOROCCO					0x06
#define SUBLANG_ARABIC_TUNISIA					0x07
#define SUBLANG_ARABIC_OMAN					0x08
#define SUBLANG_ARABIC_YEMEN					0x09
#define SUBLANG_ARABIC_SYRIA					0x0a
#define SUBLANG_ARABIC_JORDAN					0x0b
#define SUBLANG_ARABIC_LEBANON					0x0c
#define SUBLANG_ARABIC_KUWAIT					0x0d
#define SUBLANG_ARABIC_UAE					0x0e
#define SUBLANG_ARABIC_BAHRAIN					0x0f
#define SUBLANG_ARABIC_QATAR					0x10
#define SUBLANG_ARMENIAN_ARMENIA				0x01
#define SUBLANG_ASSAMESE_INDIA					0x01
#define SUBLANG_AZERI_LATIN					0x01
#define SUBLANG_AZERI_CYRILLIC					0x02
#define SUBLANG_AZERBAIJANI_AZERBAIJAN_LATIN			0x01
#define SUBLANG_AZERBAIJANI_AZERBAIJAN_CYRILLIC			0x02
#define SUBLANG_BANGLA_INDIA					0x01
#define SUBLANG_BANGLA_BANGLADESH				0x02
#define SUBLANG_BASHKIR_RUSSIA					0x01
#define SUBLANG_BASQUE_BASQUE					0x01
#define SUBLANG_BELARUSIAN_BELARUS				0x01
#define SUBLANG_BENGALI_INDIA					0x01
#define SUBLANG_BENGALI_BANGLADESH				0x02
#define SUBLANG_BOSNIAN_BOSNIA_HERZEGOVINA_LATIN		0x05
#define SUBLANG_BOSNIAN_BOSNIA_HERZEGOVINA_CYRILLIC		0x08
#define SUBLANG_BRETON_FRANCE					0x01
#define SUBLANG_BULGARIAN_BULGARIA				0x01
#define SUBLANG_CATALAN_CATALAN					0x01
#define SUBLANG_CENTRAL_KURDISH_IRAQ				0x01
#define SUBLANG_CHEROKEE_CHEROKEE				0x01
#define SUBLANG_CHINESE_TRADITIONAL				0x01
#define SUBLANG_CHINESE_SIMPLIFIED				0x02
#define SUBLANG_CHINESE_HONGKONG				0x03
#define SUBLANG_CHINESE_SINGAPORE				0x04
#define SUBLANG_CHINESE_MACAU					0x05
#define SUBLANG_CORSICAN_FRANCE					0x01
#define SUBLANG_CZECH_CZECH_REPUBLIC				0x01
#define SUBLANG_CROATIAN_CROATIA				0x01
#define SUBLANG_CROATIAN_BOSNIA_HERZEGOVINA_LATIN		0x04
#define SUBLANG_DANISH_DENMARK					0x01
#define SUBLANG_DARI_AFGHANISTAN				0x01
#define SUBLANG_DIVEHI_MALDIVES					0x01
#define SUBLANG_DUTCH						0x01
#define SUBLANG_DUTCH_BELGIAN					0x02
#define SUBLANG_ENGLISH_US					0x01
#define SUBLANG_ENGLISH_UK					0x02
#define SUBLANG_ENGLISH_AUS					0x03
#define SUBLANG_ENGLISH_CAN					0x04
#define SUBLANG_ENGLISH_NZ					0x05
#define SUBLANG_ENGLISH_EIRE					0x06
#define SUBLANG_ENGLISH_SOUTH_AFRICA				0x07
#define SUBLANG_ENGLISH_JAMAICA					0x08
#define SUBLANG_ENGLISH_CARIBBEAN				0x09
#define SUBLANG_ENGLISH_BELIZE					0x0a
#define SUBLANG_ENGLISH_TRINIDAD				0x0b
#define SUBLANG_ENGLISH_ZIMBABWE				0x0c
#define SUBLANG_ENGLISH_PHILIPPINES				0x0d
#define SUBLANG_ENGLISH_INDIA					0x10
#define SUBLANG_ENGLISH_MALAYSIA				0x11
#define SUBLANG_ENGLISH_SINGAPORE				0x12
#define SUBLANG_ESTONIAN_ESTONIA				0x01
#define SUBLANG_FAEROESE_FAROE_ISLANDS				0x01
#define SUBLANG_FILIPINO_PHILIPPINES				0x01
#define SUBLANG_FINNISH_FINLAND					0x01
#define SUBLANG_FRENCH						0x01
#define SUBLANG_FRENCH_BELGIAN					0x02
#define SUBLANG_FRENCH_CANADIAN					0x03
#define SUBLANG_FRENCH_SWISS					0x04
#define SUBLANG_FRENCH_LUXEMBOURG				0x05
#define SUBLANG_FRENCH_MONACO					0x06
#define SUBLANG_FRISIAN_NETHERLANDS				0x01
#define SUBLANG_FULAH_SENEGAL					0x02
#define SUBLANG_GALICIAN_GALICIAN				0x01
#define SUBLANG_GEORGIAN_GEORGIA				0x01
#define SUBLANG_GERMAN						0x01
#define SUBLANG_GERMAN_SWISS					0x02
#define SUBLANG_GERMAN_AUSTRIAN					0x03
#define SUBLANG_GERMAN_LUXEMBOURG				0x04
#define SUBLANG_GERMAN_LIECHTENSTEIN				0x05
#define SUBLANG_GREEK_GREECE					0x01
#define SUBLANG_GREENLANDIC_GREENLAND				0x01
#define SUBLANG_GUJARATI_INDIA					0x01
#define SUBLANG_HAUSA_NIGERIA_LATIN				0x01
#define SUBLANG_HAWAIIAN_US					0x01
#define SUBLANG_HEBREW_ISRAEL					0x01
#define SUBLANG_HINDI_INDIA					0x01
#define SUBLANG_HUNGARIAN_HUNGARY				0x01
#define SUBLANG_ICELANDIC_ICELAND				0x01
#define SUBLANG_IGBO_NIGERIA					0x01
#define SUBLANG_INDONESIAN_INDONESIA				0x01
#define SUBLANG_INUKTITUT_CANADA				0x01
#define SUBLANG_INUKTITUT_CANADA_LATIN				0x02
#define SUBLANG_IRISH_IRELAND					0x02
#define SUBLANG_ITALIAN						0x01
#define SUBLANG_ITALIAN_SWISS					0x02
#define SUBLANG_JAPANESE_JAPAN					0x01
#define SUBLANG_KANNADA_INDIA					0x01
#define SUBLANG_KASHMIRI_SASIA					0x02
#define SUBLANG_KASHMIRI_INDIA					0x02
#define SUBLANG_KAZAK_KAZAKHSTAN				0x01
#define SUBLANG_KHMER_CAMBODIA					0x01
#define SUBLANG_KICHE_GUATEMALA					0x01
#define SUBLANG_KINYARWANDA_RWANDA				0x01
#define SUBLANG_KONKANI_INDIA					0x01
#define SUBLANG_KOREAN						0x01
#define SUBLANG_KYRGYZ_KYRGYZSTAN				0x01
#define SUBLANG_LAO_LAO						0x01
#define SUBLANG_LATVIAN_LATVIA					0x01
#define SUBLANG_LITHUANIAN					0x01
#define SUBLANG_LOWER_SORBIAN_GERMANY				0x02
#define SUBLANG_LUXEMBOURGISH_LUXEMBOURG			0x01
#define SUBLANG_MACEDONIAN_MACEDONIA				0x01
#define SUBLANG_MALAY_MALAYSIA					0x01
#define SUBLANG_MALAY_BRUNEI_DARUSSALAM				0x02
#define SUBLANG_MALAYALAM_INDIA					0x01
#define SUBLANG_MALTESE_MALTA					0x01
#define SUBLANG_MAORI_NEW_ZEALAND				0x01
#define SUBLANG_MAPUDUNGUN_CHILE				0x01
#define SUBLANG_MARATHI_INDIA					0x01
#define SUBLANG_MOHAWK_MOHAWK					0x01
#define SUBLANG_MONGOLIAN_CYRILLIC_MONGOLIA			0x01
#define SUBLANG_MONGOLIAN_PRC					0x02
#define SUBLANG_NEPALI_INDIA					0x02
#define SUBLANG_NEPALI_NEPAL					0x01
#define SUBLANG_NORWEGIAN_BOKMAL				0x01
#define SUBLANG_NORWEGIAN_NYNORSK				0x02
#define SUBLANG_OCCITAN_FRANCE					0x01
#define SUBLANG_ODIA_INDIA					0x01
#define SUBLANG_ORIYA_INDIA					0x01
#define SUBLANG_PASHTO_AFGHANISTAN				0x01
#define SUBLANG_PERSIAN_IRAN					0x01
#define SUBLANG_POLISH_POLAND					0x01
#define SUBLANG_PORTUGUESE					0x02
#define SUBLANG_PORTUGUESE_BRAZILIAN				0x01
#define SUBLANG_PULAR_SENEGAL					0x02
#define SUBLANG_PUNJABI_INDIA					0x01
#define SUBLANG_PUNJABI_PAKISTAN				0x02
#define SUBLANG_QUECHUA_BOLIVIA					0x01
#define SUBLANG_QUECHUA_ECUADOR					0x02
#define SUBLANG_QUECHUA_PERU					0x03
#define SUBLANG_ROMANIAN_ROMANIA				0x01
#define SUBLANG_ROMANSH_SWITZERLAND				0x01
#define SUBLANG_RUSSIAN_RUSSIA					0x01
#define SUBLANG_SAKHA_RUSSIA					0x01
#define SUBLANG_SAMI_NORTHERN_NORWAY				0x01
#define SUBLANG_SAMI_NORTHERN_SWEDEN				0x02
#define SUBLANG_SAMI_NORTHERN_FINLAND				0x03
#define SUBLANG_SAMI_LULE_NORWAY				0x04
#define SUBLANG_SAMI_LULE_SWEDEN				0x05
#define SUBLANG_SAMI_SOUTHERN_NORWAY				0x06
#define SUBLANG_SAMI_SOUTHERN_SWEDEN				0x07
#define SUBLANG_SAMI_SKOLT_FINLAND				0x08
#define SUBLANG_SAMI_INARI_FINLAND				0x09
#define SUBLANG_SANSKRIT_INDIA					0x01
#define SUBLANG_SCOTTISH_GAELIC					0x01
#define SUBLANG_SERBIAN_BOSNIA_HERZEGOVINA_LATIN		0x06
#define SUBLANG_SERBIAN_BOSNIA_HERZEGOVINA_CYRILLIC		0x07
#define SUBLANG_SERBIAN_MONTENEGRO_LATIN			0x0b
#define SUBLANG_SERBIAN_MONTENEGRO_CYRILLIC			0x0c
#define SUBLANG_SERBIAN_SERBIA_LATIN				0x09
#define SUBLANG_SERBIAN_SERBIA_CYRILLIC				0x0a
#define SUBLANG_SERBIAN_CROATIA					0x01
#define SUBLANG_SERBIAN_LATIN					0x02
#define SUBLANG_SERBIAN_CYRILLIC				0x03
#define SUBLANG_SINDHI_INDIA					0x01
#define SUBLANG_SINDHI_PAKISTAN					0x02
#define SUBLANG_SINDHI_AFGHANISTAN				0x02
#define SUBLANG_SINHALESE_SRI_LANKA				0x01
#define SUBLANG_SOTHO_NORTHERN_SOUTH_AFRICA			0x01
#define SUBLANG_SLOVAK_SLOVAKIA					0x01
#define SUBLANG_SLOVENIAN_SLOVENIA				0x01
#define SUBLANG_SPANISH						0x01
#define SUBLANG_SPANISH_MEXICAN					0x02
#define SUBLANG_SPANISH_MODERN					0x03
#define SUBLANG_SPANISH_GUATEMALA				0x04
#define SUBLANG_SPANISH_COSTA_RICA				0x05
#define SUBLANG_SPANISH_PANAMA					0x06
#define SUBLANG_SPANISH_DOMINICAN_REPUBLIC			0x07
#define SUBLANG_SPANISH_VENEZUELA				0x08
#define SUBLANG_SPANISH_COLOMBIA				0x09
#define SUBLANG_SPANISH_PERU					0x0a
#define SUBLANG_SPANISH_ARGENTINA				0x0b
#define SUBLANG_SPANISH_ECUADOR					0x0c
#define SUBLANG_SPANISH_CHILE					0x0d
#define SUBLANG_SPANISH_URUGUAY					0x0e
#define SUBLANG_SPANISH_PARAGUAY				0x0f
#define SUBLANG_SPANISH_BOLIVIA					0x10
#define SUBLANG_SPANISH_EL_SALVADOR				0x11
#define SUBLANG_SPANISH_HONDURAS				0x12
#define SUBLANG_SPANISH_NICARAGUA				0x13
#define SUBLANG_SPANISH_PUERTO_RICO				0x14
#define SUBLANG_SPANISH_US					0x15
#define SUBLANG_SWAHILI_KENYA					0x01
#define SUBLANG_SWEDISH						0x01
#define SUBLANG_SWEDISH_FINLAND					0x02
#define SUBLANG_SYRIAC_SYRIA					0x01
#define SUBLANG_TAJIK_TAJIKISTAN				0x01
#define SUBLANG_TAMAZIGHT_ALGERIA_LATIN				0x02
#define SUBLANG_TAMAZIGHT_MOROCCO_TIFINAGH			0x04
#define SUBLANG_TAMIL_INDIA					0x01
#define SUBLANG_TAMIL_SRI_LANKA					0x02
#define SUBLANG_TATAR_RUSSIA					0x01
#define SUBLANG_TELUGU_INDIA					0x01
#define SUBLANG_THAI_THAILAND					0x01
#define SUBLANG_TIBETAN_PRC					0x01
#define SUBLANG_TIGRIGNA_ERITREA				0x02
#define SUBLANG_TIGRINYA_ERITREA				0x02
#define SUBLANG_TIGRINYA_ETHIOPIA				0x01
#define SUBLANG_TSWANA_BOTSWANA					0x02
#define SUBLANG_TSWANA_SOUTH_AFRICA				0x01
#define SUBLANG_TURKISH_TURKEY					0x01
#define SUBLANG_TURKMEN_TURKMENISTAN				0x01
#define SUBLANG_UIGHUR_PRC					0x01
#define SUBLANG_UKRAINIAN_UKRAINE				0x01
#define SUBLANG_UPPER_SORBIAN_GERMANY				0x01
#define SUBLANG_URDU_PAKISTAN					0x01
#define SUBLANG_URDU_INDIA					0x02
#define SUBLANG_UZBEK_LATIN					0x01
#define SUBLANG_UZBEK_CYRILLIC					0x02
#define SUBLANG_VALENCIAN_VALENCIA				0x02
#define SUBLANG_VIETNAMESE_VIETNAM				0x01
#define SUBLANG_WELSH_UNITED_KINGDOM				0x01
#define SUBLANG_WOLOF_SENEGAL					0x01
#define SUBLANG_XHOSA_SOUTH_AFRICA				0x01
#define SUBLANG_YAKUT_RUSSIA					0x01
#define SUBLANG_YI_PRC						0x01
#define SUBLANG_YORUBA_NIGERIA					0x01
#define SUBLANG_ZULU_SOUTH_AFRICA				0x01

#define SORT_DEFAULT						0x0

#define SORT_INVARIANT_MATH					0x1

#define SORT_JAPANESE_XJIS					0x0
#define SORT_JAPANESE_UNICODE					0x1
#define SORT_JAPANESE_RADICALSTROKE				0x4

#define SORT_CHINESE_BIG5					0x0
#define SORT_CHINESE_PRCP					0x0
#define SORT_CHINESE_UNICODE					0x1
#define SORT_CHINESE_PRC					0x2
#define SORT_CHINESE_BOPOMOFO					0x3
#define SORT_CHINESE_RADICALSTROKE				0x4

#define SORT_KOREAN_KSC						0x0
#define SORT_KOREAN_UNICODE					0x1

#define SORT_GERMAN_PHONE_BOOK					0x1

#define SORT_HUNGARIAN_DEFAULT					0x0
#define SORT_HUNGARIAN_TECHNICAL				0x1

#define SORT_GEORGIAN_TRADITIONAL				0x0
#define SORT_GEORGIAN_MODERN					0x1

#define MAKELANGID(p, s)	((((WORD)(s)) << 10) | (WORD)(p))
#define PRIMARYLANGID(lgid)	((WORD)(lgid) & 0x3FF)
#define SUBLANGID(lgid)		((WORD)(lgid) >> 10)

#define NLS_VALID_LOCALE_MASK	0x000FFFFF

#define MAKELCID(lgid, srtid)	((DWORD)((((DWORD)((WORD)(srtid))) << 16) | ((DWORD)((WORD)(lgid)))))

#define MAKESORTLCID(lgid, srtid, ver) \
	((DWORD)((MAKELCID(lgid, srtid)) | (((DWORD)((WORD)(ver))) << 20)))

#define LANGIDFROMLCID(lcid)	((WORD)(lcid))
#define SORTIDFROMLCID(lcid)	((WORD)((((DWORD)(lcid)) >> 16) & 0xF))

#define SORTVERSIONFROMLCID(lcid)	((WORD)((((DWORD)(lcid)) >> 20) & 0xF))

#define LOCALE_NAME_MAX_LENGTH	85


#define LANG_SYSTEM_DEFAULT	(MAKELANGID(LANG_NEUTRAL, SUBLANG_SYS_DEFAULT))
#define LANG_USER_DEFAULT	(MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT))

#define LOCALE_SYSTEM_DEFAULT	(MAKELCID(LANG_SYSTEM_DEFAULT, SORT_DEFAULT))
#define LOCALE_USER_DEFAULT	(MAKELCID(LANG_USER_DEFAULT, SORT_DEFAULT))

#define LOCALE_CUSTOM_DEFAULT \
	(MAKELCID(MAKELANGID(LANG_NEUTRAL, SUBLANG_CUSTOM_DEFAULT), SORT_DEFAULT))

#define LOCALE_CUSTOM_UNSPECIFIED \
	(MAKELCID(MAKELANGID(LANG_NEUTRAL, SUBLANG_CUSTOM_UNSPECIFIED), SORT_DEFAULT))

#define LOCALE_CUSTOM_UI_DEFAULT \
	(MAKELCID(MAKELANGID(LANG_NEUTRAL, SUBLANG_UI_CUSTOM_DEFAULT), SORT_DEFAULT))

#define LOCALE_NEUTRAL \
	(MAKELCID(MAKELANGID(LANG_NEUTRAL, SUBLANG_NEUTRAL), SORT_DEFAULT))

#define LOCALE_INVARIANT \
	(MAKELCID(MAKELANGID(LANG_INVARIANT, SUBLANG_NEUTRAL), SORT_DEFAULT))

#ifdef __cplusplus
extern "C" {
#endif

DWORD WINAPI FormatMessageA(DWORD dwFlags, LPCVOID lpSource, DWORD dwMessageId, DWORD dwLanguageId,
			   LPSTR lpBuffer, DWORD nSize, va_list* Arguments);

DWORD WINAPI FormatMessageW(DWORD dwFlags, LPCVOID lpSource, DWORD dwMessageId, DWORD dwLanguageId,
			   LPWSTR lpBuffer, DWORD nSize, va_list* Arguments);

#ifdef UNICODE
#define FormatMessage	FormatMessageW
#else
#define FormatMessage	FormatMessageA
#endif

#ifdef __cplusplus
}
#endif

#endif

#endif /* WINPR_LOCALE_H */

