/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal.incremental;

import java.io.File;
import java.util.Set;
import org.gradle.internal.serialize.BaseSerializerFactory;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.ListSerializer;
import org.gradle.internal.serialize.MapSerializer;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.serialize.SetSerializer;
import org.gradle.language.nativeplatform.internal.Include;
import org.gradle.language.nativeplatform.internal.IncludeDirectives;
import org.gradle.language.nativeplatform.internal.IncludeType;
import org.gradle.language.nativeplatform.internal.incremental.CompilationFileState;
import org.gradle.language.nativeplatform.internal.incremental.CompilationState;
import org.gradle.language.nativeplatform.internal.incremental.ResolvedInclude;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.DefaultInclude;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.DefaultIncludeDirectives;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilationStateSerializer
implements Serializer<CompilationState> {
    private static final int SERIAL_VERSION = 1;
    private final BaseSerializerFactory serializerFactory = new BaseSerializerFactory();
    private final Serializer<File> fileSerializer = this.serializerFactory.getSerializerFor(File.class);
    private final ListSerializer<File> fileListSerializer = new ListSerializer(this.fileSerializer);
    private final MapSerializer<File, CompilationFileState> stateMapSerializer = new MapSerializer(this.fileSerializer, (Serializer)new CompilationFileStateSerializer());

    public CompilationState read(Decoder decoder) throws Exception {
        CompilationState compilationState = new CompilationState();
        int version = decoder.readInt();
        if (version != 1) {
            return compilationState;
        }
        compilationState.sourceInputs.addAll(this.fileListSerializer.read(decoder));
        compilationState.fileStates.putAll(this.stateMapSerializer.read(decoder));
        return compilationState;
    }

    public void write(Encoder encoder, CompilationState value) throws Exception {
        encoder.writeInt(1);
        this.fileListSerializer.write(encoder, value.sourceInputs);
        this.stateMapSerializer.write(encoder, value.fileStates);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IncludeSerializer
    implements Serializer<Include> {
        private final Serializer<String> stringSerializer;
        private final Serializer<Boolean> booleanSerializer;
        private final Serializer<IncludeType> enumSerializer;

        private IncludeSerializer() {
            this.stringSerializer = CompilationStateSerializer.this.serializerFactory.getSerializerFor(String.class);
            this.booleanSerializer = CompilationStateSerializer.this.serializerFactory.getSerializerFor(Boolean.class);
            this.enumSerializer = CompilationStateSerializer.this.serializerFactory.getSerializerFor(IncludeType.class);
        }

        public Include read(Decoder decoder) throws Exception {
            String value = (String)this.stringSerializer.read(decoder);
            boolean isImport = (Boolean)this.booleanSerializer.read(decoder);
            IncludeType type = (IncludeType)this.enumSerializer.read(decoder);
            return new DefaultInclude(value, isImport, type);
        }

        public void write(Encoder encoder, Include value) throws Exception {
            this.stringSerializer.write(encoder, (Object)value.getValue());
            this.booleanSerializer.write(encoder, (Object)value.isImport());
            this.enumSerializer.write(encoder, (Object)value.getType());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SourceIncludesSerializer
    implements Serializer<IncludeDirectives> {
        private final Serializer<Include> includeSerializer;
        private final ListSerializer<Include> includeListSerializer;

        private SourceIncludesSerializer() {
            this.includeSerializer = new IncludeSerializer();
            this.includeListSerializer = new ListSerializer(this.includeSerializer);
        }

        public IncludeDirectives read(Decoder decoder) throws Exception {
            DefaultIncludeDirectives sourceIncludes = new DefaultIncludeDirectives();
            sourceIncludes.addAll(this.includeListSerializer.read(decoder));
            return sourceIncludes;
        }

        public void write(Encoder encoder, IncludeDirectives value) throws Exception {
            this.includeListSerializer.write(encoder, value.getIncludesAndImports());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResolvedIncludeSerializer
    implements Serializer<ResolvedInclude> {
        private ResolvedIncludeSerializer() {
        }

        public ResolvedInclude read(Decoder decoder) throws Exception {
            String include = decoder.readString();
            File included = null;
            if (decoder.readBoolean()) {
                included = (File)CompilationStateSerializer.this.fileSerializer.read(decoder);
            }
            return new ResolvedInclude(include, included);
        }

        public void write(Encoder encoder, ResolvedInclude value) throws Exception {
            encoder.writeString((CharSequence)value.getInclude());
            if (value.getFile() == null) {
                encoder.writeBoolean(false);
            } else {
                encoder.writeBoolean(true);
                CompilationStateSerializer.this.fileSerializer.write(encoder, (Object)value.getFile());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HashSerializer
    implements Serializer<byte[]> {
        private HashSerializer() {
        }

        public byte[] read(Decoder decoder) throws Exception {
            int size = decoder.readSmallInt();
            byte[] value = new byte[size];
            decoder.readBytes(value);
            return value;
        }

        public void write(Encoder encoder, byte[] value) throws Exception {
            encoder.writeSmallInt(value.length);
            encoder.writeBytes(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CompilationFileStateSerializer
    implements Serializer<CompilationFileState> {
        private final Serializer<byte[]> hashSerializer;
        private final Serializer<Set<ResolvedInclude>> resolveIncludesSerializer;
        private final Serializer<IncludeDirectives> sourceIncludesSerializer;

        private CompilationFileStateSerializer() {
            this.hashSerializer = new HashSerializer();
            this.resolveIncludesSerializer = new SetSerializer((Serializer)new ResolvedIncludeSerializer());
            this.sourceIncludesSerializer = new SourceIncludesSerializer();
        }

        public CompilationFileState read(Decoder decoder) throws Exception {
            CompilationFileState fileState = new CompilationFileState((byte[])this.hashSerializer.read(decoder));
            fileState.setResolvedIncludes((Set)this.resolveIncludesSerializer.read(decoder));
            fileState.setIncludeDirectives((IncludeDirectives)this.sourceIncludesSerializer.read(decoder));
            return fileState;
        }

        public void write(Encoder encoder, CompilationFileState value) throws Exception {
            this.hashSerializer.write(encoder, (Object)value.getHash());
            this.resolveIncludesSerializer.write(encoder, value.getResolvedIncludes());
            this.sourceIncludesSerializer.write(encoder, (Object)value.getIncludeDirectives());
        }
    }
}

