/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.rules;

import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.rules.AbstractFileSnapshotTaskStateChanges;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshotter;
import org.gradle.api.internal.changedetection.state.TaskExecution;
import org.gradle.util.ChangeListener;

public class OutputFilesTaskStateChanges
extends AbstractFileSnapshotTaskStateChanges {
    private final TaskExecution previousExecution;
    private final TaskExecution currentExecution;
    private final TaskInternal task;
    private final FileCollectionSnapshotter outputFilesSnapshotter;
    private final FileCollectionSnapshot outputFilesBefore;

    public OutputFilesTaskStateChanges(TaskExecution previousExecution, TaskExecution currentExecution, TaskInternal task, FileCollectionSnapshotter outputFilesSnapshotter) {
        super(task.getName());
        this.previousExecution = previousExecution;
        this.currentExecution = currentExecution;
        this.task = task;
        this.outputFilesSnapshotter = outputFilesSnapshotter;
        this.outputFilesBefore = this.createSnapshot(outputFilesSnapshotter, task.getOutputs().getFiles());
    }

    protected String getInputFileType() {
        return "Output";
    }

    public FileCollectionSnapshot getPrevious() {
        return this.previousExecution.getOutputFilesSnapshot();
    }

    public FileCollectionSnapshot getCurrent() {
        return this.outputFilesBefore;
    }

    public void saveCurrent() {
        FileCollectionSnapshot lastExecutionOutputFiles = this.previousExecution == null || this.previousExecution.getOutputFilesSnapshot() == null ? this.outputFilesSnapshotter.emptySnapshot() : this.previousExecution.getOutputFilesSnapshot();
        FileCollectionSnapshot newOutputFiles = this.outputFilesBefore.changesSince(lastExecutionOutputFiles).applyTo(lastExecutionOutputFiles, new ChangeListener<FileCollectionSnapshot.Merge>(){

            @Override
            public void added(FileCollectionSnapshot.Merge element) {
                element.ignore();
            }

            @Override
            public void removed(FileCollectionSnapshot.Merge element) {
            }

            @Override
            public void changed(FileCollectionSnapshot.Merge element) {
            }
        });
        FileCollectionSnapshot outputFilesAfter = this.createSnapshot(this.outputFilesSnapshotter, this.task.getOutputs().getFiles());
        this.currentExecution.setOutputFilesSnapshot(outputFilesAfter.changesSince(this.outputFilesBefore).applyTo(newOutputFiles));
    }
}

