/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configuration;

import java.net.URI;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.initialization.ScriptHandlerFactory;
import org.gradle.api.internal.initialization.ScriptHandlerInternal;
import org.gradle.configuration.InitScriptProcessor;
import org.gradle.configuration.ScriptPlugin;
import org.gradle.configuration.ScriptPluginFactory;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.id.LongIdGenerator;

public class DefaultInitScriptProcessor
implements InitScriptProcessor {
    private final ScriptPluginFactory configurerFactory;
    private final ScriptHandlerFactory scriptHandlerFactory;
    private final IdGenerator<Long> idGenerator = new LongIdGenerator();

    public DefaultInitScriptProcessor(ScriptPluginFactory configurerFactory, ScriptHandlerFactory scriptHandlerFactory) {
        this.configurerFactory = configurerFactory;
        this.scriptHandlerFactory = scriptHandlerFactory;
    }

    public void process(ScriptSource initScript, GradleInternal gradle) {
        ClassLoaderScope baseScope = gradle.getClassLoaderScope();
        URI uri = initScript.getResource().getURI();
        String id = uri == null ? ((Long)this.idGenerator.generateId()).toString() : uri.toString();
        ClassLoaderScope scriptScope = baseScope.createChild("init-" + id);
        ScriptHandlerInternal scriptHandler = this.scriptHandlerFactory.create(initScript, scriptScope);
        ScriptPlugin configurer = this.configurerFactory.create(initScript, scriptHandler, scriptScope, baseScope, true);
        configurer.apply(gradle);
    }
}

