/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.jmolpanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import javajs.util.SB;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.jmol.i18n.GT;
import org.jmol.modelset.Atom;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;
import org.openscience.jmol.app.jmolpanel.JmolResourceHandler;

public class AtomSetChooser
extends JFrame
implements TreeSelectionListener,
PropertyChangeListener,
ActionListener,
ChangeListener,
Runnable {
    private Thread animThread = null;
    private JTextArea propertiesTextArea;
    private JTree tree;
    private DefaultTreeModel treeModel;
    private Viewer vwr;
    private JCheckBox repeatCheckBox;
    private JSlider selectSlider;
    private JLabel infoLabel;
    private JSlider fpsSlider;
    private JSlider amplitudeSlider;
    private JSlider periodSlider;
    private JSlider scaleSlider;
    private JSlider radiusSlider;
    private JFileChooser saveChooser;
    static final String REWIND = "rewind";
    static final String PREVIOUS = "prev";
    static final String PLAY = "play";
    static final String PAUSE = "pause";
    static final String NEXT = "next";
    static final String FF = "ff";
    static final String SAVE = "save";
    static final String COLLECTION = "collection";
    static final String VECTOR = "vector";
    private int[] indexes;
    private int currentIndex = -1;
    private static final int FPS_MAX = 30;
    private static final float AMPLITUDE_PRECISION = 0.01f;
    private static final float AMPLITUDE_MAX = 1.0f;
    private static final float AMPLITUDE_VALUE = 0.5f;
    private static final float PERIOD_PRECISION = 0.001f;
    private static final float PERIOD_MAX = 1.0f;
    private static final float PERIOD_VALUE = 0.5f;
    private static final int RADIUS_MAX = 19;
    private static final int RADIUS_VALUE = 3;
    private static final float SCALE_PRECISION = 0.01f;
    private static final float SCALE_MAX = 2.0f;
    private static final float SCALE_VALUE = 1.0f;
    private int radiusValue = 1;

    public AtomSetChooser(Viewer viewer, JFrame jFrame) {
        super(GT._("AtomSetChooser"));
        this.vwr = viewer;
        this.treeModel = new DefaultTreeModel(new DefaultMutableTreeNode(GT._("No AtomSets")));
        this.layoutWindow(this.getContentPane());
        this.pack();
        this.setLocationRelativeTo(jFrame);
    }

    private void layoutWindow(Container container) {
        container.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.tree = new JTree(this.treeModel);
        this.tree.setVisibleRowCount(5);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(this);
        this.tree.setEnabled(false);
        jPanel.add((Component)new JScrollPane(this.tree), "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setBorder(new TitledBorder(GT._("Properties")));
        this.propertiesTextArea = new JTextArea();
        this.propertiesTextArea.setEditable(false);
        jPanel2.add((Component)new JScrollPane(this.propertiesTextArea), "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.setBorder(new TitledBorder(GT._("Atom Set Collection")));
        JSplitPane jSplitPane = new JSplitPane(0, jPanel, jPanel2);
        jPanel3.add((Component)jSplitPane, "Center");
        jSplitPane.setResizeWeight(0.5);
        container.add((Component)jPanel3, "Center");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        container.add((Component)jPanel4, "South");
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 1));
        jPanel5.setBorder(new TitledBorder(GT._("Collection")));
        jPanel4.add(jPanel5);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout());
        jPanel6.setBorder(new TitledBorder(GT._("Info")));
        this.infoLabel = new JLabel(" ");
        jPanel6.add((Component)this.infoLabel, "South");
        jPanel5.add(jPanel6);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BorderLayout());
        jPanel7.setBorder(new TitledBorder(GT._("Select")));
        this.selectSlider = new JSlider(0, 0, 0);
        this.selectSlider.addChangeListener(this);
        this.selectSlider.setMajorTickSpacing(5);
        this.selectSlider.setMinorTickSpacing(1);
        this.selectSlider.setPaintTicks(true);
        this.selectSlider.setSnapToTicks(true);
        this.selectSlider.setEnabled(false);
        jPanel7.add((Component)this.selectSlider, "South");
        jPanel5.add(jPanel7);
        JPanel jPanel8 = new JPanel();
        jPanel5.add(jPanel8);
        jPanel8.setLayout(new BoxLayout(jPanel8, 0));
        this.repeatCheckBox = new JCheckBox(GT._("Repeat"), false);
        JPanel jPanel9 = this.createVCRController(COLLECTION);
        jPanel9.add(this.repeatCheckBox);
        jPanel8.add(jPanel9);
        JPanel jPanel10 = new JPanel();
        jPanel8.add(jPanel10);
        int n = this.vwr.getInt(553648132);
        if (n > 30) {
            n = 30;
        }
        jPanel10.setLayout(new BorderLayout());
        jPanel10.setBorder(new TitledBorder(GT._("FPS")));
        this.fpsSlider = new JSlider(0, 30, n);
        this.fpsSlider.setMajorTickSpacing(5);
        this.fpsSlider.setMinorTickSpacing(1);
        this.fpsSlider.setPaintTicks(true);
        this.fpsSlider.setSnapToTicks(true);
        this.fpsSlider.addChangeListener(this);
        jPanel10.add((Component)this.fpsSlider, "South");
        JPanel jPanel11 = new JPanel();
        jPanel4.add(jPanel11);
        jPanel11.setLayout(new BoxLayout(jPanel11, 1));
        jPanel11.setBorder(new TitledBorder(GT._("Vector")));
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout(new BoxLayout(jPanel12, 0));
        JPanel jPanel13 = new JPanel();
        jPanel13.setLayout(new BorderLayout());
        jPanel13.setBorder(new TitledBorder(GT._("Radius")));
        this.radiusSlider = new JSlider(0, 19, 3);
        this.radiusSlider.setMajorTickSpacing(5);
        this.radiusSlider.setMinorTickSpacing(1);
        this.radiusSlider.setPaintTicks(true);
        this.radiusSlider.setSnapToTicks(true);
        this.radiusSlider.addChangeListener(this);
        this.script("vector 3");
        jPanel13.add(this.radiusSlider);
        jPanel12.add(jPanel13);
        JPanel jPanel14 = new JPanel();
        jPanel14.setLayout(new BorderLayout());
        jPanel14.setBorder(new TitledBorder(GT._("Scale")));
        this.scaleSlider = new JSlider(0, 200, 100);
        this.scaleSlider.addChangeListener(this);
        this.script("vector scale 1.0");
        jPanel14.add(this.scaleSlider);
        jPanel12.add(jPanel14);
        jPanel11.add(jPanel12);
        JPanel jPanel15 = new JPanel();
        jPanel15.setLayout(new BoxLayout(jPanel15, 0));
        JPanel jPanel16 = new JPanel();
        jPanel16.setLayout(new BorderLayout());
        jPanel16.setBorder(new TitledBorder(GT._("Amplitude")));
        this.amplitudeSlider = new JSlider(0, 100, 50);
        this.script("vibration scale 0.5");
        this.amplitudeSlider.addChangeListener(this);
        jPanel16.add(this.amplitudeSlider);
        jPanel15.add(jPanel16);
        JPanel jPanel17 = new JPanel();
        jPanel17.setLayout(new BorderLayout());
        jPanel17.setBorder(new TitledBorder(GT._("Period")));
        this.periodSlider = new JSlider(0, 999, 499);
        this.script("vibration 0.5;vibration off;");
        this.periodSlider.addChangeListener(this);
        jPanel17.add(this.periodSlider);
        jPanel15.add(jPanel17);
        jPanel11.add(jPanel15);
        jPanel11.add(this.createVCRController(VECTOR));
    }

    private JPanel createVCRController(String string) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setBorder(new TitledBorder(string.equals(COLLECTION) ? GT._("Frame") : GT._("Vibration")));
        Insets insets = new Insets(1, 1, 1, 1);
        String[] stringArray = new String[]{REWIND, PREVIOUS, PLAY, PAUSE, NEXT, FF};
        String[] stringArray2 = null;
        if (string.equals(COLLECTION)) {
            stringArray2 = new String[]{GT._("Go to first atom set in the collection"), GT._("Go to previous atom set in the collection"), GT._("Play the whole collection of atom sets"), GT._("Pause playing"), GT._("Go to next atom set in the collection"), GT._("Jump to last atom set in the collection")};
        } else if (string.equals(VECTOR)) {
            stringArray2 = new String[]{GT._("Go to first atom set in the collection"), GT._("Go to previous atom set in the collection"), GT._("Vibration ON"), GT._("Vibration OFF"), GT._("Go to next atom set in the collection"), GT._("Jump to last atom set in the collection")};
        }
        int n = stringArray.length;
        int n2 = 0;
        while (--n >= 0) {
            String string2 = stringArray[n2];
            JButton jButton = new JButton(JmolResourceHandler.getIconX("AtomSetChooser." + string2 + "Image"));
            if (stringArray2 != null && stringArray2.length > n2) {
                jButton.setToolTipText(stringArray2[n2]);
            }
            jButton.setMargin(insets);
            jButton.setActionCommand(string + "." + string2);
            jButton.addActionListener(this);
            jPanel.add(jButton);
            ++n2;
        }
        jPanel.add(Box.createHorizontalGlue());
        return jPanel;
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == null) {
            return;
        }
        try {
            int n = 0;
            if (defaultMutableTreeNode.isLeaf()) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                this.setIndexes(defaultMutableTreeNode2);
                n = defaultMutableTreeNode2.getIndex(defaultMutableTreeNode);
            } else {
                this.setIndexes(defaultMutableTreeNode);
            }
            this.showAtomSetIndex(n, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void showAtomSetIndex(int n, boolean bl) {
        if (bl) {
            this.selectSlider.setValue(n);
            return;
        }
        try {
            this.currentIndex = n;
            int n2 = this.indexes[n];
            this.script("frame " + this.vwr.getModelNumberDotted(n2));
            this.infoLabel.setText(this.vwr.getModelName(n2));
            this.showProperties(this.vwr.ms.am[n2].properties);
            this.showAuxiliaryInfo(this.vwr.ms.getModelAuxiliaryInfo(n2));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void setIndexes(DefaultMutableTreeNode defaultMutableTreeNode) {
        int n = defaultMutableTreeNode.getLeafCount();
        this.indexes = new int[n];
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.depthFirstEnumeration();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            if (!defaultMutableTreeNode.isLeaf()) continue;
            this.indexes[n2++] = ((AtomSet)defaultMutableTreeNode).getAtomSetIndex();
        }
        this.selectSlider.setEnabled(n > 0);
        this.selectSlider.setMaximum(n - 1);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        String[] stringArray = string.split("\\.");
        try {
            if (stringArray.length == 2) {
                String string2 = stringArray[0];
                string = stringArray[1];
                if (COLLECTION.equals(string2)) {
                    if (REWIND.equals(string)) {
                        this.animThread = null;
                        this.showAtomSetIndex(0, true);
                    } else if (PREVIOUS.equals(string)) {
                        this.showAtomSetIndex(this.currentIndex - 1, true);
                    } else if (PLAY.equals(string)) {
                        if (this.animThread == null) {
                            this.animThread = new Thread((Runnable)this, "AtomSetChooserAnimationThread");
                            this.animThread.start();
                        }
                    } else if (PAUSE.equals(string)) {
                        this.animThread = null;
                    } else if (NEXT.equals(string)) {
                        this.showAtomSetIndex(this.currentIndex + 1, true);
                    } else if (FF.equals(string)) {
                        this.animThread = null;
                        this.showAtomSetIndex(this.indexes.length - 1, true);
                    } else if (SAVE.equals(string)) {
                        this.saveXYZCollection();
                    }
                } else if (VECTOR.equals(string2)) {
                    if (REWIND.equals(string)) {
                        this.findFrequency(0, 1);
                    } else if (PREVIOUS.equals(string)) {
                        this.findFrequency(this.currentIndex - 1, -1);
                    } else if (PLAY.equals(string)) {
                        this.script("vibration on; vectors " + this.radiusValue);
                    } else if (PAUSE.equals(string)) {
                        this.script("vibration off; vectors off");
                    } else if (NEXT.equals(string)) {
                        this.findFrequency(this.currentIndex + 1, 1);
                    } else if (FF.equals(string)) {
                        this.findFrequency(this.indexes.length - 1, -1);
                    } else if (SAVE.equals(string)) {
                        Logger.warn("Not implemented");
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void saveXYZCollection() {
        int n;
        int n2 = this.indexes.length;
        if (n2 == 0) {
            Logger.warn("No collection selected.");
            return;
        }
        if (this.saveChooser == null) {
            this.saveChooser = new JFileChooser();
        }
        if ((n = this.saveChooser.showSaveDialog(this)) == 0) {
            File file = this.saveChooser.getSelectedFile();
            String string = file.getAbsolutePath();
            try {
                PrintWriter printWriter = new PrintWriter(new FileOutputStream(string));
                for (int i = 0; i < n2; ++i) {
                    int n3 = this.indexes[i];
                    SB sB = new SB();
                    sB.append(this.vwr.getModelName(n3)).append("\n");
                    int n4 = 0;
                    int n5 = this.vwr.ms.ac;
                    for (int j = 0; j < n5; ++j) {
                        if (this.vwr.ms.at[j].mi != n3) continue;
                        ++n4;
                        Atom atom = this.vwr.ms.at[j];
                        sB.append(this.vwr.ms.at[j].getAtomName()).append("\t");
                        sB.appendF(atom.x).append("\t").appendF(atom.y).append("\t").appendF(atom.z).append("\n");
                    }
                    printWriter.println(n4);
                    printWriter.print(sB);
                }
                printWriter.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
    }

    public void findFrequency(int n, int n2) {
        int n3 = this.indexes.length;
        boolean bl = false;
        while (n >= 0 && n < n3 && !(bl = this.vwr.modelHasVibrationVectors(this.indexes[n]))) {
            n += n2;
        }
        if (bl) {
            this.showAtomSetIndex(n, true);
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        int n = ((JSlider)object).getValue();
        String string = null;
        if (object == this.selectSlider) {
            this.showAtomSetIndex(n, false);
        } else if (object == this.fpsSlider) {
            if (n == 0) {
                this.fpsSlider.setValue(1);
            } else {
                string = "animation fps " + n;
            }
        } else if (object == this.radiusSlider) {
            if (n == 0) {
                n = 1;
                this.radiusSlider.setValue(1);
            } else {
                string = "vector " + n;
            }
            this.radiusValue = n;
        } else if (object == this.scaleSlider) {
            string = "vector scale " + (float)n * 0.01f;
        } else if (object == this.amplitudeSlider) {
            string = "vibration scale " + (float)n * 0.01f;
        } else if (object == this.periodSlider) {
            string = "vibration " + (float)n * 0.001f;
        }
        if (string != null) {
            this.script(string);
        }
    }

    private void script(String string) {
        this.vwr.evalStringQuiet(string + "\u0001## REPAINT_IGNORE ##");
    }

    protected void showProperties(Properties properties) {
        boolean bl = false;
        this.propertiesTextArea.setText("");
        if (properties != null) {
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (string.startsWith(".")) continue;
                this.propertiesTextArea.append((bl ? "\n " : " ") + string + "=" + properties.getProperty(string));
                bl = true;
            }
        }
    }

    protected void showAuxiliaryInfo(Map<String, Object> map) {
        String string = " ";
        if (map != null) {
            for (String string2 : map.keySet()) {
                if (string2.startsWith(".")) continue;
                this.propertiesTextArea.append(string + string2 + "=" + map.get(string2));
                string = "\n ";
            }
        }
    }

    private void createTreeModel() {
        Properties properties;
        String string = null;
        String string2 = null;
        String string3 = this.vwr.ms.modelSetName;
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string3 == null ? "zapped" : string3);
        Properties properties2 = properties = string3 == null ? null : this.vwr.getModelSetProperties();
        if (properties != null) {
            string = properties.getProperty("PATH_KEY");
            string2 = properties.getProperty("PATH_SEPARATOR");
        }
        if (string == null || string2 == null) {
            if (string3 != null) {
                int n = this.vwr.ms.mc;
                for (int i = 0; i < n; ++i) {
                    defaultMutableTreeNode.add(new AtomSet(i, this.vwr.getModelName(i)));
                }
            }
        } else {
            int n = this.vwr.ms.mc;
            for (int i = 0; i < n; ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = defaultMutableTreeNode;
                String string4 = this.vwr.ms.getModelProperty(i, string);
                if (string4 != null) {
                    DefaultMutableTreeNode defaultMutableTreeNode3 = null;
                    String[] stringArray = string4.split(string2);
                    int n2 = 0;
                    int n3 = stringArray.length;
                    while (--n3 >= 0) {
                        boolean bl = false;
                        String string5 = stringArray[n2];
                        int n4 = defaultMutableTreeNode2.getChildCount();
                        while (--n4 >= 0 && !(bl = string5.equals((defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(n4)).toString()))) {
                        }
                        if (bl) {
                            defaultMutableTreeNode2 = defaultMutableTreeNode3;
                        } else {
                            DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(string5);
                            defaultMutableTreeNode2.add(defaultMutableTreeNode4);
                            defaultMutableTreeNode2 = defaultMutableTreeNode4;
                        }
                        ++n2;
                    }
                }
                defaultMutableTreeNode2.add(new AtomSet(i, this.vwr.getModelName(i)));
            }
        }
        this.treeModel.setRoot(defaultMutableTreeNode);
        this.treeModel.reload();
        this.tree.setEnabled(defaultMutableTreeNode.getChildCount() > 0);
        this.indexes = null;
        this.currentIndex = -1;
        this.selectSlider.setEnabled(false);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("chemFile")) {
            this.createTreeModel();
        }
    }

    @Override
    public void run() {
        Thread thread = Thread.currentThread();
        thread.setPriority(1);
        while (this.animThread == thread) {
            if (this.currentIndex < 0) {
                this.animThread = null;
                continue;
            }
            ++this.currentIndex;
            if (this.currentIndex == this.indexes.length) {
                if (this.repeatCheckBox.isSelected()) {
                    this.currentIndex = 0;
                } else {
                    --this.currentIndex;
                    this.animThread = null;
                }
            }
            this.showAtomSetIndex(this.currentIndex, true);
            try {
                int n = this.vwr.getInt(553648132);
                Thread.sleep((int)(1000.0 / (double)(n == 0 ? 1 : n)));
            }
            catch (InterruptedException interruptedException) {
                Logger.errorEx(null, interruptedException);
            }
        }
    }

    private static class AtomSet
    extends DefaultMutableTreeNode {
        private int atomSetIndex;
        private String atomSetName;

        public AtomSet(int n, String string) {
            this.atomSetIndex = n;
            this.atomSetName = string;
        }

        public int getAtomSetIndex() {
            return this.atomSetIndex;
        }

        @Override
        public String toString() {
            return this.atomSetName;
        }
    }
}

