/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.io.Serializable;
import java.util.Objects;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;

public class RelationMemberData
implements PrimitiveId,
Serializable {
    private static final long serialVersionUID = 381392198209333319L;
    private final String role;
    private final long memberId;
    private final OsmPrimitiveType memberType;

    public RelationMemberData(String string, OsmPrimitiveType osmPrimitiveType, long l) {
        this.role = string == null ? "" : string;
        this.memberType = osmPrimitiveType;
        this.memberId = l;
    }

    public RelationMemberData(String string, PrimitiveId primitiveId) {
        this(string, primitiveId.getType(), primitiveId.getUniqueId());
    }

    public long getMemberId() {
        return this.memberId;
    }

    public String getRole() {
        return this.role;
    }

    public OsmPrimitiveType getMemberType() {
        return this.memberType;
    }

    public boolean hasRole() {
        return !"".equals(this.role);
    }

    public String toString() {
        return (this.memberType != null ? this.memberType.getAPIName() : "undefined") + ' ' + this.memberId;
    }

    @Override
    public OsmPrimitiveType getType() {
        return this.memberType;
    }

    @Override
    public long getUniqueId() {
        return this.memberId;
    }

    @Override
    public boolean isNew() {
        return this.memberId <= 0L;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.role, this.memberId, this.memberType});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        RelationMemberData relationMemberData = (RelationMemberData)object;
        return this.memberId == relationMemberData.memberId && Objects.equals(this.role, relationMemberData.role) && this.memberType == relationMemberData.memberType;
    }
}

