/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.java.ReadArgNode;
import com.oracle.truffle.api.nodes.Node;

@NodeChildren(value={@NodeChild(value="valueNode", type=ReadArgNode.class)})
abstract class UnboxNode
extends Node {
    @Node.Child
    private Node unbox;
    @Node.Child
    private Node isBoxed;

    UnboxNode() {
    }

    public abstract Object executeUnbox(VirtualFrame var1);

    @Specialization
    public int executeUnbox(int value) {
        return value;
    }

    @Specialization
    public long executeUnbox(long value) {
        return value;
    }

    @Specialization
    public String executeUnbox(String value) {
        return value;
    }

    @Specialization(guards={"isBoxedPrimitive(frame, foreignValue)"})
    public Object executeUnbox(VirtualFrame frame, TruffleObject foreignValue) {
        if (this.unbox == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.unbox = this.insert(Message.UNBOX.createNode());
        }
        return ForeignAccess.execute(this.unbox, frame, foreignValue, new Object[0]);
    }

    protected final boolean isBoxedPrimitive(VirtualFrame frame, TruffleObject object) {
        if (this.isBoxed == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.isBoxed = this.insert(Message.IS_BOXED.createNode());
        }
        return (Boolean)ForeignAccess.execute(this.isBoxed, frame, object, new Object[0]);
    }
}

