/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.debug.shell.server;

import com.oracle.truffle.api.debug.Breakpoint;
import com.oracle.truffle.api.debug.Debugger;
import com.oracle.truffle.api.debug.ExecutionEvent;
import com.oracle.truffle.api.debug.SuspendedEvent;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.instrument.StandardSyntaxTag;
import com.oracle.truffle.api.instrument.SyntaxTag;
import com.oracle.truffle.api.instrument.Visualizer;
import com.oracle.truffle.api.instrument.impl.DefaultVisualizer;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.LineLocation;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.vm.EventConsumer;
import com.oracle.truffle.api.vm.PolyglotEngine;
import com.oracle.truffle.tools.debug.shell.REPLMessage;
import com.oracle.truffle.tools.debug.shell.client.SimpleREPLClient;
import com.oracle.truffle.tools.debug.shell.server.REPLHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.WeakHashMap;

public final class REPLServer {
    private static int nextBreakpointUID = 0;
    private final PolyglotEngine engine;
    private Debugger db;
    private Context currentServerContext;
    private SimpleREPLClient replClient = null;
    private String statusPrefix;
    private final Map<String, REPLHandler> handlerMap = new HashMap<String, REPLHandler>();
    private final TreeSet<PolyglotEngine.Language> engineLanguages = new TreeSet<PolyglotEngine.Language>(new Comparator<PolyglotEngine.Language>(){

        @Override
        public int compare(PolyglotEngine.Language lang1, PolyglotEngine.Language lang2) {
            return lang1.getName().compareTo(lang2.getName());
        }
    });
    private final Map<String, PolyglotEngine.Language> nameToLanguage = new TreeMap<String, PolyglotEngine.Language>(String.CASE_INSENSITIVE_ORDER);
    private PolyglotEngine.Language defaultLanguage;
    private final Visualizer visualizer;
    private Map<Integer, BreakpointInfo> breakpoints = new WeakHashMap<Integer, BreakpointInfo>();
    private final EventConsumer<SuspendedEvent> onHalted = new EventConsumer<SuspendedEvent>(SuspendedEvent.class){

        @Override
        protected void on(SuspendedEvent ev) {
            REPLServer.this.haltedAt(ev);
        }
    };
    private final EventConsumer<ExecutionEvent> onExec = new EventConsumer<ExecutionEvent>(ExecutionEvent.class){

        @Override
        protected void on(ExecutionEvent event) {
            if (REPLServer.this.db == null) {
                REPLServer.this.db = event.getDebugger();
                for (BreakpointInfo breakpointInfo : REPLServer.this.breakpoints.values()) {
                    breakpointInfo.activate(REPLServer.this.db);
                }
            }
            if (REPLServer.this.currentServerContext.steppingInto) {
                event.prepareStepInto();
            }
        }
    };

    public REPLServer(String defaultMIMEType, Visualizer visualizer) {
        this.visualizer = visualizer == null ? new DefaultVisualizer() : visualizer;
        this.engine = PolyglotEngine.newBuilder().onEvent(this.onHalted).onEvent(this.onExec).build();
        this.engineLanguages.addAll(this.engine.getLanguages().values());
        if (this.engineLanguages.size() == 0) {
            throw new RuntimeException("No language implementations installed");
        }
        for (PolyglotEngine.Language language : this.engineLanguages) {
            this.nameToLanguage.put(language.getName(), language);
        }
        if (defaultMIMEType == null) {
            this.defaultLanguage = this.engineLanguages.iterator().next();
        } else {
            this.defaultLanguage = this.engine.getLanguages().get(defaultMIMEType);
            if (this.defaultLanguage == null) {
                throw new RuntimeException("Implementation not found for \"" + defaultMIMEType + "\"");
            }
        }
        this.statusPrefix = REPLServer.languageName(this.defaultLanguage);
    }

    public void add(REPLHandler handler) {
        this.handlerMap.put(handler.getOp(), handler);
    }

    public void start() {
        this.add(REPLHandler.BACKTRACE_HANDLER);
        this.add(REPLHandler.BREAK_AT_LINE_HANDLER);
        this.add(REPLHandler.BREAK_AT_LINE_ONCE_HANDLER);
        this.add(REPLHandler.BREAK_AT_THROW_HANDLER);
        this.add(REPLHandler.BREAK_AT_THROW_ONCE_HANDLER);
        this.add(REPLHandler.BREAKPOINT_INFO_HANDLER);
        this.add(REPLHandler.CALL_HANDLER);
        this.add(REPLHandler.CLEAR_BREAK_HANDLER);
        this.add(REPLHandler.CONTINUE_HANDLER);
        this.add(REPLHandler.DELETE_HANDLER);
        this.add(REPLHandler.DISABLE_BREAK_HANDLER);
        this.add(REPLHandler.ENABLE_BREAK_HANDLER);
        this.add(REPLHandler.EVAL_HANDLER);
        this.add(REPLHandler.FILE_HANDLER);
        this.add(REPLHandler.FRAME_HANDLER);
        this.add(REPLHandler.INFO_HANDLER);
        this.add(REPLHandler.KILL_HANDLER);
        this.add(REPLHandler.LOAD_HANDLER);
        this.add(REPLHandler.QUIT_HANDLER);
        this.add(REPLHandler.SET_BREAK_CONDITION_HANDLER);
        this.add(REPLHandler.SET_LANGUAGE_HANDLER);
        this.add(REPLHandler.STEP_INTO_HANDLER);
        this.add(REPLHandler.STEP_OUT_HANDLER);
        this.add(REPLHandler.STEP_OVER_HANDLER);
        this.add(REPLHandler.TRUFFLE_HANDLER);
        this.add(REPLHandler.TRUFFLE_NODE_HANDLER);
        this.add(REPLHandler.UNSET_BREAK_CONDITION_HANDLER);
        this.replClient = new SimpleREPLClient(this);
        this.currentServerContext = new Context(null, null, this.defaultLanguage);
        this.replClient.start();
    }

    public String getWelcome() {
        return "GraalVM MultiLanguage Debugger 0.9\nCopyright (c) 2013-5, Oracle and/or its affiliates";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void haltedAt(SuspendedEvent event) {
        REPLMessage message = new REPLMessage();
        message.put("op", "stopped");
        PolyglotEngine.Language haltedLanguage = this.currentServerContext.currentLanguage;
        String mimeType = this.findMime(event.getNode());
        if (mimeType == null) {
            message.put("warnings", "unable to detect language at halt");
        } else {
            PolyglotEngine.Language language = this.engine.getLanguages().get(mimeType);
            if (language == null) {
                message.put("warnings", "no language installed for MIME type \"" + mimeType + "\"");
            } else {
                haltedLanguage = language;
            }
        }
        this.currentServerContext = new Context(this.currentServerContext, event, haltedLanguage);
        message.put("language-name", haltedLanguage.getName());
        SourceSection src = event.getNode().getSourceSection();
        Source source = src.getSource();
        message.put("source-name", source.getName());
        String path = source.getPath();
        if (path == null) {
            message.put("source-text", source.getCode());
        } else {
            message.put("path", path);
        }
        message.put("line-number", Integer.toString(src.getStartLine()));
        message.put("status", "succeeded");
        message.put("debug-level", Integer.toString(this.currentServerContext.getLevel()));
        List<String> warnings = event.getRecentWarnings();
        if (!warnings.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String warning : warnings) {
                sb.append(warning + "\n");
            }
            message.put("warnings", sb.toString());
        }
        try {
            this.replClient.halted(message);
        }
        finally {
            this.currentServerContext = this.currentServerContext.predecessor;
        }
    }

    private String findMime(Node node) {
        Source source;
        String result = null;
        SourceSection section = node.getEncapsulatingSourceSection();
        if (section != null && (source = section.getSource()) != null) {
            result = source.getMimeType();
        }
        return result;
    }

    public REPLMessage[] receive(REPLMessage request) {
        if (this.currentServerContext == null) {
            REPLMessage message = new REPLMessage();
            message.put("status", "failed");
            message.put("displayable-message", "server not started");
            REPLMessage[] reply = new REPLMessage[]{message};
            return reply;
        }
        return this.currentServerContext.receive(request);
    }

    Context getCurrentContext() {
        return this.currentServerContext;
    }

    Visualizer getVisualizer() {
        return this.visualizer;
    }

    PolyglotEngine.Language getLanguage() {
        return this.defaultLanguage;
    }

    TreeSet<PolyglotEngine.Language> getLanguages() {
        return this.engineLanguages;
    }

    public String getLanguageName() {
        return REPLServer.languageName(this.defaultLanguage);
    }

    private static String languageName(PolyglotEngine.Language lang) {
        return lang.getName() + "(" + lang.getVersion() + ")";
    }

    private String defaultMIME(PolyglotEngine.Language language) {
        return language.getMimeTypes().iterator().next();
    }

    BreakpointInfo setLineBreakpoint(int ignoreCount, LineLocation lineLocation, boolean oneShot) {
        return new BreakpointInfo(this.db, lineLocation, ignoreCount, oneShot);
    }

    BreakpointInfo setTagBreakpoint(int ignoreCount, StandardSyntaxTag tag, boolean oneShot) {
        return new BreakpointInfo(this.db, tag, ignoreCount, oneShot);
    }

    synchronized BreakpointInfo findBreakpoint(int id) {
        return this.breakpoints.get(id);
    }

    Collection<BreakpointInfo> getBreakpoints() {
        return new ArrayList<BreakpointInfo>(this.breakpoints.values());
    }

    final class BreakpointInfo {
        private final BreakpointKind kind;
        private Breakpoint breakpoint;
        private Breakpoint.State state;
        private final int uid;
        private boolean oneShot;
        private int ignoreCount;
        private Source conditionSource;
        private final LineLocation lineLocation;
        private final SyntaxTag tag;

        private BreakpointInfo(Debugger debugger, LineLocation lineLocation, int ignoreCount, boolean oneShot) {
            this.kind = BreakpointKind.LINE;
            this.lineLocation = lineLocation;
            this.tag = null;
            this.ignoreCount = ignoreCount;
            this.oneShot = oneShot;
            this.uid = nextBreakpointUID++;
            if (debugger == null) {
                this.state = Breakpoint.State.ENABLED_UNRESOLVED;
            } else {
                this.activate(debugger);
            }
            REPLServer.this.breakpoints.put(this.uid, this);
        }

        private BreakpointInfo(Debugger debugger, SyntaxTag tag, int ignoreCount, boolean oneShot) {
            this.kind = BreakpointKind.TAG;
            this.lineLocation = null;
            this.tag = tag;
            this.ignoreCount = ignoreCount;
            this.oneShot = oneShot;
            this.uid = nextBreakpointUID++;
            if (debugger == null) {
                this.state = Breakpoint.State.ENABLED_UNRESOLVED;
            } else {
                this.activate(debugger);
            }
            REPLServer.this.breakpoints.put(this.uid, this);
        }

        private void activate(Debugger debugger) {
            if (this.breakpoint != null) {
                throw new IllegalStateException("Breakpoint already activated");
            }
            if (this.state == Breakpoint.State.DISPOSED) {
                throw new IllegalStateException("Breakpoint already disposed");
            }
            try {
                switch (this.kind) {
                    case LINE: {
                        this.breakpoint = debugger.setLineBreakpoint(this.ignoreCount, this.lineLocation, this.oneShot);
                        break;
                    }
                    case TAG: {
                        this.breakpoint = debugger.setTagBreakpoint(this.ignoreCount, this.tag, this.oneShot);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected breakpoint kind");
                    }
                }
                if (this.conditionSource != null) {
                    this.breakpoint.setCondition(this.conditionSource.getCode());
                    this.conditionSource = null;
                }
                if (this.state == Breakpoint.State.DISABLED_UNRESOLVED) {
                    this.breakpoint.setEnabled(false);
                }
                this.state = null;
            }
            catch (IOException ex) {
                throw new IllegalStateException("Failure to activate breakpoint " + this.uid + ":  " + ex.getMessage());
            }
        }

        int getID() {
            return this.uid;
        }

        String describeState() {
            return (this.breakpoint == null ? this.state : this.breakpoint.getState()).getName();
        }

        String describeLocation() {
            if (this.breakpoint == null) {
                switch (this.kind) {
                    case LINE: {
                        return "Line: " + this.lineLocation.getShortDescription();
                    }
                    case TAG: {
                        return "Tag " + this.tag.name();
                    }
                }
                throw new IllegalStateException("Unexpected breakpoint state");
            }
            return this.breakpoint.getLocationDescription();
        }

        void setEnabled(boolean enabled) {
            block8: {
                block7: {
                    if (this.breakpoint != null) break block7;
                    switch (this.state) {
                        case ENABLED_UNRESOLVED: {
                            if (!enabled) {
                                this.state = Breakpoint.State.DISABLED_UNRESOLVED;
                            }
                            break block8;
                        }
                        case DISABLED_UNRESOLVED: {
                            if (enabled) {
                                this.state = Breakpoint.State.ENABLED_UNRESOLVED;
                            }
                            break block8;
                        }
                        case DISPOSED: {
                            throw new IllegalStateException("Disposed breakpoints must stay disposed");
                        }
                        default: {
                            throw new IllegalStateException("Unexpected breakpoint state");
                        }
                    }
                }
                this.breakpoint.setEnabled(enabled);
            }
        }

        boolean isEnabled() {
            return this.breakpoint == null ? this.state == Breakpoint.State.ENABLED_UNRESOLVED : this.breakpoint.isEnabled();
        }

        void setCondition(String expr) throws IOException {
            if (this.breakpoint == null) {
                this.conditionSource = expr == null ? null : Source.fromText(expr, "breakpoint condition from text: " + expr);
            } else {
                this.breakpoint.setCondition(expr);
            }
        }

        String getCondition() {
            Source source = this.breakpoint == null ? this.conditionSource : this.breakpoint.getCondition();
            return source == null ? null : source.getCode();
        }

        int getIgnoreCount() {
            return this.breakpoint == null ? this.ignoreCount : this.breakpoint.getIgnoreCount();
        }

        int getHitCount() {
            return this.breakpoint == null ? 0 : this.breakpoint.getHitCount();
        }

        void dispose() {
            if (this.breakpoint == null) {
                if (this.state == Breakpoint.State.DISPOSED) {
                    throw new IllegalStateException("Breakpoint already disposed");
                }
            } else {
                this.breakpoint.dispose();
                this.breakpoint = null;
            }
            this.state = Breakpoint.State.DISPOSED;
            REPLServer.this.breakpoints.remove(this.uid);
            this.conditionSource = null;
        }
    }

    public final class Context {
        private final Context predecessor;
        private final int level;
        private final SuspendedEvent event;
        private PolyglotEngine.Language currentLanguage;
        private boolean steppingInto = false;

        Context(Context predecessor, SuspendedEvent event, PolyglotEngine.Language language) {
            assert (language != null);
            this.level = predecessor == null ? 0 : predecessor.getLevel() + 1;
            this.predecessor = predecessor;
            this.event = event;
            this.currentLanguage = language;
        }

        int getLevel() {
            return this.level;
        }

        Node getNodeAtHalt() {
            return this.event.getNode();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Object call(String name, boolean stepInto, List<String> argList) throws IOException {
            PolyglotEngine.Value symbol = REPLServer.this.engine.findGlobalSymbol(name);
            if (symbol == null) {
                throw new IOException("symbol \"" + name + "\" not found");
            }
            ArrayList<Object> args = new ArrayList<Object>();
            for (String stringArg : argList) {
                Integer intArg = null;
                try {
                    intArg = Integer.valueOf(stringArg);
                    args.add(intArg);
                }
                catch (NumberFormatException e) {
                    args.add(stringArg);
                }
            }
            this.steppingInto = stepInto;
            try {
                Object object = symbol.execute(args.toArray(new Object[0])).get();
                return object;
            }
            finally {
                this.steppingInto = false;
            }
        }

        void eval(Source source, boolean stepInto) throws IOException {
            this.steppingInto = stepInto;
            try {
                REPLServer.this.engine.eval(source);
            }
            finally {
                this.steppingInto = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Object eval(String code, Integer frameNumber, boolean stepInto) throws IOException {
            if (this.event == null) {
                if (frameNumber != null) {
                    throw new IllegalStateException("Frame number requires a halted execution");
                }
                this.steppingInto = stepInto;
                String mimeType = REPLServer.this.defaultMIME(this.currentLanguage);
                try {
                    Object object = REPLServer.this.engine.eval(Source.fromText(code, "eval(\"" + code + "\")").withMimeType(mimeType)).get();
                    return object;
                }
                finally {
                    this.steppingInto = false;
                }
            }
            if (frameNumber == null) {
                throw new IllegalStateException("Eval in halted context requires a frame number");
            }
            if (stepInto) {
                this.event.prepareStepInto(1);
            }
            try {
                FrameInstance frame = frameNumber == 0 ? null : this.event.getStack().get(frameNumber - 1);
                Object result = this.event.eval(code, frame);
                Object object = result instanceof PolyglotEngine.Value ? ((PolyglotEngine.Value)result).get() : result;
                return object;
            }
            finally {
                this.event.prepareContinue();
            }
        }

        MaterializedFrame getFrameAtHalt() {
            return this.event.getFrame();
        }

        REPLMessage[] receive(REPLMessage request) {
            String command = request.get("op");
            REPLHandler handler = (REPLHandler)REPLServer.this.handlerMap.get(command);
            if (handler == null) {
                REPLMessage message = new REPLMessage();
                message.put("op", command);
                message.put("status", "failed");
                message.put("displayable-message", REPLServer.this.statusPrefix + " op \"" + command + "\" not supported");
                REPLMessage[] reply = new REPLMessage[]{message};
                return reply;
            }
            return handler.receive(request, REPLServer.this);
        }

        Node getNode() {
            return this.event.getNode();
        }

        MaterializedFrame getFrame() {
            return this.event.getFrame();
        }

        List<FrameInstance> getStack() {
            return this.event.getStack();
        }

        public String getLanguageName() {
            return this.currentLanguage.getName();
        }

        String setLanguage(String name) throws IOException {
            assert (name != null);
            PolyglotEngine.Language language = (PolyglotEngine.Language)REPLServer.this.nameToLanguage.get(name);
            if (language == null) {
                throw new IOException("Language \" + name + \" not supported");
            }
            if (language == this.currentLanguage) {
                return this.currentLanguage.getName();
            }
            if (this.event != null) {
                throw new IOException("Only supported at top level");
            }
            this.currentLanguage = language;
            return language.getName();
        }

        void prepareStepOut() {
            this.event.prepareStepOut();
        }

        void prepareStepInto(int repeat) {
            this.event.prepareStepInto(repeat);
        }

        void prepareStepOver(int repeat) {
            this.event.prepareStepOver(repeat);
        }

        void prepareContinue() {
            this.event.prepareContinue();
        }
    }

    static enum BreakpointKind {
        LINE,
        TAG;

    }
}

