/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.format.nodes.write;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import java.util.Arrays;
import org.jruby.truffle.format.nodes.PackNode;
import org.jruby.truffle.format.runtime.MissingValue;
import org.jruby.truffle.runtime.RubyContext;

@NodeChildren(value={@NodeChild(value="value", type=PackNode.class)})
public abstract class WriteValueNode
extends PackNode {
    public WriteValueNode(RubyContext context) {
        super(context);
    }

    @Specialization
    public Object doWrite(VirtualFrame frame, MissingValue value) {
        return null;
    }

    @Specialization(guards={"!isMissingValue(value)"})
    public Object doWrite(VirtualFrame frame, Object value) {
        Object[] output = this.ensureCapacity(frame, 1);
        int outputPosition = this.getOutputPosition(frame);
        output[outputPosition] = value;
        this.setOutputPosition(frame, outputPosition + 1);
        return null;
    }

    private Object[] ensureCapacity(VirtualFrame frame, int length) {
        Object[] output = (Object[])this.getOutput(frame);
        int outputPosition = this.getOutputPosition(frame);
        if (outputPosition + length > output.length) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            output = Arrays.copyOf(output, (output.length + length) * 2);
            this.setOutput(frame, output);
        }
        return output;
    }

    protected boolean isMissingValue(Object object) {
        return object instanceof MissingValue;
    }
}

