/*
 * Decompiled with CFR 0.152.
 */
package org.joni.ast;

import org.joni.ast.Node;

public final class AnchorNode
extends Node {
    public final int type;
    public boolean asciiRange;
    public Node target;
    public int charLength;

    public AnchorNode(int type2) {
        this.type = type2;
        this.charLength = -1;
    }

    public int getType() {
        return 7;
    }

    protected void setChild(Node newChild) {
        this.target = newChild;
    }

    protected Node getChild() {
        return this.target;
    }

    public void setTarget(Node tgt) {
        this.target = tgt;
        tgt.parent = this;
    }

    public String getName() {
        return "Anchor";
    }

    public String toString(int level2) {
        StringBuilder value2 = new StringBuilder();
        value2.append("\n  type: " + this.typeToString());
        value2.append("\n  ascii: " + this.asciiRange);
        value2.append("\n  target: " + AnchorNode.pad(this.target, level2 + 1));
        return value2.toString();
    }

    public String typeToString() {
        StringBuilder type2 = new StringBuilder();
        if (this.isType(1)) {
            type2.append("BEGIN_BUF ");
        }
        if (this.isType(2)) {
            type2.append("BEGIN_LINE ");
        }
        if (this.isType(4)) {
            type2.append("BEGIN_POSITION ");
        }
        if (this.isType(8)) {
            type2.append("END_BUF ");
        }
        if (this.isType(16)) {
            type2.append("SEMI_END_BUF ");
        }
        if (this.isType(32)) {
            type2.append("END_LINE ");
        }
        if (this.isType(64)) {
            type2.append("WORD_BOUND ");
        }
        if (this.isType(128)) {
            type2.append("NOT_WORD_BOUND ");
        }
        if (this.isType(256)) {
            type2.append("WORD_BEGIN ");
        }
        if (this.isType(512)) {
            type2.append("WORD_END ");
        }
        if (this.isType(1024)) {
            type2.append("PREC_READ ");
        }
        if (this.isType(2048)) {
            type2.append("PREC_READ_NOT ");
        }
        if (this.isType(4096)) {
            type2.append("LOOK_BEHIND ");
        }
        if (this.isType(8192)) {
            type2.append("LOOK_BEHIND_NOT ");
        }
        if (this.isType(16384)) {
            type2.append("ANYCHAR_STAR ");
        }
        if (this.isType(32768)) {
            type2.append("ANYCHAR_STAR_ML ");
        }
        return type2.toString();
    }

    private boolean isType(int type2) {
        return (this.type & type2) != 0;
    }
}

