/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.bkdtree;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.lucene.bkdtree.GrowingHeapLatLonWriter;
import org.apache.lucene.bkdtree.HeapLatLonWriter;
import org.apache.lucene.bkdtree.LatLonReader;
import org.apache.lucene.bkdtree.LatLonWriter;
import org.apache.lucene.bkdtree.OfflineLatLonWriter;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.ByteArrayDataOutput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.InPlaceMergeSorter;
import org.apache.lucene.util.LongBitSet;
import org.apache.lucene.util.OfflineSorter;

class BKDTreeWriter {
    static final int BYTES_PER_DOC = 20;
    public static final int DEFAULT_MAX_POINTS_IN_LEAF_NODE = 1024;
    public static final int DEFAULT_MAX_POINTS_SORT_IN_HEAP = 131072;
    private final byte[] scratchBytes = new byte[20];
    private final ByteArrayDataOutput scratchBytesOutput = new ByteArrayDataOutput(this.scratchBytes);
    private OfflineSorter.ByteSequencesWriter writer;
    private GrowingHeapLatLonWriter heapWriter;
    private Path tempInput;
    private final int maxPointsInLeafNode;
    private final int maxPointsSortInHeap;
    private long pointCount;
    static final double MAX_LAT_INCL = Math.nextAfter(90.0, Double.POSITIVE_INFINITY);
    static final double MAX_LON_INCL = Math.nextAfter(180.0, Double.POSITIVE_INFINITY);
    static final double MIN_LAT_INCL = -90.0;
    static final double MIN_LON_INCL = -180.0;
    private static final int BITS = 32;
    private static final double LON_SCALE = 1.1930464702777777E7;
    private static final double LAT_SCALE = 2.3860929405555554E7;
    public static final double TOLERANCE = 1.0E-7;

    public BKDTreeWriter() throws IOException {
        this(1024, 131072);
    }

    public BKDTreeWriter(int maxPointsInLeafNode, int maxPointsSortInHeap) throws IOException {
        BKDTreeWriter.verifyParams(maxPointsInLeafNode, maxPointsSortInHeap);
        this.maxPointsInLeafNode = maxPointsInLeafNode;
        this.maxPointsSortInHeap = maxPointsSortInHeap;
        this.heapWriter = new GrowingHeapLatLonWriter(maxPointsSortInHeap);
    }

    public static void verifyParams(int maxPointsInLeafNode, int maxPointsSortInHeap) {
        if (maxPointsInLeafNode <= 0) {
            throw new IllegalArgumentException("maxPointsInLeafNode must be > 0; got " + maxPointsInLeafNode);
        }
        if (maxPointsInLeafNode > ArrayUtil.MAX_ARRAY_LENGTH) {
            throw new IllegalArgumentException("maxPointsInLeafNode must be <= ArrayUtil.MAX_ARRAY_LENGTH (= " + ArrayUtil.MAX_ARRAY_LENGTH + "); got " + maxPointsInLeafNode);
        }
        if (maxPointsSortInHeap < maxPointsInLeafNode) {
            throw new IllegalArgumentException("maxPointsSortInHeap must be >= maxPointsInLeafNode; got " + maxPointsSortInHeap + " vs maxPointsInLeafNode=" + maxPointsInLeafNode);
        }
        if (maxPointsSortInHeap > ArrayUtil.MAX_ARRAY_LENGTH) {
            throw new IllegalArgumentException("maxPointsSortInHeap must be <= ArrayUtil.MAX_ARRAY_LENGTH (= " + ArrayUtil.MAX_ARRAY_LENGTH + "); got " + maxPointsSortInHeap);
        }
    }

    public void add(double lat, double lon, int docID) throws IOException {
        if (!BKDTreeWriter.validLat(lat)) {
            throw new IllegalArgumentException("invalid lat: " + lat);
        }
        if (!BKDTreeWriter.validLon(lon)) {
            throw new IllegalArgumentException("invalid lon: " + lon);
        }
        this.add(BKDTreeWriter.encodeLat(lat), BKDTreeWriter.encodeLon(lon), docID);
    }

    private void switchToOffline() throws IOException {
        this.tempInput = Files.createTempFile(OfflineSorter.getDefaultTempDir(), "in", "", new FileAttribute[0]);
        this.writer = new OfflineSorter.ByteSequencesWriter(this.tempInput);
        int i = 0;
        while ((long)i < this.pointCount) {
            this.scratchBytesOutput.reset(this.scratchBytes);
            this.scratchBytesOutput.writeInt(this.heapWriter.latEncs[i]);
            this.scratchBytesOutput.writeInt(this.heapWriter.lonEncs[i]);
            this.scratchBytesOutput.writeVInt(this.heapWriter.docIDs[i]);
            this.scratchBytesOutput.writeVLong((long)i);
            this.writer.write(this.scratchBytes, 0, this.scratchBytes.length);
            ++i;
        }
        this.heapWriter = null;
    }

    void add(int latEnc, int lonEnc, int docID) throws IOException {
        assert (latEnc > Integer.MIN_VALUE);
        assert (latEnc < Integer.MAX_VALUE);
        assert (lonEnc > Integer.MIN_VALUE);
        assert (lonEnc < Integer.MAX_VALUE);
        if (this.pointCount >= (long)this.maxPointsSortInHeap) {
            if (this.writer == null) {
                this.switchToOffline();
            }
            this.scratchBytesOutput.reset(this.scratchBytes);
            this.scratchBytesOutput.writeInt(latEnc);
            this.scratchBytesOutput.writeInt(lonEnc);
            this.scratchBytesOutput.writeVInt(docID);
            this.scratchBytesOutput.writeVLong(this.pointCount);
            this.writer.write(this.scratchBytes, 0, this.scratchBytes.length);
        } else {
            this.heapWriter.append(latEnc, lonEnc, this.pointCount, docID);
        }
        ++this.pointCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LatLonWriter convertToFixedWidth(Path in) throws IOException {
        LatLonWriter sortedWriter;
        block16: {
            OfflineSorter.ByteSequencesReader reader;
            block15: {
                BytesRefBuilder scratch = new BytesRefBuilder();
                scratch.grow(20);
                BytesRef bytes = scratch.get();
                ByteArrayDataInput dataReader = new ByteArrayDataInput();
                reader = null;
                sortedWriter = null;
                boolean success = false;
                try {
                    reader = new OfflineSorter.ByteSequencesReader(in);
                    sortedWriter = this.getWriter(this.pointCount);
                    for (long i = 0L; i < this.pointCount; ++i) {
                        boolean result = reader.read(scratch);
                        assert (result);
                        dataReader.reset(bytes.bytes, bytes.offset, bytes.length);
                        int latEnc = dataReader.readInt();
                        int lonEnc = dataReader.readInt();
                        int docID = dataReader.readVInt();
                        long ord = dataReader.readVLong();
                        assert (docID >= 0) : "docID=" + docID;
                        assert (latEnc > Integer.MIN_VALUE);
                        assert (latEnc < Integer.MAX_VALUE);
                        assert (lonEnc > Integer.MIN_VALUE);
                        assert (lonEnc < Integer.MAX_VALUE);
                        sortedWriter.append(latEnc, lonEnc, ord, docID);
                    }
                    success = true;
                    if (!success) break block15;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close((Closeable[])new Closeable[]{sortedWriter, reader});
                    } else {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{sortedWriter, reader});
                        try {
                            sortedWriter.destroy();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                IOUtils.close((Closeable[])new Closeable[]{sortedWriter, reader});
                break block16;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{sortedWriter, reader});
            try {
                sortedWriter.destroy();
            }
            catch (Throwable t) {}
        }
        return sortedWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LatLonWriter sort(final boolean lon) throws IOException {
        LatLonWriter latLonWriter;
        block9: {
            Path sorted;
            block8: {
                if (this.heapWriter != null) {
                    assert (this.pointCount < Integer.MAX_VALUE);
                    new InPlaceMergeSorter(){

                        protected void swap(int i, int j) {
                            int docID = ((BKDTreeWriter)BKDTreeWriter.this).heapWriter.docIDs[i];
                            ((BKDTreeWriter)BKDTreeWriter.this).heapWriter.docIDs[i] = ((BKDTreeWriter)BKDTreeWriter.this).heapWriter.docIDs[j];
                            ((BKDTreeWriter)BKDTreeWriter.this).heapWriter.docIDs[j] = docID;
                            long ord = ((BKDTreeWriter)BKDTreeWriter.this).heapWriter.ords[i];
                            ((BKDTreeWriter)BKDTreeWriter.this).heapWriter.ords[i] = ((BKDTreeWriter)BKDTreeWriter.this).heapWriter.ords[j];
                            ((BKDTreeWriter)BKDTreeWriter.this).heapWriter.ords[j] = ord;
                            int latEnc = ((BKDTreeWriter)BKDTreeWriter.this).heapWriter.latEncs[i];
                            ((BKDTreeWriter)BKDTreeWriter.this).heapWriter.latEncs[i] = ((BKDTreeWriter)BKDTreeWriter.this).heapWriter.latEncs[j];
                            ((BKDTreeWriter)BKDTreeWriter.this).heapWriter.latEncs[j] = latEnc;
                            int lonEnc = ((BKDTreeWriter)BKDTreeWriter.this).heapWriter.lonEncs[i];
                            ((BKDTreeWriter)BKDTreeWriter.this).heapWriter.lonEncs[i] = ((BKDTreeWriter)BKDTreeWriter.this).heapWriter.lonEncs[j];
                            ((BKDTreeWriter)BKDTreeWriter.this).heapWriter.lonEncs[j] = lonEnc;
                        }

                        protected int compare(int i, int j) {
                            int cmp = lon ? Integer.compare(((BKDTreeWriter)BKDTreeWriter.this).heapWriter.lonEncs[i], ((BKDTreeWriter)BKDTreeWriter.this).heapWriter.lonEncs[j]) : Integer.compare(((BKDTreeWriter)BKDTreeWriter.this).heapWriter.latEncs[i], ((BKDTreeWriter)BKDTreeWriter.this).heapWriter.latEncs[j]);
                            if (cmp != 0) {
                                return cmp;
                            }
                            cmp = Integer.compare(((BKDTreeWriter)BKDTreeWriter.this).heapWriter.docIDs[i], ((BKDTreeWriter)BKDTreeWriter.this).heapWriter.docIDs[j]);
                            if (cmp != 0) {
                                return cmp;
                            }
                            return Long.compare(((BKDTreeWriter)BKDTreeWriter.this).heapWriter.ords[i], ((BKDTreeWriter)BKDTreeWriter.this).heapWriter.ords[j]);
                        }
                    }.sort(0, (int)this.pointCount);
                    HeapLatLonWriter sorted2 = new HeapLatLonWriter((int)this.pointCount);
                    int i = 0;
                    while ((long)i < this.pointCount) {
                        sorted2.append(this.heapWriter.latEncs[i], this.heapWriter.lonEncs[i], this.heapWriter.ords[i], this.heapWriter.docIDs[i]);
                        ++i;
                    }
                    sorted2.close();
                    return sorted2;
                }
                assert (this.tempInput != null);
                final ByteArrayDataInput reader = new ByteArrayDataInput();
                Comparator<BytesRef> cmp = new Comparator<BytesRef>(){
                    private final ByteArrayDataInput readerB = new ByteArrayDataInput();

                    @Override
                    public int compare(BytesRef a, BytesRef b) {
                        reader.reset(a.bytes, a.offset, a.length);
                        int latAEnc = reader.readInt();
                        int lonAEnc = reader.readInt();
                        int docIDA = reader.readVInt();
                        long ordA = reader.readVLong();
                        reader.reset(b.bytes, b.offset, b.length);
                        int latBEnc = reader.readInt();
                        int lonBEnc = reader.readInt();
                        int docIDB = reader.readVInt();
                        long ordB = reader.readVLong();
                        int cmp = lon ? Integer.compare(lonAEnc, lonBEnc) : Integer.compare(latAEnc, latBEnc);
                        if (cmp != 0) {
                            return cmp;
                        }
                        cmp = Integer.compare(docIDA, docIDB);
                        if (cmp != 0) {
                            return cmp;
                        }
                        return Long.compare(ordA, ordB);
                    }
                };
                sorted = Files.createTempFile(OfflineSorter.getDefaultTempDir(), "sorted", "", new FileAttribute[0]);
                boolean success = false;
                try {
                    OfflineSorter latSorter = new OfflineSorter((Comparator)cmp);
                    latSorter.sort(this.tempInput, sorted);
                    LatLonWriter writer = this.convertToFixedWidth(sorted);
                    success = true;
                    latLonWriter = writer;
                    if (!success) break block8;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.rm((Path[])new Path[]{sorted});
                    } else {
                        IOUtils.deleteFilesIgnoringExceptions((Path[])new Path[]{sorted});
                    }
                    throw throwable;
                }
                IOUtils.rm((Path[])new Path[]{sorted});
                break block9;
            }
            IOUtils.deleteFilesIgnoringExceptions((Path[])new Path[]{sorted});
        }
        return latLonWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long finish(IndexOutput out) throws IOException {
        int i;
        long[] leafBlockFPs;
        int[] splitValues;
        int numLeaves;
        block19: {
            LatLonWriter lonSortedWriter;
            LatLonWriter latSortedWriter;
            block18: {
                if (this.writer != null) {
                    this.writer.close();
                }
                LongBitSet bitSet = new LongBitSet(this.pointCount);
                long countPerLeaf = this.pointCount;
                long innerNodeCount = 1L;
                while (countPerLeaf > (long)this.maxPointsInLeafNode) {
                    countPerLeaf = (countPerLeaf + 1L) / 2L;
                    innerNodeCount *= 2L;
                }
                if (1L + 2L * innerNodeCount >= Integer.MAX_VALUE) {
                    throw new IllegalStateException("too many nodes; increase maxPointsInLeafNode (currently " + this.maxPointsInLeafNode + ") and reindex");
                }
                numLeaves = (int)(--innerNodeCount + 1L);
                splitValues = new int[numLeaves];
                leafBlockFPs = new long[numLeaves];
                assert (this.pointCount / (long)splitValues.length <= (long)this.maxPointsInLeafNode) : "pointCount=" + this.pointCount + " splitValues.length=" + splitValues.length + " maxPointsInLeafNode=" + this.maxPointsInLeafNode;
                latSortedWriter = null;
                lonSortedWriter = null;
                boolean success = false;
                try {
                    lonSortedWriter = this.sort(true);
                    latSortedWriter = this.sort(false);
                    this.heapWriter = null;
                    this.build(1, numLeaves, new PathSlice(latSortedWriter, 0L, this.pointCount), new PathSlice(lonSortedWriter, 0L, this.pointCount), bitSet, out, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE, splitValues, leafBlockFPs);
                    success = true;
                    if (!success) break block18;
                }
                catch (Throwable throwable) {
                    if (success) {
                        latSortedWriter.destroy();
                        lonSortedWriter.destroy();
                        IOUtils.rm((Path[])new Path[]{this.tempInput});
                    } else {
                        try {
                            latSortedWriter.destroy();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                        try {
                            lonSortedWriter.destroy();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                        IOUtils.deleteFilesIgnoringExceptions((Path[])new Path[]{this.tempInput});
                    }
                    throw throwable;
                }
                latSortedWriter.destroy();
                lonSortedWriter.destroy();
                IOUtils.rm((Path[])new Path[]{this.tempInput});
                break block19;
            }
            try {
                latSortedWriter.destroy();
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                lonSortedWriter.destroy();
            }
            catch (Throwable t) {
                // empty catch block
            }
            IOUtils.deleteFilesIgnoringExceptions((Path[])new Path[]{this.tempInput});
        }
        long indexFP = out.getFilePointer();
        out.writeVInt(numLeaves);
        for (i = 0; i < splitValues.length; ++i) {
            out.writeInt(splitValues[i]);
        }
        for (i = 0; i < leafBlockFPs.length; ++i) {
            out.writeVLong(leafBlockFPs[i]);
        }
        return indexFP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long markLeftTree(int splitDim, PathSlice source, LongBitSet bitSet, int[] splitValueRet, int minLatEnc, int maxLatEnc, int minLonEnc, int maxLonEnc) throws IOException {
        long leftCount;
        block23: {
            LatLonReader reader;
            block21: {
                int splitValue;
                boolean success;
                block22: {
                    block20: {
                        leftCount = source.count / 2L;
                        reader = source.writer.getReader(source.start + leftCount);
                        success = false;
                        try {
                            boolean result = reader.next();
                            assert (result);
                            int latSplitEnc = reader.latEnc();
                            assert (latSplitEnc >= minLatEnc && latSplitEnc < maxLatEnc) : "latSplitEnc=" + latSplitEnc + " minLatEnc=" + minLatEnc + " maxLatEnc=" + maxLatEnc;
                            int lonSplitEnc = reader.lonEnc();
                            assert (lonSplitEnc >= minLonEnc && lonSplitEnc < maxLonEnc) : "lonSplitEnc=" + lonSplitEnc + " minLonEnc=" + minLonEnc + " maxLonEnc=" + maxLonEnc;
                            splitValue = splitDim == 0 ? latSplitEnc : lonSplitEnc;
                            success = true;
                            if (!success) break block20;
                        }
                        catch (Throwable throwable) {
                            if (success) {
                                IOUtils.close((Closeable[])new Closeable[]{reader});
                            } else {
                                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{reader});
                            }
                            throw throwable;
                        }
                        IOUtils.close((Closeable[])new Closeable[]{reader});
                        break block22;
                    }
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{reader});
                }
                splitValueRet[0] = splitValue;
                assert (bitSet.cardinality() == 0L) : "cardinality=" + bitSet.cardinality();
                success = false;
                reader = source.writer.getReader(source.start);
                try {
                    int lastValue = Integer.MIN_VALUE;
                    int i = 0;
                    while ((long)i < leftCount) {
                        boolean result = reader.next();
                        assert (result);
                        int latEnc = reader.latEnc();
                        int lonEnc = reader.lonEnc();
                        int value = splitDim == 0 ? latEnc : lonEnc;
                        assert (value >= lastValue);
                        lastValue = value;
                        if (value == splitValue) {
                            leftCount = i;
                            break;
                        }
                        assert (value < splitValue) : "i=" + i + " value=" + value + " vs splitValue=" + splitValue;
                        long ord = reader.ord();
                        int docID = reader.docID();
                        assert (docID >= 0) : "docID=" + docID + " reader=" + reader;
                        assert (!bitSet.get(ord));
                        bitSet.set(ord);
                        ++i;
                    }
                    if (!(success = true)) break block21;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close((Closeable[])new Closeable[]{reader});
                    } else {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{reader});
                    }
                    throw throwable;
                }
                IOUtils.close((Closeable[])new Closeable[]{reader});
                break block23;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{reader});
        }
        assert (leftCount == bitSet.cardinality()) : "leftCount=" + leftCount + " cardinality=" + bitSet.cardinality();
        return leftCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void build(int nodeID, int leafNodeOffset, PathSlice lastLatSorted, PathSlice lastLonSorted, LongBitSet bitSet, IndexOutput out, int minLatEnc, int maxLatEnc, int minLonEnc, int maxLonEnc, int[] splitValues, long[] leafBlockFPs) throws IOException {
        block54: {
            int nextLeftCount;
            boolean success;
            LatLonWriter rightWriter;
            LatLonWriter leftWriter;
            int splitValue;
            long leftCount;
            long count;
            PathSlice source;
            int splitDim;
            block55: {
                LatLonReader reader;
                block50: {
                    PathSlice nextSource;
                    block52: {
                        int[] docIDs;
                        block53: {
                            LatLonReader reader2;
                            block49: {
                                long latRange = (long)maxLatEnc - (long)minLatEnc;
                                long lonRange = (long)maxLonEnc - (long)minLonEnc;
                                assert (lastLatSorted.count == lastLonSorted.count);
                                if (latRange >= lonRange) {
                                    splitDim = 0;
                                    source = lastLatSorted;
                                    nextSource = lastLonSorted;
                                } else {
                                    splitDim = 1;
                                    source = lastLonSorted;
                                    nextSource = lastLatSorted;
                                }
                                count = source.count;
                                if (count == 0L) {
                                    if (nodeID < splitValues.length) {
                                        splitValues[nodeID] = Integer.MAX_VALUE;
                                    }
                                    return;
                                }
                                if (nodeID < leafNodeOffset) break block52;
                                assert (maxLatEnc > minLatEnc);
                                assert (maxLonEnc > minLonEnc);
                                reader2 = source.writer.getReader(source.start);
                                docIDs = new int[(int)count];
                                boolean success2 = false;
                                try {
                                    int i = 0;
                                    while ((long)i < source.count) {
                                        boolean result = reader2.next();
                                        assert (result);
                                        docIDs[i] = reader2.docID();
                                        ++i;
                                    }
                                    success2 = true;
                                    if (!success2) break block49;
                                }
                                catch (Throwable throwable) {
                                    if (success2) {
                                        IOUtils.close((Closeable[])new Closeable[]{reader2});
                                    } else {
                                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{reader2});
                                    }
                                    throw throwable;
                                }
                                IOUtils.close((Closeable[])new Closeable[]{reader2});
                                break block53;
                            }
                            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{reader2});
                        }
                        Arrays.sort(docIDs);
                        int lastDocID = -1;
                        int uniqueCount = 0;
                        for (int i = 0; i < docIDs.length; ++i) {
                            int docID = docIDs[i];
                            if (docID == lastDocID) continue;
                            ++uniqueCount;
                            lastDocID = docID;
                        }
                        assert ((long)uniqueCount <= count);
                        long startFP = out.getFilePointer();
                        out.writeVInt(uniqueCount);
                        leafBlockFPs[nodeID - leafNodeOffset] = startFP;
                        lastDocID = -1;
                        for (int i = 0; i < docIDs.length; ++i) {
                            int docID = docIDs[i];
                            if (docID == lastDocID) continue;
                            out.writeInt(docID);
                            lastDocID = docID;
                        }
                        break block54;
                    }
                    assert (nodeID < splitValues.length) : "nodeID=" + nodeID + " splitValues.length=" + splitValues.length;
                    int[] splitValueArray = new int[1];
                    leftCount = this.markLeftTree(splitDim, source, bitSet, splitValueArray, minLatEnc, maxLatEnc, minLonEnc, maxLonEnc);
                    splitValue = splitValueArray[0];
                    leftWriter = null;
                    rightWriter = null;
                    reader = null;
                    success = false;
                    nextLeftCount = 0;
                    try {
                        leftWriter = this.getWriter(leftCount);
                        rightWriter = this.getWriter(count - leftCount);
                        reader = nextSource.writer.getReader(nextSource.start);
                        int i = 0;
                        while ((long)i < count) {
                            boolean result = reader.next();
                            assert (result);
                            int latEnc = reader.latEnc();
                            int lonEnc = reader.lonEnc();
                            long ord = reader.ord();
                            int docID = reader.docID();
                            assert (docID >= 0) : "docID=" + docID + " reader=" + reader;
                            if (bitSet.get(ord)) {
                                if (splitDim == 0) {
                                    assert (latEnc < splitValue) : "latEnc=" + latEnc + " splitValue=" + splitValue;
                                } else assert (lonEnc < splitValue) : "lonEnc=" + lonEnc + " splitValue=" + splitValue;
                                leftWriter.append(latEnc, lonEnc, ord, docID);
                                ++nextLeftCount;
                            } else {
                                if (splitDim == 0) {
                                    assert (latEnc >= splitValue) : "latEnc=" + latEnc + " splitValue=" + splitValue;
                                } else assert (lonEnc >= splitValue) : "lonEnc=" + lonEnc + " splitValue=" + splitValue;
                                rightWriter.append(latEnc, lonEnc, ord, docID);
                            }
                            ++i;
                        }
                        bitSet.clear(0L, this.pointCount);
                        success = true;
                        if (!success) break block50;
                    }
                    catch (Throwable throwable) {
                        if (success) {
                            IOUtils.close((Closeable[])new Closeable[]{reader, leftWriter, rightWriter});
                        } else {
                            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{reader, leftWriter, rightWriter});
                        }
                        throw throwable;
                    }
                    IOUtils.close((Closeable[])new Closeable[]{reader, leftWriter, rightWriter});
                    break block55;
                }
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{reader, leftWriter, rightWriter});
            }
            assert (leftCount == (long)nextLeftCount) : "leftCount=" + leftCount + " nextLeftCount=" + nextLeftCount;
            success = false;
            try {
                if (splitDim == 0) {
                    this.build(2 * nodeID, leafNodeOffset, new PathSlice(source.writer, source.start, leftCount), new PathSlice(leftWriter, 0L, leftCount), bitSet, out, minLatEnc, splitValue, minLonEnc, maxLonEnc, splitValues, leafBlockFPs);
                    leftWriter.destroy();
                    this.build(2 * nodeID + 1, leafNodeOffset, new PathSlice(source.writer, source.start + leftCount, count - leftCount), new PathSlice(rightWriter, 0L, count - leftCount), bitSet, out, splitValue, maxLatEnc, minLonEnc, maxLonEnc, splitValues, leafBlockFPs);
                    rightWriter.destroy();
                } else {
                    this.build(2 * nodeID, leafNodeOffset, new PathSlice(leftWriter, 0L, leftCount), new PathSlice(source.writer, source.start, leftCount), bitSet, out, minLatEnc, maxLatEnc, minLonEnc, splitValue, splitValues, leafBlockFPs);
                    leftWriter.destroy();
                    this.build(2 * nodeID + 1, leafNodeOffset, new PathSlice(rightWriter, 0L, count - leftCount), new PathSlice(source.writer, source.start + leftCount, count - leftCount), bitSet, out, minLatEnc, maxLatEnc, splitValue, maxLonEnc, splitValues, leafBlockFPs);
                    rightWriter.destroy();
                }
                success = true;
            }
            finally {
                if (!success) {
                    try {
                        leftWriter.destroy();
                    }
                    catch (Throwable t) {}
                    try {
                        rightWriter.destroy();
                    }
                    catch (Throwable t) {}
                }
            }
            splitValues[nodeID] = splitValue;
        }
    }

    LatLonWriter getWriter(long count) throws IOException {
        if (count < (long)this.maxPointsSortInHeap) {
            return new HeapLatLonWriter((int)count);
        }
        return new OfflineLatLonWriter(count);
    }

    static boolean validLat(double lat) {
        return !Double.isNaN(lat) && lat >= -90.0 && lat <= MAX_LAT_INCL;
    }

    static boolean validLon(double lon) {
        return !Double.isNaN(lon) && lon >= -180.0 && lon <= MAX_LON_INCL;
    }

    static int encodeLat(double lat) {
        assert (BKDTreeWriter.validLat(lat)) : "lat=" + lat;
        long x = (long)(lat * 2.3860929405555554E7);
        assert (x < Integer.MAX_VALUE) : "lat=" + lat + " mapped to Integer.MAX_VALUE + " + (x - Integer.MAX_VALUE);
        assert (x > Integer.MIN_VALUE) : "lat=" + lat + " mapped to Integer.MIN_VALUE";
        return (int)x;
    }

    static int encodeLon(double lon) {
        assert (BKDTreeWriter.validLon(lon)) : "lon=" + lon;
        long x = (long)(lon * 1.1930464702777777E7);
        assert (x < Integer.MAX_VALUE);
        assert (x > Integer.MIN_VALUE);
        return (int)x;
    }

    static double decodeLat(int x) {
        return (double)x / 2.3860929405555554E7;
    }

    static double decodeLon(int x) {
        return (double)x / 1.1930464702777777E7;
    }

    private static final class PathSlice {
        final LatLonWriter writer;
        final long start;
        final long count;

        public PathSlice(LatLonWriter writer, long start, long count) {
            this.writer = writer;
            this.start = start;
            this.count = count;
        }

        public String toString() {
            return "PathSlice(start=" + this.start + " count=" + this.count + " writer=" + this.writer + ")";
        }
    }
}

