/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.format.parser;

import com.oracle.truffle.api.nodes.Node;
import java.nio.ByteOrder;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.jruby.truffle.format.nodes.PackNode;
import org.jruby.truffle.format.nodes.SourceNode;
import org.jruby.truffle.format.nodes.control.AtUnpackNode;
import org.jruby.truffle.format.nodes.control.BackUnpackNode;
import org.jruby.truffle.format.nodes.control.ForwardUnpackNode;
import org.jruby.truffle.format.nodes.control.NNode;
import org.jruby.truffle.format.nodes.control.SequenceNode;
import org.jruby.truffle.format.nodes.control.StarNode;
import org.jruby.truffle.format.nodes.decode.DecodeByteNodeGen;
import org.jruby.truffle.format.nodes.decode.DecodeFloat32NodeGen;
import org.jruby.truffle.format.nodes.decode.DecodeFloat64NodeGen;
import org.jruby.truffle.format.nodes.decode.DecodeInteger16BigNodeGen;
import org.jruby.truffle.format.nodes.decode.DecodeInteger16LittleNodeGen;
import org.jruby.truffle.format.nodes.decode.DecodeInteger32BigNodeGen;
import org.jruby.truffle.format.nodes.decode.DecodeInteger32LittleNodeGen;
import org.jruby.truffle.format.nodes.decode.DecodeInteger64BigNodeGen;
import org.jruby.truffle.format.nodes.decode.DecodeInteger64LittleNodeGen;
import org.jruby.truffle.format.nodes.read.ReadBERNodeGen;
import org.jruby.truffle.format.nodes.read.ReadBase64StringNodeGen;
import org.jruby.truffle.format.nodes.read.ReadBinaryStringNodeGen;
import org.jruby.truffle.format.nodes.read.ReadBitStringNodeGen;
import org.jruby.truffle.format.nodes.read.ReadByteNodeGen;
import org.jruby.truffle.format.nodes.read.ReadBytesNode;
import org.jruby.truffle.format.nodes.read.ReadBytesNodeGen;
import org.jruby.truffle.format.nodes.read.ReadHexStringNodeGen;
import org.jruby.truffle.format.nodes.read.ReadMIMEStringNodeGen;
import org.jruby.truffle.format.nodes.read.ReadUTF8CharacterNodeGen;
import org.jruby.truffle.format.nodes.read.ReadUUStringNodeGen;
import org.jruby.truffle.format.nodes.type.AsUnsignedNodeGen;
import org.jruby.truffle.format.nodes.write.WriteValueNodeGen;
import org.jruby.truffle.format.parser.PackBaseListener;
import org.jruby.truffle.format.parser.PackParser;
import org.jruby.truffle.format.runtime.PackEncoding;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;

public class UnpackTreeBuilder
extends PackBaseListener {
    private final RubyContext context;
    private final Node currentNode;
    private PackEncoding encoding = PackEncoding.DEFAULT;
    private final Deque<List<PackNode>> sequenceStack = new ArrayDeque<List<PackNode>>();

    public UnpackTreeBuilder(RubyContext context, Node currentNode) {
        this.context = context;
        this.currentNode = currentNode;
        this.pushSequence();
    }

    @Override
    public void enterSequence(PackParser.SequenceContext ctx) {
        this.pushSequence();
    }

    @Override
    public void exitSequence(PackParser.SequenceContext ctx) {
        List<PackNode> sequence = this.sequenceStack.pop();
        this.appendNode(new SequenceNode(this.context, sequence.toArray(new PackNode[sequence.size()])));
    }

    @Override
    public void exitInt8(PackParser.Int8Context ctx) {
        this.appendNode(this.applyCount(ctx.count(), WriteValueNodeGen.create(this.context, DecodeByteNodeGen.create(this.context, true, ReadByteNodeGen.create(this.context, new SourceNode())))));
    }

    @Override
    public void exitUint8(PackParser.Uint8Context ctx) {
        this.appendNode(this.applyCount(ctx.count(), WriteValueNodeGen.create(this.context, DecodeByteNodeGen.create(this.context, false, ReadByteNodeGen.create(this.context, new SourceNode())))));
    }

    @Override
    public void exitInt16Little(PackParser.Int16LittleContext ctx) {
        this.integer(16, ByteOrder.LITTLE_ENDIAN, ctx.count(), true);
    }

    @Override
    public void exitInt16Big(PackParser.Int16BigContext ctx) {
        this.integer(16, ByteOrder.BIG_ENDIAN, ctx.count(), true);
    }

    @Override
    public void exitInt16Native(PackParser.Int16NativeContext ctx) {
        this.integer(16, ByteOrder.nativeOrder(), ctx.count(), true);
    }

    @Override
    public void exitUint16Little(PackParser.Uint16LittleContext ctx) {
        this.integer(16, ByteOrder.LITTLE_ENDIAN, ctx.count(), false);
    }

    @Override
    public void exitUint16Big(PackParser.Uint16BigContext ctx) {
        this.integer(16, ByteOrder.BIG_ENDIAN, ctx.count(), false);
    }

    @Override
    public void exitUint16Native(PackParser.Uint16NativeContext ctx) {
        this.integer(16, ByteOrder.nativeOrder(), ctx.count(), false);
    }

    @Override
    public void exitInt32Little(PackParser.Int32LittleContext ctx) {
        this.integer(32, ByteOrder.LITTLE_ENDIAN, ctx.count(), true);
    }

    @Override
    public void exitInt32Big(PackParser.Int32BigContext ctx) {
        this.integer(32, ByteOrder.BIG_ENDIAN, ctx.count(), true);
    }

    @Override
    public void exitInt32Native(PackParser.Int32NativeContext ctx) {
        this.integer(32, ByteOrder.nativeOrder(), ctx.count(), true);
    }

    @Override
    public void exitUint32Little(PackParser.Uint32LittleContext ctx) {
        this.integer(32, ByteOrder.LITTLE_ENDIAN, ctx.count(), false);
    }

    @Override
    public void exitUint32Big(PackParser.Uint32BigContext ctx) {
        this.integer(32, ByteOrder.BIG_ENDIAN, ctx.count(), false);
    }

    @Override
    public void exitUint32Native(PackParser.Uint32NativeContext ctx) {
        this.integer(32, ByteOrder.nativeOrder(), ctx.count(), false);
    }

    @Override
    public void exitInt64Little(PackParser.Int64LittleContext ctx) {
        this.integer(64, ByteOrder.LITTLE_ENDIAN, ctx.count(), true);
    }

    @Override
    public void exitInt64Big(PackParser.Int64BigContext ctx) {
        this.integer(64, ByteOrder.BIG_ENDIAN, ctx.count(), true);
    }

    @Override
    public void exitInt64Native(PackParser.Int64NativeContext ctx) {
        this.integer(64, ByteOrder.nativeOrder(), ctx.count(), true);
    }

    @Override
    public void exitUint64Little(PackParser.Uint64LittleContext ctx) {
        this.integer(64, ByteOrder.LITTLE_ENDIAN, ctx.count(), false);
    }

    @Override
    public void exitUint64Big(PackParser.Uint64BigContext ctx) {
        this.integer(64, ByteOrder.BIG_ENDIAN, ctx.count(), false);
    }

    @Override
    public void exitUint64Native(PackParser.Uint64NativeContext ctx) {
        this.integer(64, ByteOrder.nativeOrder(), ctx.count(), false);
    }

    public void integer(int size, ByteOrder byteOrder, PackParser.CountContext count, boolean signed) {
        this.appendNode(this.applyCount(count, this.readInteger(size, byteOrder, this.consumePartial(count), signed)));
    }

    @Override
    public void exitUtf8Character(PackParser.Utf8CharacterContext ctx) {
        this.appendNode(this.applyCount(ctx.count(), WriteValueNodeGen.create(this.context, ReadUTF8CharacterNodeGen.create(this.context, new SourceNode()))));
    }

    @Override
    public void exitBerInteger(PackParser.BerIntegerContext ctx) {
        this.appendNode(this.applyCount(ctx.count(), WriteValueNodeGen.create(this.context, ReadBERNodeGen.create(this.context, new SourceNode()))));
    }

    @Override
    public void exitF64Native(PackParser.F64NativeContext ctx) {
        this.appendNode(this.applyCount(ctx.count(), WriteValueNodeGen.create(this.context, DecodeFloat64NodeGen.create(this.context, this.readIntegerX(64, ByteOrder.nativeOrder(), this.consumePartial(ctx.count()), true)))));
    }

    @Override
    public void exitF32Native(PackParser.F32NativeContext ctx) {
        this.appendNode(this.applyCount(ctx.count(), WriteValueNodeGen.create(this.context, DecodeFloat32NodeGen.create(this.context, this.readIntegerX(32, ByteOrder.nativeOrder(), this.consumePartial(ctx.count()), true)))));
    }

    @Override
    public void exitF64Little(PackParser.F64LittleContext ctx) {
        this.appendNode(this.applyCount(ctx.count(), WriteValueNodeGen.create(this.context, DecodeFloat64NodeGen.create(this.context, this.readIntegerX(64, ByteOrder.LITTLE_ENDIAN, this.consumePartial(ctx.count()), true)))));
    }

    @Override
    public void exitF32Little(PackParser.F32LittleContext ctx) {
        this.appendNode(this.applyCount(ctx.count(), WriteValueNodeGen.create(this.context, DecodeFloat32NodeGen.create(this.context, this.readIntegerX(32, ByteOrder.LITTLE_ENDIAN, this.consumePartial(ctx.count()), true)))));
    }

    @Override
    public void exitF64Big(PackParser.F64BigContext ctx) {
        this.appendNode(this.applyCount(ctx.count(), WriteValueNodeGen.create(this.context, DecodeFloat64NodeGen.create(this.context, this.readIntegerX(64, ByteOrder.BIG_ENDIAN, this.consumePartial(ctx.count()), true)))));
    }

    @Override
    public void exitF32Big(PackParser.F32BigContext ctx) {
        this.appendNode(this.applyCount(ctx.count(), WriteValueNodeGen.create(this.context, DecodeFloat32NodeGen.create(this.context, this.readIntegerX(32, ByteOrder.BIG_ENDIAN, this.consumePartial(ctx.count()), true)))));
    }

    @Override
    public void exitBinaryStringSpacePadded(PackParser.BinaryStringSpacePaddedContext ctx) {
        if (ctx.count() == null) {
            this.appendNode(WriteValueNodeGen.create(this.context, ReadBinaryStringNodeGen.create(this.context, false, false, 1, true, true, false, new SourceNode())));
        } else if (ctx.count().INT() == null) {
            this.appendNode(WriteValueNodeGen.create(this.context, ReadBinaryStringNodeGen.create(this.context, true, false, -1, true, true, false, new SourceNode())));
        } else {
            int count = Integer.parseInt(ctx.count().INT().getSymbol().getText());
            this.appendNode(WriteValueNodeGen.create(this.context, ReadBinaryStringNodeGen.create(this.context, false, false, count, true, true, false, new SourceNode())));
        }
    }

    @Override
    public void exitBinaryStringNullPadded(PackParser.BinaryStringNullPaddedContext ctx) {
        if (ctx.count() == null) {
            this.appendNode(WriteValueNodeGen.create(this.context, ReadBinaryStringNodeGen.create(this.context, false, false, 1, false, false, false, new SourceNode())));
        } else if (ctx.count().INT() == null) {
            this.appendNode(WriteValueNodeGen.create(this.context, ReadBinaryStringNodeGen.create(this.context, true, false, -1, false, false, false, new SourceNode())));
        } else {
            int count = Integer.parseInt(ctx.count().INT().getSymbol().getText());
            this.appendNode(WriteValueNodeGen.create(this.context, ReadBinaryStringNodeGen.create(this.context, false, false, count, false, false, false, new SourceNode())));
        }
    }

    @Override
    public void exitBinaryStringNullStar(PackParser.BinaryStringNullStarContext ctx) {
        if (ctx.count() == null) {
            this.appendNode(WriteValueNodeGen.create(this.context, ReadBinaryStringNodeGen.create(this.context, false, true, 1, false, true, true, new SourceNode())));
        } else if (ctx.count().INT() == null) {
            this.appendNode(WriteValueNodeGen.create(this.context, ReadBinaryStringNodeGen.create(this.context, true, true, -1, false, true, true, new SourceNode())));
        } else {
            int count = Integer.parseInt(ctx.count().INT().getSymbol().getText());
            this.appendNode(WriteValueNodeGen.create(this.context, ReadBinaryStringNodeGen.create(this.context, false, false, count, false, true, true, new SourceNode())));
        }
    }

    @Override
    public void exitBitStringMSBFirst(PackParser.BitStringMSBFirstContext ctx) {
        this.bitString(ByteOrder.BIG_ENDIAN, ctx.count());
    }

    @Override
    public void exitBitStringMSBLast(PackParser.BitStringMSBLastContext ctx) {
        this.bitString(ByteOrder.LITTLE_ENDIAN, ctx.count());
    }

    @Override
    public void exitHexStringHighFirst(PackParser.HexStringHighFirstContext ctx) {
        this.hexString(ByteOrder.BIG_ENDIAN, ctx.count());
    }

    @Override
    public void exitHexStringLowFirst(PackParser.HexStringLowFirstContext ctx) {
        this.hexString(ByteOrder.LITTLE_ENDIAN, ctx.count());
    }

    @Override
    public void exitUuString(PackParser.UuStringContext ctx) {
        this.appendNode(WriteValueNodeGen.create(this.context, ReadUUStringNodeGen.create(this.context, new SourceNode())));
    }

    @Override
    public void exitMimeString(PackParser.MimeStringContext ctx) {
        this.appendNode(WriteValueNodeGen.create(this.context, ReadMIMEStringNodeGen.create(this.context, new SourceNode())));
    }

    @Override
    public void exitBase64String(PackParser.Base64StringContext ctx) {
        this.appendNode(WriteValueNodeGen.create(this.context, ReadBase64StringNodeGen.create(this.context, new SourceNode())));
    }

    @Override
    public void exitPointer(PackParser.PointerContext ctx) {
    }

    @Override
    public void exitAt(PackParser.AtContext ctx) {
        int position;
        if (ctx.count() == null) {
            position = 0;
        } else {
            if (ctx.count() != null && ctx.count().INT() == null) {
                return;
            }
            position = Integer.parseInt(ctx.count().INT().getText());
        }
        this.appendNode(new AtUnpackNode(this.context, position));
    }

    @Override
    public void exitBack(PackParser.BackContext ctx) {
        if (ctx.count() != null && ctx.count().INT() == null) {
            this.appendNode(new BackUnpackNode(this.context, true));
        } else if (ctx.count() == null || ctx.count().INT() != null) {
            this.appendNode(this.applyCount(ctx.count(), new BackUnpackNode(this.context, false)));
        }
    }

    @Override
    public void exitNullByte(PackParser.NullByteContext ctx) {
        if (ctx.count() != null && ctx.count().INT() == null) {
            this.appendNode(new ForwardUnpackNode(this.context, true));
        } else if (ctx.count() == null || ctx.count().INT() != null) {
            this.appendNode(this.applyCount(ctx.count(), new ForwardUnpackNode(this.context, false)));
        }
    }

    @Override
    public void enterSubSequence(PackParser.SubSequenceContext ctx) {
        this.pushSequence();
    }

    @Override
    public void exitSubSequence(PackParser.SubSequenceContext ctx) {
        List<PackNode> sequence = this.sequenceStack.pop();
        SequenceNode sequenceNode = new SequenceNode(this.context, sequence.toArray(new PackNode[sequence.size()]));
        PackNode resultingNode = ctx.INT() == null ? sequenceNode : new NNode(this.context, Integer.parseInt(ctx.INT().getText()), sequenceNode);
        this.appendNode(resultingNode);
    }

    @Override
    public void exitErrorDisallowedNative(PackParser.ErrorDisallowedNativeContext ctx) {
        throw new RaiseException(this.context.getCoreLibrary().argumentError("'" + ctx.NATIVE().getText() + "' allowed only after types sSiIlLqQ", this.currentNode));
    }

    public PackNode getNode() {
        return this.sequenceStack.peek().get(0);
    }

    public PackEncoding getEncoding() {
        return this.encoding;
    }

    private void pushSequence() {
        this.sequenceStack.push(new ArrayList());
    }

    private void appendNode(PackNode node) {
        this.sequenceStack.peek().add(node);
    }

    private boolean consumePartial(PackParser.CountContext ctx) {
        return ctx != null && ctx.INT() == null;
    }

    private PackNode readInteger(int size, ByteOrder byteOrder, boolean consumePartial, boolean signed) {
        ReadBytesNode readNode = ReadBytesNodeGen.create(this.context, size / 8, consumePartial, new SourceNode());
        return this.readInteger(size, byteOrder, readNode, signed);
    }

    private PackNode readIntegerX(int size, ByteOrder byteOrder, boolean consumePartial, boolean signed) {
        ReadBytesNode readNode = ReadBytesNodeGen.create(this.context, size / 8, consumePartial, new SourceNode());
        return this.readIntegerX(size, byteOrder, readNode, signed);
    }

    private PackNode readInteger(int size, ByteOrder byteOrder, PackNode readNode, boolean signed) {
        PackNode convert;
        switch (size) {
            case 16: {
                if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                    convert = DecodeInteger16LittleNodeGen.create(this.context, readNode);
                    break;
                }
                convert = DecodeInteger16BigNodeGen.create(this.context, readNode);
                break;
            }
            case 32: {
                if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                    convert = DecodeInteger32LittleNodeGen.create(this.context, readNode);
                    break;
                }
                convert = DecodeInteger32BigNodeGen.create(this.context, readNode);
                break;
            }
            case 64: {
                if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                    convert = DecodeInteger64LittleNodeGen.create(this.context, readNode);
                    break;
                }
                convert = DecodeInteger64BigNodeGen.create(this.context, readNode);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        if (!signed) {
            convert = AsUnsignedNodeGen.create(this.context, convert);
        }
        return WriteValueNodeGen.create(this.context, convert);
    }

    private PackNode readIntegerX(int size, ByteOrder byteOrder, PackNode readNode, boolean signed) {
        PackNode convert;
        switch (size) {
            case 16: {
                if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                    convert = DecodeInteger16LittleNodeGen.create(this.context, readNode);
                    break;
                }
                convert = DecodeInteger16BigNodeGen.create(this.context, readNode);
                break;
            }
            case 32: {
                if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                    convert = DecodeInteger32LittleNodeGen.create(this.context, readNode);
                    break;
                }
                convert = DecodeInteger32BigNodeGen.create(this.context, readNode);
                break;
            }
            case 64: {
                if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                    convert = DecodeInteger64LittleNodeGen.create(this.context, readNode);
                    break;
                }
                convert = DecodeInteger64BigNodeGen.create(this.context, readNode);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        if (!signed) {
            convert = AsUnsignedNodeGen.create(this.context, convert);
        }
        return convert;
    }

    private void bitString(ByteOrder byteOrder, PackParser.CountContext ctx) {
        int length;
        boolean star;
        if (ctx == null) {
            star = false;
            length = 1;
        } else if (ctx.INT() == null) {
            star = true;
            length = 0;
        } else {
            star = false;
            length = Integer.parseInt(ctx.INT().getText());
        }
        this.appendNode(WriteValueNodeGen.create(this.context, ReadBitStringNodeGen.create(this.context, byteOrder, star, length, new SourceNode())));
    }

    private void hexString(ByteOrder byteOrder, PackParser.CountContext ctx) {
        int length;
        boolean star;
        if (ctx == null) {
            star = false;
            length = 1;
        } else if (ctx.INT() == null) {
            star = true;
            length = 0;
        } else {
            star = false;
            length = Integer.parseInt(ctx.INT().getText());
        }
        this.appendNode(WriteValueNodeGen.create(this.context, ReadHexStringNodeGen.create(this.context, byteOrder, star, length, new SourceNode())));
    }

    private PackNode applyCount(PackParser.CountContext count, PackNode node) {
        if (count == null) {
            return node;
        }
        if (count.INT() != null) {
            return new NNode(this.context, Integer.parseInt(count.INT().getText()), node);
        }
        return new StarNode(this.context, node);
    }
}

