/*
 * Decompiled with CFR 0.152.
 */
package test.suite;

import dguitar.adaptors.song.RepeatedSongPhrase;
import dguitar.adaptors.song.SongMeasure;
import dguitar.adaptors.song.SongPhrase;
import dguitar.adaptors.song.TimeSignature;
import dguitar.adaptors.song.impl.RepeatedSongPhraseImpl;
import dguitar.adaptors.song.impl.SongMeasureImpl;
import dguitar.adaptors.song.impl.SongPhraseListImpl;
import junit.framework.TestCase;

public class RepeatedSongPhraseImplTest
extends TestCase {
    RepeatedSongPhrase phrase;

    public void setUp() {
        SongPhraseListImpl part = new SongPhraseListImpl();
        int i = 0;
        while (i < 5) {
            SongMeasureImpl measure = new SongMeasureImpl(i, 10080, new TimeSignature(4, 4));
            part.addPhrase(measure);
            ++i;
        }
        this.phrase = new RepeatedSongPhraseImpl(part, 2);
    }

    public void testGetScoreMeasureCount() {
        RepeatedSongPhraseImplTest.assertEquals((int)5, (int)this.phrase.getScoreMeasureCount());
    }

    public void testGetScoreMeasure() {
        int i = 0;
        while (i < 5) {
            SongMeasure measure = this.phrase.getScoreMeasure(i);
            RepeatedSongPhraseImplTest.assertEquals((int)i, (int)measure.getIndex());
            ++i;
        }
    }

    public void testGetPerformanceMeasureCount() {
        RepeatedSongPhraseImplTest.assertEquals((int)15, (int)this.phrase.getPerformanceMeasureCount());
    }

    public void testGetPerformanceMeasure() {
        int i = 0;
        while (i < 15) {
            SongMeasure measure = this.phrase.getPerformanceMeasure(i);
            RepeatedSongPhraseImplTest.assertEquals((int)(i % 5), (int)measure.getIndex());
            ++i;
        }
    }

    public void testGetPhrase() {
        SongPhrase subphrase = this.phrase.getPhrase();
        RepeatedSongPhraseImplTest.assertTrue((boolean)(subphrase instanceof SongPhraseListImpl));
        RepeatedSongPhraseImplTest.assertEquals((int)5, (int)subphrase.getScoreMeasureCount());
        RepeatedSongPhraseImplTest.assertEquals((int)5, (int)subphrase.getPerformanceMeasureCount());
    }

    public void testGetRepeatCount() {
        RepeatedSongPhraseImplTest.assertEquals((int)2, (int)this.phrase.getRepeatCount());
    }
}

