// See COPYING for copyright and license details
(function() {
    var tldEnd = new RegExp("\\.tld$");
    Object.defineProperties(net, {
        "domainMatch" : 
        {
            value : function(domain, match) {
                var result = false;
                if (tldEnd.test(match))
                {
                    return domain.substring(0, domain.indexOf(".")) === match.substring(0, match.indexOf("."));
                }
                else 
                {
                    return domain === match;
                }
            }
        }, 
        "hostMatch" : 
        {
            value : function(host, match) {
                if (tldEnd.test(match))
                {
                    var domain = net.domainFromHost(host);
                    if (domain == host)
                        return net.domainMatch(host, match);

                    var domainStart = host.indexOf(domain);
                    if (host.substring(0, domainStart) != match.substring(0, domainStart))
                        return false;

                    return net.domainMatch(host.indexOf(domainStart), match.indexOf(domainStart));
                }
                else 
                {
                    return host == match;
                }
            }
        }, 
        "clearCookies" : 
        { 
            value : function() 
            {
                this.allCookies().forEach(function(c) { c.delete(); });
            }
        }, 
        "sessionCookies" : 
        {
            value : function() 
            {
                var now = new Date();
                return this.allCookies().filter(function(c) { return !c.expires || c.expires < now; });
            }
        }, 
        "persistentCookies" : 
        {
            value : function() 
            {
                var now = new Date();
                return this.allCookies().filter(function(c) { return c.expires && c.expires > now; });
            }
        }
    });
    Object.freeze(net);
})();
