/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.info;

import java.io.IOException;
import org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class NodesInfoRequest
extends BaseNodesRequest<NodesInfoRequest> {
    private boolean settings = true;
    private boolean os = true;
    private boolean process = true;
    private boolean jvm = true;
    private boolean threadPool = true;
    private boolean transport = true;
    private boolean http = true;
    private boolean plugins = true;

    public NodesInfoRequest() {
    }

    public NodesInfoRequest(String ... nodesIds) {
        super(nodesIds);
    }

    public NodesInfoRequest clear() {
        this.settings = false;
        this.os = false;
        this.process = false;
        this.jvm = false;
        this.threadPool = false;
        this.transport = false;
        this.http = false;
        this.plugins = false;
        return this;
    }

    public NodesInfoRequest all() {
        this.settings = true;
        this.os = true;
        this.process = true;
        this.jvm = true;
        this.threadPool = true;
        this.transport = true;
        this.http = true;
        this.plugins = true;
        return this;
    }

    public boolean settings() {
        return this.settings;
    }

    public NodesInfoRequest settings(boolean settings) {
        this.settings = settings;
        return this;
    }

    public boolean os() {
        return this.os;
    }

    public NodesInfoRequest os(boolean os) {
        this.os = os;
        return this;
    }

    public boolean process() {
        return this.process;
    }

    public NodesInfoRequest process(boolean process) {
        this.process = process;
        return this;
    }

    public boolean jvm() {
        return this.jvm;
    }

    public NodesInfoRequest jvm(boolean jvm) {
        this.jvm = jvm;
        return this;
    }

    public boolean threadPool() {
        return this.threadPool;
    }

    public NodesInfoRequest threadPool(boolean threadPool) {
        this.threadPool = threadPool;
        return this;
    }

    public boolean transport() {
        return this.transport;
    }

    public NodesInfoRequest transport(boolean transport) {
        this.transport = transport;
        return this;
    }

    public boolean http() {
        return this.http;
    }

    public NodesInfoRequest http(boolean http) {
        this.http = http;
        return this;
    }

    public NodesInfoRequest plugins(boolean plugins) {
        this.plugins = plugins;
        return this;
    }

    public boolean plugins() {
        return this.plugins;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.settings = in.readBoolean();
        this.os = in.readBoolean();
        this.process = in.readBoolean();
        this.jvm = in.readBoolean();
        this.threadPool = in.readBoolean();
        this.transport = in.readBoolean();
        this.http = in.readBoolean();
        this.plugins = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.settings);
        out.writeBoolean(this.os);
        out.writeBoolean(this.process);
        out.writeBoolean(this.jvm);
        out.writeBoolean(this.threadPool);
        out.writeBoolean(this.transport);
        out.writeBoolean(this.http);
        out.writeBoolean(this.plugins);
    }
}

