/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import java.io.IOException;
import org.elasticsearch.action.support.ToXContentToBytes;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.index.query.QueryBuilder;

public class QuerySourceBuilder
extends ToXContentToBytes {
    private QueryBuilder queryBuilder;
    private BytesReference queryBinary;

    public QuerySourceBuilder setQuery(QueryBuilder query) {
        this.queryBuilder = query;
        return this;
    }

    public QuerySourceBuilder setQuery(BytesReference queryBinary) {
        this.queryBinary = queryBinary;
        return this;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.innerToXContent(builder, params);
        builder.endObject();
        return builder;
    }

    public void innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.queryBuilder != null) {
            builder.field("query");
            this.queryBuilder.toXContent(builder, params);
        }
        if (this.queryBinary != null) {
            if (XContentFactory.xContentType(this.queryBinary) == builder.contentType()) {
                builder.rawField("query", this.queryBinary);
            } else {
                builder.field("query_binary", this.queryBinary);
            }
        }
    }
}

